from _typeshed import Incomplete
from collections.abc import Generator

from networkx.utils.backends import _dispatchable

@_dispatchable
def cycle_basis(G, root: Incomplete | None = None): ...
@_dispatchable
def simple_cycles(G, length_bound: Incomplete | None = None) -> Generator[Incomplete, Incomplete, None]: ...

class _NeighborhoodCache(dict[Incomplete, Incomplete]):
    G: Incomplete
    def __init__(self, G) -> None: ...
    def __missing__(self, v): ...

@_dispatchable
def chordless_cycles(G, length_bound: Incomplete | None = None) -> Generator[Incomplete, Incomplete, None]: ...
@_dispatchable
def recursive_simple_cycles(G): ...
@_dispatchable
def find_cycle(G, source: Incomplete | None = None, orientation: Incomplete | None = None): ...
@_dispatchable
def minimum_cycle_basis(G, weight: Incomplete | None = None): ...
