/* tcl_supp.c -- TCL Support Functions
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tua.h"

static tcl_command_def_t tcl_commands[] =
{
 /* from portalias.c */
  {"port_alias", tcl_insert_port_alias,
   "Inserts ALIAS as the new name for PORT"},
#if USE_GLOB_ALIASES
  {"glob_port_alias", tcl_insert_port_glob_alias,
   "Inserts ALIAS as the new meta-name for ports that match PATTERN"},
#endif

 /* from porttree.c */
  {"kill_port", tcl_kill_port,
   "PORT will never appear in the report"},

 /* from reports.c */
  {"systems_report", tcl_systems_report,
   "Shows the Per System Report"},
  {"users_report", tcl_users_report,
   "Shows the Per User Report"},
  {"daily_report", tcl_daily_report,
   "Shows the Daily Report"},
  {"system_summary", tcl_system_summary,
   "Shows the Systems Summary"},
  {"system_summary_table", tcl_system_summary_table,
   "Shows the Systems Summary in Table format"},
  {"report", tcl_report,
   "Shows various reports:\n\
daily              shows the daily report.\n\
ports [portname]   shows the ports report. If PORTNAME is specified, shows\n\
                   the report for just that port.\n\
summary [sysname]  shows the systems summary. If SYSNAME is specified, just\n\
                   that system is reported.\n\
systems [sysname]  shows the systems report.\n\
table              not yet implemented.\n\
users [username]   shows the users report."},
  {"sys_alias", tcl_insert_system_alias,
   "Inserts ALIAS as the new name for SYSTEM"},
#if USE_GLOB_ALIASES
  {"glob_sys_alias", tcl_insert_system_glob_alias,
   "Inserts ALIAS as the new meta-name for systems that match PATTERN"},
#endif

 /* from systree.c */
  {"kill_sys", tcl_kill_system,
   "SYSTEM will never appear in the report"},

 /* from tua.c */
  {"do_option", tcl_do_option,
   "Behaves as if OPTION was on the command line"},
  {"interactive", interactive_mode,
   "Starts interactive mode"},

 /* from useralias.c */
  {"user_alias", tcl_insert_user_alias,
   "Inserts ALIAS as the new name for USER"},
#if USE_GLOB_ALIASES
  {"glob_user_alias", tcl_insert_user_glob_alias,
   "Inserts ALIAS as the new meta-name for users that match PATTERN"},
#endif

 /* from usertree.c */
  {"kill_user", tcl_kill_user,
   "USER will never appear in the report"},

  {"help", tcl_show_help,
   "Prints a short explanation of COMMAND"},
  {0, 0, 0}
};

int
DEFUN (tcl_show_help, (clientData, interp, argc, argv),
       ClientData clientData AND
       Tcl_Interp * interp AND
       int argc AND
       char *argv[])
{
  return TCL_OK;
}

void
DEFUN_VOID (initialize_TCL)
{
  int cmd_index;

  TUA_interp = Tcl_CreateInterp ();
  cmd_index = 0;
  while (tcl_commands[cmd_index].name)
    {
      Tcl_CreateCommand (TUA_interp, tcl_commands[cmd_index].name,
			 tcl_commands[cmd_index].function,
			 (ClientData) 0, (Tcl_CmdDeleteProc *) NULL);
      cmd_index++;
    }
}
