/*
 * $Id: RequestScopeNestedObjectExtractorTest.java 817009 2009-09-20 11:26:26Z apetrelli $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.tiles.ognl;

import static org.junit.Assert.*;
import static org.easymock.EasyMock.*;

import java.util.HashMap;
import java.util.Map;

import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.ognl.NestedObjectExtractor;
import org.apache.tiles.ognl.RequestScopeNestedObjectExtractor;
import org.apache.tiles.ognl.SessionScopeNestedObjectExtractor;
import org.junit.Test;

/**
 * Tests {@link RequestScopeNestedObjectExtractor}.
 *
 * @version $Rev: 817009 $ $Date: 2009-09-20 13:26:26 +0200 (dom, 20 set 2009) $
 */
public class RequestScopeNestedObjectExtractorTest {

    /**
     * Tests {@link SessionScopeNestedObjectExtractor#getNestedObject(TilesRequestContext)}.
     */
    @Test
    public void testGetNestedObject() {
        TilesRequestContext request = createMock(TilesRequestContext.class);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("attribute1", "value1");
        expect(request.getSessionScope()).andReturn(map);

        replay(request);
        NestedObjectExtractor<TilesRequestContext> extractor = new SessionScopeNestedObjectExtractor();
        assertEquals(map, extractor.getNestedObject(request));
        verify(request);
    }

}
