#!/bin/sh
#
# Generate code for including a copy of the default tigrc inside the
# binary.
#
# Usage: $0 /path/to/tigrc
#
# Copyright (c) 2014 Jonas Fonseca <jonas.fonseca@gmail.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

TIGRC="${1:-tigrc}"

read_tigrc() {
	if test -z "$NO_BUILTIN_TIGRC"; then
		sed 's/\s*#.*//' "$TIGRC" | sed 's,\\,\\\\\\\\,g' | sed 's,",\\\\",g' | sed 's/	\+/	/g'
	else
		echo '#'
	fi
}

echo "/* Generated by $0 on $(date) */"
echo "const char *builtin_config ="

read_tigrc | while read line; do
	case "$line" in
	"")	: ignore ;;
	*)	printf '	"%s\\n"\n' "$line"
	esac
done

echo ";"
