/*
 * Decompiled with CFR 0.152.
 */
package com.google.scrollview;

import com.google.scrollview.events.SVEvent;
import com.google.scrollview.ui.SVImageHandler;
import com.google.scrollview.ui.SVWindow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.piccolo2d.nodes.PImage;

public class ScrollView {
    public static int SERVER_PORT = 8461;
    private static Socket socket;
    private static PrintStream out;
    public static BufferedReader in;
    public static float[] polylineXCoords;
    public static float[] polylineYCoords;
    public static int polylineSize;
    public static int polylineScanned;
    private static ArrayList<SVWindow> windows;
    private static Pattern intPattern;
    private static Pattern floatPattern;
    static int nrInputLines;
    static boolean debugViewNetworkTraffic;

    public static void addMessage(SVEvent sVEvent) {
        if (debugViewNetworkTraffic) {
            System.out.println("(S->c) " + sVEvent.toString());
        }
        String string = sVEvent.toString();
        try {
            byte[] byArray = string.getBytes("UTF8");
            out.write(byArray, 0, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Oops... can't encode to UTF8... Exiting");
            System.exit(0);
        }
        out.println();
        boolean bl = out.checkError();
        if (bl) {
            System.out.println("Connection error. Quitting ScrollView Server...");
            System.exit(0);
        }
    }

    public static String receiveMessage() throws IOException {
        return in.readLine();
    }

    private static void IOLoop() {
        try {
            while (!socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown() && socket.isConnected() && socket.isBound()) {
                String string = ScrollView.receiveMessage();
                ++nrInputLines;
                if (debugViewNetworkTraffic) {
                    System.out.println("(c->S," + nrInputLines + ")" + string);
                }
                if (polylineSize > polylineScanned) {
                    boolean bl = true;
                    for (String string2 : string.split(",")) {
                        int n = Integer.parseInt(string2);
                        if (bl) {
                            ScrollView.polylineXCoords[ScrollView.polylineScanned] = n;
                        } else {
                            ScrollView.polylineYCoords[ScrollView.polylineScanned++] = n;
                        }
                        bl = !bl;
                    }
                    assert (bl);
                    continue;
                }
                ScrollView.processInput(string);
            }
        }
        catch (IOException iOException) {
            System.out.println("Connection error. Quitting ScrollView Server...");
        }
        System.exit(0);
    }

    private static void parseArguments(String string, ArrayList<Integer> arrayList, ArrayList<Float> arrayList2, ArrayList<String> arrayList3, ArrayList<Boolean> arrayList4) {
        String string2 = null;
        for (String string3 : string.split(",")) {
            int n;
            if (string2 != null) {
                n = string2.length() + 1 + string3.length();
                StringBuilder stringBuilder = new StringBuilder(n);
                stringBuilder.append(string2);
                stringBuilder.append(",");
                stringBuilder.append(string3);
                string2 = stringBuilder.toString();
            } else {
                if (string3.length() == 0) continue;
                n = string3.charAt(0);
                if (n == 39 || n == 34) {
                    string2 = string3;
                }
            }
            if (string2 != null) {
                int n2;
                assert (string2.charAt(0) == '\'' || string2.charAt(0) == '\"');
                n = string2.length();
                if (n <= 1 || string2.charAt(n - 1) != string2.charAt(0)) continue;
                for (n2 = n - 1; n2 > 0 && string2.charAt(n2 - 1) == '\\'; --n2) {
                }
                if ((n - 1 - n2) % 2 != 0) continue;
                arrayList3.add(string2.substring(1, n - 1));
                string2 = null;
                continue;
            }
            if (floatPattern.matcher(string3).matches()) {
                arrayList2.add(Float.valueOf(Float.parseFloat(string3)));
                continue;
            }
            if (string3.equals("true")) {
                arrayList4.add(true);
                continue;
            }
            if (string3.equals("false")) {
                arrayList4.add(false);
                continue;
            }
            if (!intPattern.matcher(string3).matches()) continue;
            arrayList.add(Integer.parseInt(string3));
        }
        assert (string2 == null);
    }

    private static void processInput(String string) {
        if (string == null) {
            return;
        }
        if (string.charAt(0) == 'w') {
            String string2 = string.substring(1);
            String[] stringArray = string2.split("[ :]", 2);
            int n = Integer.parseInt(stringArray[0]);
            int n2 = string.indexOf(40);
            int n3 = string.lastIndexOf(41);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
            ArrayList<Float> arrayList2 = new ArrayList<Float>(2);
            ArrayList<String> arrayList3 = new ArrayList<String>(4);
            ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>(3);
            ScrollView.parseArguments(string.substring(n2 + 1, n3), arrayList, arrayList2, arrayList3, arrayList4);
            int n4 = string.indexOf(58);
            if (n4 > 1 && n4 < n2) {
                String string3 = string.substring(n4 + 1, n2);
                if (string3.equals("drawLine")) {
                    windows.get(n).drawLine(arrayList.get(0), arrayList.get(1), arrayList.get(2), arrayList.get(3));
                } else if (string3.equals("createPolyline")) {
                    windows.get(n).createPolyline(arrayList.get(0));
                } else if (string3.equals("drawPolyline")) {
                    windows.get(n).drawPolyline();
                } else if (string3.equals("drawRectangle")) {
                    windows.get(n).drawRectangle(arrayList.get(0), arrayList.get(1), arrayList.get(2), arrayList.get(3));
                } else if (string3.equals("setVisible")) {
                    windows.get(n).setVisible(arrayList4.get(0));
                } else if (string3.equals("setAlwaysOnTop")) {
                    windows.get(n).setAlwaysOnTop(arrayList4.get(0));
                } else if (string3.equals("addMessage")) {
                    windows.get(n).addMessage(arrayList3.get(0));
                } else if (string3.equals("addMessageBox")) {
                    windows.get(n).addMessageBox();
                } else if (string3.equals("clear")) {
                    windows.get(n).clear();
                } else if (string3.equals("setStrokeWidth")) {
                    windows.get(n).setStrokeWidth(arrayList2.get(0).floatValue());
                } else if (string3.equals("drawEllipse")) {
                    windows.get(n).drawEllipse(arrayList.get(0), arrayList.get(1), arrayList.get(2), arrayList.get(3));
                } else if (string3.equals("pen")) {
                    if (arrayList.size() == 4) {
                        windows.get(n).pen(arrayList.get(0), arrayList.get(1), arrayList.get(2), arrayList.get(3));
                    } else {
                        windows.get(n).pen(arrayList.get(0), arrayList.get(1), arrayList.get(2));
                    }
                } else if (string3.equals("brush")) {
                    if (arrayList.size() == 4) {
                        windows.get(n).brush(arrayList.get(0), arrayList.get(1), arrayList.get(2), arrayList.get(3));
                    } else {
                        windows.get(n).brush(arrayList.get(0), arrayList.get(1), arrayList.get(2));
                    }
                } else if (string3.equals("textAttributes")) {
                    windows.get(n).textAttributes(arrayList3.get(0), arrayList.get(0), arrayList4.get(0), arrayList4.get(1), arrayList4.get(2));
                } else if (string3.equals("drawText")) {
                    windows.get(n).drawText(arrayList.get(0), arrayList.get(1), arrayList3.get(0));
                } else if (string3.equals("addMenuBarItem")) {
                    if (arrayList4.size() > 0) {
                        windows.get(n).addMenuBarItem(arrayList3.get(0), arrayList3.get(1), arrayList.get(0), arrayList4.get(0));
                    } else if (arrayList.size() > 0) {
                        windows.get(n).addMenuBarItem(arrayList3.get(0), arrayList3.get(1), arrayList.get(0));
                    } else {
                        windows.get(n).addMenuBarItem(arrayList3.get(0), arrayList3.get(1));
                    }
                } else if (string3.equals("addPopupMenuItem")) {
                    if (arrayList3.size() == 4) {
                        windows.get(n).addPopupMenuItem(arrayList3.get(0), arrayList3.get(1), arrayList.get(0), arrayList3.get(2), arrayList3.get(3));
                    } else {
                        windows.get(n).addPopupMenuItem(arrayList3.get(0), arrayList3.get(1));
                    }
                } else if (string3.equals("update")) {
                    windows.get(n).update();
                } else if (string3.equals("showInputDialog")) {
                    windows.get(n).showInputDialog(arrayList3.get(0));
                } else if (string3.equals("showYesNoDialog")) {
                    windows.get(n).showYesNoDialog(arrayList3.get(0));
                } else if (string3.equals("zoomRectangle")) {
                    windows.get(n).zoomRectangle(arrayList.get(0), arrayList.get(1), arrayList.get(2), arrayList.get(3));
                } else if (string3.equals("readImage")) {
                    PImage pImage = SVImageHandler.readImage(arrayList.get(2), in);
                    windows.get(n).drawImage(pImage, arrayList.get(0), arrayList.get(1));
                } else if (string3.equals("drawImage")) {
                    PImage pImage = new PImage(arrayList3.get(0));
                    windows.get(n).drawImage(pImage, arrayList.get(0), arrayList.get(1));
                } else if (string3.equals("destroy")) {
                    windows.get(n).destroy();
                }
            } else if (stringArray[1].startsWith("= luajava.newInstance")) {
                while (windows.size() <= n) {
                    windows.add(null);
                }
                windows.set(n, new SVWindow(arrayList3.get(1), arrayList.get(0), arrayList.get(1), arrayList.get(2), arrayList.get(3), arrayList.get(4), arrayList.get(5), arrayList.get(6)));
            }
        } else if (string.startsWith("svmain") && string.startsWith("svmain:exit")) {
            ScrollView.exit();
        }
    }

    public static void exit() {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            SERVER_PORT = Integer.parseInt(stringArray[0]);
        }
        windows = new ArrayList(100);
        intPattern = Pattern.compile("[0-9-][0-9]*");
        floatPattern = Pattern.compile("[0-9-][0-9]*\\.[0-9]*");
        try {
            ServerSocket serverSocket = new ServerSocket(SERVER_PORT);
            System.out.println("Socket started on port " + SERVER_PORT);
            socket = serverSocket.accept();
            System.out.println("Client connected");
            out = new PrintStream(socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF8"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        ScrollView.IOLoop();
    }

    static {
        nrInputLines = 0;
        debugViewNetworkTraffic = false;
    }
}

