/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.nodes;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.piccolo2d.PNode;
import org.piccolo2d.nodes.PPath;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PPaintContext;
import org.piccolo2d.util.PPickPath;

public class PClip
extends PPath.Float {
    private static final long serialVersionUID = 1L;

    public PBounds computeFullBounds(PBounds dstBounds) {
        PBounds result;
        if (dstBounds == null) {
            result = new PBounds();
        } else {
            result = dstBounds;
            result.reset();
        }
        result.add(this.getBoundsReference());
        this.localToParent((Rectangle2D)result);
        return result;
    }

    public void repaintFrom(PBounds localBounds, PNode childOrThis) {
        if (childOrThis != this) {
            Rectangle2D.intersect((Rectangle2D)this.getBoundsReference(), (Rectangle2D)localBounds, (Rectangle2D)localBounds);
            super.repaintFrom(localBounds, childOrThis);
        } else {
            super.repaintFrom(localBounds, childOrThis);
        }
    }

    protected void paint(PPaintContext paintContext) {
        Paint p = this.getPaint();
        if (p != null) {
            Graphics2D g2 = paintContext.getGraphics();
            g2.setPaint(p);
            g2.fill(this.getPathReference());
        }
        paintContext.pushClip((Shape)this.getPathReference());
    }

    protected void paintAfterChildren(PPaintContext paintContext) {
        paintContext.popClip((Shape)this.getPathReference());
        if (this.getStroke() != null && this.getStrokePaint() != null) {
            Graphics2D g2 = paintContext.getGraphics();
            g2.setPaint(this.getStrokePaint());
            g2.setStroke(this.getStroke());
            g2.draw(this.getPathReference());
        }
    }

    public boolean fullPick(PPickPath pickPath) {
        if (this.getPickable() && this.fullIntersects((Rectangle2D)pickPath.getPickBounds())) {
            pickPath.pushNode((PNode)this);
            pickPath.pushTransform(this.getTransformReference(false));
            if (this.pick(pickPath)) {
                return true;
            }
            if (this.getChildrenPickable() && this.getPathReference().intersects((Rectangle2D)pickPath.getPickBounds())) {
                int count = this.getChildrenCount();
                for (int i = count - 1; i >= 0; --i) {
                    PNode each = this.getChild(i);
                    if (!each.fullPick(pickPath)) continue;
                    return true;
                }
            }
            if (this.pickAfterChildren(pickPath)) {
                return true;
            }
            pickPath.popTransform(this.getTransformReference(false));
            pickPath.popNode((PNode)this);
        }
        return false;
    }
}

