// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/sensu/sensu-go/api/core/v2/mutator.proto

package v2

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	github_com_golang_protobuf_proto "github.com/golang/protobuf/proto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A Mutator is a mutator specification.
type Mutator struct {
	// Metadata contains the name, namespace, labels and annotations of the
	// mutator
	ObjectMeta `protobuf:"bytes,1,opt,name=metadata,proto3,embedded=metadata" json:"metadata,omitempty"`
	// Command is the command to be executed.
	Command string `protobuf:"bytes,2,opt,name=command,proto3" json:"command,omitempty"`
	// Timeout is the command execution timeout in seconds.
	Timeout uint32 `protobuf:"varint,3,opt,name=timeout,proto3" json:"timeout"`
	// Env is a list of environment variables to use with command execution
	EnvVars []string `protobuf:"bytes,4,rep,name=env_vars,json=envVars,proto3" json:"env_vars"`
	// RuntimeAssets are a list of assets required to execute a mutator.
	RuntimeAssets []string `protobuf:"bytes,8,rep,name=runtime_assets,json=runtimeAssets,proto3" json:"runtime_assets"`
	// Secrets is the list of Sensu secrets to set for the mutators's
	// execution environment.
	Secrets []*Secret `protobuf:"bytes,9,rep,name=secrets,proto3" json:"secrets"`
	// Type specifies the type of the mutator. If blank or set to "pipe", the
	// mutator will execute a command with the default shell of the sensu user.
	// If set to "javascript", the eval field will be used, interpreted as ECMAScript 5
	// and run on the Otto VM. The runtime assets will be assumed to be javascript
	// assets, and the environment variables will be made available to the global
	// environment of the mutator.
	Type string `protobuf:"bytes,10,opt,name=type,proto3" json:"type,omitempty"`
	// When the type of the mutator is "javascript", the eval field will be expected
	// to hold a valid ECMAScript 5 expression.
	Eval                 string   `protobuf:"bytes,11,opt,name=eval,proto3" json:"eval,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Mutator) Reset()         { *m = Mutator{} }
func (m *Mutator) String() string { return proto.CompactTextString(m) }
func (*Mutator) ProtoMessage()    {}
func (*Mutator) Descriptor() ([]byte, []int) {
	return fileDescriptor_7da68774301ea6ee, []int{0}
}
func (m *Mutator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Mutator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Mutator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Mutator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mutator.Merge(m, src)
}
func (m *Mutator) XXX_Size() int {
	return m.Size()
}
func (m *Mutator) XXX_DiscardUnknown() {
	xxx_messageInfo_Mutator.DiscardUnknown(m)
}

var xxx_messageInfo_Mutator proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Mutator)(nil), "sensu.core.v2.Mutator")
}

func init() {
	proto.RegisterFile("github.com/sensu/sensu-go/api/core/v2/mutator.proto", fileDescriptor_7da68774301ea6ee)
}

var fileDescriptor_7da68774301ea6ee = []byte{
	// 417 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x51, 0xbf, 0x6e, 0xd4, 0x30,
	0x18, 0x3f, 0xf7, 0x2a, 0x72, 0xe7, 0xe3, 0x18, 0x2c, 0x21, 0x99, 0x0e, 0x76, 0x84, 0x04, 0x64,
	0x00, 0x87, 0xe6, 0x58, 0x40, 0x0c, 0x90, 0xbd, 0x42, 0x0a, 0x82, 0x81, 0xa5, 0x72, 0x52, 0x13,
	0x82, 0x48, 0x1c, 0xc5, 0x8e, 0xa5, 0xbe, 0x01, 0x8f, 0xc0, 0x82, 0xd4, 0xb1, 0x8f, 0xc0, 0x23,
	0x74, 0xec, 0x13, 0x44, 0x10, 0xb6, 0x3c, 0x01, 0x23, 0xb2, 0x73, 0x29, 0x47, 0xa7, 0x2e, 0xd1,
	0xf7, 0xfb, 0x6b, 0x7f, 0x0e, 0xdc, 0xe4, 0x85, 0xfe, 0xd4, 0xa6, 0x2c, 0x93, 0x65, 0xa8, 0x44,
	0xa5, 0xda, 0xf1, 0xfb, 0x24, 0x97, 0x21, 0xaf, 0x8b, 0x30, 0x93, 0x8d, 0x08, 0x4d, 0x14, 0x96,
	0xad, 0xe6, 0x5a, 0x36, 0xac, 0x6e, 0xa4, 0x96, 0x68, 0xed, 0x3c, 0xcc, 0x8a, 0xcc, 0x44, 0x07,
	0xcf, 0x76, 0x3a, 0x72, 0x99, 0xcb, 0xd0, 0xb9, 0xd2, 0xf6, 0xe3, 0x2b, 0x73, 0xc8, 0x36, 0xec,
	0xd0, 0x91, 0x8e, 0x73, 0xd3, 0x58, 0x72, 0xf0, 0xf4, 0x86, 0x27, 0x0b, 0xcd, 0xb7, 0x89, 0xe8,
	0x66, 0x09, 0x25, 0xb2, 0x46, 0xe8, 0x31, 0x73, 0xff, 0xfb, 0x1c, 0x7a, 0x47, 0xe3, 0xe5, 0xd1,
	0x3b, 0xb8, 0xb0, 0x6d, 0x27, 0x5c, 0x73, 0x0c, 0x7c, 0x10, 0xac, 0xa2, 0x7b, 0xec, 0xbf, 0x4d,
	0xd8, 0x9b, 0xf4, 0xb3, 0xc8, 0xf4, 0x91, 0xd0, 0x3c, 0x26, 0x17, 0x1d, 0x9d, 0x5d, 0x76, 0x14,
	0x0c, 0x1d, 0x45, 0x53, 0xec, 0xb1, 0x2c, 0x0b, 0x2d, 0xca, 0x5a, 0x9f, 0x26, 0x57, 0x55, 0x08,
	0x43, 0x2f, 0x93, 0x65, 0xc9, 0xab, 0x13, 0xbc, 0xe7, 0x83, 0x60, 0x99, 0x4c, 0x10, 0x3d, 0x80,
	0x9e, 0x2e, 0x4a, 0x21, 0x5b, 0x8d, 0xe7, 0x3e, 0x08, 0xd6, 0xf1, 0x6a, 0xe8, 0xe8, 0x44, 0x25,
	0xd3, 0x80, 0x1e, 0xc1, 0x85, 0xa8, 0xcc, 0xb1, 0xe1, 0x8d, 0xc2, 0xfb, 0xfe, 0x3c, 0x58, 0xc6,
	0xb7, 0x87, 0x8e, 0x5e, 0x71, 0x89, 0x27, 0x2a, 0xf3, 0x9e, 0x37, 0x0a, 0x3d, 0x87, 0x77, 0x9a,
	0xb6, 0xb2, 0xb1, 0x63, 0xae, 0x94, 0xd0, 0x0a, 0x2f, 0x9c, 0x1d, 0x0d, 0x1d, 0xbd, 0xa6, 0x24,
	0xeb, 0x2d, 0x7e, 0xed, 0x20, 0x7a, 0x09, 0xbd, 0xf1, 0x5d, 0x14, 0x5e, 0xfa, 0xf3, 0x60, 0x15,
	0xdd, 0xbd, 0xb6, 0xfa, 0x5b, 0xa7, 0x8e, 0x37, 0xdc, 0x3a, 0x93, 0x69, 0x40, 0x0f, 0xe1, 0xbe,
	0x3e, 0xad, 0x05, 0x86, 0x76, 0xbf, 0xf1, 0x38, 0x8b, 0x77, 0x9e, 0xc3, 0xe9, 0xd6, 0x27, 0x0c,
	0xff, 0x82, 0x57, 0xff, 0x7c, 0x16, 0xef, 0xfa, 0x2c, 0x7e, 0xb1, 0xf8, 0x7a, 0x46, 0x67, 0xe7,
	0x67, 0x14, 0xc4, 0xfe, 0x9f, 0x5f, 0x04, 0x9c, 0xf7, 0x04, 0xfc, 0xe8, 0x09, 0xb8, 0xe8, 0x09,
	0xb8, 0xec, 0x09, 0xf8, 0xd9, 0x13, 0xf0, 0xed, 0x37, 0x99, 0x7d, 0xd8, 0x33, 0x51, 0x7a, 0xcb,
	0xfd, 0xc8, 0xcd, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd0, 0x15, 0x8e, 0x91, 0xaa, 0x02, 0x00,
	0x00,
}

func (this *Mutator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Mutator)
	if !ok {
		that2, ok := that.(Mutator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ObjectMeta.Equal(&that1.ObjectMeta) {
		return false
	}
	if this.Command != that1.Command {
		return false
	}
	if this.Timeout != that1.Timeout {
		return false
	}
	if len(this.EnvVars) != len(that1.EnvVars) {
		return false
	}
	for i := range this.EnvVars {
		if this.EnvVars[i] != that1.EnvVars[i] {
			return false
		}
	}
	if len(this.RuntimeAssets) != len(that1.RuntimeAssets) {
		return false
	}
	for i := range this.RuntimeAssets {
		if this.RuntimeAssets[i] != that1.RuntimeAssets[i] {
			return false
		}
	}
	if len(this.Secrets) != len(that1.Secrets) {
		return false
	}
	for i := range this.Secrets {
		if !this.Secrets[i].Equal(that1.Secrets[i]) {
			return false
		}
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Eval != that1.Eval {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}

type MutatorFace interface {
	Proto() github_com_golang_protobuf_proto.Message
	GetObjectMeta() ObjectMeta
	GetCommand() string
	GetTimeout() uint32
	GetEnvVars() []string
	GetRuntimeAssets() []string
	GetSecrets() []*Secret
	GetType() string
	GetEval() string
}

func (this *Mutator) Proto() github_com_golang_protobuf_proto.Message {
	return this
}

func (this *Mutator) TestProto() github_com_golang_protobuf_proto.Message {
	return NewMutatorFromFace(this)
}

func (this *Mutator) GetObjectMeta() ObjectMeta {
	return this.ObjectMeta
}

func (this *Mutator) GetCommand() string {
	return this.Command
}

func (this *Mutator) GetTimeout() uint32 {
	return this.Timeout
}

func (this *Mutator) GetEnvVars() []string {
	return this.EnvVars
}

func (this *Mutator) GetRuntimeAssets() []string {
	return this.RuntimeAssets
}

func (this *Mutator) GetSecrets() []*Secret {
	return this.Secrets
}

func (this *Mutator) GetType() string {
	return this.Type
}

func (this *Mutator) GetEval() string {
	return this.Eval
}

func NewMutatorFromFace(that MutatorFace) *Mutator {
	this := &Mutator{}
	this.ObjectMeta = that.GetObjectMeta()
	this.Command = that.GetCommand()
	this.Timeout = that.GetTimeout()
	this.EnvVars = that.GetEnvVars()
	this.RuntimeAssets = that.GetRuntimeAssets()
	this.Secrets = that.GetSecrets()
	this.Type = that.GetType()
	this.Eval = that.GetEval()
	return this
}

func (m *Mutator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mutator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Mutator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Eval) > 0 {
		i -= len(m.Eval)
		copy(dAtA[i:], m.Eval)
		i = encodeVarintMutator(dAtA, i, uint64(len(m.Eval)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintMutator(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Secrets) > 0 {
		for iNdEx := len(m.Secrets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Secrets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMutator(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.RuntimeAssets) > 0 {
		for iNdEx := len(m.RuntimeAssets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RuntimeAssets[iNdEx])
			copy(dAtA[i:], m.RuntimeAssets[iNdEx])
			i = encodeVarintMutator(dAtA, i, uint64(len(m.RuntimeAssets[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.EnvVars) > 0 {
		for iNdEx := len(m.EnvVars) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.EnvVars[iNdEx])
			copy(dAtA[i:], m.EnvVars[iNdEx])
			i = encodeVarintMutator(dAtA, i, uint64(len(m.EnvVars[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.Timeout != 0 {
		i = encodeVarintMutator(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Command) > 0 {
		i -= len(m.Command)
		copy(dAtA[i:], m.Command)
		i = encodeVarintMutator(dAtA, i, uint64(len(m.Command)))
		i--
		dAtA[i] = 0x12
	}
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMutator(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintMutator(dAtA []byte, offset int, v uint64) int {
	offset -= sovMutator(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedMutator(r randyMutator, easy bool) *Mutator {
	this := &Mutator{}
	v1 := NewPopulatedObjectMeta(r, easy)
	this.ObjectMeta = *v1
	this.Command = string(randStringMutator(r))
	this.Timeout = uint32(r.Uint32())
	v2 := r.Intn(10)
	this.EnvVars = make([]string, v2)
	for i := 0; i < v2; i++ {
		this.EnvVars[i] = string(randStringMutator(r))
	}
	v3 := r.Intn(10)
	this.RuntimeAssets = make([]string, v3)
	for i := 0; i < v3; i++ {
		this.RuntimeAssets[i] = string(randStringMutator(r))
	}
	if r.Intn(5) != 0 {
		v4 := r.Intn(5)
		this.Secrets = make([]*Secret, v4)
		for i := 0; i < v4; i++ {
			this.Secrets[i] = NewPopulatedSecret(r, easy)
		}
	}
	this.Type = string(randStringMutator(r))
	this.Eval = string(randStringMutator(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMutator(r, 12)
	}
	return this
}

type randyMutator interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMutator(r randyMutator) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringMutator(r randyMutator) string {
	v5 := r.Intn(100)
	tmps := make([]rune, v5)
	for i := 0; i < v5; i++ {
		tmps[i] = randUTF8RuneMutator(r)
	}
	return string(tmps)
}
func randUnrecognizedMutator(r randyMutator, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldMutator(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldMutator(dAtA []byte, r randyMutator, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateMutator(dAtA, uint64(key))
		v6 := r.Int63()
		if r.Intn(2) == 0 {
			v6 *= -1
		}
		dAtA = encodeVarintPopulateMutator(dAtA, uint64(v6))
	case 1:
		dAtA = encodeVarintPopulateMutator(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateMutator(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateMutator(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateMutator(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateMutator(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Mutator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ObjectMeta.Size()
	n += 1 + l + sovMutator(uint64(l))
	l = len(m.Command)
	if l > 0 {
		n += 1 + l + sovMutator(uint64(l))
	}
	if m.Timeout != 0 {
		n += 1 + sovMutator(uint64(m.Timeout))
	}
	if len(m.EnvVars) > 0 {
		for _, s := range m.EnvVars {
			l = len(s)
			n += 1 + l + sovMutator(uint64(l))
		}
	}
	if len(m.RuntimeAssets) > 0 {
		for _, s := range m.RuntimeAssets {
			l = len(s)
			n += 1 + l + sovMutator(uint64(l))
		}
	}
	if len(m.Secrets) > 0 {
		for _, e := range m.Secrets {
			l = e.Size()
			n += 1 + l + sovMutator(uint64(l))
		}
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovMutator(uint64(l))
	}
	l = len(m.Eval)
	if l > 0 {
		n += 1 + l + sovMutator(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMutator(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMutator(x uint64) (n int) {
	return sovMutator(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Mutator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMutator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mutator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mutator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMutator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMutator
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMutator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMutator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMutator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMutator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			m.Timeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMutator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timeout |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvVars", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMutator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMutator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMutator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EnvVars = append(m.EnvVars, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeAssets", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMutator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMutator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMutator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeAssets = append(m.RuntimeAssets, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secrets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMutator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMutator
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMutator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secrets = append(m.Secrets, &Secret{})
			if err := m.Secrets[len(m.Secrets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMutator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMutator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMutator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Eval", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMutator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMutator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMutator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Eval = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMutator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMutator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMutator(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMutator
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMutator
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMutator
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMutator
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMutator
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMutator
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMutator        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMutator          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMutator = fmt.Errorf("proto: unexpected end of group")
)
