[comment {-*- tcl -*- doctools manpage}]
[vset CORO_AUTO_VERSION 1.3]
[manpage_begin coroutine::auto n [vset CORO_AUTO_VERSION]]
[keywords after]
[keywords channel]
[keywords coroutine]
[keywords events]
[keywords exit]
[keywords gets]
[keywords global]
[keywords {green threads}]
[keywords read]
[keywords threads]
[keywords update]
[keywords vwait]
[copyright {2010-2014 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Coroutine utilities}]
[category  Coroutine]
[titledesc {Automatic event and IO coroutine awareness}]
[require Tcl "8.6 9"]
[require coroutine::auto [vset CORO_AUTO_VERSION]]
[require coroutine 1.4]
[description]

The [package coroutine::auto] package provides no commands or other
directly visible functionality.

Built on top of the package [package coroutine], it intercepts various
builtin commands of the Tcl core to make any code using them
coroutine-oblivious, i.e. able to run inside and outside of a
coroutine without changes.

[para] The commands so affected by this package are
[list_begin definitions]
[def [cmd after]]
[def [cmd exit]]
[def [cmd gets]]
[def [cmd global]]
[def [cmd puts]]
[def [cmd read]]
[def [cmd socket]]
[def [cmd update]]
[def [cmd vwait]]
[list_end]

[vset CATEGORY coroutine]
[include ../common-text/feedback.inc]
[manpage_end]
