
[//000000001]: # (fileutil::multi \- file utilities)
[//000000002]: # (Generated from file 'multi\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (fileutil::multi\(n\) 0\.1 tcllib "file utilities")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

fileutil::multi \- Multi\-file operation, scatter/gather, standard object

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [PUBLIC API](#section2)

  - [Bugs, Ideas, Feedback](#section3)

  - [Keywords](#keywords)

  - [Category](#category)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.4  
package require fileutil::multi ?0\.1?  
package require fileutil::multi::op ?0\.1?  
package require wip ?1\.0?  

[__::fileutil::multi__ ?*word*\.\.\.?](#1)  

# <a name='description'></a>DESCRIPTION

This package provides a single command to perform actions on multiple files
selected by glob patterns\. It is a thin layer over the package
__[fileutil::multi::op](multiop\.md)__ which provides objects for the
same\. This package simply creates a single such object and directs all file
commands to it\.

At the core is a domain specific language allowing the easy specification of
multi\-file copy and/or move and/or deletion operations\. Alternate names would be
scatter/gather processor, or maybe even assembler\. For the detailed
specification of this language, and examples, please see the documention for the
package __[fileutil::multi::op](multiop\.md)__\.

# <a name='section2'></a>PUBLIC API

The main command of the package is:

  - <a name='1'></a>__::fileutil::multi__ ?*word*\.\.\.?

    This command interprets the specified words as file commands to execute\. See
    the section __FILE API__ of the documentation for the package
    __[fileutil::multi::op](multiop\.md)__ for the set of acceptable
    commands, their syntax, and semantics\.

    The result of the command is the result generated by the last file command
    it executed\.

# <a name='section3'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *fileutil* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='keywords'></a>KEYWORDS

[copy](\.\./\.\./\.\./\.\./index\.md\#copy), [file
utilities](\.\./\.\./\.\./\.\./index\.md\#file\_utilities),
[move](\.\./\.\./\.\./\.\./index\.md\#move),
[multi\-file](\.\./\.\./\.\./\.\./index\.md\#multi\_file),
[remove](\.\./\.\./\.\./\.\./index\.md\#remove)

# <a name='category'></a>CATEGORY

Programming tools
