[comment {-*- tcl -*- doctools manpage}]
[manpage_begin soundex n 1.0]
[copyright {????, Algorithm: Donald E. Knuth}]
[copyright {2003, Documentation: Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[copyright {1998, Tcl port: Evan Rempel <erempel@uvic.ca>}]
[moddesc   {Soundex}]
[titledesc {Soundex}]
[category  {Hashes, checksums, and encryption}]
[require Tcl 8.2]
[require soundex [opt 1.0]]
[description]
[para]

This package provides soundex algorithms which allow the
comparison of words based on their phonetic likeness.

[para]

Currently only an algorithm by Knuth is provided, which
is tuned to english names and words.

[list_begin definitions]

[call [cmd ::soundex::knuth] [arg string]]

Computes the soundex code of the input [arg string] using
Knuth's algorithm and returns it as the result of the
command.

[list_end]


[section EXAMPLES]

[example {
    % ::soundex::knuth Knuth
    K530
}]

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph soundex] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords soundex knuth {text comparison} {text likeness}]
[manpage_end]
