[comment {-*- tcl -*- doctools manpage}]
[manpage_begin lambda n 1]
[copyright {2011 Andreas Kupries, BSD licensed}]
[moddesc {Utility commands for anonymous procedures}]
[titledesc {Utility commands for anonymous procedures}]
[category  Utility]
[require Tcl 8.5]
[require lambda [opt 1]]
[keywords lambda {anonymous procedure} callback {command prefix}]
[keywords {partial application} currying proc]
[see_also apply(n) proc(n)]
[description]
[para]

This package provides two convenience commands to make the writing of
anonymous procedures, i.e. lambdas more [cmd proc]-like. Instead of,
for example, to write

[example {
     set f {::apply {{x} {
        ....
     }}}
}]

with its deep nesting of braces, or

[example {
     set f [list ::apply {{x y} {
        ....
     }} $value_for_x]
}]

with a list command to insert some of the arguments of a partial
application, just write

[example {
     set f [lambda {x} {
        ....
     }]
}]

and

[example {
     set f [lambda {x y} {
        ....
     } $value_for_x]
}]

[section {COMMANDS}]

[list_begin definitions]
[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::lambda] [arg arguments] [arg body] [opt [arg arg]...]]

The command constructs an anonymous procedure from the list of
arguments, body script and (optional) predefined argument values and
returns a command prefix representing this anonymous procedure.

[para] When invoked the [arg body] is run in a new procedure scope
just underneath the global scope, with the arguments set to the values
supplied at both construction and invokation time.


[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::lambda@] [arg namespace] [arg arguments] [arg body] [opt [arg arg]...]]

The command constructs an anonymous procedure from the namespace name,
list of arguments, body script and (optional) predefined argument
values and returns a command prefix representing this anonymous
procedure.

[para] When invoked the [arg body] is run in a new procedure scope in
the [arg namespace], with the arguments set to the values supplied at
both construction and invokation time.

[list_end]

[section AUTHORS]
Andreas Kupries

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph lambda] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.

[manpage_end]
