/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.2.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

/*
 * TASMANIAN project, https://github.com/ORNL/TASMANIAN
 * Copyright (c) 2020 Oak Ridge National Laboratory, UT-Battelle, LLC.
 * Distributed under an MIT open source license: see LICENSE for details.
 */

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif

#if __cplusplus >=201103L
# define SWIG_NULLPTR nullptr
#else
# define SWIG_NULLPTR NULL
#endif 


/* C99 and C++11 should provide snprintf, but define SWIG_NO_SNPRINTF
 * if you're missing it.
 */
#if ((defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L) || \
     (defined __cplusplus && __cplusplus >= 201103L) || \
     defined SWIG_HAVE_SNPRINTF) && \
    !defined SWIG_NO_SNPRINTF
# define SWIG_snprintf(O,S,F,A) snprintf(O,S,F,A)
# define SWIG_snprintf2(O,S,F,A,B) snprintf(O,S,F,A,B)
#else
/* Fallback versions ignore the buffer size, but most of our uses either have a
 * fixed maximum possible size or dynamically allocate a buffer that's large
 * enough.
 */
# define SWIG_snprintf(O,S,F,A) sprintf(O,F,A)
# define SWIG_snprintf2(O,S,F,A,B) sprintf(O,F,A,B)
#endif



#ifndef SWIGEXTERN
# ifdef __cplusplus
#   define SWIGEXTERN extern
# else
#   define SWIGEXTERN
# endif
#endif


#define SWIG_exception_impl(DECL, CODE, MSG, RETURNNULL) \
 { throw std::logic_error("In " DECL ": " MSG); }

/* SWIG Errors applicable to all language modules, values are reserved from -1 to -99 */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13



#ifdef __cplusplus
extern "C" {
#endif
SWIGEXPORT void SWIG_check_unhandled_exception_impl(const char* decl);
SWIGEXPORT void SWIG_store_exception(const char* decl, int errcode, const char *msg);
#ifdef __cplusplus
}
#endif


#undef SWIG_exception_impl
#define SWIG_exception_impl(DECL, CODE, MSG, RETURNNULL) \
    SWIG_store_exception(DECL, CODE, MSG); RETURNNULL;


enum SwigMemFlags {
    SWIG_MEM_OWN = 0x01,
    SWIG_MEM_RVALUE = 0x02,
};


#define SWIG_check_nonnull(PTR, TYPENAME, FNAME, FUNCNAME, RETURNNULL) \
  if (!(PTR)) { \
    SWIG_exception_impl(FUNCNAME, SWIG_NullReferenceError, \
                        "Cannot pass null " TYPENAME " (class " FNAME ") " \
                        "as a reference", RETURNNULL); \
  }


namespace swig {
enum AssignmentType {
  ASSIGNMENT_DEFAULT,
  ASSIGNMENT_NODESTRUCT,
  ASSIGNMENT_SMARTPTR
};
}



#define SWIG_VERSION 0x040200
#define SWIGFORTRAN
#define SWIGPOLICY_TasGrid_TasmanianSparseGrid swig::ASSIGNMENT_DEFAULT

#ifdef __cplusplus
#include <utility>
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigSmartPointer {
    T *ptr;
    SwigSmartPointer(T *p) : ptr(p) { }
    ~SwigSmartPointer() { delete ptr; }
    SwigSmartPointer& operator=(SwigSmartPointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
    void reset(T *p) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = p; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigSmartPointer tmp(new T(t)); pointer = tmp; return *this; }
#if __cplusplus >=201103L
  SwigValueWrapper& operator=(T&& t) { SwigSmartPointer tmp(new T(std::move(t))); pointer = tmp; return *this; }
  operator T&&() const { return std::move(*pointer.ptr); }
#else
  operator T&() const { return *pointer.ptr; }
#endif
  T *operator&() const { return pointer.ptr; }
  static void reset(SwigValueWrapper& t, T *p) { t.pointer.reset(p); }
};

/*
 * SwigValueInit() is a generic initialisation solution as the following approach:
 * 
 *       T c_result = T();
 * 
 * doesn't compile for all types for example:
 * 
 *       unsigned int c_result = unsigned int();
 */
template <typename T> T SwigValueInit() {
  return T();
}

#if __cplusplus >=201103L
# define SWIG_STD_MOVE(OBJ) std::move(OBJ)
#else
# define SWIG_STD_MOVE(OBJ) OBJ
#endif

#endif


#include <stdexcept>


/* Support for the `contract` feature.
 *
 * Note that RETURNNULL is first because it's inserted via a 'Replaceall' in
 * the fortran.cxx file.
 */
#define SWIG_contract_assert(RETURNNULL, EXPR, MSG) \
 if (!(EXPR)) { SWIG_exception_impl("$decl", SWIG_ValueError, MSG, RETURNNULL); } 


#define SWIG_as_voidptr(a) const_cast< void * >(static_cast< const void * >(a)) 
#define SWIG_as_voidptrptr(a) ((void)SWIG_as_voidptr(*a),reinterpret_cast< void** >(a)) 



extern "C" {

int tasmanian_ierr = 0;

}



#include <stdlib.h>
#ifdef _MSC_VER
# ifndef strtoull
#  define strtoull _strtoui64
# endif
# ifndef strtoll
#  define strtoll _strtoi64
# endif
#endif


struct SwigArrayWrapper {
    void* data;
    size_t size;
};


SWIGINTERN SwigArrayWrapper SwigArrayWrapper_uninitialized() {
  SwigArrayWrapper result;
  result.data = NULL;
  result.size = 0;
  return result;
}


#include <string.h>


// Stored exception message
SWIGINTERN const char* swig_last_exception_cstr = NULL;
// Retrieve error message
SWIGEXPORT const char* tasmanian_get_serr() {
  if (!swig_last_exception_cstr) {
    SWIG_store_exception("UNKNOWN", SWIG_RuntimeError,
                         "no error string was present");
  }
  return swig_last_exception_cstr;
}


#include <string>


#include <cctype>

extern "C" {

// Call this function before any new action
SWIGEXPORT void SWIG_check_unhandled_exception_impl(const char* decl) {
  if (tasmanian_ierr != 0) {
    // Construct message; calling the error string function ensures that
    // the string is allocated if the user did something goofy like
    // manually setting the integer. Since this function is not expected to
    // be wrapped by a catch statement, it will probably terminate the
    // program.
    std::string msg("An unhandled exception occurred before a call to ");
    msg += decl;
    msg += "; ";
    std::string prev_msg = tasmanian_get_serr();
    prev_msg[0] = std::tolower(prev_msg[0]);
    msg += prev_msg;
    throw std::runtime_error(msg);
  }
}

// Save an exception to the fortran error code and string
SWIGEXPORT void SWIG_store_exception(const char *decl,
                                     int errcode,
                                     const char *msg) {
  ::tasmanian_ierr = errcode;

  static std::string last_exception_msg;
  // Save the message to a std::string first
  last_exception_msg = "In ";
  last_exception_msg += decl;
  last_exception_msg += ": ";
  last_exception_msg += msg;
  swig_last_exception_cstr = last_exception_msg.c_str();
}
}


#include <typeinfo>
#include <stdexcept>


#include <stdint.h>


#include "tsgEnumerates.hpp"


#include "TasmanianSparseGrid.hpp"


struct SwigClassWrapper {
    void* cptr;
    int cmemflags;
};


SWIGINTERN SwigClassWrapper SwigClassWrapper_uninitialized() {
    SwigClassWrapper result;
    result.cptr = NULL;
    result.cmemflags = 0;
    return result;
}

SWIGINTERN void TasGrid_TasmanianSparseGrid_setConformalTransformASIN__SWIG_1(TasGrid::TasmanianSparseGrid *self,int *truncation){
        self->setConformalTransformASIN( std::vector<int>(truncation, truncation + self->getNumDimensions()) );
    }

namespace swig {

template<class T, AssignmentType A>
struct DestructorPolicy {
  static SwigClassWrapper destroy(SwigClassWrapper self) {
    delete static_cast<T*>(self.cptr);
    return SwigClassWrapper_uninitialized();
  }
};
template<class T>
struct DestructorPolicy<T, ASSIGNMENT_NODESTRUCT> {
  static SwigClassWrapper destroy(SwigClassWrapper) {
    SWIG_exception_impl("assignment", SWIG_TypeError, "Invalid assignment: class type has private destructor", return SwigClassWrapper_uninitialized());
  }
};
}


namespace swig {

SWIGINTERN SwigClassWrapper capture(SwigClassWrapper other) {
  other.cmemflags &= ~SWIG_MEM_RVALUE;
  return other;
}

template<class T, AssignmentType A>
struct AssignmentPolicy {
  static SwigClassWrapper destroy(SwigClassWrapper self) {
    return DestructorPolicy<T, A>::destroy(self);
  }
  static SwigClassWrapper alias(SwigClassWrapper other) {
    SwigClassWrapper self = other;
    self.cmemflags &= ~SWIG_MEM_OWN;
    return self;
  }
  static SwigClassWrapper move_alias(SwigClassWrapper self, SwigClassWrapper other) {
    if (self.cmemflags & SWIG_MEM_OWN) {
      destroy(self);
    }
    return capture(other);
  }
  static SwigClassWrapper copy_alias(SwigClassWrapper self, SwigClassWrapper other) {
    if (self.cmemflags & SWIG_MEM_OWN) {
      destroy(self);
    }
    return capture(other);
  }
};

template<class T>
struct AssignmentPolicy<T, ASSIGNMENT_SMARTPTR> {
  static SwigClassWrapper destroy(SwigClassWrapper self) {
    return DestructorPolicy<T, ASSIGNMENT_SMARTPTR>::destroy(self);
  }
  static SwigClassWrapper alias(SwigClassWrapper other) {
    SwigClassWrapper self;
    self.cptr = new T(*static_cast<T*>(other.cptr));
    self.cmemflags = other.cmemflags | SWIG_MEM_OWN;
    return self;
  }
  static SwigClassWrapper move_alias(SwigClassWrapper self, SwigClassWrapper other) {
    self = copy_alias(self, other);
    self.cmemflags = other.cmemflags & ~SWIG_MEM_RVALUE;
    destroy(other);
    return self;
  }
  static SwigClassWrapper copy_alias(SwigClassWrapper self, SwigClassWrapper other) {
    // LHS and RHS should both 'own' their shared pointers
    T *pself = static_cast<T*>(self.cptr);
    T *pother = static_cast<T*>(other.cptr);
    *pself = *pother;
    return self;
  }
};

} // end namespace swig

template<class T, swig::AssignmentType A>
SWIGINTERN void SWIG_assign(SwigClassWrapper* self, SwigClassWrapper other) {
  typedef swig::AssignmentPolicy<T, A> Policy_t;

  if (self->cptr == NULL) {
    /* LHS is unassigned */
    if (other.cmemflags & SWIG_MEM_RVALUE) {
      /* Capture pointer from RHS, clear 'moving' flag */
      *self = swig::capture(other);
    } else {
      /* Aliasing another class; clear ownership or copy smart pointer */
      *self = Policy_t::alias(other);
    }
  } else if (other.cptr == NULL) {
    /* Replace LHS with a null pointer */
    *self = Policy_t::destroy(*self);
  } else if (self->cptr == other.cptr) {
    /* Self-assignment: ignore */
  } else if (other.cmemflags & SWIG_MEM_RVALUE) {
    /* Transferred ownership from a variable that's about to be lost.
     * Move-assign and delete the transient data */
    *self = Policy_t::move_alias(*self, other);
  } else {
    /* RHS shouldn't be deleted, alias to LHS */
    *self = Policy_t::copy_alias(*self, other);
  }
}

template<class T, swig::AssignmentType A>
SWIGINTERN void SWIG_free_rvalue(SwigClassWrapper other) {
  typedef swig::AssignmentPolicy<T, A> Policy_t;
  if (other.cmemflags & SWIG_MEM_RVALUE 
      && other.cmemflags & SWIG_MEM_OWN) {
    /* We own *and* are being passed an expiring value */
    Policy_t::destroy(other);
  }
}


extern "C" {
SWIGEXPORT SwigArrayWrapper _wrap_get_serr() {
  SwigArrayWrapper fresult ;
  char *result = 0 ;
  
  result = (char *)tasmanian_get_serr();
  fresult.size = strlen((char*)(result));
  fresult.data = const_cast< char * >(result);
  return fresult;
}


SWIGEXPORT SwigClassWrapper _wrap_new_TasmanianSparseGrid__SWIG_0() {
  SwigClassWrapper fresult ;
  TasGrid::TasmanianSparseGrid *result = 0 ;
  
  result = (TasGrid::TasmanianSparseGrid *)new TasGrid::TasmanianSparseGrid();
  fresult.cptr = (void*)result;
  fresult.cmemflags = SWIG_MEM_RVALUE | (1 ? SWIG_MEM_OWN : 0);
  return fresult;
}


SWIGEXPORT SwigClassWrapper _wrap_new_TasmanianSparseGrid__SWIG_1(SwigClassWrapper *farg1) {
  SwigClassWrapper fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = 0 ;
  TasGrid::TasmanianSparseGrid *result = 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const &", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::TasmanianSparseGrid(TasGrid::TasmanianSparseGrid const &)", return SwigClassWrapper_uninitialized());
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (TasGrid::TasmanianSparseGrid *)new TasGrid::TasmanianSparseGrid((TasGrid::TasmanianSparseGrid const &)*arg1);
  fresult.cptr = (void*)result;
  fresult.cmemflags = SWIG_MEM_RVALUE | (1 ? SWIG_MEM_OWN : 0);
  return fresult;
}


SWIGEXPORT void _wrap_delete_TasmanianSparseGrid(SwigClassWrapper *farg1) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  delete arg1;
}


SWIGEXPORT SwigArrayWrapper _wrap_TasmanianSparseGrid_getVersion() {
  SwigArrayWrapper fresult ;
  char *result = 0 ;
  
  result = (char *)TasGrid::TasmanianSparseGrid::getVersion();
  fresult.size = strlen((char*)(result));
  fresult.data = const_cast< char * >(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getVersionMajor() {
  int fresult ;
  int result;
  
  result = (int)TasGrid::TasmanianSparseGrid::getVersionMajor();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getVersionMinor() {
  int fresult ;
  int result;
  
  result = (int)TasGrid::TasmanianSparseGrid::getVersionMinor();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT SwigArrayWrapper _wrap_TasmanianSparseGrid_getLicense() {
  SwigArrayWrapper fresult ;
  char *result = 0 ;
  
  result = (char *)TasGrid::TasmanianSparseGrid::getLicense();
  fresult.size = strlen((char*)(result));
  fresult.data = const_cast< char * >(result);
  return fresult;
}


SWIGEXPORT SwigArrayWrapper _wrap_TasmanianSparseGrid_getGitCommitHash() {
  SwigArrayWrapper fresult ;
  char *result = 0 ;
  
  result = (char *)TasGrid::TasmanianSparseGrid::getGitCommitHash();
  fresult.size = strlen((char*)(result));
  fresult.data = const_cast< char * >(result);
  return fresult;
}


SWIGEXPORT SwigArrayWrapper _wrap_TasmanianSparseGrid_getCmakeCxxFlags() {
  SwigArrayWrapper fresult ;
  char *result = 0 ;
  
  result = (char *)TasGrid::TasmanianSparseGrid::getCmakeCxxFlags();
  fresult.size = strlen((char*)(result));
  fresult.data = const_cast< char * >(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isOpenMPEnabled() {
  int fresult ;
  bool result;
  
  result = (bool)TasGrid::TasmanianSparseGrid::isOpenMPEnabled();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isCudaEnabled() {
  int fresult ;
  bool result;
  
  result = (bool)TasGrid::TasmanianSparseGrid::isCudaEnabled();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isHipEnabled() {
  int fresult ;
  bool result;
  
  result = (bool)TasGrid::TasmanianSparseGrid::isHipEnabled();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isDpcppEnabled() {
  int fresult ;
  bool result;
  
  result = (bool)TasGrid::TasmanianSparseGrid::isDpcppEnabled();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_write__SWIG_0(SwigClassWrapper *farg1, SwigArrayWrapper *farg2, int const *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  char *arg2 = (char *) 0 ;
  bool arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::write(char const *,bool) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (char *)(farg2->data);
  arg3 = (*farg3 ? true : false);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->write((char const *)arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_write__SWIG_1(SwigClassWrapper *farg1, SwigArrayWrapper *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  char *arg2 = (char *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::write(char const *) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (char *)(farg2->data);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->write((char const *)arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_read__SWIG_0(SwigClassWrapper *farg1, SwigArrayWrapper *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  char *arg2 = (char *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::read(char const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (char *)(farg2->data);
  (arg1)->read((char const *)arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeGlobalGrid__SWIG_5(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6, int *farg7, double const *farg8, double const *farg9, SwigArrayWrapper *farg10, int *farg11) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  int *arg7 = (int *) 0 ;
  double arg8 ;
  double arg9 ;
  char *arg10 = (char *) 0 ;
  int *arg11 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeGlobalGrid(int,int,int,TasGrid::TypeDepth,TasGrid::TypeOneDRule,int const *,double,double,char const *,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  arg7 = (int *)(farg7);
  arg8 = (double)(*farg8);
  arg9 = (double)(*farg9);
  arg10 = (char *)(farg10->data);
  arg11 = (int *)(farg11);
  (arg1)->makeGlobalGrid(arg2,arg3,arg4,arg5,arg6,(int const *)arg7,arg8,arg9,(char const *)arg10,(int const *)arg11);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeGlobalGrid__SWIG_6(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6, int *farg7, double const *farg8, double const *farg9, SwigArrayWrapper *farg10) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  int *arg7 = (int *) 0 ;
  double arg8 ;
  double arg9 ;
  char *arg10 = (char *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeGlobalGrid(int,int,int,TasGrid::TypeDepth,TasGrid::TypeOneDRule,int const *,double,double,char const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  arg7 = (int *)(farg7);
  arg8 = (double)(*farg8);
  arg9 = (double)(*farg9);
  arg10 = (char *)(farg10->data);
  (arg1)->makeGlobalGrid(arg2,arg3,arg4,arg5,arg6,(int const *)arg7,arg8,arg9,(char const *)arg10);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeGlobalGrid__SWIG_7(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6, int *farg7, double const *farg8, double const *farg9) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  int *arg7 = (int *) 0 ;
  double arg8 ;
  double arg9 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeGlobalGrid(int,int,int,TasGrid::TypeDepth,TasGrid::TypeOneDRule,int const *,double,double)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  arg7 = (int *)(farg7);
  arg8 = (double)(*farg8);
  arg9 = (double)(*farg9);
  (arg1)->makeGlobalGrid(arg2,arg3,arg4,arg5,arg6,(int const *)arg7,arg8,arg9);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeGlobalGrid__SWIG_8(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6, int *farg7, double const *farg8) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  int *arg7 = (int *) 0 ;
  double arg8 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeGlobalGrid(int,int,int,TasGrid::TypeDepth,TasGrid::TypeOneDRule,int const *,double)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  arg7 = (int *)(farg7);
  arg8 = (double)(*farg8);
  (arg1)->makeGlobalGrid(arg2,arg3,arg4,arg5,arg6,(int const *)arg7,arg8);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeGlobalGrid__SWIG_9(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6, int *farg7) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  int *arg7 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeGlobalGrid(int,int,int,TasGrid::TypeDepth,TasGrid::TypeOneDRule,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  arg7 = (int *)(farg7);
  (arg1)->makeGlobalGrid(arg2,arg3,arg4,arg5,arg6,(int const *)arg7);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeGlobalGrid__SWIG_10(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeGlobalGrid(int,int,int,TasGrid::TypeDepth,TasGrid::TypeOneDRule)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  (arg1)->makeGlobalGrid(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeSequenceGrid__SWIG_2(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6, int *farg7, int *farg8) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  int *arg7 = (int *) 0 ;
  int *arg8 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeSequenceGrid(int,int,int,TasGrid::TypeDepth,TasGrid::TypeOneDRule,int const *,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  arg7 = (int *)(farg7);
  arg8 = (int *)(farg8);
  (arg1)->makeSequenceGrid(arg2,arg3,arg4,arg5,arg6,(int const *)arg7,(int const *)arg8);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeSequenceGrid__SWIG_3(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6, int *farg7) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  int *arg7 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeSequenceGrid(int,int,int,TasGrid::TypeDepth,TasGrid::TypeOneDRule,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  arg7 = (int *)(farg7);
  (arg1)->makeSequenceGrid(arg2,arg3,arg4,arg5,arg6,(int const *)arg7);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeSequenceGrid__SWIG_4(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeSequenceGrid(int,int,int,TasGrid::TypeDepth,TasGrid::TypeOneDRule)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  (arg1)->makeSequenceGrid(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeLocalPolynomialGrid__SWIG_1(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6, int *farg7) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  int *arg7 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeLocalPolynomialGrid(int,int,int,int,TasGrid::TypeOneDRule,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (int)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  arg7 = (int *)(farg7);
  (arg1)->makeLocalPolynomialGrid(arg2,arg3,arg4,arg5,arg6,(int const *)arg7);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeLocalPolynomialGrid__SWIG_2(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int const *farg6) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  TasGrid::TypeOneDRule arg6 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeLocalPolynomialGrid(int,int,int,int,TasGrid::TypeOneDRule)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (int)(*farg5);
  arg6 = (TasGrid::TypeOneDRule)(*farg6);
  (arg1)->makeLocalPolynomialGrid(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeLocalPolynomialGrid__SWIG_3(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeLocalPolynomialGrid(int,int,int,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (int)(*farg5);
  (arg1)->makeLocalPolynomialGrid(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeLocalPolynomialGrid__SWIG_4(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeLocalPolynomialGrid(int,int,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  (arg1)->makeLocalPolynomialGrid(arg2,arg3,arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeWaveletGrid__SWIG_1(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int *farg6) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int *arg6 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeWaveletGrid(int,int,int,int,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (int)(*farg5);
  arg6 = (int *)(farg6);
  (arg1)->makeWaveletGrid(arg2,arg3,arg4,arg5,(int const *)arg6);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeWaveletGrid__SWIG_2(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeWaveletGrid(int,int,int,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (int)(*farg5);
  (arg1)->makeWaveletGrid(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeWaveletGrid__SWIG_3(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeWaveletGrid(int,int,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  (arg1)->makeWaveletGrid(arg2,arg3,arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeFourierGrid__SWIG_2(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int *farg6, int *farg7) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  int *arg6 = (int *) 0 ;
  int *arg7 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeFourierGrid(int,int,int,TasGrid::TypeDepth,int const *,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (int *)(farg6);
  arg7 = (int *)(farg7);
  (arg1)->makeFourierGrid(arg2,arg3,arg4,arg5,(int const *)arg6,(int const *)arg7);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeFourierGrid__SWIG_3(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5, int *farg6) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  int *arg6 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeFourierGrid(int,int,int,TasGrid::TypeDepth,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  arg6 = (int *)(farg6);
  (arg1)->makeFourierGrid(arg2,arg3,arg4,arg5,(int const *)arg6);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_makeFourierGrid__SWIG_4(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int const *farg5) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  TasGrid::TypeDepth arg5 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::makeFourierGrid(int,int,int,TasGrid::TypeDepth)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (TasGrid::TypeDepth)(*farg5);
  (arg1)->makeFourierGrid(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_copyGrid__SWIG_0(SwigClassWrapper *farg1, SwigClassWrapper *farg2, int const *farg3, int const *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  TasGrid::TasmanianSparseGrid *arg2 = 0 ;
  int arg3 ;
  int arg4 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::copyGrid(TasGrid::TasmanianSparseGrid const &,int,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  SWIG_check_nonnull(farg2->cptr, "TasGrid::TasmanianSparseGrid const &", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::copyGrid(TasGrid::TasmanianSparseGrid const &,int,int)", return );
  arg2 = (TasGrid::TasmanianSparseGrid *)farg2->cptr;
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  (arg1)->copyGrid((TasGrid::TasmanianSparseGrid const &)*arg2,arg3,arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_copyGrid__SWIG_1(SwigClassWrapper *farg1, SwigClassWrapper *farg2, int const *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  TasGrid::TasmanianSparseGrid *arg2 = 0 ;
  int arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::copyGrid(TasGrid::TasmanianSparseGrid const &,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  SWIG_check_nonnull(farg2->cptr, "TasGrid::TasmanianSparseGrid const &", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::copyGrid(TasGrid::TasmanianSparseGrid const &,int)", return );
  arg2 = (TasGrid::TasmanianSparseGrid *)farg2->cptr;
  arg3 = (int)(*farg3);
  (arg1)->copyGrid((TasGrid::TasmanianSparseGrid const &)*arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_copyGrid__SWIG_2(SwigClassWrapper *farg1, SwigClassWrapper *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  TasGrid::TasmanianSparseGrid *arg2 = 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::copyGrid(TasGrid::TasmanianSparseGrid const &)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  SWIG_check_nonnull(farg2->cptr, "TasGrid::TasmanianSparseGrid const &", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::copyGrid(TasGrid::TasmanianSparseGrid const &)", return );
  arg2 = (TasGrid::TasmanianSparseGrid *)farg2->cptr;
  (arg1)->copyGrid((TasGrid::TasmanianSparseGrid const &)*arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateGlobalGrid__SWIG_2(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int *farg4, int *farg5) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  int *arg4 = (int *) 0 ;
  int *arg5 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateGlobalGrid(int,TasGrid::TypeDepth,int const *,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  arg4 = (int *)(farg4);
  arg5 = (int *)(farg5);
  (arg1)->updateGlobalGrid(arg2,arg3,(int const *)arg4,(int const *)arg5);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateGlobalGrid__SWIG_3(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  int *arg4 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateGlobalGrid(int,TasGrid::TypeDepth,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  arg4 = (int *)(farg4);
  (arg1)->updateGlobalGrid(arg2,arg3,(int const *)arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateGlobalGrid__SWIG_4(SwigClassWrapper *farg1, int const *farg2, int const *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateGlobalGrid(int,TasGrid::TypeDepth)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  (arg1)->updateGlobalGrid(arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateSequenceGrid__SWIG_2(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int *farg4, int *farg5) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  int *arg4 = (int *) 0 ;
  int *arg5 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateSequenceGrid(int,TasGrid::TypeDepth,int const *,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  arg4 = (int *)(farg4);
  arg5 = (int *)(farg5);
  (arg1)->updateSequenceGrid(arg2,arg3,(int const *)arg4,(int const *)arg5);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateSequenceGrid__SWIG_3(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  int *arg4 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateSequenceGrid(int,TasGrid::TypeDepth,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  arg4 = (int *)(farg4);
  (arg1)->updateSequenceGrid(arg2,arg3,(int const *)arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateSequenceGrid__SWIG_4(SwigClassWrapper *farg1, int const *farg2, int const *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateSequenceGrid(int,TasGrid::TypeDepth)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  (arg1)->updateSequenceGrid(arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateFourierGrid__SWIG_2(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int *farg4, int *farg5) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  int *arg4 = (int *) 0 ;
  int *arg5 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateFourierGrid(int,TasGrid::TypeDepth,int const *,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  arg4 = (int *)(farg4);
  arg5 = (int *)(farg5);
  (arg1)->updateFourierGrid(arg2,arg3,(int const *)arg4,(int const *)arg5);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateFourierGrid__SWIG_3(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  int *arg4 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateFourierGrid(int,TasGrid::TypeDepth,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  arg4 = (int *)(farg4);
  (arg1)->updateFourierGrid(arg2,arg3,(int const *)arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateFourierGrid__SWIG_4(SwigClassWrapper *farg1, int const *farg2, int const *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateFourierGrid(int,TasGrid::TypeDepth)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  (arg1)->updateFourierGrid(arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateGrid__SWIG_2(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int *farg4, int *farg5) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  int *arg4 = (int *) 0 ;
  int *arg5 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateGrid(int,TasGrid::TypeDepth,int const *,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  arg4 = (int *)(farg4);
  arg5 = (int *)(farg5);
  (arg1)->updateGrid(arg2,arg3,(int const *)arg4,(int const *)arg5);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateGrid__SWIG_3(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  int *arg4 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateGrid(int,TasGrid::TypeDepth,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  arg4 = (int *)(farg4);
  (arg1)->updateGrid(arg2,arg3,(int const *)arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_updateGrid__SWIG_4(SwigClassWrapper *farg1, int const *farg2, int const *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  TasGrid::TypeDepth arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::updateGrid(int,TasGrid::TypeDepth)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (TasGrid::TypeDepth)(*farg3);
  (arg1)->updateGrid(arg2,arg3);
}


SWIGEXPORT double _wrap_TasmanianSparseGrid_getAlpha(SwigClassWrapper *farg1) {
  double fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getAlpha() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (double)((TasGrid::TasmanianSparseGrid const *)arg1)->getAlpha();
  fresult = (double)(result);
  return fresult;
}


SWIGEXPORT double _wrap_TasmanianSparseGrid_getBeta(SwigClassWrapper *farg1) {
  double fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getBeta() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (double)((TasGrid::TasmanianSparseGrid const *)arg1)->getBeta();
  fresult = (double)(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getOrder(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getOrder() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (int)((TasGrid::TasmanianSparseGrid const *)arg1)->getOrder();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getNumDimensions(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getNumDimensions() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (int)((TasGrid::TasmanianSparseGrid const *)arg1)->getNumDimensions();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getNumOutputs(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getNumOutputs() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (int)((TasGrid::TasmanianSparseGrid const *)arg1)->getNumOutputs();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getRule(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  TasGrid::TypeOneDRule result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getRule() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (TasGrid::TypeOneDRule)((TasGrid::TasmanianSparseGrid const *)arg1)->getRule();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT SwigArrayWrapper _wrap_TasmanianSparseGrid_getCustomRuleDescription(SwigClassWrapper *farg1) {
  SwigArrayWrapper fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  char *result = 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getCustomRuleDescription() const", return SwigArrayWrapper_uninitialized());
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (char *)((TasGrid::TasmanianSparseGrid const *)arg1)->getCustomRuleDescription();
  fresult.size = strlen((char*)(result));
  fresult.data = const_cast< char * >(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getNumLoaded(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getNumLoaded() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (int)((TasGrid::TasmanianSparseGrid const *)arg1)->getNumLoaded();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getNumNeeded(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getNumNeeded() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (int)((TasGrid::TasmanianSparseGrid const *)arg1)->getNumNeeded();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getNumPoints(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getNumPoints() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (int)((TasGrid::TasmanianSparseGrid const *)arg1)->getNumPoints();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_getLoadedPoints__SWIG_2(SwigClassWrapper *farg1, double *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getLoadedPoints(double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->getLoadedPoints(arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_getNeededPoints__SWIG_2(SwigClassWrapper *farg1, double *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 = (double *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getNeededPoints(double *) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->getNeededPoints(arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_getPoints__SWIG_2(SwigClassWrapper *farg1, double *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getPoints(double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->getPoints(arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_getQuadratureWeights__SWIG_2(SwigClassWrapper *farg1, double *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getQuadratureWeights(double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->getQuadratureWeights(arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_getInterpolationWeights__SWIG_3(SwigClassWrapper *farg1, double *farg2, double *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  double *arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getInterpolationWeights(double const [],double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (double *)(farg3);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->getInterpolationWeights((double const (*))arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_getDifferentiationWeights__SWIG_3(SwigClassWrapper *farg1, double *farg2, double *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  double *arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getDifferentiationWeights(double const [],double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (double *)(farg3);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->getDifferentiationWeights((double const (*))arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_loadNeededValues__SWIG_1(SwigClassWrapper *farg1, double *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 = (double *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::loadNeededValues(double const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  (arg1)->loadNeededValues((double const *)arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_loadNeededPoints__SWIG_1(SwigClassWrapper *farg1, double *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 = (double *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::loadNeededPoints(double const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  (arg1)->loadNeededPoints((double const *)arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_evaluate__SWIG_1(SwigClassWrapper *farg1, double *farg2, double *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  double *arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::evaluate(double const [],double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (double *)(farg3);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->evaluate((double const (*))arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_evaluateBatch__SWIG_0(SwigClassWrapper *farg1, double *farg2, int const *farg3, double *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  int arg3 ;
  double *arg4 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::evaluateBatch(double const [],int,double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (int)(*farg3);
  arg4 = (double *)(farg4);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->evaluateBatch((double const (*))arg2,arg3,arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_evaluateBatch__SWIG_1(SwigClassWrapper *farg1, float *farg2, int const *farg3, float *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  float *arg2 ;
  int arg3 ;
  float *arg4 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::evaluateBatch(float const [],int,float []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (float *)(farg2);
  arg3 = (int)(*farg3);
  arg4 = (float *)(farg4);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->evaluateBatch((float const (*))arg2,arg3,arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_integrate__SWIG_1(SwigClassWrapper *farg1, double *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::integrate(double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->integrate(arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_differentiate__SWIG_2(SwigClassWrapper *farg1, double *farg2, double *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  double *arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::differentiate(double const [],double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (double *)(farg3);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->differentiate((double const (*))arg2,arg3);
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isGlobal(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  bool result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::isGlobal() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (bool)((TasGrid::TasmanianSparseGrid const *)arg1)->isGlobal();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isSequence(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  bool result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::isSequence() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (bool)((TasGrid::TasmanianSparseGrid const *)arg1)->isSequence();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isLocalPolynomial(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  bool result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::isLocalPolynomial() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (bool)((TasGrid::TasmanianSparseGrid const *)arg1)->isLocalPolynomial();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isWavelet(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  bool result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::isWavelet() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (bool)((TasGrid::TasmanianSparseGrid const *)arg1)->isWavelet();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isFourier(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  bool result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::isFourier() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (bool)((TasGrid::TasmanianSparseGrid const *)arg1)->isFourier();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isEmpty(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  bool result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::isEmpty() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (bool)((TasGrid::TasmanianSparseGrid const *)arg1)->isEmpty();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_empty(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  bool result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::empty() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (bool)((TasGrid::TasmanianSparseGrid const *)arg1)->empty();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_setDomainTransform__SWIG_1(SwigClassWrapper *farg1, double *farg2, double *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  double *arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::setDomainTransform(double const [],double const [])", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (double *)(farg3);
  (arg1)->setDomainTransform((double const (*))arg2,(double const (*))arg3);
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isSetDomainTransfrom(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  bool result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::isSetDomainTransfrom() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (bool)((TasGrid::TasmanianSparseGrid const *)arg1)->isSetDomainTransfrom();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_clearDomainTransform(SwigClassWrapper *farg1) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::clearDomainTransform()", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  (arg1)->clearDomainTransform();
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_getDomainTransform__SWIG_1(SwigClassWrapper *farg1, double *farg2, double *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  double *arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getDomainTransform(double [],double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (double *)(farg3);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->getDomainTransform(arg2,arg3);
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isSetConformalTransformASIN(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  bool result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::isSetConformalTransformASIN() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (bool)((TasGrid::TasmanianSparseGrid const *)arg1)->isSetConformalTransformASIN();
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_clearConformalTransform(SwigClassWrapper *farg1) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::clearConformalTransform()", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  (arg1)->clearConformalTransform();
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_clearLevelLimits(SwigClassWrapper *farg1) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::clearLevelLimits()", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  (arg1)->clearLevelLimits();
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_setAnisotropicRefinement__SWIG_1(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4, int *farg5) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  TasGrid::TypeDepth arg2 ;
  int arg3 ;
  int arg4 ;
  int *arg5 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::setAnisotropicRefinement(TasGrid::TypeDepth,int,int,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (TasGrid::TypeDepth)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (int *)(farg5);
  (arg1)->setAnisotropicRefinement(arg2,arg3,arg4,(int const *)arg5);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_setAnisotropicRefinement__SWIG_2(SwigClassWrapper *farg1, int const *farg2, int const *farg3, int const *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  TasGrid::TypeDepth arg2 ;
  int arg3 ;
  int arg4 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::setAnisotropicRefinement(TasGrid::TypeDepth,int,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (TasGrid::TypeDepth)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (int)(*farg4);
  (arg1)->setAnisotropicRefinement(arg2,arg3,arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_setSurplusRefinement__SWIG_3(SwigClassWrapper *farg1, double const *farg2, int const *farg3, int const *farg4, int *farg5, double *farg6) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double arg2 ;
  TasGrid::TypeRefinement arg3 ;
  int arg4 ;
  int *arg5 = (int *) 0 ;
  double *arg6 = (double *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::setSurplusRefinement(double,TasGrid::TypeRefinement,int,int const *,double const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double)(*farg2);
  arg3 = (TasGrid::TypeRefinement)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (int *)(farg5);
  arg6 = (double *)(farg6);
  (arg1)->setSurplusRefinement(arg2,arg3,arg4,(int const *)arg5,(double const *)arg6);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_setSurplusRefinement__SWIG_4(SwigClassWrapper *farg1, double const *farg2, int const *farg3, int const *farg4, int *farg5) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double arg2 ;
  TasGrid::TypeRefinement arg3 ;
  int arg4 ;
  int *arg5 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::setSurplusRefinement(double,TasGrid::TypeRefinement,int,int const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double)(*farg2);
  arg3 = (TasGrid::TypeRefinement)(*farg3);
  arg4 = (int)(*farg4);
  arg5 = (int *)(farg5);
  (arg1)->setSurplusRefinement(arg2,arg3,arg4,(int const *)arg5);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_setSurplusRefinement__SWIG_5(SwigClassWrapper *farg1, double const *farg2, int const *farg3, int const *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double arg2 ;
  TasGrid::TypeRefinement arg3 ;
  int arg4 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::setSurplusRefinement(double,TasGrid::TypeRefinement,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double)(*farg2);
  arg3 = (TasGrid::TypeRefinement)(*farg3);
  arg4 = (int)(*farg4);
  (arg1)->setSurplusRefinement(arg2,arg3,arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_setSurplusRefinement__SWIG_6(SwigClassWrapper *farg1, double const *farg2, int const *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double arg2 ;
  TasGrid::TypeRefinement arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::setSurplusRefinement(double,TasGrid::TypeRefinement)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double)(*farg2);
  arg3 = (TasGrid::TypeRefinement)(*farg3);
  (arg1)->setSurplusRefinement(arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_clearRefinement(SwigClassWrapper *farg1) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::clearRefinement()", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  (arg1)->clearRefinement();
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_mergeRefinement(SwigClassWrapper *farg1) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::mergeRefinement()", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  (arg1)->mergeRefinement();
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_getHierarchicalCoefficientsStatic(SwigClassWrapper *farg1, double *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 = (double *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getHierarchicalCoefficientsStatic(double *) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->getHierarchicalCoefficientsStatic(arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_setHierarchicalCoefficients__SWIG_1(SwigClassWrapper *farg1, double *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::setHierarchicalCoefficients(double const [])", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  (arg1)->setHierarchicalCoefficients((double const (*))arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_evaluateHierarchicalFunctions__SWIG_2(SwigClassWrapper *farg1, double *farg2, int const *farg3, double *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  int arg3 ;
  double *arg4 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::evaluateHierarchicalFunctions(double const [],int,double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (int)(*farg3);
  arg4 = (double *)(farg4);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->evaluateHierarchicalFunctions((double const (*))arg2,arg3,arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_integrateHierarchicalFunctions__SWIG_2(SwigClassWrapper *farg1, double *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::integrateHierarchicalFunctions(double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->integrateHierarchicalFunctions(arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_printStats__SWIG_1(SwigClassWrapper *farg1) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::printStats() const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  ((TasGrid::TasmanianSparseGrid const *)arg1)->printStats();
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_enableAcceleration__SWIG_0(SwigClassWrapper *farg1, int const *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  TasGrid::TypeAcceleration arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::enableAcceleration(TasGrid::TypeAcceleration)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (TasGrid::TypeAcceleration)(*farg2);
  (arg1)->enableAcceleration(arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_enableAcceleration__SWIG_1(SwigClassWrapper *farg1, int const *farg2, int const *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  TasGrid::TypeAcceleration arg2 ;
  int arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::enableAcceleration(TasGrid::TypeAcceleration,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (TasGrid::TypeAcceleration)(*farg2);
  arg3 = (int)(*farg3);
  (arg1)->enableAcceleration(arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_favorSparseAcceleration(SwigClassWrapper *farg1, int const *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  bool arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::favorSparseAcceleration(bool)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (*farg2 ? true : false);
  (arg1)->favorSparseAcceleration(arg2);
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getAccelerationType(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  TasGrid::TypeAcceleration result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getAccelerationType() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (TasGrid::TypeAcceleration)((TasGrid::TasmanianSparseGrid const *)arg1)->getAccelerationType();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_isAccelerationAvailable(int const *farg1) {
  int fresult ;
  TasGrid::TypeAcceleration arg1 ;
  bool result;
  
  arg1 = (TasGrid::TypeAcceleration)(*farg1);
  result = (bool)TasGrid::TasmanianSparseGrid::isAccelerationAvailable(arg1);
  fresult = (result ? 1 : 0);
  return fresult;
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_setGPUID(SwigClassWrapper *farg1, int const *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::setGPUID(int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  (arg1)->setGPUID(arg2);
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getGPUID(SwigClassWrapper *farg1) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::getGPUID() const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = (int)((TasGrid::TasmanianSparseGrid const *)arg1)->getGPUID();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getNumGPUs() {
  int fresult ;
  int result;
  
  result = (int)TasGrid::TasmanianSparseGrid::getNumGPUs();
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_getGPUMemory(int const *farg1) {
  int fresult ;
  int arg1 ;
  int result;
  
  arg1 = (int)(*farg1);
  result = (int)TasGrid::TasmanianSparseGrid::getGPUMemory(arg1);
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT SwigArrayWrapper _wrap_TasmanianSparseGrid_getGPUName(int const *farg1) {
  SwigArrayWrapper fresult ;
  int arg1 ;
  std::string result;
  
  arg1 = (int)(*farg1);
  result = TasGrid::TasmanianSparseGrid::getGPUName(arg1);
  fresult.size = (&result)->size();
  if (fresult.size > 0) {
    fresult.data = malloc(fresult.size);
    memcpy(fresult.data, (&result)->c_str(), fresult.size);
  } else {
    fresult.data = NULL;
  }
  return fresult;
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_removePointsByHierarchicalCoefficient__SWIG_0(SwigClassWrapper *farg1, double const *farg2, int const *farg3, double *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double arg2 ;
  int arg3 ;
  double *arg4 = (double *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::removePointsByHierarchicalCoefficient(double,int,double const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (double *)(farg4);
  (arg1)->removePointsByHierarchicalCoefficient(arg2,arg3,(double const *)arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_removePointsByHierarchicalCoefficient__SWIG_1(SwigClassWrapper *farg1, double const *farg2, int const *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double arg2 ;
  int arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::removePointsByHierarchicalCoefficient(double,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double)(*farg2);
  arg3 = (int)(*farg3);
  (arg1)->removePointsByHierarchicalCoefficient(arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_removePointsByHierarchicalCoefficient__SWIG_2(SwigClassWrapper *farg1, double const *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::removePointsByHierarchicalCoefficient(double)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double)(*farg2);
  (arg1)->removePointsByHierarchicalCoefficient(arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_removePointsByHierarchicalCoefficient__SWIG_3(SwigClassWrapper *farg1, int const *farg2, int const *farg3, double *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  double *arg4 = (double *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::removePointsByHierarchicalCoefficient(int,int,double const *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  arg4 = (double *)(farg4);
  (arg1)->removePointsByHierarchicalCoefficient(arg2,arg3,(double const *)arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_removePointsByHierarchicalCoefficient__SWIG_4(SwigClassWrapper *farg1, int const *farg2, int const *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  int arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::removePointsByHierarchicalCoefficient(int,int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  (arg1)->removePointsByHierarchicalCoefficient(arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_removePointsByHierarchicalCoefficient__SWIG_5(SwigClassWrapper *farg1, int const *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int arg2 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::removePointsByHierarchicalCoefficient(int)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  (arg1)->removePointsByHierarchicalCoefficient(arg2);
}


SWIGEXPORT int _wrap_TasmanianSparseGrid_evaluateSparseHierarchicalFunctionsGetNZ(SwigClassWrapper *farg1, double *farg2, int const *farg3) {
  int fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  int arg3 ;
  int result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::evaluateSparseHierarchicalFunctionsGetNZ(double const [],int) const", return 0);
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (int)(*farg3);
  result = (int)((TasGrid::TasmanianSparseGrid const *)arg1)->evaluateSparseHierarchicalFunctionsGetNZ((double const (*))arg2,arg3);
  fresult = (int)(result);
  return fresult;
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_evaluateSparseHierarchicalFunctionsStatic(SwigClassWrapper *farg1, double *farg2, int const *farg3, int *farg4, int *farg5, double *farg6) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  int arg3 ;
  int *arg4 ;
  int *arg5 ;
  double *arg6 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::evaluateSparseHierarchicalFunctionsStatic(double const [],int,int [],int [],double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (int)(*farg3);
  arg4 = (int *)(farg4);
  arg5 = (int *)(farg5);
  arg6 = (double *)(farg6);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->evaluateSparseHierarchicalFunctionsStatic((double const (*))arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_evaluateFast__SWIG_0(SwigClassWrapper *farg1, double *farg2, double *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  double *arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::evaluateFast< double >(double const [],double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (double *)(farg3);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->SWIGTEMPLATEDISAMBIGUATOR evaluateFast< double >((double const (*))arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_evaluateFast__SWIG_2(SwigClassWrapper *farg1, float *farg2, float *farg3) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  float *arg2 ;
  float *arg3 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::evaluateFast< float >(float const [],float []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (float *)(farg2);
  arg3 = (float *)(farg3);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->SWIGTEMPLATEDISAMBIGUATOR evaluateFast< float >((float const (*))arg2,arg3);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_evaluateBatchGPU__SWIG_0(SwigClassWrapper *farg1, double *farg2, int const *farg3, double *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  double *arg2 ;
  int arg3 ;
  double *arg4 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::evaluateBatchGPU< double >(double const [],int,double []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (double *)(farg2);
  arg3 = (int)(*farg3);
  arg4 = (double *)(farg4);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->SWIGTEMPLATEDISAMBIGUATOR evaluateBatchGPU< double >((double const (*))arg2,arg3,arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_evaluateBatchGPU__SWIG_1(SwigClassWrapper *farg1, float *farg2, int const *farg3, float *farg4) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  float *arg2 ;
  int arg3 ;
  float *arg4 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::evaluateBatchGPU< float >(float const [],int,float []) const", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (float *)(farg2);
  arg3 = (int)(*farg3);
  arg4 = (float *)(farg4);
  ((TasGrid::TasmanianSparseGrid const *)arg1)->SWIGTEMPLATEDISAMBIGUATOR evaluateBatchGPU< float >((float const (*))arg2,arg3,arg4);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_setConformalTransformASIN__SWIG_1(SwigClassWrapper *farg1, int *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  int *arg2 = (int *) 0 ;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid *", "TasmanianSparseGrid", "TasGrid::TasmanianSparseGrid::setConformalTransformASIN(int *)", return );
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int *)(farg2);
  TasGrid_TasmanianSparseGrid_setConformalTransformASIN__SWIG_1(arg1,arg2);
}


SWIGEXPORT void _wrap_TasmanianSparseGrid_op_assign__(SwigClassWrapper *farg1, SwigClassWrapper *farg2) {
  TasGrid::TasmanianSparseGrid *arg1 = (TasGrid::TasmanianSparseGrid *) 0 ;
  TasGrid::TasmanianSparseGrid *arg2 = 0 ;
  
  (void)sizeof(arg1);
  (void)sizeof(arg2);
  SWIG_assign<TasGrid::TasmanianSparseGrid, SWIGPOLICY_TasGrid_TasmanianSparseGrid>(farg1, *farg2);
  
}


SWIGEXPORT SwigClassWrapper _wrap_TasmanianReadGrid(SwigArrayWrapper *farg1) {
  SwigClassWrapper fresult ;
  char *arg1 = (char *) 0 ;
  TasGrid::TasmanianSparseGrid result;
  
  arg1 = (char *)(farg1->data);
  result = TasGrid::readGrid((char const *)arg1);
  fresult.cptr = new (TasGrid::TasmanianSparseGrid)(result);
  fresult.cmemflags = SWIG_MEM_RVALUE | SWIG_MEM_OWN;
  return fresult;
}


SWIGEXPORT SwigClassWrapper _wrap_TasmanianCopyGrid__SWIG_0(SwigClassWrapper *farg1, int const *farg2, int const *farg3) {
  SwigClassWrapper fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  TasGrid::TasmanianSparseGrid result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const &", "TasmanianSparseGrid", "TasGrid::copyGrid(TasGrid::TasmanianSparseGrid const &,int,int)", return SwigClassWrapper_uninitialized());
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  arg3 = (int)(*farg3);
  result = TasGrid::copyGrid((TasGrid::TasmanianSparseGrid const &)*arg1,arg2,arg3);
  fresult.cptr = new (TasGrid::TasmanianSparseGrid)(result);
  fresult.cmemflags = SWIG_MEM_RVALUE | SWIG_MEM_OWN;
  return fresult;
}


SWIGEXPORT SwigClassWrapper _wrap_TasmanianCopyGrid__SWIG_1(SwigClassWrapper *farg1, int const *farg2) {
  SwigClassWrapper fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = 0 ;
  int arg2 ;
  TasGrid::TasmanianSparseGrid result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const &", "TasmanianSparseGrid", "TasGrid::copyGrid(TasGrid::TasmanianSparseGrid const &,int)", return SwigClassWrapper_uninitialized());
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  arg2 = (int)(*farg2);
  result = TasGrid::copyGrid((TasGrid::TasmanianSparseGrid const &)*arg1,arg2);
  fresult.cptr = new (TasGrid::TasmanianSparseGrid)(result);
  fresult.cmemflags = SWIG_MEM_RVALUE | SWIG_MEM_OWN;
  return fresult;
}


SWIGEXPORT SwigClassWrapper _wrap_TasmanianCopyGrid__SWIG_2(SwigClassWrapper *farg1) {
  SwigClassWrapper fresult ;
  TasGrid::TasmanianSparseGrid *arg1 = 0 ;
  TasGrid::TasmanianSparseGrid result;
  
  SWIG_check_nonnull(farg1->cptr, "TasGrid::TasmanianSparseGrid const &", "TasmanianSparseGrid", "TasGrid::copyGrid(TasGrid::TasmanianSparseGrid const &)", return SwigClassWrapper_uninitialized());
  arg1 = (TasGrid::TasmanianSparseGrid *)farg1->cptr;
  result = TasGrid::copyGrid((TasGrid::TasmanianSparseGrid const &)*arg1);
  fresult.cptr = new (TasGrid::TasmanianSparseGrid)(result);
  fresult.cmemflags = SWIG_MEM_RVALUE | SWIG_MEM_OWN;
  return fresult;
}


} // extern

