; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -ppc-vsr-nums-as-vr -mtriple=powerpc64-unknown-linux-gnu \
; RUN:       -verify-machineinstrs -ppc-asm-full-reg-names -mcpu=pwr8 -relocation-model=pic \
; RUN:       | FileCheck %s
; RUN: llc < %s -ppc-vsr-nums-as-vr -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:       -verify-machineinstrs -ppc-asm-full-reg-names -mcpu=pwr8 -relocation-model=pic \
; RUN:       | FileCheck %s -check-prefix=CHECK-LE
; RUN: llc < %s -vec-extabi -mtriple=powerpc64-ibm-aix-xcoff \
; RUN:       -verify-machineinstrs -mcpu=pwr8 \
; RUN:       | FileCheck %s -check-prefix=CHECK-AIX

; The build[csilf] functions simply test the scalar_to_vector handling with
; direct moves. This corresponds to the "insertelement" instruction. Subsequent
; to this, there will be a splat corresponding to the shufflevector.

@d = common global double 0.000000e+00, align 8

; Function Attrs: norecurse nounwind readnone
define <16 x i8> @buildc(i8 zeroext %a) {
; CHECK-LABEL: buildc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtvsrwz v2, r3
; CHECK-NEXT:    vspltb v2, v2, 7
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: buildc:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mtvsrd v2, r3
; CHECK-LE-NEXT:    vspltb v2, v2, 7
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: buildc:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mtvsrwz 34, 3
; CHECK-AIX-NEXT:    vspltb 2, 2, 7
; CHECK-AIX-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <16 x i8> undef, i8 %a, i32 0
  %splat.splat = shufflevector <16 x i8> %splat.splatinsert, <16 x i8> undef, <16 x i32> zeroinitializer
  ret <16 x i8> %splat.splat


}

; Function Attrs: norecurse nounwind readnone
define <8 x i16> @builds(i16 zeroext %a) {
; CHECK-LABEL: builds:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtvsrwz v2, r3
; CHECK-NEXT:    vsplth v2, v2, 3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: builds:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mtvsrd v2, r3
; CHECK-LE-NEXT:    vsplth v2, v2, 3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: builds:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mtvsrwz 34, 3
; CHECK-AIX-NEXT:    vsplth 2, 2, 3
; CHECK-AIX-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <8 x i16> undef, i16 %a, i32 0
  %splat.splat = shufflevector <8 x i16> %splat.splatinsert, <8 x i16> undef, <8 x i32> zeroinitializer
  ret <8 x i16> %splat.splat


}

; Function Attrs: norecurse nounwind readnone
define <4 x i32> @buildi(i32 zeroext %a) {
; CHECK-LABEL: buildi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r3
; CHECK-NEXT:    xxspltw v2, vs0, 1
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: buildi:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mtfprwz f0, r3
; CHECK-LE-NEXT:    xxspltw v2, vs0, 1
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: buildi:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mtfprwz 0, 3
; CHECK-AIX-NEXT:    xxspltw 34, 0, 1
; CHECK-AIX-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %a, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat


}

; Function Attrs: norecurse nounwind readnone
define <2 x i64> @buildl(i64 %a) {
; CHECK-LABEL: buildl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xxspltd v2, vs0, 0
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: buildl:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mtfprd f0, r3
; CHECK-LE-NEXT:    xxspltd v2, vs0, 0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: buildl:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mtfprd 0, 3
; CHECK-AIX-NEXT:    xxmrghd 34, 0, 0
; CHECK-AIX-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %a, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat


}

; Function Attrs: norecurse nounwind readnone
define <4 x float> @buildf(float %a) {
; CHECK-LABEL: buildf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpspn vs0, f1
; CHECK-NEXT:    xxspltw v2, vs0, 0
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: buildf:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xscvdpspn vs0, f1
; CHECK-LE-NEXT:    xxspltw v2, vs0, 0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: buildf:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xscvdpspn 0, 1
; CHECK-AIX-NEXT:    xxspltw 34, 0, 0
; CHECK-AIX-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <4 x float> undef, float %a, i32 0
  %splat.splat = shufflevector <4 x float> %splat.splatinsert, <4 x float> undef, <4 x i32> zeroinitializer
  ret <4 x float> %splat.splat


}

; The optimization to remove stack operations from PPCDAGToDAGISel::Select
; should still trigger for v2f64, producing an lxvdsx.
; Function Attrs: norecurse nounwind readonly
define <2 x double> @buildd() {
; CHECK-LABEL: buildd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, .LC0@toc@ha
; CHECK-NEXT:    ld r3, .LC0@toc@l(r3)
; CHECK-NEXT:    lxvdsx v2, 0, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: buildd:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    addis r3, r2, .LC0@toc@ha
; CHECK-LE-NEXT:    ld r3, .LC0@toc@l(r3)
; CHECK-LE-NEXT:    lxvdsx v2, 0, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: buildd:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    ld 3, L..C0(2) # @d
; CHECK-AIX-NEXT:    lxvdsx 34, 0, 3
; CHECK-AIX-NEXT:    blr
entry:
  %0 = load double, ptr @d, align 8
  %splat.splatinsert = insertelement <2 x double> undef, double %0, i32 0
  %splat.splat = shufflevector <2 x double> %splat.splatinsert, <2 x double> undef, <2 x i32> zeroinitializer
  ret <2 x double> %splat.splat


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc0(<16 x i8> %vsc) {
; CHECK-LABEL: getsc0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 8, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc0:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    clrldi r3, r3, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc0:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 8, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 0
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc1(<16 x i8> %vsc) {
; CHECK-LABEL: getsc1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 16, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 56, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc1:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 16, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 1
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc2(<16 x i8> %vsc) {
; CHECK-LABEL: getsc2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 24, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc2:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 48, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc2:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 24, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 2
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc3(<16 x i8> %vsc) {
; CHECK-LABEL: getsc3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 32, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc3:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 40, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc3:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 32, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 3
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc4(<16 x i8> %vsc) {
; CHECK-LABEL: getsc4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 40, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc4:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 32, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc4:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 40, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 4
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc5(<16 x i8> %vsc) {
; CHECK-LABEL: getsc5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 48, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc5:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 24, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc5:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 48, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 5
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc6(<16 x i8> %vsc) {
; CHECK-LABEL: getsc6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 56, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc6:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 16, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc6:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 56, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 6
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc7(<16 x i8> %vsc) {
; CHECK-LABEL: getsc7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    clrldi r3, r3, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc7:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 8, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc7:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    clrldi 3, 3, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 7
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc8(<16 x i8> %vsc) {
; CHECK-LABEL: getsc8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 8, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc8:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    clrldi r3, r3, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc8:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 8, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 8
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc9(<16 x i8> %vsc) {
; CHECK-LABEL: getsc9:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 16, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc9:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 56, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc9:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 16, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 9
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc10(<16 x i8> %vsc) {
; CHECK-LABEL: getsc10:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 24, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc10:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 48, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc10:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 24, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 10
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc11(<16 x i8> %vsc) {
; CHECK-LABEL: getsc11:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 32, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc11:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 40, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc11:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 32, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 11
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc12(<16 x i8> %vsc) {
; CHECK-LABEL: getsc12:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 40, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc12:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 32, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc12:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 40, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 12
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc13(<16 x i8> %vsc) {
; CHECK-LABEL: getsc13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 48, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc13:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 24, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc13:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 48, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 13
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc14(<16 x i8> %vsc) {
; CHECK-LABEL: getsc14:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 56, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc14:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 16, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc14:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 56, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 14
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc15(<16 x i8> %vsc) {
; CHECK-LABEL: getsc15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    clrldi r3, r3, 56
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsc15:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 8, 56
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsc15:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    clrldi 3, 3, 56
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 15
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc0(<16 x i8> %vuc) {
; CHECK-LABEL: getuc0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 8, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc0:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    clrldi r3, r3, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc0:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 8, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 0
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc1(<16 x i8> %vuc) {
; CHECK-LABEL: getuc1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 16, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 56, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc1:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 16, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 1
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc2(<16 x i8> %vuc) {
; CHECK-LABEL: getuc2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 24, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc2:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 48, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc2:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 24, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 2
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc3(<16 x i8> %vuc) {
; CHECK-LABEL: getuc3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 32, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc3:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 40, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc3:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 32, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 3
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc4(<16 x i8> %vuc) {
; CHECK-LABEL: getuc4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 40, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc4:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 32, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc4:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 40, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 4
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc5(<16 x i8> %vuc) {
; CHECK-LABEL: getuc5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 48, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc5:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 24, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc5:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 48, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 5
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc6(<16 x i8> %vuc) {
; CHECK-LABEL: getuc6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 56, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc6:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 16, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc6:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 56, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 6
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc7(<16 x i8> %vuc) {
; CHECK-LABEL: getuc7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    clrldi r3, r3, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc7:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 8, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc7:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    clrldi 3, 3, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 7
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc8(<16 x i8> %vuc) {
; CHECK-LABEL: getuc8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 8, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc8:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    clrldi r3, r3, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc8:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 8, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 8
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc9(<16 x i8> %vuc) {
; CHECK-LABEL: getuc9:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 16, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc9:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 56, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc9:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 16, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 9
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc10(<16 x i8> %vuc) {
; CHECK-LABEL: getuc10:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 24, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc10:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 48, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc10:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 24, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 10
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc11(<16 x i8> %vuc) {
; CHECK-LABEL: getuc11:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 32, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc11:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 40, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc11:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 32, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 11
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc12(<16 x i8> %vuc) {
; CHECK-LABEL: getuc12:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 40, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc12:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 32, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc12:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 40, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 12
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc13(<16 x i8> %vuc) {
; CHECK-LABEL: getuc13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 48, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc13:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 24, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc13:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 48, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 13
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc14(<16 x i8> %vuc) {
; CHECK-LABEL: getuc14:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 56, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc14:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 16, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc14:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 56, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 14
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc15(<16 x i8> %vuc) {
; CHECK-LABEL: getuc15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    clrldi r3, r3, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getuc15:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 8, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getuc15:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    clrldi 3, 3, 56
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 15
  ret i8 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getvelsc(<16 x i8> %vsc, i32 signext %i) {
; CHECK-LABEL: getvelsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r4, r5, 8
; CHECK-NEXT:    li r3, 7
; CHECK-NEXT:    lvsl v3, 0, r4
; CHECK-NEXT:    andc r3, r3, r5
; CHECK-NEXT:    sldi r3, r3, 3
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    mfvsrd r4, v2
; CHECK-NEXT:    srd r3, r4, r3
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getvelsc:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li r3, 8
; CHECK-LE-NEXT:    andc r3, r3, r5
; CHECK-LE-NEXT:    lvsl v3, 0, r3
; CHECK-LE-NEXT:    li r3, 7
; CHECK-LE-NEXT:    and r3, r3, r5
; CHECK-LE-NEXT:    vperm v2, v2, v2, v3
; CHECK-LE-NEXT:    sldi r3, r3, 3
; CHECK-LE-NEXT:    mfvsrd r4, v2
; CHECK-LE-NEXT:    srd r3, r4, r3
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getvelsc:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    andi. 5, 3, 8
; CHECK-AIX-NEXT:    li 4, 7
; CHECK-AIX-NEXT:    lvsl 3, 0, 5
; CHECK-AIX-NEXT:    andc 3, 4, 3
; CHECK-AIX-NEXT:    sldi 3, 3, 3
; CHECK-AIX-NEXT:    vperm 2, 2, 2, 3
; CHECK-AIX-NEXT:    mfvsrd 4, 34
; CHECK-AIX-NEXT:    srd 3, 4, 3
; CHECK-AIX-NEXT:    extsb 3, 3
; CHECK-AIX-NEXT:    blr


entry:
  %vecext = extractelement <16 x i8> %vsc, i32 %i
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getveluc(<16 x i8> %vuc, i32 signext %i) {
; CHECK-LABEL: getveluc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r4, r5, 8
; CHECK-NEXT:    li r3, 7
; CHECK-NEXT:    lvsl v3, 0, r4
; CHECK-NEXT:    andc r3, r3, r5
; CHECK-NEXT:    sldi r3, r3, 3
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    mfvsrd r4, v2
; CHECK-NEXT:    srd r3, r4, r3
; CHECK-NEXT:    clrldi r3, r3, 56
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getveluc:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li r3, 8
; CHECK-LE-NEXT:    andc r3, r3, r5
; CHECK-LE-NEXT:    lvsl v3, 0, r3
; CHECK-LE-NEXT:    li r3, 7
; CHECK-LE-NEXT:    and r3, r3, r5
; CHECK-LE-NEXT:    vperm v2, v2, v2, v3
; CHECK-LE-NEXT:    sldi r3, r3, 3
; CHECK-LE-NEXT:    mfvsrd r4, v2
; CHECK-LE-NEXT:    srd r3, r4, r3
; CHECK-LE-NEXT:    clrldi r3, r3, 56
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getveluc:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    andi. 5, 3, 8
; CHECK-AIX-NEXT:    li 4, 7
; CHECK-AIX-NEXT:    lvsl 3, 0, 5
; CHECK-AIX-NEXT:    andc 3, 4, 3
; CHECK-AIX-NEXT:    sldi 3, 3, 3
; CHECK-AIX-NEXT:    vperm 2, 2, 2, 3
; CHECK-AIX-NEXT:    mfvsrd 4, 34
; CHECK-AIX-NEXT:    srd 3, 4, 3
; CHECK-AIX-NEXT:    clrldi 3, 3, 56
; CHECK-AIX-NEXT:    blr


entry:
  %vecext = extractelement <16 x i8> %vuc, i32 %i
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss0(<8 x i16> %vss) {
; CHECK-LABEL: getss0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 16, 48
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getss0:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    clrldi r3, r3, 48
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getss0:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 16, 48
; CHECK-AIX-NEXT:    extsh 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 0
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss1(<8 x i16> %vss) {
; CHECK-LABEL: getss1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 32, 48
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getss1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 48, 48
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getss1:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 32, 48
; CHECK-AIX-NEXT:    extsh 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 1
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss2(<8 x i16> %vss) {
; CHECK-LABEL: getss2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 48, 48
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getss2:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 32, 48
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getss2:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 48, 48
; CHECK-AIX-NEXT:    extsh 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 2
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss3(<8 x i16> %vss) {
; CHECK-LABEL: getss3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getss3:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 16, 48
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getss3:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    clrldi 3, 3, 48
; CHECK-AIX-NEXT:    extsh 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 3
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss4(<8 x i16> %vss) {
; CHECK-LABEL: getss4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 16, 48
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getss4:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    clrldi r3, r3, 48
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getss4:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 16, 48
; CHECK-AIX-NEXT:    extsh 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 4
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss5(<8 x i16> %vss) {
; CHECK-LABEL: getss5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 32, 48
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getss5:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 48, 48
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getss5:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 32, 48
; CHECK-AIX-NEXT:    extsh 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 5
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss6(<8 x i16> %vss) {
; CHECK-LABEL: getss6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 48, 48
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getss6:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 32, 48
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getss6:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 48, 48
; CHECK-AIX-NEXT:    extsh 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 6
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss7(<8 x i16> %vss) {
; CHECK-LABEL: getss7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getss7:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 16, 48
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getss7:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    clrldi 3, 3, 48
; CHECK-AIX-NEXT:    extsh 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 7
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus0(<8 x i16> %vus) {
; CHECK-LABEL: getus0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 16, 48
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getus0:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    clrldi r3, r3, 48
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getus0:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 16, 48
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 0
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus1(<8 x i16> %vus) {
; CHECK-LABEL: getus1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 32, 48
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getus1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 48, 48
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getus1:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 32, 48
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 1
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus2(<8 x i16> %vus) {
; CHECK-LABEL: getus2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    rldicl r3, r3, 48, 48
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getus2:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 32, 48
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getus2:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    rldicl 3, 3, 48, 48
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 2
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus3(<8 x i16> %vus) {
; CHECK-LABEL: getus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getus3:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    rldicl r3, r3, 16, 48
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getus3:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    clrldi 3, 3, 48
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 3
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus4(<8 x i16> %vus) {
; CHECK-LABEL: getus4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 16, 48
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getus4:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    clrldi r3, r3, 48
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getus4:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 16, 48
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 4
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus5(<8 x i16> %vus) {
; CHECK-LABEL: getus5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 32, 48
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getus5:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 48, 48
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getus5:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 32, 48
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 5
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus6(<8 x i16> %vus) {
; CHECK-LABEL: getus6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    rldicl r3, r3, 48, 48
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getus6:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 32, 48
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getus6:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    rldicl 3, 3, 48, 48
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 6
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus7(<8 x i16> %vus) {
; CHECK-LABEL: getus7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getus7:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    rldicl r3, r3, 16, 48
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getus7:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    clrldi 3, 3, 48
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 7
  ret i16 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getvelss(<8 x i16> %vss, i32 signext %i) {
; CHECK-LABEL: getvelss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r4, r5, 4
; CHECK-NEXT:    li r3, 3
; CHECK-NEXT:    sldi r4, r4, 1
; CHECK-NEXT:    andc r3, r3, r5
; CHECK-NEXT:    lvsl v3, 0, r4
; CHECK-NEXT:    sldi r3, r3, 4
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    mfvsrd r4, v2
; CHECK-NEXT:    srd r3, r4, r3
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getvelss:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li r3, 4
; CHECK-LE-NEXT:    andc r3, r3, r5
; CHECK-LE-NEXT:    sldi r3, r3, 1
; CHECK-LE-NEXT:    lvsl v3, 0, r3
; CHECK-LE-NEXT:    li r3, 3
; CHECK-LE-NEXT:    and r3, r3, r5
; CHECK-LE-NEXT:    vperm v2, v2, v2, v3
; CHECK-LE-NEXT:    sldi r3, r3, 4
; CHECK-LE-NEXT:    mfvsrd r4, v2
; CHECK-LE-NEXT:    srd r3, r4, r3
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getvelss:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    andi. 5, 3, 4
; CHECK-AIX-NEXT:    li 4, 3
; CHECK-AIX-NEXT:    sldi 5, 5, 1
; CHECK-AIX-NEXT:    andc 3, 4, 3
; CHECK-AIX-NEXT:    lvsl 3, 0, 5
; CHECK-AIX-NEXT:    sldi 3, 3, 4
; CHECK-AIX-NEXT:    vperm 2, 2, 2, 3
; CHECK-AIX-NEXT:    mfvsrd 4, 34
; CHECK-AIX-NEXT:    srd 3, 4, 3
; CHECK-AIX-NEXT:    extsh 3, 3
; CHECK-AIX-NEXT:    blr


entry:
  %vecext = extractelement <8 x i16> %vss, i32 %i
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getvelus(<8 x i16> %vus, i32 signext %i) {
; CHECK-LABEL: getvelus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r4, r5, 4
; CHECK-NEXT:    li r3, 3
; CHECK-NEXT:    sldi r4, r4, 1
; CHECK-NEXT:    andc r3, r3, r5
; CHECK-NEXT:    lvsl v3, 0, r4
; CHECK-NEXT:    sldi r3, r3, 4
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    mfvsrd r4, v2
; CHECK-NEXT:    srd r3, r4, r3
; CHECK-NEXT:    clrldi r3, r3, 48
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getvelus:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li r3, 4
; CHECK-LE-NEXT:    andc r3, r3, r5
; CHECK-LE-NEXT:    sldi r3, r3, 1
; CHECK-LE-NEXT:    lvsl v3, 0, r3
; CHECK-LE-NEXT:    li r3, 3
; CHECK-LE-NEXT:    and r3, r3, r5
; CHECK-LE-NEXT:    vperm v2, v2, v2, v3
; CHECK-LE-NEXT:    sldi r3, r3, 4
; CHECK-LE-NEXT:    mfvsrd r4, v2
; CHECK-LE-NEXT:    srd r3, r4, r3
; CHECK-LE-NEXT:    clrldi r3, r3, 48
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getvelus:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    andi. 5, 3, 4
; CHECK-AIX-NEXT:    li 4, 3
; CHECK-AIX-NEXT:    sldi 5, 5, 1
; CHECK-AIX-NEXT:    andc 3, 4, 3
; CHECK-AIX-NEXT:    lvsl 3, 0, 5
; CHECK-AIX-NEXT:    sldi 3, 3, 4
; CHECK-AIX-NEXT:    vperm 2, 2, 2, 3
; CHECK-AIX-NEXT:    mfvsrd 4, 34
; CHECK-AIX-NEXT:    srd 3, 4, 3
; CHECK-AIX-NEXT:    clrldi 3, 3, 48
; CHECK-AIX-NEXT:    blr


entry:
  %vecext = extractelement <8 x i16> %vus, i32 %i
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @getsi0(<4 x i32> %vsi) {
; CHECK-LABEL: getsi0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsi0:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprwz r3, f0
; CHECK-LE-NEXT:    extsw r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsi0:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxsldwi 0, 34, 34, 3
; CHECK-AIX-NEXT:    mffprwz 3, 0
; CHECK-AIX-NEXT:    extsw 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vsi, i32 0
  ret i32 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i32 @getsi1(<4 x i32> %vsi) {
; CHECK-LABEL: getsi1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrwz r3, v2
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsi1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxsldwi vs0, v2, v2, 1
; CHECK-LE-NEXT:    mffprwz r3, f0
; CHECK-LE-NEXT:    extsw r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsi1:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrwz 3, 34
; CHECK-AIX-NEXT:    extsw 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vsi, i32 1
  ret i32 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i32 @getsi2(<4 x i32> %vsi) {
; CHECK-LABEL: getsi2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 1
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsi2:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrwz r3, v2
; CHECK-LE-NEXT:    extsw r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsi2:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxsldwi 0, 34, 34, 1
; CHECK-AIX-NEXT:    mffprwz 3, 0
; CHECK-AIX-NEXT:    extsw 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vsi, i32 2
  ret i32 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i32 @getsi3(<4 x i32> %vsi) {
; CHECK-LABEL: getsi3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsi3:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-LE-NEXT:    mffprwz r3, f0
; CHECK-LE-NEXT:    extsw r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsi3:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprwz 3, 0
; CHECK-AIX-NEXT:    extsw 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vsi, i32 3
  ret i32 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i32 @getui0(<4 x i32> %vui) {
; CHECK-LABEL: getui0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getui0:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprwz r3, f0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getui0:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxsldwi 0, 34, 34, 3
; CHECK-AIX-NEXT:    mffprwz 3, 0
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vui, i32 0
  ret i32 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i32 @getui1(<4 x i32> %vui) {
; CHECK-LABEL: getui1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrwz r3, v2
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getui1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxsldwi vs0, v2, v2, 1
; CHECK-LE-NEXT:    mffprwz r3, f0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getui1:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrwz 3, 34
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vui, i32 1
  ret i32 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i32 @getui2(<4 x i32> %vui) {
; CHECK-LABEL: getui2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 1
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getui2:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrwz r3, v2
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getui2:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxsldwi 0, 34, 34, 1
; CHECK-AIX-NEXT:    mffprwz 3, 0
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vui, i32 2
  ret i32 %vecext


}

; Function Attrs: norecurse nounwind readnone
define zeroext i32 @getui3(<4 x i32> %vui) {
; CHECK-LABEL: getui3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getui3:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-LE-NEXT:    mffprwz r3, f0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getui3:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprwz 3, 0
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vui, i32 3
  ret i32 %vecext


}

; Function Attrs: norecurse nounwind readnone
define signext i32 @getvelsi(<4 x i32> %vsi, i32 signext %i) {
; CHECK-LABEL: getvelsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r4, r5, 2
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    sldi r4, r4, 2
; CHECK-NEXT:    andc r3, r3, r5
; CHECK-NEXT:    lvsl v3, 0, r4
; CHECK-NEXT:    sldi r3, r3, 5
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    mfvsrd r4, v2
; CHECK-NEXT:    srd r3, r4, r3
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getvelsi:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li r3, 2
; CHECK-LE-NEXT:    andc r3, r3, r5
; CHECK-LE-NEXT:    sldi r3, r3, 2
; CHECK-LE-NEXT:    lvsl v3, 0, r3
; CHECK-LE-NEXT:    li r3, 1
; CHECK-LE-NEXT:    and r3, r3, r5
; CHECK-LE-NEXT:    vperm v2, v2, v2, v3
; CHECK-LE-NEXT:    sldi r3, r3, 5
; CHECK-LE-NEXT:    mfvsrd r4, v2
; CHECK-LE-NEXT:    srd r3, r4, r3
; CHECK-LE-NEXT:    extsw r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getvelsi:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    andi. 5, 3, 2
; CHECK-AIX-NEXT:    li 4, 1
; CHECK-AIX-NEXT:    sldi 5, 5, 2
; CHECK-AIX-NEXT:    andc 3, 4, 3
; CHECK-AIX-NEXT:    lvsl 3, 0, 5
; CHECK-AIX-NEXT:    sldi 3, 3, 5
; CHECK-AIX-NEXT:    vperm 2, 2, 2, 3
; CHECK-AIX-NEXT:    mfvsrd 4, 34
; CHECK-AIX-NEXT:    srd 3, 4, 3
; CHECK-AIX-NEXT:    extsw 3, 3
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vsi, i32 %i
  ret i32 %vecext
; FIXME: add check patterns when variable element extraction is implemented
}

; Function Attrs: norecurse nounwind readnone
define zeroext i32 @getvelui(<4 x i32> %vui, i32 signext %i) {
; CHECK-LABEL: getvelui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r4, r5, 2
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    sldi r4, r4, 2
; CHECK-NEXT:    andc r3, r3, r5
; CHECK-NEXT:    lvsl v3, 0, r4
; CHECK-NEXT:    sldi r3, r3, 5
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    mfvsrd r4, v2
; CHECK-NEXT:    srd r3, r4, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getvelui:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li r3, 2
; CHECK-LE-NEXT:    andc r3, r3, r5
; CHECK-LE-NEXT:    sldi r3, r3, 2
; CHECK-LE-NEXT:    lvsl v3, 0, r3
; CHECK-LE-NEXT:    li r3, 1
; CHECK-LE-NEXT:    and r3, r3, r5
; CHECK-LE-NEXT:    vperm v2, v2, v2, v3
; CHECK-LE-NEXT:    sldi r3, r3, 5
; CHECK-LE-NEXT:    mfvsrd r4, v2
; CHECK-LE-NEXT:    srd r3, r4, r3
; CHECK-LE-NEXT:    clrldi r3, r3, 32
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getvelui:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    andi. 5, 3, 2
; CHECK-AIX-NEXT:    li 4, 1
; CHECK-AIX-NEXT:    sldi 5, 5, 2
; CHECK-AIX-NEXT:    andc 3, 4, 3
; CHECK-AIX-NEXT:    lvsl 3, 0, 5
; CHECK-AIX-NEXT:    sldi 3, 3, 5
; CHECK-AIX-NEXT:    vperm 2, 2, 2, 3
; CHECK-AIX-NEXT:    mfvsrd 4, 34
; CHECK-AIX-NEXT:    srd 3, 4, 3
; CHECK-AIX-NEXT:    clrldi 3, 3, 32
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vui, i32 %i
  ret i32 %vecext
; FIXME: add check patterns when variable element extraction is implemented
}

; Function Attrs: norecurse nounwind readnone
define i64 @getsl0(<2 x i64> %vsl) {
; CHECK-LABEL: getsl0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsl0:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsl0:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vsl, i32 0
  ret i64 %vecext


}

; Function Attrs: norecurse nounwind readnone
define i64 @getsl1(<2 x i64> %vsl) {
; CHECK-LABEL: getsl1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getsl1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getsl1:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vsl, i32 1
  ret i64 %vecext


}

; Function Attrs: norecurse nounwind readnone
define i64 @getul0(<2 x i64> %vul) {
; CHECK-LABEL: getul0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getul0:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    mffprd r3, f0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getul0:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vul, i32 0
  ret i64 %vecext


}

; Function Attrs: norecurse nounwind readnone
define i64 @getul1(<2 x i64> %vul) {
; CHECK-LABEL: getul1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getul1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getul1:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    mffprd 3, 0
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vul, i32 1
  ret i64 %vecext


}

; Function Attrs: norecurse nounwind readnone
define i64 @getvelsl(<2 x i64> %vsl, i32 signext %i) {
; CHECK-LABEL: getvelsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r3, r5, 1
; CHECK-NEXT:    sldi r3, r3, 3
; CHECK-NEXT:    lvsl v3, 0, r3
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getvelsl:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li r3, 1
; CHECK-LE-NEXT:    andc r3, r3, r5
; CHECK-LE-NEXT:    sldi r3, r3, 3
; CHECK-LE-NEXT:    lvsl v3, 0, r3
; CHECK-LE-NEXT:    vperm v2, v2, v2, v3
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getvelsl:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    andi. 3, 3, 1
; CHECK-AIX-NEXT:    sldi 3, 3, 3
; CHECK-AIX-NEXT:    lvsl 3, 0, 3
; CHECK-AIX-NEXT:    vperm 2, 2, 2, 3
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vsl, i32 %i
  ret i64 %vecext
; FIXME: add check patterns when variable element extraction is implemented
}

; Function Attrs: norecurse nounwind readnone
define i64 @getvelul(<2 x i64> %vul, i32 signext %i) {
; CHECK-LABEL: getvelul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r3, r5, 1
; CHECK-NEXT:    sldi r3, r3, 3
; CHECK-NEXT:    lvsl v3, 0, r3
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    mfvsrd r3, v2
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getvelul:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li r3, 1
; CHECK-LE-NEXT:    andc r3, r3, r5
; CHECK-LE-NEXT:    sldi r3, r3, 3
; CHECK-LE-NEXT:    lvsl v3, 0, r3
; CHECK-LE-NEXT:    vperm v2, v2, v2, v3
; CHECK-LE-NEXT:    mfvsrd r3, v2
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getvelul:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    andi. 3, 3, 1
; CHECK-AIX-NEXT:    sldi 3, 3, 3
; CHECK-AIX-NEXT:    lvsl 3, 0, 3
; CHECK-AIX-NEXT:    vperm 2, 2, 2, 3
; CHECK-AIX-NEXT:    mfvsrd 3, 34
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vul, i32 %i
  ret i64 %vecext
; FIXME: add check patterns when variable element extraction is implemented
}

; Function Attrs: norecurse nounwind readnone
define float @getf0(<4 x float> %vf) {
; CHECK-LABEL: getf0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvspdpn f1, v2
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getf0:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-LE-NEXT:    xscvspdpn f1, vs0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getf0:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xscvspdpn 1, 34
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %vf, i32 0
  ret float %vecext


}

; Function Attrs: norecurse nounwind readnone
define float @getf1(<4 x float> %vf) {
; CHECK-LABEL: getf1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 1
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getf1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs0, v2
; CHECK-LE-NEXT:    xscvspdpn f1, vs0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getf1:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxsldwi 0, 34, 34, 1
; CHECK-AIX-NEXT:    xscvspdpn 1, 0
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %vf, i32 1
  ret float %vecext


}

; Function Attrs: norecurse nounwind readnone
define float @getf2(<4 x float> %vf) {
; CHECK-LABEL: getf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs0, v2
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getf2:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxsldwi vs0, v2, v2, 1
; CHECK-LE-NEXT:    xscvspdpn f1, vs0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getf2:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 0, 34
; CHECK-AIX-NEXT:    xscvspdpn 1, 0
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %vf, i32 2
  ret float %vecext


}

; Function Attrs: norecurse nounwind readnone
define float @getf3(<4 x float> %vf) {
; CHECK-LABEL: getf3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-NEXT:    xscvspdpn f1, vs0
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getf3:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xscvspdpn f1, v2
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getf3:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxsldwi 0, 34, 34, 3
; CHECK-AIX-NEXT:    xscvspdpn 1, 0
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %vf, i32 3
  ret float %vecext


}

; Function Attrs: norecurse nounwind readnone
define float @getvelf(<4 x float> %vf, i32 signext %i) {
; CHECK-LABEL: getvelf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sldi r3, r5, 2
; CHECK-NEXT:    lvsl v3, 0, r3
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    xscvspdpn f1, v2
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getvelf:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xori r3, r5, 3
; CHECK-LE-NEXT:    sldi r3, r3, 2
; CHECK-LE-NEXT:    lvsl v3, 0, r3
; CHECK-LE-NEXT:    vperm v2, v2, v2, v3
; CHECK-LE-NEXT:    xscvspdpn f1, v2
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getvelf:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    sldi 3, 3, 2
; CHECK-AIX-NEXT:    lvsl 3, 0, 3
; CHECK-AIX-NEXT:    vperm 2, 2, 2, 3
; CHECK-AIX-NEXT:    xscvspdpn 1, 34
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %vf, i32 %i
  ret float %vecext
; FIXME: add check patterns when variable element extraction is implemented
}

; Function Attrs: norecurse nounwind readnone
define double @getd0(<2 x double> %vd) {
; CHECK-LABEL: getd0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlor f1, v2, v2
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getd0:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxswapd vs1, v2
; CHECK-LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getd0:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxlor 1, 34, 34
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <2 x double> %vd, i32 0
  ret double %vecext


}

; Function Attrs: norecurse nounwind readnone
define double @getd1(<2 x double> %vd) {
; CHECK-LABEL: getd1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd vs1, v2
; CHECK-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getd1:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    xxlor f1, v2, v2
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getd1:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    xxswapd 1, 34
; CHECK-AIX-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <2 x double> %vd, i32 1
  ret double %vecext
}

; Function Attrs: norecurse nounwind readnone
define double @getveld(<2 x double> %vd, i32 signext %i) {
; CHECK-LABEL: getveld:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r3, r5, 1
; CHECK-NEXT:    sldi r3, r3, 3
; CHECK-NEXT:    lvsl v3, 0, r3
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    xxlor vs1, v2, v2
; CHECK-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: getveld:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    li r3, 1
; CHECK-LE-NEXT:    andc r3, r3, r5
; CHECK-LE-NEXT:    sldi r3, r3, 3
; CHECK-LE-NEXT:    lvsl v3, 0, r3
; CHECK-LE-NEXT:    vperm v2, v2, v2, v3
; CHECK-LE-NEXT:    xxlor vs1, v2, v2
; CHECK-LE-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: getveld:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    andi. 3, 3, 1
; CHECK-AIX-NEXT:    sldi 3, 3, 3
; CHECK-AIX-NEXT:    lvsl 3, 0, 3
; CHECK-AIX-NEXT:    vperm 2, 2, 2, 3
; CHECK-AIX-NEXT:    xxlor 1, 34, 34
; CHECK-AIX-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; CHECK-AIX-NEXT:    blr
entry:
  %vecext = extractelement <2 x double> %vd, i32 %i
  ret double %vecext
; FIXME: add check patterns when variable element extraction is implemented
}

; To check when LHS is i32 to vector and RHS is i64 to vector,
; the combination should be skipped properly.
define <2 x i64> @buildi2(i64 %arg, i32 %arg1) {
; CHECK-LABEL: buildi2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sldi r4, r4, 32
; CHECK-NEXT:    mtfprd f1, r3
; CHECK-NEXT:    mtfprd f0, r4
; CHECK-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-NEXT:    blr
;
; CHECK-LE-LABEL: buildi2:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    mtfprd f0, r4
; CHECK-LE-NEXT:    mtfprd f1, r3
; CHECK-LE-NEXT:    xxswapd vs0, vs0
; CHECK-LE-NEXT:    xxswapd v2, vs1
; CHECK-LE-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-NEXT:    blr
;
; CHECK-AIX-LABEL: buildi2:
; CHECK-AIX:       # %bb.0: # %entry
; CHECK-AIX-NEXT:    sldi 4, 4, 32
; CHECK-AIX-NEXT:    mtfprd 1, 3
; CHECK-AIX-NEXT:    mtfprd 0, 4
; CHECK-AIX-NEXT:    xxmrghd 34, 0, 1
; CHECK-AIX-NEXT:    blr
entry:
  %lhs.i32 = insertelement <4 x i32> undef, i32 %arg1, i32 0
  %rhs = insertelement <2 x i64> undef, i64 %arg, i32 0
  %lhs = bitcast <4 x i32> %lhs.i32 to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}
