/* Copyright (C) 2007-2024 Open Information Security Foundation
 *
 * You can copy, redistribute or modify this Program under the terms of
 * the GNU General Public License version 2 as published by the Free
 * Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * version 2 along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

/**
 * \file
 *
 * \author Victor Julien <victor@inliniac.net>
 *
 * Implements the noalert and alert keywords.
 */

#include "suricata-common.h"
#include "action-globals.h"
#include "detect.h"
#include "detect-noalert.h"
#include "util-debug.h"
#include "util-validate.h"

static int DetectNoalertSetup(DetectEngineCtx *de_ctx, Signature *s, const char *nullstr)
{
    DEBUG_VALIDATE_BUG_ON(nullstr != NULL);

    s->action &= ~ACTION_ALERT;
    return 0;
}

static int DetectAlertSetup(DetectEngineCtx *de_ctx, Signature *s, const char *nullstr)
{
    DEBUG_VALIDATE_BUG_ON(nullstr != NULL);

    s->action |= ACTION_ALERT;
    return 0;
}

void DetectNoalertRegister(void)
{
    sigmatch_table[DETECT_NOALERT].name = "noalert";
    sigmatch_table[DETECT_NOALERT].desc = "no alert will be generated by the rule";
    sigmatch_table[DETECT_NOALERT].url = "/rules/noalert.html";
    sigmatch_table[DETECT_NOALERT].Setup = DetectNoalertSetup;
    sigmatch_table[DETECT_NOALERT].flags |= SIGMATCH_NOOPT;

    sigmatch_table[DETECT_ALERT].name = "alert";
    sigmatch_table[DETECT_ALERT].desc = "alert will be generated by the rule";
    sigmatch_table[DETECT_ALERT].url = "/rules/noalert.html";
    sigmatch_table[DETECT_ALERT].Setup = DetectAlertSetup;
    sigmatch_table[DETECT_ALERT].flags |= SIGMATCH_NOOPT;
}
