use core:lang;
use debug;
use lang:bs:macro;

Str catchTest(Int throwOn) {
	try {
		if (throwOn == 1)
			throwError;
		if (throwOn == 2)
			throw SyntaxError(SrcPos(), "Test");
		"None";
	} catch (DebugError e) {
		"D" # e.message;
	} catch (SyntaxError e) {
		"S" # e.message;
	}
}


Int throwTest() {
	throw SyntaxError(SrcPos(), "Test");
}

Str smallCatchTest() {
	try {
		throwError;
		"None";
	} catch (DebugError e) {
		"D" # e.message;
	}
}
