/* sqlheavy-query-result.c generated by valac 0.16.0, the Vala compiler
 * generated from sqlheavy-query-result.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _SqlHeavyQueryResultNextAsyncData SqlHeavyQueryResultNextAsyncData;
typedef struct _Block2Data Block2Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SqlHeavyQueryResultNextInternalAsyncData SqlHeavyQueryResultNextInternalAsyncData;
typedef struct _SqlHeavyQueryResultCompleteAsyncData SqlHeavyQueryResultCompleteAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

struct _SQLHeavyQueryResultPrivate {
	SQLHeavyQuery* _query;
	SQLHeavyValueArray* _bindings;
	sqlite3_stmt* stmt;
	gboolean stmt_is_owned;
	gint error_code;
	GTimer* execution_timer;
	gboolean _finished;
	gint _field_count;
	GHashTable* _field_names;
};

struct _SqlHeavyQueryResultNextAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyQueryResult* self;
	GCancellable* cancellable;
	gboolean result;
	gint64 insert_id;
	GCancellable* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	SQLHeavyQueryResult * self;
	gboolean executing;
	GStaticMutex executing_lock;
	SQLHeavyQueryable* queryable;
	SQLHeavyDatabase* database;
	GThread* thread;
	GError* _error_;
	gint64 insert_id;
	gulong cancellable_sig;
	gboolean step_res;
	GMainContext* thread_context;
	GSource* idle_source;
	GCancellable* cancellable;
	gint steps;
	gpointer _async_data_;
};

struct _SqlHeavyQueryResultNextInternalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyQueryResult* self;
	GCancellable* cancellable;
	gint steps;
	gint64 last_insert_id;
	gboolean result;
	Block2Data* _data2_;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gint _tmp2_;
	SQLHeavyQuery* _tmp3_;
	SQLHeavyQueryable* _tmp4_;
	SQLHeavyQueryable* _tmp5_;
	SQLHeavyQueryable* _tmp6_;
	SQLHeavyQueryable* _tmp7_;
	SQLHeavyDatabase* _tmp8_;
	SQLHeavyDatabase* _tmp9_;
	GMainContext* _tmp10_;
	GSource* _tmp11_;
	GSource* _tmp12_;
	GCancellable* _tmp13_;
	GCancellable* _tmp14_;
	gulong _tmp15_;
	GError* e;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	gint _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	GError* _tmp23_;
	gint64 _tmp24_;
	gboolean _tmp25_;
	GError * _inner_error_;
};

struct _SqlHeavyQueryResultCompleteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyQueryResult* self;
	GCancellable* cancellable;
	gint64 insert_id;
	GCancellable* _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_;
};


static gpointer sql_heavy_query_result_parent_class = NULL;
static SQLHeavyRecordIface* sql_heavy_query_result_sql_heavy_record_parent_iface = NULL;
static SQLHeavyRecordSetIface* sql_heavy_query_result_sql_heavy_record_set_parent_iface = NULL;

#define SQL_HEAVY_QUERY_RESULT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_QUERY_RESULT, SQLHeavyQueryResultPrivate))
enum  {
	SQL_HEAVY_QUERY_RESULT_DUMMY_PROPERTY,
	SQL_HEAVY_QUERY_RESULT_QUERY,
	SQL_HEAVY_QUERY_RESULT_BINDINGS,
	SQL_HEAVY_QUERY_RESULT_FULL_SCAN_STEPS,
	SQL_HEAVY_QUERY_RESULT_SORT_OPERATIONS,
	SQL_HEAVY_QUERY_RESULT_EXECUTION_TIME,
	SQL_HEAVY_QUERY_RESULT_FINISHED,
	SQL_HEAVY_QUERY_RESULT_FIELD_COUNT
};
void sql_heavy_profiling_database_insert (SQLHeavyProfilingDatabase* self, SQLHeavyQueryResult* query_result);
gint sqlite3_finalize (sqlite3_stmt* stmt);
void sql_heavy_query_return_stmt (SQLHeavyQuery* self);
gboolean sql_heavy_query_result_next_internal (SQLHeavyQueryResult* self, GError** error);
static void sql_heavy_query_result_set_finished (SQLHeavyQueryResult* self, gboolean value);
gboolean sql_heavy_error_if_not_ok (gint ec, SQLHeavyQueryable* queryable, GError** error);
static void sql_heavy_query_result_acquire_locks (SQLHeavyQueryResult* self, SQLHeavyQueryable* queryable, SQLHeavyDatabase* database);
void sql_heavy_database_step_lock (SQLHeavyDatabase* self);
static void sql_heavy_query_result_release_locks (SQLHeavyQueryResult* self, SQLHeavyQueryable* queryable, SQLHeavyDatabase* database);
void sql_heavy_database_step_unlock (SQLHeavyDatabase* self);
static gboolean sql_heavy_query_result_real_next (SQLHeavyRecordSet* base, GError** error);
static void sql_heavy_query_result_next_async_data_free (gpointer _data);
static gboolean sql_heavy_query_result_next_async_co (SqlHeavyQueryResultNextAsyncData* _data_);
void sql_heavy_query_result_next_internal_async (SQLHeavyQueryResult* self, GCancellable* cancellable, gint steps, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean sql_heavy_query_result_next_internal_finish (SQLHeavyQueryResult* self, GAsyncResult* _res_, gint64* last_insert_id, GError** error);
static void sql_heavy_query_result_next_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void sql_heavy_query_result_next_internal_async_data_free (gpointer _data);
static gboolean sql_heavy_query_result_next_internal_async_co (SqlHeavyQueryResultNextInternalAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _sql_heavy_query_result_next_internal_async_co_gsource_func (gpointer self);
static void ___lambda6_ (Block2Data* _data2_);
const gchar* sql_heavy_sqlite_errstr (gint ec);
static void ____lambda6__g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void* ___lambda7_ (Block2Data* _data2_);
static gpointer ____lambda7__gthread_func (gpointer self);
static void sql_heavy_query_result_complete_async_data_free (gpointer _data);
static gboolean sql_heavy_query_result_complete_async_co (SqlHeavyQueryResultCompleteAsyncData* _data_);
static void sql_heavy_query_result_complete_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gint sql_heavy_query_result_field_check_index (SQLHeavyQueryResult* self, gint field, GError** error);
static gchar* sql_heavy_query_result_real_field_name (SQLHeavyRecord* base, gint field, GError** error);
static gint sql_heavy_query_result_real_field_index (SQLHeavyRecord* base, const gchar* field, GError** error);
static gint* _int_dup (gint* self);
static GType sql_heavy_query_result_real_field_type (SQLHeavyRecord* base, gint field, GError** error);
GType sql_heavy_sqlite_type_to_g_type (gint stype, GError** error);
static void sql_heavy_query_result_real_fetch (SQLHeavyRecord* base, gint field, GValue* result, GError** error);
void sql_heavy_sqlite_value_to_g_value (sqlite3_value* value, GValue* result);
static gchar* sql_heavy_query_result_real_fetch_string (SQLHeavyRecord* base, gint field, GError** error);
static gint sql_heavy_query_result_real_fetch_int (SQLHeavyRecord* base, gint field, GError** error);
static gint64 sql_heavy_query_result_real_fetch_int64 (SQLHeavyRecord* base, gint field, GError** error);
static gdouble sql_heavy_query_result_real_fetch_double (SQLHeavyRecord* base, gint field, GError** error);
static guint8* sql_heavy_query_result_real_fetch_blob (SQLHeavyRecord* base, gint field, int* result_length1, GError** error);
static SQLHeavyRow* sql_heavy_query_result_real_fetch_foreign_row (SQLHeavyRecord* base, gint field, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_new_no_lock (SQLHeavyQuery* query, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_lock (GType object_type, SQLHeavyQuery* query, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_new_insert (SQLHeavyQuery* query, gint64* insert_id, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_insert (GType object_type, SQLHeavyQuery* query, gint64* insert_id, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_new_no_exec (SQLHeavyQuery* query, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_exec (GType object_type, SQLHeavyQuery* query, GError** error);
static GObject * sql_heavy_query_result_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
sqlite3_stmt* sql_heavy_query_try_to_steal_stmt (SQLHeavyQuery* self);
sqlite3* sql_heavy_database_get_sqlite_db (SQLHeavyDatabase* self);
gint sqlite3_prepare_v2 (sqlite3* db, const gchar* sql, gint n_bytes, sqlite3_stmt** stmt, const gchar** tail);
SQLHeavyValueArray* sql_heavy_query_get_bindings (SQLHeavyQuery* self);
static void sql_heavy_query_result_finalize (GObject* obj);
static void _vala_sql_heavy_query_result_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sql_heavy_query_result_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Move to the next row in the result set.
     *
     * This internal function is called by {@link next} (among
     * others), and will not acquire any locks.
     *
     * @return true on success, false if the query is finished executing
     * @see next
     */
gboolean sql_heavy_query_result_next_internal (SQLHeavyQueryResult* self, GError** error) {
	gboolean result = FALSE;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* stmt;
	gboolean _tmp1_;
	GTimer* _tmp2_;
	sqlite3_stmt* _tmp3_;
	gint _tmp4_ = 0;
	GTimer* _tmp5_;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->stmt;
	stmt = _tmp0_;
	_tmp1_ = self->priv->_finished;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->execution_timer;
	g_timer_continue (_tmp2_);
	_tmp3_ = stmt;
	_tmp4_ = sqlite3_step (_tmp3_);
	self->priv->error_code = _tmp4_;
	_tmp5_ = self->priv->execution_timer;
	g_timer_stop (_tmp5_);
	_tmp6_ = self->priv->error_code;
	switch (_tmp6_) {
		case SQLITE_ROW:
		{
			self->priv->error_code = SQLITE_OK;
			g_signal_emit_by_name (self, "received-row");
			result = TRUE;
			return result;
		}
		case SQLITE_DONE:
		{
			sql_heavy_query_result_set_finished (self, TRUE);
			self->priv->error_code = SQLITE_OK;
			result = FALSE;
			return result;
		}
		default:
		{
			gint _tmp7_;
			SQLHeavyQuery* _tmp8_;
			SQLHeavyQueryable* _tmp9_;
			SQLHeavyQueryable* _tmp10_;
			_tmp7_ = self->priv->error_code;
			_tmp8_ = self->priv->_query;
			_tmp9_ = sql_heavy_query_get_queryable (_tmp8_);
			_tmp10_ = _tmp9_;
			sql_heavy_error_if_not_ok (_tmp7_, _tmp10_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SQL_HEAVY_ERROR) {
					g_propagate_error (error, _inner_error_);
					return FALSE;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			g_assert_not_reached ();
		}
	}
}


/**
     * Acquire locks
     *
     * @param queryable the relevant {@link Queryable}
     * @param database the relevant {@link Database}
     */
static void sql_heavy_query_result_acquire_locks (SQLHeavyQueryResult* self, SQLHeavyQueryable* queryable, SQLHeavyDatabase* database) {
	SQLHeavyQueryable* _tmp0_;
	SQLHeavyDatabase* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (queryable != NULL);
	g_return_if_fail (database != NULL);
	_tmp0_ = queryable;
	sql_heavy_queryable_lock (_tmp0_);
	_tmp1_ = database;
	sql_heavy_database_step_lock (_tmp1_);
}


/**
     * Release locks
     *
     * @param queryable the relevant {@link Queryable}
     * @param database the relevant {@link Database}
     */
static void sql_heavy_query_result_release_locks (SQLHeavyQueryResult* self, SQLHeavyQueryable* queryable, SQLHeavyDatabase* database) {
	SQLHeavyDatabase* _tmp0_;
	SQLHeavyQueryable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (queryable != NULL);
	g_return_if_fail (database != NULL);
	_tmp0_ = database;
	sql_heavy_database_step_unlock (_tmp0_);
	_tmp1_ = queryable;
	sql_heavy_queryable_unlock (_tmp1_);
}


/**
     * Move to the next row in the result set.
     *
     * @return true on success, false if the query is finished executing
     * @see next_async
     * @see complete
     */
static gboolean sql_heavy_query_result_real_next (SQLHeavyRecordSet* base, GError** error) {
	SQLHeavyQueryResult * self;
	gboolean result = FALSE;
	SQLHeavyQuery* _tmp0_;
	SQLHeavyQueryable* _tmp1_;
	SQLHeavyQueryable* _tmp2_;
	SQLHeavyQueryable* queryable;
	SQLHeavyDatabase* _tmp3_;
	SQLHeavyDatabase* _tmp4_;
	SQLHeavyDatabase* db;
	gboolean _tmp5_ = FALSE;
	gboolean res;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = self->priv->_query;
	_tmp1_ = sql_heavy_query_get_queryable (_tmp0_);
	_tmp2_ = _tmp1_;
	queryable = _tmp2_;
	_tmp3_ = sql_heavy_queryable_get_database (queryable);
	_tmp4_ = _tmp3_;
	db = _tmp4_;
	sql_heavy_query_result_acquire_locks (self, queryable, db);
	_tmp5_ = sql_heavy_query_result_next_internal (self, &_inner_error_);
	res = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (db);
			return FALSE;
		} else {
			_g_object_unref0 (db);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	sql_heavy_query_result_release_locks (self, queryable, db);
	result = res;
	_g_object_unref0 (db);
	return result;
}


static void sql_heavy_query_result_next_async_data_free (gpointer _data) {
	SqlHeavyQueryResultNextAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SqlHeavyQueryResultNextAsyncData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sql_heavy_query_result_next_async (SQLHeavyQueryResult* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyQueryResultNextAsyncData* _data_;
	SQLHeavyQueryResult* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (SqlHeavyQueryResultNextAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_query_result_next_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_query_result_next_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	sql_heavy_query_result_next_async_co (_data_);
}


gboolean sql_heavy_query_result_next_finish (SQLHeavyQueryResult* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SqlHeavyQueryResultNextAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
     * Move to the next result in the result set asynchronously
     *
     * @param cancellable optional cancellable for aborting the operation
     * @return true on success, false if the query is finished executing
     * @see next
     */
static void sql_heavy_query_result_next_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyQueryResultNextAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sql_heavy_query_result_next_async_co (_data_);
}


static gboolean sql_heavy_query_result_next_async_co (SqlHeavyQueryResultNextAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->insert_id = (gint64) 0;
	_data_->_tmp0_ = _data_->cancellable;
	_data_->_tmp1_ = 0LL;
	_data_->_state_ = 1;
	sql_heavy_query_result_next_internal_async (_data_->self, _data_->_tmp0_, 1, sql_heavy_query_result_next_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = sql_heavy_query_result_next_internal_finish (_data_->self, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error_);
	_data_->insert_id = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->result = _data_->_tmp3_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void sql_heavy_query_result_next_internal_async_data_free (gpointer _data) {
	SqlHeavyQueryResultNextInternalAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SqlHeavyQueryResultNextInternalAsyncData, _data_);
}


void sql_heavy_query_result_next_internal_async (SQLHeavyQueryResult* self, GCancellable* cancellable, gint steps, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyQueryResultNextInternalAsyncData* _data_;
	SQLHeavyQueryResult* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	gint _tmp3_;
	_data_ = g_slice_new0 (SqlHeavyQueryResultNextInternalAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_query_result_next_internal_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_query_result_next_internal_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	_tmp3_ = steps;
	_data_->steps = _tmp3_;
	sql_heavy_query_result_next_internal_async_co (_data_);
}


gboolean sql_heavy_query_result_next_internal_finish (SQLHeavyQueryResult* self, GAsyncResult* _res_, gint64* last_insert_id, GError** error) {
	gboolean result;
	SqlHeavyQueryResultNextInternalAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (last_insert_id) {
		*last_insert_id = _data_->last_insert_id;
	}
	result = _data_->result;
	return result;
}


/**
     * Move to the next result in the result set asynchronously
     *
     * @param cancellable optional cancellable for aborting the operation
     * @param steps number of steps to take through the result set, or 0 for unlimited
     * @return true on success, false if the query is finished executing
     * @see next
     */
static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SQLHeavyQueryResult * self;
		self = _data2_->self;
		_g_source_unref0 (_data2_->idle_source);
		_g_error_free0 (_data2_->_error_);
		_g_object_unref0 (_data2_->database);
		_g_object_unref0 (_data2_->queryable);
		g_static_mutex_free (&_data2_->executing_lock);
		_g_object_unref0 (_data2_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _sql_heavy_query_result_next_internal_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = sql_heavy_query_result_next_internal_async_co (self);
	return result;
}


static void ___lambda6_ (Block2Data* _data2_) {
	SQLHeavyQueryResult * self;
	gboolean _tmp0_;
	self = _data2_->self;
	g_static_mutex_lock (&_data2_->executing_lock);
	_tmp0_ = _data2_->executing;
	if (_tmp0_) {
		SQLHeavyDatabase* _tmp1_;
		_tmp1_ = _data2_->database;
		sql_heavy_database_interrupt (_tmp1_);
	} else {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_;
		GSource* _tmp4_;
		GMainContext* _tmp5_;
		GThread* _tmp6_;
		SQLHeavyQueryable* _tmp8_;
		SQLHeavyDatabase* _tmp9_;
		_tmp2_ = sql_heavy_sqlite_errstr (SQLITE_INTERRUPT);
		_tmp3_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERRUPTED, _tmp2_);
		_g_error_free0 (_data2_->_error_);
		_data2_->_error_ = _tmp3_;
		_tmp4_ = _data2_->idle_source;
		_tmp5_ = _data2_->thread_context;
		g_source_attach (_tmp4_, _tmp5_);
		_tmp6_ = _data2_->thread;
		if (_tmp6_ != NULL) {
			GThread* _tmp7_;
			_tmp7_ = _data2_->thread;
			g_thread_exit (NULL);
		}
		_tmp8_ = _data2_->queryable;
		_tmp9_ = _data2_->database;
		sql_heavy_query_result_release_locks (self, _tmp8_, _tmp9_);
	}
	g_static_mutex_unlock (&_data2_->executing_lock);
}


static void ____lambda6__g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	___lambda6_ (self);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void* ___lambda7_ (Block2Data* _data2_) {
	SQLHeavyQueryResult * self;
	void* result = NULL;
	SQLHeavyQueryable* _tmp0_;
	SQLHeavyDatabase* _tmp1_;
	SQLHeavyDatabase* _tmp17_;
	gint64 _tmp18_;
	gint64 _tmp19_;
	SQLHeavyQueryable* _tmp20_;
	SQLHeavyDatabase* _tmp21_;
	gulong _tmp22_;
	GSource* _tmp25_;
	GMainContext* _tmp26_;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->queryable;
	_tmp1_ = _data2_->database;
	sql_heavy_query_result_acquire_locks (self, _tmp0_, _tmp1_);
	g_static_mutex_lock (&_data2_->executing_lock);
	_data2_->executing = TRUE;
	g_static_mutex_unlock (&_data2_->executing_lock);
	{
		while (TRUE) {
			gint _tmp2_;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			GCancellable* _tmp5_;
			gboolean _tmp8_;
			gboolean _tmp12_;
			gint _tmp13_;
			_tmp2_ = _data2_->steps;
			if (!(_tmp2_ != 0)) {
				break;
			}
			_tmp5_ = _data2_->cancellable;
			if (_tmp5_ != NULL) {
				GCancellable* _tmp6_;
				gboolean _tmp7_ = FALSE;
				_tmp6_ = _data2_->cancellable;
				_tmp7_ = g_cancellable_is_cancelled (_tmp6_);
				_tmp4_ = _tmp7_;
			} else {
				_tmp4_ = FALSE;
			}
			_tmp8_ = _tmp4_;
			if (_tmp8_) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = sql_heavy_query_result_next_internal (self, &_inner_error_);
				_tmp10_ = _tmp9_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == SQL_HEAVY_ERROR) {
						goto __catch25_sql_heavy_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_data2_->step_res = _tmp10_;
				_tmp11_ = _data2_->step_res;
				_tmp3_ = !_tmp11_;
			}
			_tmp12_ = _tmp3_;
			if (_tmp12_) {
				break;
			}
			_tmp13_ = _data2_->steps;
			if (_tmp13_ > 0) {
				gint _tmp14_;
				_tmp14_ = _data2_->steps;
				_data2_->steps = _tmp14_ - 1;
			}
		}
	}
	goto __finally25;
	__catch25_sql_heavy_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		GError* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _g_error_copy0 (_tmp15_);
		_g_error_free0 (_data2_->_error_);
		_data2_->_error_ = _tmp16_;
		_g_error_free0 (e);
	}
	__finally25:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp17_ = _data2_->database;
	_tmp18_ = sql_heavy_database_get_last_insert_id (_tmp17_);
	_tmp19_ = _tmp18_;
	_data2_->insert_id = _tmp19_;
	_tmp20_ = _data2_->queryable;
	_tmp21_ = _data2_->database;
	sql_heavy_query_result_release_locks (self, _tmp20_, _tmp21_);
	_tmp22_ = _data2_->cancellable_sig;
	if (_tmp22_ != ((gulong) 0)) {
		GCancellable* _tmp23_;
		gulong _tmp24_;
		_tmp23_ = _data2_->cancellable;
		_tmp24_ = _data2_->cancellable_sig;
		g_cancellable_disconnect (_tmp23_, _tmp24_);
	}
	_tmp25_ = _data2_->idle_source;
	_tmp26_ = _data2_->thread_context;
	g_source_attach (_tmp25_, _tmp26_);
	result = NULL;
	return result;
}


static gpointer ____lambda7__gthread_func (gpointer self) {
	gpointer result;
	result = ___lambda7_ (self);
	return result;
}


static gboolean sql_heavy_query_result_next_internal_async_co (SqlHeavyQueryResultNextInternalAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->cancellable;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->_data2_->cancellable = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->steps;
	_data_->_data2_->steps = _data_->_tmp2_;
	_data_->_data2_->_async_data_ = _data_;
	_data_->_data2_->executing = FALSE;
	g_static_mutex_init (&_data_->_data2_->executing_lock);
	_data_->_tmp3_ = _data_->self->priv->_query;
	_data_->_tmp4_ = sql_heavy_query_get_queryable (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
	_data_->_data2_->queryable = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->_data2_->queryable;
	_data_->_tmp8_ = sql_heavy_queryable_get_database (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_data2_->database = _data_->_tmp9_;
	_data_->_data2_->thread = NULL;
	_data_->_data2_->_error_ = NULL;
	_data_->_data2_->insert_id = (gint64) 0;
	_data_->_data2_->cancellable_sig = (gulong) 0;
	_data_->_data2_->step_res = FALSE;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_main_context_get_thread_default ();
	_data_->_data2_->thread_context = _data_->_tmp10_;
	_data_->_tmp11_ = g_idle_source_new ();
	_data_->_data2_->idle_source = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->_data2_->idle_source;
	g_source_set_callback (_data_->_tmp12_, _sql_heavy_query_result_next_internal_async_co_gsource_func, _data_, NULL);
	_data_->_tmp13_ = _data_->_data2_->cancellable;
	if (_data_->_tmp13_ != NULL) {
		_data_->_tmp14_ = _data_->_data2_->cancellable;
		_data_->_tmp15_ = 0UL;
		_data_->_tmp15_ = g_signal_connect_data (_data_->_tmp14_, "cancelled", (GCallback) ____lambda6__g_cancellable_cancelled, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
		_data_->_data2_->cancellable_sig = _data_->_tmp15_;
	}
	{
		g_thread_create (____lambda7__gthread_func, _data_->_data2_, FALSE, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch24_g_thread_error;
			}
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	goto __finally24;
	__catch24_g_thread_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp16_ = _data_->e;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = _data_->_tmp18_->code;
		_data_->_tmp20_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_THREAD, "Thread error: %s (%d)", _data_->_tmp17_, _data_->_tmp19_);
		_data_->_inner_error_ = _data_->_tmp20_;
		_g_error_free0 (_data_->e);
		goto __finally24;
	}
	__finally24:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp21_ = _data_->_data2_->_error_;
	if (_data_->_tmp21_ != NULL) {
		_data_->_tmp22_ = _data_->_data2_->_error_;
		_data_->_tmp23_ = _g_error_copy0 (_data_->_tmp22_);
		_data_->_inner_error_ = _data_->_tmp23_;
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp24_ = _data_->_data2_->insert_id;
	_data_->last_insert_id = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->_data2_->step_res;
	_data_->result = _data_->_tmp25_;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Finish iterating through the result set.
     */
void sql_heavy_query_result_complete (SQLHeavyQueryResult* self, GError** error) {
	SQLHeavyQuery* _tmp0_;
	SQLHeavyQueryable* _tmp1_;
	SQLHeavyQueryable* _tmp2_;
	SQLHeavyQueryable* queryable;
	SQLHeavyQueryable* _tmp3_;
	SQLHeavyDatabase* _tmp4_;
	SQLHeavyDatabase* _tmp5_;
	SQLHeavyDatabase* db;
	SQLHeavyQueryable* _tmp6_;
	SQLHeavyDatabase* _tmp7_;
	SQLHeavyDatabase* _tmp9_;
	SQLHeavyQueryable* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_query;
	_tmp1_ = sql_heavy_query_get_queryable (_tmp0_);
	_tmp2_ = _tmp1_;
	queryable = _tmp2_;
	_tmp3_ = queryable;
	_tmp4_ = sql_heavy_queryable_get_database (_tmp3_);
	_tmp5_ = _tmp4_;
	db = _tmp5_;
	_tmp6_ = queryable;
	sql_heavy_queryable_lock (_tmp6_);
	_tmp7_ = db;
	sql_heavy_database_step_lock (_tmp7_);
	while (TRUE) {
		gboolean _tmp8_;
		_tmp8_ = self->priv->_finished;
		if (!(!_tmp8_)) {
			break;
		}
		sql_heavy_query_result_next_internal (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (db);
				return;
			} else {
				_g_object_unref0 (db);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp9_ = db;
	sql_heavy_database_step_unlock (_tmp9_);
	_tmp10_ = queryable;
	sql_heavy_queryable_unlock (_tmp10_);
	_g_object_unref0 (db);
}


static void sql_heavy_query_result_complete_async_data_free (gpointer _data) {
	SqlHeavyQueryResultCompleteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SqlHeavyQueryResultCompleteAsyncData, _data_);
}


void sql_heavy_query_result_complete_async (SQLHeavyQueryResult* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyQueryResultCompleteAsyncData* _data_;
	SQLHeavyQueryResult* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (SqlHeavyQueryResultCompleteAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_query_result_complete_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_query_result_complete_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	sql_heavy_query_result_complete_async_co (_data_);
}


void sql_heavy_query_result_complete_finish (SQLHeavyQueryResult* self, GAsyncResult* _res_, GError** error) {
	SqlHeavyQueryResultCompleteAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Finish iterating through the result set asynchronously
     *
     * @param cancellable optional cancellable for aborting the operation
     */
static void sql_heavy_query_result_complete_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyQueryResultCompleteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sql_heavy_query_result_complete_async_co (_data_);
}


static gboolean sql_heavy_query_result_complete_async_co (SqlHeavyQueryResultCompleteAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->insert_id = (gint64) 0;
	_data_->_tmp0_ = _data_->cancellable;
	_data_->_tmp1_ = 0LL;
	_data_->_state_ = 1;
	sql_heavy_query_result_next_internal_async (_data_->self, _data_->_tmp0_, 0, sql_heavy_query_result_complete_async_ready, _data_);
	return FALSE;
	_state_1:
	sql_heavy_query_result_next_internal_finish (_data_->self, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error_);
	_data_->insert_id = _data_->_tmp1_;
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * {@inheritDoc}
     */
static gint sql_heavy_query_result_field_check_index (SQLHeavyQueryResult* self, gint field, GError** error) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp5_;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = field;
	if (_tmp1_ < 0) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = field;
		_tmp3_ = sql_heavy_record_get_field_count ((SQLHeavyRecord*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp2_ > _tmp4_;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_;
		_tmp6_ = sql_heavy_sqlite_errstr (SQLITE_RANGE);
		_tmp7_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, _tmp6_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp8_ = field;
	result = _tmp8_;
	return result;
}


/**
     * {@inheritDoc}
     */
static gchar* sql_heavy_query_result_real_field_name (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_column_name (_tmp3_, _tmp2_);
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}


/**
     * Name of the table that is the origin of a field
     *
     * @param field index of the field
     * @return the table
     * @see field_origin_table
     */
gchar* sql_heavy_query_result_field_origin_table_name (SQLHeavyQueryResult* self, gint field, GError** error) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_column_table_name (_tmp3_, _tmp2_);
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}


/**
     * Table that is the origin of a field
     *
     * @param field index of the field
     * @return the table
     * @see field_origin_table_name
     */
SQLHeavyTable* sql_heavy_query_result_field_origin_table (SQLHeavyQueryResult* self, gint field, GError** error) {
	SQLHeavyTable* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	SQLHeavyQuery* _tmp3_;
	SQLHeavyQueryable* _tmp4_;
	SQLHeavyQueryable* _tmp5_;
	gchar* _tmp6_;
	SQLHeavyTable* _tmp7_;
	SQLHeavyTable* _tmp8_;
	SQLHeavyTable* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_origin_table_name (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = self->priv->_query;
	_tmp4_ = sql_heavy_query_get_queryable (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp2_;
	_tmp7_ = sql_heavy_table_new (_tmp5_, _tmp6_, &_inner_error_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp9_;
	return result;
}


/**
     * Name of the column that is the origin of a field
     *
     * @param field index of the field
     * @return the table name
     */
gchar* sql_heavy_query_result_field_origin_name (SQLHeavyQueryResult* self, gint field, GError** error) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_column_origin_name (_tmp3_, _tmp2_);
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}


/**
     * {@inheritDoc}
     */
static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static gint sql_heavy_query_result_real_field_index (SQLHeavyRecord* base, const gchar* field, GError** error) {
	SQLHeavyQueryResult * self;
	gint result = 0;
	GHashTable* _tmp0_;
	GHashTable* _tmp19_;
	const gchar* _tmp20_;
	gconstpointer _tmp21_ = NULL;
	gint* _tmp22_;
	gint* field_number;
	gint* _tmp23_;
	gint* _tmp26_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	g_return_val_if_fail (field != NULL, 0);
	_tmp0_ = self->priv->_field_names;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GDestroyNotify _tmp3_;
		GDestroyNotify _tmp4_;
		GHashTable* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint fields;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_free;
		_tmp4_ = g_free;
		_tmp5_ = g_hash_table_new_full (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
		_g_hash_table_unref0 (self->priv->_field_names);
		self->priv->_field_names = _tmp5_;
		_tmp6_ = sql_heavy_record_get_field_count ((SQLHeavyRecord*) self);
		_tmp7_ = _tmp6_;
		fields = _tmp7_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					GHashTable* _tmp16_;
					gint _tmp17_;
					gint* _tmp18_;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = fields;
					if (!(_tmp11_ < _tmp12_)) {
						break;
					}
					_tmp13_ = i;
					_tmp14_ = sql_heavy_record_field_name ((SQLHeavyRecord*) self, _tmp13_, &_inner_error_);
					_tmp15_ = _tmp14_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					_tmp16_ = self->priv->_field_names;
					_tmp17_ = i;
					_tmp18_ = __int_dup0 (&_tmp17_);
					g_hash_table_replace (_tmp16_, _tmp15_, _tmp18_);
				}
			}
		}
	}
	_tmp19_ = self->priv->_field_names;
	_tmp20_ = field;
	_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
	_tmp22_ = __int_dup0 ((gint*) _tmp21_);
	field_number = _tmp22_;
	_tmp23_ = field_number;
	if (_tmp23_ == NULL) {
		const gchar* _tmp24_ = NULL;
		GError* _tmp25_;
		_tmp24_ = sql_heavy_sqlite_errstr (SQLITE_RANGE);
		_tmp25_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, _tmp24_);
		_inner_error_ = _tmp25_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (field_number);
			return 0;
		} else {
			_g_free0 (field_number);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp26_ = field_number;
	result = (gint) (*_tmp26_);
	_g_free0 (field_number);
	return result;
}


/**
     * {@inheritDoc}
     */
static GType sql_heavy_query_result_real_field_type (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	GType result = 0UL;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	gint _tmp4_ = 0;
	GType _tmp5_ = 0UL;
	GType _tmp6_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0UL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0UL;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_column_type (_tmp3_, _tmp2_);
	_tmp5_ = sql_heavy_sqlite_type_to_g_type (_tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0UL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0UL;
		}
	}
	result = _tmp6_;
	return result;
}


/**
     * {@inheritDoc}
     */
static void sql_heavy_query_result_real_fetch (SQLHeavyRecord* base, gint field, GValue* result, GError** error) {
	SQLHeavyQueryResult * self;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_value* _tmp4_ = NULL;
	GValue _tmp5_ = {0};
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_column_value (_tmp3_, _tmp2_);
	sql_heavy_sqlite_value_to_g_value (_tmp4_, &_tmp5_);
	*result = _tmp5_;
	return;
}


/**
     * {@inheritDoc}
     */
static gchar* sql_heavy_query_result_real_fetch_string (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_column_text (_tmp3_, _tmp2_);
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}


/**
     * {@inheritDoc}
     */
static gint sql_heavy_query_result_real_fetch_int (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_column_int (_tmp3_, _tmp2_);
	result = _tmp4_;
	return result;
}


/**
     * {@inheritDoc}
     */
static gint64 sql_heavy_query_result_real_fetch_int64 (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	gint64 result = 0LL;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	gint64 _tmp4_ = 0LL;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0LL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_column_int64 (_tmp3_, _tmp2_);
	result = _tmp4_;
	return result;
}


/**
     * {@inheritDoc}
     */
static gdouble sql_heavy_query_result_real_fetch_double (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	gdouble result = 0.0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	gdouble _tmp4_ = 0.0;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0.0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0.0;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_column_double (_tmp3_, _tmp2_);
	result = _tmp4_;
	return result;
}


/**
     * {@inheritDoc}
     */
static guint8* sql_heavy_query_result_real_fetch_blob (SQLHeavyRecord* base, gint field, int* result_length1, GError** error) {
	SQLHeavyQueryResult * self;
	guint8* result = NULL;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	gint _tmp4_ = 0;
	guint8* _tmp5_ = NULL;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	sqlite3_stmt* _tmp7_;
	gint _tmp8_;
	void* _tmp9_ = NULL;
	guint8* _tmp10_;
	gint _tmp10__length1;
	guint8* _tmp11_;
	gint _tmp11__length1;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_column_bytes (_tmp3_, _tmp2_);
	_tmp5_ = g_new0 (guint8, _tmp4_);
	res = _tmp5_;
	res_length1 = _tmp4_;
	_res_size_ = res_length1;
	_tmp6_ = res;
	_tmp6__length1 = res_length1;
	_tmp7_ = self->priv->stmt;
	_tmp8_ = field;
	_tmp9_ = sqlite3_column_blob (_tmp7_, _tmp8_);
	_tmp10_ = res;
	_tmp10__length1 = res_length1;
	memcpy (_tmp6_, _tmp9_, (gsize) _tmp10__length1);
	_tmp11_ = res;
	_tmp11__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	return result;
}


/**
     * {@inheritDoc}
     */
static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static SQLHeavyRow* sql_heavy_query_result_real_fetch_foreign_row (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	SQLHeavyRow* result = NULL;
	gint _tmp0_;
	SQLHeavyTable* _tmp1_ = NULL;
	SQLHeavyTable* table;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	SQLHeavyTable* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_;
	gint foreign_key_idx;
	SQLHeavyTable* _tmp9_;
	gint _tmp10_;
	SQLHeavyTable* _tmp11_ = NULL;
	SQLHeavyTable* foreign_table;
	SQLHeavyTable* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* foreign_column;
	SQLHeavyQuery* _tmp15_;
	SQLHeavyQueryable* _tmp16_;
	SQLHeavyQueryable* _tmp17_;
	SQLHeavyTable* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	SQLHeavyQuery* _tmp26_;
	SQLHeavyQuery* _tmp27_;
	SQLHeavyQuery* q;
	gint _tmp28_;
	gint64 _tmp29_ = 0LL;
	gint64 _tmp30_;
	SQLHeavyQuery* _tmp31_;
	SQLHeavyQuery* _tmp32_;
	SQLHeavyQueryResult* _tmp33_ = NULL;
	SQLHeavyQueryResult* _tmp34_;
	SQLHeavyQueryResult* _tmp35_;
	gint64 _tmp36_ = 0LL;
	gint64 _tmp37_;
	gint64 _tmp38_;
	SQLHeavyTable* _tmp39_;
	SQLHeavyRow* _tmp40_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_result_field_origin_table (self, _tmp0_, &_inner_error_);
	table = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = field;
	_tmp3_ = sql_heavy_query_result_field_origin_name (self, _tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = table;
	_tmp6_ = _tmp4_;
	_tmp7_ = sql_heavy_table_foreign_key_index (_tmp5_, _tmp6_, &_inner_error_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	foreign_key_idx = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = table;
	_tmp10_ = foreign_key_idx;
	_tmp11_ = sql_heavy_table_foreign_key_table (_tmp9_, _tmp10_, &_inner_error_);
	foreign_table = _tmp11_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = table;
	_tmp13_ = foreign_key_idx;
	_tmp14_ = sql_heavy_table_foreign_key_to (_tmp12_, _tmp13_, &_inner_error_);
	foreign_column = _tmp14_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp15_ = self->priv->_query;
	_tmp16_ = sql_heavy_query_get_queryable (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = foreign_table;
	_tmp19_ = sql_heavy_table_get_name (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = foreign_column;
	_tmp23_ = string_to_string (_tmp22_);
	_tmp24_ = g_strconcat ("SELECT `ROWID` FROM `", _tmp21_, "` WHERE `", _tmp23_, "` = :value;", NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = sql_heavy_query_new (_tmp17_, _tmp25_, &_inner_error_);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp25_);
	q = _tmp27_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp28_ = field;
	_tmp29_ = sql_heavy_record_fetch_int64 ((SQLHeavyRecord*) self, _tmp28_, &_inner_error_);
	_tmp30_ = _tmp29_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp31_ = q;
	sql_heavy_query_bind_int64 (_tmp31_, 1, _tmp30_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp32_ = q;
	_tmp33_ = sql_heavy_query_execute (_tmp32_, NULL, &_inner_error_, NULL);
	_tmp34_ = _tmp33_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp35_ = _tmp34_;
	_tmp36_ = sql_heavy_record_fetch_int64 ((SQLHeavyRecord*) _tmp35_, 0, &_inner_error_);
	_tmp37_ = _tmp36_;
	_g_object_unref0 (_tmp35_);
	_tmp38_ = _tmp37_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp39_ = foreign_table;
	_tmp40_ = sql_heavy_row_new (_tmp39_, _tmp38_);
	result = _tmp40_;
	_g_object_unref0 (q);
	_g_free0 (foreign_column);
	_g_object_unref0 (foreign_table);
	_g_object_unref0 (table);
	return result;
}


/**
     * Create a new QueryResult without acquiring locks
     *
     * @param query the relevant query
     */
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_lock (GType object_type, SQLHeavyQuery* query, GError** error) {
	SQLHeavyQueryResult * self = NULL;
	SQLHeavyQuery* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = query;
	self = (SQLHeavyQueryResult*) g_object_new (object_type, "query", _tmp0_, NULL);
	sql_heavy_query_result_next_internal (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


SQLHeavyQueryResult* sql_heavy_query_result_new_no_lock (SQLHeavyQuery* query, GError** error) {
	return sql_heavy_query_result_construct_no_lock (SQL_HEAVY_TYPE_QUERY_RESULT, query, error);
}


/**
     * Create a new QueryResult and return the {@link Database.last_insert_id}
     *
     * @param query the relevant query
     * @param insert_id location to put the ID of the inserted row
     * @see Query.execute_insert
     */
SQLHeavyQueryResult* sql_heavy_query_result_construct_insert (GType object_type, SQLHeavyQuery* query, gint64* insert_id, GError** error) {
	gint64 _vala_insert_id = 0LL;
	SQLHeavyQueryResult * self = NULL;
	SQLHeavyQuery* _tmp0_;
	SQLHeavyQuery* _tmp1_;
	SQLHeavyQueryable* _tmp2_;
	SQLHeavyQueryable* _tmp3_;
	SQLHeavyQueryable* queryable;
	SQLHeavyQueryable* _tmp4_;
	SQLHeavyDatabase* _tmp5_;
	SQLHeavyDatabase* _tmp6_;
	SQLHeavyDatabase* db;
	SQLHeavyQueryable* _tmp7_;
	SQLHeavyDatabase* _tmp8_;
	SQLHeavyQueryable* _tmp16_;
	SQLHeavyDatabase* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = query;
	self = (SQLHeavyQueryResult*) g_object_new (object_type, "query", _tmp0_, NULL);
	_tmp1_ = query;
	_tmp2_ = sql_heavy_query_get_queryable (_tmp1_);
	_tmp3_ = _tmp2_;
	queryable = _tmp3_;
	_tmp4_ = queryable;
	_tmp5_ = sql_heavy_queryable_get_database (_tmp4_);
	_tmp6_ = _tmp5_;
	db = _tmp6_;
	_tmp7_ = queryable;
	_tmp8_ = db;
	sql_heavy_query_result_acquire_locks (self, _tmp7_, _tmp8_);
	{
		SQLHeavyDatabase* _tmp9_;
		gint64 _tmp10_;
		gint64 _tmp11_;
		sql_heavy_query_result_next_internal (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch26_sql_heavy_error;
			}
			_g_object_unref0 (db);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = db;
		_tmp10_ = sql_heavy_database_get_last_insert_id (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_insert_id = _tmp11_;
	}
	goto __finally26;
	__catch26_sql_heavy_error:
	{
		GError* e = NULL;
		SQLHeavyQueryable* _tmp12_;
		SQLHeavyDatabase* _tmp13_;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = queryable;
		_tmp13_ = db;
		sql_heavy_query_result_release_locks (self, _tmp12_, _tmp13_);
		_tmp14_ = e;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally26;
	}
	__finally26:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (db);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (db);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = queryable;
	_tmp17_ = db;
	sql_heavy_query_result_release_locks (self, _tmp16_, _tmp17_);
	_g_object_unref0 (db);
	if (insert_id) {
		*insert_id = _vala_insert_id;
	}
	return self;
}


SQLHeavyQueryResult* sql_heavy_query_result_new_insert (SQLHeavyQuery* query, gint64* insert_id, GError** error) {
	return sql_heavy_query_result_construct_insert (SQL_HEAVY_TYPE_QUERY_RESULT, query, insert_id, error);
}


/**
     * Create a new QueryResult but do not run it.
     *
     * @param query the relevant query
     */
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_exec (GType object_type, SQLHeavyQuery* query, GError** error) {
	SQLHeavyQueryResult * self = NULL;
	SQLHeavyQuery* _tmp0_;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = query;
	self = (SQLHeavyQueryResult*) g_object_new (object_type, "query", _tmp0_, NULL);
	return self;
}


SQLHeavyQueryResult* sql_heavy_query_result_new_no_exec (SQLHeavyQuery* query, GError** error) {
	return sql_heavy_query_result_construct_no_exec (SQL_HEAVY_TYPE_QUERY_RESULT, query, error);
}


/**
     * Create a new QueryResult
     *
     * @param query the relevant query
     */
SQLHeavyQueryResult* sql_heavy_query_result_construct (GType object_type, SQLHeavyQuery* query, GError** error) {
	SQLHeavyQueryResult * self = NULL;
	SQLHeavyQuery* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = query;
	self = (SQLHeavyQueryResult*) g_object_new (object_type, "query", _tmp0_, NULL);
	sql_heavy_record_set_next ((SQLHeavyRecordSet*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


SQLHeavyQueryResult* sql_heavy_query_result_new (SQLHeavyQuery* query, GError** error) {
	return sql_heavy_query_result_construct (SQL_HEAVY_TYPE_QUERY_RESULT, query, error);
}


SQLHeavyQuery* sql_heavy_query_result_get_query (SQLHeavyQueryResult* self) {
	SQLHeavyQuery* result;
	SQLHeavyQuery* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_query;
	result = _tmp0_;
	return result;
}


static void sql_heavy_query_result_set_query (SQLHeavyQueryResult* self, SQLHeavyQuery* value) {
	SQLHeavyQuery* _tmp0_;
	SQLHeavyQuery* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_query);
	self->priv->_query = _tmp1_;
	g_object_notify ((GObject *) self, "query");
}


SQLHeavyValueArray* sql_heavy_query_result_get_bindings (SQLHeavyQueryResult* self) {
	SQLHeavyValueArray* result;
	SQLHeavyValueArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_bindings;
	result = _tmp0_;
	return result;
}


static void sql_heavy_query_result_set_bindings (SQLHeavyQueryResult* self, SQLHeavyValueArray* value) {
	SQLHeavyValueArray* _tmp0_;
	SQLHeavyValueArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_bindings);
	self->priv->_bindings = _tmp1_;
	g_object_notify ((GObject *) self, "bindings");
}


gint sql_heavy_query_result_get_full_scan_steps (SQLHeavyQueryResult* self) {
	gint result;
	sqlite3_stmt* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->stmt;
	_tmp1_ = sqlite3_stmt_status (_tmp0_, SQLITE_STMTSTATUS_FULLSCAN_STEP, 0);
	result = _tmp1_;
	return result;
}


gint sql_heavy_query_result_get_sort_operations (SQLHeavyQueryResult* self) {
	gint result;
	sqlite3_stmt* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->stmt;
	_tmp1_ = sqlite3_stmt_status (_tmp0_, SQLITE_STMTSTATUS_SORT, 0);
	result = _tmp1_;
	return result;
}


gdouble sql_heavy_query_result_get_execution_time (SQLHeavyQueryResult* self) {
	gdouble result;
	GTimer* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->execution_timer;
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


gboolean sql_heavy_query_result_get_finished (SQLHeavyQueryResult* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_finished;
	result = _tmp0_;
	return result;
}


static void sql_heavy_query_result_set_finished (SQLHeavyQueryResult* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_finished = _tmp0_;
	g_object_notify ((GObject *) self, "finished");
}


static gint sql_heavy_query_result_real_get_field_count (SQLHeavyRecord* base) {
	gint result;
	SQLHeavyQueryResult* self;
	gint _tmp0_;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = self->priv->_field_count;
	result = _tmp0_;
	return result;
}


static gpointer _g_byte_array_ref0 (gpointer self) {
	return self ? g_byte_array_ref (self) : NULL;
}


static GObject * sql_heavy_query_result_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SQLHeavyQueryResult * self;
	GTimer* _tmp0_;
	GTimer* _tmp1_;
	GTimer* _tmp2_;
	SQLHeavyQuery* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp20_;
	gint _tmp21_ = 0;
	SQLHeavyValueArray* _tmp22_;
	SQLHeavyValueArray* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint bindings_length;
	parent_class = G_OBJECT_CLASS (sql_heavy_query_result_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SQL_HEAVY_QUERY_RESULT (obj);
	_tmp0_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->execution_timer);
	self->priv->execution_timer = _tmp0_;
	_tmp1_ = self->priv->execution_timer;
	g_timer_stop (_tmp1_);
	_tmp2_ = self->priv->execution_timer;
	g_timer_reset (_tmp2_);
	_tmp3_ = self->priv->_query;
	_tmp4_ = sql_heavy_query_try_to_steal_stmt (_tmp3_);
	self->priv->stmt = _tmp4_;
	_tmp5_ = self->priv->stmt;
	if (_tmp5_ == NULL) {
		SQLHeavyQuery* _tmp6_;
		SQLHeavyQueryable* _tmp7_;
		SQLHeavyQueryable* _tmp8_;
		SQLHeavyDatabase* _tmp9_;
		SQLHeavyDatabase* _tmp10_;
		SQLHeavyDatabase* _tmp11_;
		sqlite3* _tmp12_ = NULL;
		sqlite3* _tmp13_;
		sqlite3* db;
		sqlite3* _tmp14_;
		SQLHeavyQuery* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		sqlite3_stmt* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		self->priv->stmt_is_owned = TRUE;
		_tmp6_ = self->priv->_query;
		_tmp7_ = sql_heavy_query_get_queryable (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = sql_heavy_queryable_get_database (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = sql_heavy_database_get_sqlite_db (_tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		db = _tmp13_;
		_tmp14_ = db;
		_tmp15_ = self->priv->_query;
		_tmp16_ = sql_heavy_query_get_sql (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp19_ = sqlite3_prepare_v2 (_tmp14_, _tmp17_, -1, &_tmp18_, NULL);
		self->priv->stmt = _tmp18_;
		g_assert (_tmp19_ == SQLITE_OK);
	} else {
		self->priv->stmt_is_owned = FALSE;
	}
	_tmp20_ = self->priv->stmt;
	_tmp21_ = sqlite3_column_count (_tmp20_);
	self->priv->_field_count = _tmp21_;
	_tmp22_ = self->priv->_bindings;
	if (_tmp22_ == NULL) {
		SQLHeavyQuery* _tmp23_;
		SQLHeavyValueArray* _tmp24_ = NULL;
		SQLHeavyValueArray* _tmp25_;
		_tmp23_ = self->priv->_query;
		_tmp24_ = sql_heavy_query_get_bindings (_tmp23_);
		_tmp25_ = _tmp24_;
		sql_heavy_query_result_set_bindings (self, _tmp25_);
		_g_object_unref0 (_tmp25_);
	}
	_tmp26_ = self->priv->_bindings;
	_tmp27_ = sql_heavy_value_array_get_length (_tmp26_);
	_tmp28_ = _tmp27_;
	bindings_length = _tmp28_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp29_;
			_tmp29_ = TRUE;
			while (TRUE) {
				gboolean _tmp30_;
				gint _tmp32_;
				gint _tmp33_;
				SQLHeavyValueArray* _tmp34_;
				gint _tmp35_;
				GValue* _tmp36_ = NULL;
				GValue* val;
				GValue* _tmp37_;
				_tmp30_ = _tmp29_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp32_ = i;
				_tmp33_ = bindings_length;
				if (!(_tmp32_ < _tmp33_)) {
					break;
				}
				_tmp34_ = self->priv->_bindings;
				_tmp35_ = i;
				_tmp36_ = sql_heavy_value_array_get (_tmp34_, _tmp35_);
				val = _tmp36_;
				_tmp37_ = val;
				if (_tmp37_ == NULL) {
					g_critical ("sqlheavy-query-result.vala:459: Incomplete bindings");
				} else {
					GValue* _tmp38_;
					GType _tmp39_ = 0UL;
					GType val_t;
					gint _tmp40_;
					gint index;
					GType _tmp41_;
					_tmp38_ = val;
					_tmp39_ = G_VALUE_TYPE (_tmp38_);
					val_t = _tmp39_;
					_tmp40_ = i;
					index = _tmp40_ + 1;
					_tmp41_ = val_t;
					if (_tmp41_ == G_TYPE_STRING) {
						sqlite3_stmt* _tmp42_;
						gint _tmp43_;
						GValue* _tmp44_;
						const gchar* _tmp45_ = NULL;
						_tmp42_ = self->priv->stmt;
						_tmp43_ = index;
						_tmp44_ = val;
						_tmp45_ = g_value_get_string (_tmp44_);
						sqlite3_bind_text (_tmp42_, _tmp43_, _tmp45_, -1, NULL);
					} else {
						GType _tmp46_;
						_tmp46_ = val_t;
						if (_tmp46_ == G_TYPE_INT) {
							sqlite3_stmt* _tmp47_;
							gint _tmp48_;
							GValue* _tmp49_;
							gint _tmp50_ = 0;
							_tmp47_ = self->priv->stmt;
							_tmp48_ = index;
							_tmp49_ = val;
							_tmp50_ = g_value_get_int (_tmp49_);
							sqlite3_bind_int (_tmp47_, _tmp48_, _tmp50_);
						} else {
							GType _tmp51_;
							_tmp51_ = val_t;
							if (_tmp51_ == G_TYPE_INT64) {
								sqlite3_stmt* _tmp52_;
								gint _tmp53_;
								GValue* _tmp54_;
								gint64 _tmp55_ = 0LL;
								_tmp52_ = self->priv->stmt;
								_tmp53_ = index;
								_tmp54_ = val;
								_tmp55_ = g_value_get_int64 (_tmp54_);
								sqlite3_bind_int64 (_tmp52_, _tmp53_, _tmp55_);
							} else {
								GType _tmp56_;
								_tmp56_ = val_t;
								if (_tmp56_ == G_TYPE_FLOAT) {
									sqlite3_stmt* _tmp57_;
									gint _tmp58_;
									GValue* _tmp59_;
									gfloat _tmp60_ = 0.0F;
									_tmp57_ = self->priv->stmt;
									_tmp58_ = index;
									_tmp59_ = val;
									_tmp60_ = g_value_get_float (_tmp59_);
									sqlite3_bind_double (_tmp57_, _tmp58_, (gdouble) _tmp60_);
								} else {
									GType _tmp61_;
									_tmp61_ = val_t;
									if (_tmp61_ == G_TYPE_DOUBLE) {
										sqlite3_stmt* _tmp62_;
										gint _tmp63_;
										GValue* _tmp64_;
										gdouble _tmp65_ = 0.0;
										_tmp62_ = self->priv->stmt;
										_tmp63_ = index;
										_tmp64_ = val;
										_tmp65_ = g_value_get_double (_tmp64_);
										sqlite3_bind_double (_tmp62_, _tmp63_, _tmp65_);
									} else {
										GType _tmp66_;
										_tmp66_ = val_t;
										if (_tmp66_ == G_TYPE_POINTER) {
											sqlite3_stmt* _tmp67_;
											gint _tmp68_;
											_tmp67_ = self->priv->stmt;
											_tmp68_ = index;
											sqlite3_bind_null (_tmp67_, _tmp68_);
										} else {
											GType _tmp69_;
											_tmp69_ = val_t;
											if (_tmp69_ == G_TYPE_BYTE_ARRAY) {
												GValue* _tmp70_;
												GByteArray* _tmp71_;
												GByteArray* ba;
												sqlite3_stmt* _tmp72_;
												gint _tmp73_;
												GByteArray* _tmp74_;
												guint8* _tmp75_;
												gint _tmp75__length1;
												GByteArray* _tmp76_;
												guint _tmp77_;
												_tmp70_ = val;
												_tmp71_ = _g_byte_array_ref0 (g_value_get_boxed (_tmp70_));
												ba = _tmp71_;
												_tmp72_ = self->priv->stmt;
												_tmp73_ = index;
												_tmp74_ = ba;
												_tmp75_ = _tmp74_->data;
												_tmp75__length1 = (gint) _tmp74_->len;
												_tmp76_ = ba;
												_tmp77_ = _tmp76_->len;
												sqlite3_bind_blob (_tmp72_, _tmp73_, _tmp75_, (gint) _tmp77_, NULL);
												_g_byte_array_unref0 (ba);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	return obj;
}


static void sql_heavy_query_result_class_init (SQLHeavyQueryResultClass * klass) {
	sql_heavy_query_result_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyQueryResultPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sql_heavy_query_result_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sql_heavy_query_result_set_property;
	G_OBJECT_CLASS (klass)->constructor = sql_heavy_query_result_constructor;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_query_result_finalize;
	/**
	     * The Query associated with this result.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_QUERY, g_param_spec_object ("query", "query", "query", SQL_HEAVY_TYPE_QUERY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The bindings for this query result
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_BINDINGS, g_param_spec_object ("bindings", "bindings", "bindings", SQL_HEAVY_TYPE_VALUE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Number of times that SQLite has stepped forward in a table as
	     * part of a full table scan.
	     *
	     * See SQLite documentation at [[http://sqlite.org/c3ref/c_stmtstatus_fullscan_step.html]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_FULL_SCAN_STEPS, g_param_spec_int ("full-scan-steps", "full-scan-steps", "full-scan-steps", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The number of sort operations that have occurred.
	     *
	     * See SQLite documentation at [[http://sqlite.org/c3ref/c_stmtstatus_fullscan_step.html]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_SORT_OPERATIONS, g_param_spec_int ("sort-operations", "sort-operations", "sort-operations", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * A timer for determining how much time (wall-clock) has been
	     * spent executing the statement.
	     *
	     * This clock is started and stopped each time step () is called,
	     * and reset when reset () is called.
	     *
	     * @return seconds elapsed
	     * @see Database.enable_profiling
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_EXECUTION_TIME, g_param_spec_double ("execution-time", "execution-time", "execution-time", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Whether the result set has been iterated through in its
	     * entirety
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_FINISHED, g_param_spec_boolean ("finished", "finished", "finished", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_FIELD_COUNT, g_param_spec_int ("field-count", "field-count", "field-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Signal which is emitted each time a row is recieved.
	     */
	g_signal_new ("received_row", SQL_HEAVY_TYPE_QUERY_RESULT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void sql_heavy_query_result_sql_heavy_record_interface_init (SQLHeavyRecordIface * iface) {
	sql_heavy_query_result_sql_heavy_record_parent_iface = g_type_interface_peek_parent (iface);
	iface->field_name = (gchar* (*)(SQLHeavyRecord*, gint, GError**)) sql_heavy_query_result_real_field_name;
	iface->field_index = (gint (*)(SQLHeavyRecord*, const gchar*, GError**)) sql_heavy_query_result_real_field_index;
	iface->field_type = (GType (*)(SQLHeavyRecord*, gint, GError**)) sql_heavy_query_result_real_field_type;
	iface->fetch = (void (*)(SQLHeavyRecord*, gint, GValue*, GError**)) sql_heavy_query_result_real_fetch;
	iface->fetch_string = (gchar* (*)(SQLHeavyRecord*, gint, GError**)) sql_heavy_query_result_real_fetch_string;
	iface->fetch_int = (gint (*)(SQLHeavyRecord*, gint, GError**)) sql_heavy_query_result_real_fetch_int;
	iface->fetch_int64 = (gint64 (*)(SQLHeavyRecord*, gint, GError**)) sql_heavy_query_result_real_fetch_int64;
	iface->fetch_double = (gdouble (*)(SQLHeavyRecord*, gint, GError**)) sql_heavy_query_result_real_fetch_double;
	iface->fetch_blob = (guint8* (*)(SQLHeavyRecord*, gint, int*, GError**)) sql_heavy_query_result_real_fetch_blob;
	iface->fetch_foreign_row = (SQLHeavyRow* (*)(SQLHeavyRecord*, gint, GError**)) sql_heavy_query_result_real_fetch_foreign_row;
	iface->get_field_count = sql_heavy_query_result_real_get_field_count;
}


static void sql_heavy_query_result_sql_heavy_record_set_interface_init (SQLHeavyRecordSetIface * iface) {
	sql_heavy_query_result_sql_heavy_record_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(SQLHeavyRecordSet*, GError**)) sql_heavy_query_result_real_next;
}


static void sql_heavy_query_result_instance_init (SQLHeavyQueryResult * self) {
	self->priv = SQL_HEAVY_QUERY_RESULT_GET_PRIVATE (self);
	self->priv->error_code = SQLITE_OK;
	self->priv->_field_names = NULL;
}


static void sql_heavy_query_result_finalize (GObject* obj) {
	SQLHeavyQueryResult * self;
	SQLHeavyQuery* _tmp0_;
	SQLHeavyQuery* query;
	SQLHeavyQuery* _tmp1_;
	SQLHeavyQueryable* _tmp2_;
	SQLHeavyQueryable* _tmp3_;
	SQLHeavyQueryable* queryable;
	SQLHeavyQueryable* _tmp4_;
	SQLHeavyDatabase* _tmp5_;
	SQLHeavyDatabase* _tmp6_;
	SQLHeavyDatabase* _tmp7_;
	SQLHeavyProfilingDatabase* _tmp8_;
	SQLHeavyProfilingDatabase* _tmp9_;
	SQLHeavyProfilingDatabase* _tmp10_;
	SQLHeavyProfilingDatabase* prof_db;
	SQLHeavyQueryable* _tmp11_;
	SQLHeavyQuery* _tmp12_;
	SQLHeavyProfilingDatabase* _tmp13_;
	sqlite3_stmt* _tmp15_;
	SQLHeavyQuery* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp20_;
	self = SQL_HEAVY_QUERY_RESULT (obj);
	_tmp0_ = self->priv->_query;
	query = _tmp0_;
	_tmp1_ = query;
	_tmp2_ = sql_heavy_query_get_queryable (_tmp1_);
	_tmp3_ = _tmp2_;
	queryable = _tmp3_;
	_tmp4_ = queryable;
	_tmp5_ = sql_heavy_queryable_get_database (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = sql_heavy_database_get_profiling_data (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp7_);
	prof_db = _tmp10_;
	_tmp11_ = queryable;
	_tmp12_ = query;
	g_signal_emit_by_name (_tmp11_, "query-executed", _tmp12_);
	_tmp13_ = prof_db;
	if (_tmp13_ != NULL) {
		SQLHeavyProfilingDatabase* _tmp14_;
		_tmp14_ = prof_db;
		sql_heavy_profiling_database_insert (_tmp14_, self);
	}
	_tmp15_ = self->priv->stmt;
	sqlite3_reset (_tmp15_);
	_tmp16_ = query;
	_tmp17_ = sql_heavy_query_get_auto_clear (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		SQLHeavyQuery* _tmp19_;
		_tmp19_ = query;
		sql_heavy_query_clear (_tmp19_);
	}
	_tmp20_ = self->priv->stmt_is_owned;
	if (_tmp20_) {
		sqlite3_stmt* _tmp21_;
		_tmp21_ = self->priv->stmt;
		sqlite3_finalize (_tmp21_);
	} else {
		SQLHeavyQuery* _tmp22_;
		_tmp22_ = query;
		sql_heavy_query_return_stmt (_tmp22_);
	}
	_g_object_unref0 (self->priv->_query);
	_g_object_unref0 (self->priv->_bindings);
	_g_timer_destroy0 (self->priv->execution_timer);
	_g_hash_table_unref0 (self->priv->_field_names);
	G_OBJECT_CLASS (sql_heavy_query_result_parent_class)->finalize (obj);
}


/**
   * The result of executing a {@link Query}
   */
GType sql_heavy_query_result_get_type (void) {
	static volatile gsize sql_heavy_query_result_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_query_result_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyQueryResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_query_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyQueryResult), 0, (GInstanceInitFunc) sql_heavy_query_result_instance_init, NULL };
		static const GInterfaceInfo sql_heavy_record_info = { (GInterfaceInitFunc) sql_heavy_query_result_sql_heavy_record_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo sql_heavy_record_set_info = { (GInterfaceInitFunc) sql_heavy_query_result_sql_heavy_record_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sql_heavy_query_result_type_id;
		sql_heavy_query_result_type_id = g_type_register_static (G_TYPE_OBJECT, "SQLHeavyQueryResult", &g_define_type_info, 0);
		g_type_add_interface_static (sql_heavy_query_result_type_id, SQL_HEAVY_TYPE_RECORD, &sql_heavy_record_info);
		g_type_add_interface_static (sql_heavy_query_result_type_id, SQL_HEAVY_TYPE_RECORD_SET, &sql_heavy_record_set_info);
		g_once_init_leave (&sql_heavy_query_result_type_id__volatile, sql_heavy_query_result_type_id);
	}
	return sql_heavy_query_result_type_id__volatile;
}


static void _vala_sql_heavy_query_result_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SQLHeavyQueryResult * self;
	self = SQL_HEAVY_QUERY_RESULT (object);
	switch (property_id) {
		case SQL_HEAVY_QUERY_RESULT_QUERY:
		g_value_set_object (value, sql_heavy_query_result_get_query (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_BINDINGS:
		g_value_set_object (value, sql_heavy_query_result_get_bindings (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_FULL_SCAN_STEPS:
		g_value_set_int (value, sql_heavy_query_result_get_full_scan_steps (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_SORT_OPERATIONS:
		g_value_set_int (value, sql_heavy_query_result_get_sort_operations (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_EXECUTION_TIME:
		g_value_set_double (value, sql_heavy_query_result_get_execution_time (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_FINISHED:
		g_value_set_boolean (value, sql_heavy_query_result_get_finished (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_FIELD_COUNT:
		g_value_set_int (value, sql_heavy_record_get_field_count ((SQLHeavyRecord*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sql_heavy_query_result_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SQLHeavyQueryResult * self;
	self = SQL_HEAVY_QUERY_RESULT (object);
	switch (property_id) {
		case SQL_HEAVY_QUERY_RESULT_QUERY:
		sql_heavy_query_result_set_query (self, g_value_get_object (value));
		break;
		case SQL_HEAVY_QUERY_RESULT_BINDINGS:
		sql_heavy_query_result_set_bindings (self, g_value_get_object (value));
		break;
		case SQL_HEAVY_QUERY_RESULT_FINISHED:
		sql_heavy_query_result_set_finished (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



