/******************************************************************************
 * THIS FILE IS GENERATED - ANY EDITS WILL BE OVERWRITTEN
 */

#pragma once

#include "jobs/basejob.h"

#include <QtCore/QJsonObject>

namespace Quotient
{

// Operations

/// Set some account_data for the user.
/*!
 * Set some account_data for the client. This config is only visible to the user
 * that set the account_data. The config will be synced to clients in the
 * top-level ``account_data``.
 */
class SetAccountDataJob : public BaseJob
{
public:
    /*! Set some account_data for the user.
     * \param userId
     *   The ID of the user to set account_data for. The access token must be
     *   authorized to make requests for this user ID.
     * \param type
     *   The event type of the account_data to set. Custom types should be
     *   namespaced to avoid clashes.
     * \param content
     *   The content of the account_data
     */
    explicit SetAccountDataJob(const QString& userId, const QString& type,
                               const QJsonObject& content = {});
};

/// Get some account_data for the user.
/*!
 * Get some account_data for the client. This config is only visible to the user
 * that set the account_data.
 */
class GetAccountDataJob : public BaseJob
{
public:
    /*! Get some account_data for the user.
     * \param userId
     *   The ID of the user to get account_data for. The access token must be
     *   authorized to make requests for this user ID.
     * \param type
     *   The event type of the account_data to get. Custom types should be
     *   namespaced to avoid clashes.
     */
    explicit GetAccountDataJob(const QString& userId, const QString& type);

    /*! Construct a URL without creating a full-fledged job object
     *
     * This function can be used when a URL for
     * GetAccountDataJob is necessary but the job
     * itself isn't.
     */
    static QUrl makeRequestUrl(QUrl baseUrl, const QString& userId,
                               const QString& type);
};

/// Set some account_data for the user.
/*!
 * Set some account_data for the client on a given room. This config is only
 * visible to the user that set the account_data. The config will be synced to
 * clients in the per-room ``account_data``.
 */
class SetAccountDataPerRoomJob : public BaseJob
{
public:
    /*! Set some account_data for the user.
     * \param userId
     *   The ID of the user to set account_data for. The access token must be
     *   authorized to make requests for this user ID.
     * \param roomId
     *   The ID of the room to set account_data on.
     * \param type
     *   The event type of the account_data to set. Custom types should be
     *   namespaced to avoid clashes.
     * \param content
     *   The content of the account_data
     */
    explicit SetAccountDataPerRoomJob(const QString& userId,
                                      const QString& roomId, const QString& type,
                                      const QJsonObject& content = {});
};

/// Get some account_data for the user.
/*!
 * Get some account_data for the client on a given room. This config is only
 * visible to the user that set the account_data.
 */
class GetAccountDataPerRoomJob : public BaseJob
{
public:
    /*! Get some account_data for the user.
     * \param userId
     *   The ID of the user to set account_data for. The access token must be
     *   authorized to make requests for this user ID.
     * \param roomId
     *   The ID of the room to get account_data for.
     * \param type
     *   The event type of the account_data to get. Custom types should be
     *   namespaced to avoid clashes.
     */
    explicit GetAccountDataPerRoomJob(const QString& userId,
                                      const QString& roomId,
                                      const QString& type);

    /*! Construct a URL without creating a full-fledged job object
     *
     * This function can be used when a URL for
     * GetAccountDataPerRoomJob is necessary but the job
     * itself isn't.
     */
    static QUrl makeRequestUrl(QUrl baseUrl, const QString& userId,
                               const QString& roomId, const QString& type);
};

} // namespace Quotient
