8.3 Skalen

# Skalen

Sonic Pi kennt eine große Anzahl von Skalen. Wie wäre es, eine 
C3-Dur-Skala zu spielen?

```
play_pattern_timed scale(:c3, :major), 0.125, release: 0.1
```

Wir können die Skala auch über mehrere Oktaven spielen lassen:

```
play_pattern_timed scale(:c3, :major, num_octaves: 3), 0.125, release: 0.1
```

Und wie wär's mit allen Noten einer pentatonischen Tonleiter?

```
play_pattern_timed scale(:c3, :major_pentatonic, num_octaves: 3), 0.125, release: 0.1
```

## Zufällige Noten

Akkorde und Skalen sind gute Methoden, eine zufällige Auswahl auf etwas 
von Bedeutung einzugrenzen. Spiele einmal mit diesem Beispiel, das 
zufällige Noten aus dem E-Moll-Akkord in der 3. Oktave auswählt:

```
use_synth :tb303
loop do
  play choose(chord(:E3, :minor)), release: 0.3, cutoff: rrand(60, 120)
  sleep 0.25
end
```

Probiere auch verschiedene Akkord-Namen und Cut-Off-Bereiche aus.

## Akkorde und Skalen entdecken

Um herauszufinden, welche Skalen und Akkorde Sonic Pi unterstützt,
klicke einfach auf den `Lang`-Button ganz auf der linke Seite 
dieses Tutorials und wähle entweder `chord` oder `scale` aus der 
API-Liste. Scrolle im Hauptfenster herunter, bist Du eine lange Liste 
von Akkorden oder Skalen findest.

Viel Spaß und nicht vergessen: Es gibt keine Fehler, nur Möglichkeiten.
