9.4 Cykanie

# Cykanie

Coś na co na pewno będziesz robił dość często podczas kodowania na żywo 
to iterowanie przez pierścienie. Będziesz wrzucał nuty do pierścieni dla 
tworzenia melodii, czasów uśpienia dla rytmów, progresji akordów, różne wariacje 
barw dźwięku, itd.

## Cykające Pierścienie

Sonic Pi udostępnia *bardzo* przydatne narzędzie do pracy z pierścieniami 
w żywych pętlach `live_loop`. Nazywa się to systemem cykania. Udostępnia 
Ci możliwość *cykania przez pierścienie*. Spójrzmy na następujący przykład: 

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end
```

Wzięliśmy tu pentatoniczną skalę E3 moll i cykamy przez każdy jej element. 
Dokonaliśmy tego przez dodanie polecenia `.tick` na końcu deklaracji skali. 
Każde cyknięcie jest lokalne dla danej żywej pętli, więc każda żywa pętla 
może posiadać swojego własnego niezależnego cykacza:

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end

live_loop :arp2 do
  use_synth :dsaw
  play (scale :e2, :minor_pentatonic, num_octaves: 3).tick, release: 0.25
  sleep 0.25
end
```

## Cyknięcie

Możesz również uruchomić polecenie cyknięcia `tick` jako standardową funkcje 
i używać zwracanej wartości jako indeksu: 

```
live_loop :arp do
  idx = tick
  play (scale :e3, :minor_pentatonic)[idx], release: 0.1
  sleep 0.125
end
```

Jednakże, dużo ładniej jest korzystać z polecenia `.tick` dodanego na końcu. 
Funkcja `tick` jest stworzona dla sytuacji gdy chesz zrobić coś fantazyjnego 
z wartością zwracaną przy cyknięciu oraz gdy chcesz używać cyknięć 
do innych rzeczy niż indeksowania elementów pierścieni.

## Look

Magiczną rzeczą w cykaniu jest to, że możliwe jest nie tylko zwrócenie  
nowego indeksu (albo wartości znajdującej się w pierścieniu pod tym 
indeksem). Mechanizm ten pilnuje też aby przy każdym twoim kolejnym 
cyknięciu była to kolejna wartość. Zerknij na przykłady znajdujące się 
w dokumentacji dla polecenia `tick` aby zobaczyć wiele różnych sposobów 
na pracę z nim. Jednakże, na tą chwilę, ważne jest aby zaznaczyć, że czasami 
będziesz chciał po prostu podejrzeć aktualną wartość cyknięcia *bez zwiększania* 
jego wartości. Możesz tego dokonać za pomocą funkcji `look`. Możesz uruchamiać 
polecenie `look` jako standardową funkcję lub poprzez dodanie `.look` 
na końcu pierścienia.

## Nazwane Cyknięcia

Na koniec, czasami będziesz potrzebował więcej niż jednego cykacza dla 
danej żywej pętli. Można tego dokonać poprzez nadanie twojemu cyknięciu 
nazwę: 

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick(:foo), release: 0.1
  sleep (ring 0.125, 0.25).tick(:bar)
end
```

Powyżej używamy dwóch cykaczy, jeden dla zagrania nuty i drugi dla  
odliczania czasu uśpienia. Jako, że oba znajdują się w tej samej żywej pętli, 
potrzebowaliśmy nadać im unikalne nazwy aby sprawić by były oddzielne. 
To jest dokładnie taki sam mechanizm jak w przypadku nadawania nazw 
żywym pętlom (`live_loop`) - po prostu przekazujemy symbol poprzedzony 
dwukropkiem `:`. W powyższym przykładzie nazwaliśmy pierwszego 
cykacza `:foo` a drugiego `:bar`. Jeśli chcemy podejrzeć aktualną 
wartość, któregoś z nich za pomocą polecenia `look`, to musimy 
do polecenia `look` również przekazać nazwę konkretnego cykacza.

## Nie twórz zbyt skomplikowanych rzeczy

Większość mocy zawartej w systemie cykania nie jest przydatna gdy 
dopiero zaczynasz. Nie próbój i nie ucz się wszystkiego z tego 
rozdziału. Postaraj skupić się na cykaniu przez pojedynczy pierścień. 
To powinno dać Ci największą satysfakcję oraz prostotę związaną 
z cykaniem przez pierścienie w twoich żywych pętlach. 

Zerknij do dokumentacji na polecenie `tick` gdzie znajdziesz wiele 
przydatnych przykładów. Wesołego cykania!
