3.3 Rozciąganie Sampli 

# Rozciąganie Sampli 

Teraz, gdy już umiemy grać za pomocą różnorodnych syntezatorów i
sampli, przyszedł czas aby nauczyć się w jaki sposób można modyfikować
syntezatory i sample aby sprawić by muzyka była jeszcze bardziej
unikalna i interesująca. Na początek poznajmy możliwość rozciągania
(*stretch*) i ściskania (*squash*) sampli.

## Reprezentacja Sampla

Sample to nagrane dźwięki, które są przechowywane niczym liczby, które
mówią o tym jak poruszyć stożek głośnika by zreprodukować dany dźwięk.
Stożek głośnika może poruszać się do środka i na zewnątrz, tak samo
liczby muszą jedynie przedstawiać jak daleko do środka lub na zewnątrz
powinien znajdować się stożek głośnika w danym momencie. Aby móć
wiernie odwzorować nagrany dźwięk sampla zazwyczaj potrzeba do tego
wiele tysięcy liczb na sekundę! Sonic Pi bierze tę listę liczb i
zasila nimi głośniki z odpowiednią prędkością tak aby głośniki twojego
komputera poruszały się do przodu i do tyłu w taki właśnie sposób aby
zreprodukować dany dźwięk. Mimo to, całkiem fajnie jest zmieniać
prędkość z jaką te liczby są przekazywane do głośnika aby w ten sposób
zmieniać brzmienie.

## Zmiana tempa

Pobawmy się jednym z dźwięków z
[gatunku ambient](https://pl.wikipedia.org/wiki/Ambient):
`:ambi_choir`. Aby zagrać go w domyślnym tempie, możesz przekazać
parametr `rate:` do polecenia sample: 

```
sample :ambi_choir, rate: 1
```

Takie poleceni sprawia, że sampel zostanie zagrany w normalnym tempie
(1), więc póki co nic specjalnego się nie dzieje. Nic jednak nie stoi
nam na przeszkodzie abyśmy zmienili tę liczbę na coś innego. Co
powiesz na wartośc `0.5`:

```
sample :ambi_choir, rate: 0.5
```

Łał! Co się tutaj dzieje? Otóż, dwie rzeczy. Po pierwsze, odtworzenie
naszego naszego sampla zajmuje drugie tyle czasu. Po drugie, dźwięk
jest niższy o oktawę. Przyjrzyjmy się tym dwóm tematom nieco bardziej
szczegółowo.

## Rozciągamy

Sampel, który jest bardzo fajny do rozciągania i kompresji to 
Amen beakbit. Przy normalnym tempie, możemy wyobrazić sobie wrzucenie 
go do utworu *drum 'n' bass*:

```
sample :loop_amen
```

Jednak gdy zmienimy tempo możemy bardzo szybko zmienić gatunek. Spróbuj 
połowy prędkości aby stworzyć *oldschool'owy hip hop*:

```
sample :loop_amen, rate: 0.5
```

Jeśli przyśpieszymy, wejdziemy na terytorium *jungle*:

```
sample :loop_amen, rate: 1.5
```

A teraz nasz ulubiony finalny trik - zobaczmy co się stanie jeśli 
użyjemy ujemnego tempa:

```
sample :loop_amen, rate: -1
```

Łoł! To jest odtwarzane *od tyłu*! A teraz spróbuj sam pokombinować 
z różnymi samplami ustawiając je na różne tempa. Spróbuj bardzo szybkich 
temp. Spróbuj niewiarygodnie niskich temp. Sprawdź jak różne i interesujące 
dźwięki możesz wyprodukować.

## Proste Wyjaśnienie Częstotliwości Próbkowania

Przydatnym sposobem myślenia o samplach jest myślenie o nich jak 
o sprężynkach. Z tempem (szybkością) odtwarzania jest tak jak 
ze ściskaniem i rozciąganiem sprężyny. Zagranie sampla w tempie 
równym 2 spowoduje, że *ściśniesz sprężynę* do połowy jej normalnej 
długości. Dlatego też zagranie takiego sampla zajmie o połowę 
mniej czasu. Jeśli zagrasz sampel w tempie równym połowe normalnego, 
to wtedy *rozciągasz sprężynę tak, że podwaja swoją długość. W takim 
przypadku zagranie całego sampla zajmie dwa razy więcej czasu. 
Im bardziej ściśniesz sprężynę (wyższe tempo), tym stanie się krótsza. 
Analogicznie, im bardziej rozciągniesz (niższe tempo), tym będzie 
dłuższa.

Ściskanie sprężyny zwiększa jej gęstość (liczba zwojów na cm) - jest to 
podobne do tego gdy sampel brzmi na *wyższym poziomie* (pitch). 
Rozciąganie zmniejsza gęstość i jest podobne to dźwięku posiadającego 
*niższy poziom* (pitch).

## Matematyka Stojąca Za Częstotliwością Próbkowania

(Ta sekcja jest udostępniona dla tych osób, które są zainteresowane 
szczegółami. Jeśli nie jesteś, możesz ją po prostu pominąć...)

Jak zauważyliśmy już powyżej, sampel jest reprezentowany przez wielką, 
długą listę liczb, które defuniują to w jakiej pozycji powinien znajdować 
się głośnik w danym momencie czasu. Możemy wziąć te liczby i wykorzystać 
je do narysowania wykresu graficznego, który mógłby wyglądać bardzo podobnie 
do tego:

![sample graph](../images/tutorial/sample.png)

Być może widziałeś już podobne obrazki. Nazywa się ją *przebiegiem 
fali* sampla. Jest to nic innego jak tylko wykres prezentujący liczby. 
Zazwyczaj przebieg fali takiej jak ta będzie miał 44100 punktów z danymi 
na sekundę(jest związane z twierdzeniem Kotelnikowa-Shanona). Więc jeśli 
sampel trwa przez 2 sekundy, to *przebieg fali* będzie reprezentowany 
przez 88200 liczb które przekażemy do głośnika z prędkością 44100 punktów 
na sekundę. Odtworzenie tego powinno zatem zajęć tylko 1 sekundę. Możemy 
spróbować również odtworzyć go w tempie o połowę mniejszym, co dałoby wartość 
22050 punktów na sekundę i odtworzenie zajęłoby 4 sekundy.

Na czas trwania sampli ma wpływ szybkość odtwarzania:

* podwojenie szybkości odtwarzania skraca o połowę czas odtwarzania
* skrócenie szybkości odtwarzania o połowę podwaja czas odtwarzania
* ustawienie szybkości odtwarzania równej jednej czwartej sprawi, że 
czas odtwarzania będzie czterokrotnie dłuższy
* ustawienie szybkości odwarzania na poziomie 1/10 spowoduje, 
że czas odtwarzania zajmie 10 razy dłużej

Możemy przedstawić to za pomocą następującego wzoru:

```
nowy_czas_trwania_sampla = (1 / tempo) * czas_trwania_sampla
```

Zmiana szybkości odtwarzania wpływa również na wysokość tonu (pitch) sampla. 
Częstotliwość lub wysokość tonu widoczna na fali dźwięku jest determinowana 
przez to jak szybko się ona zmienia w górę i w dół. Nasze mózgi w jakiś 
sposób zmieniają szybkie ruchy głośnika na wysokie nuty oraz wolne ruchy 
głośników na niskie nuty. To jest właśnie przyczyną tego, że czasami 
możesz nawet zobaczyć ruch dużego głośnika basowego gdy wydaje on 
z siebie super niski bas - w zasadzie to porusza się on wtedy znacznie 
wolniej w tę i z powrotem niż wtedy gdy głośnik produkuje wyższe dźwięki. 

Jeśli weźmie się falę dźwięku i ściśnie się to wtedy będzie się ona poruszać 
w górę i w dół więcej razy na sekundę. Spowoduje to, że dany dźwięk będzie 
miał wyższy ton. Oznacza to, że podwojenie ruchów w górę i w dół (oscylacji) 
zwiększa częstotliwość dwukrotnie. Podsumowując, *zagranie twojego sampla 
z podwójną prędkością spowoduje, że częstotliwość, którą usłyszysz będzie 
dwa razy wyższa*. Analogicznie, *obniżenie tempa o połowę spowoduje, że 
częstotliwość będzie też niższa o połowę*. Inne wartości tempa będą będą 
oddziaływać na częstotliwość odpowiednio.
