8.4 Anillos

# Anillos

Una variación interesante a las listas, son los anillos. Si sabes
algo de programación, puedes haberte topado con anillos de buffers
o arrays. Aquí sólo iremos con los anillos - es corto y simple.

En la sección anterior de listas, vimos cómo sacar elementos de
ellas a través del mecanismo de indexado:

```
puts [52, 55, 59][1]
```

Ahora, ¿qué sucede si quieres el índice `100`? Bueno, claramente no 
existe un elemente en el índice 100, ya que sólo hay 3 elementos dentro.
Así que Sonic Pi te responderá un `nil`.
Sin embargo, considera que tienes un contador tal como el pulso actual 
que se va incrementando. Hagamos nuestro contador y lista:

```
counter = 0
notes = [52, 55, 59]
```

We can now use our counter to access a note in our list:

```
puts notes[counter]
```

Grandioso, obtuvimos `52`. Ahora, incrementemos nuestro contador y
obtengamos otra nota:

```
counter = (inc counter)
puts notes[counter]
```

Super, obtuvimos `55`y después `59`. Sin embargo, si lo hacemos de nuevo,
se nos acaban los números de la lista y obtenemos `nil`. Si quisiésemos
buclear y volver a comenzar la lista, usaríamos los anillos.

## Creando Anillos

Podemos crear anillos de dos maneras: con la función `ring`y los elementos
del anillo como parámetros:

```
(ring 52, 55, 59)
```

O podemos tomar una lista normal y convertirla a anillo con el mensaje
`.ring`:

```
[52, 55, 59].ring
```

## Indexando Anillos 

Un anillo puede ser utilizado de la misma manera que una lista, exceptuando
que puedes usar índices negativos y mayores al tamaño del anillo mismo, los
cuales envolverán y apuntarán siempre a alguno de los elementos del anillo:

```
(ring 52, 55, 59)[0] #=> 52
(ring 52, 55, 59)[1] #=> 55
(ring 52, 55, 59)[2] #=> 59
(ring 52, 55, 59)[3] #=> 52
(ring 52, 55, 59)[-1] #=> 59
```

## USando Anillos

Usemos una variable para representar el número del pulso actual.
Podemos usar esto como un índice a nuestro anillo para agarrar notas
a ser tocadas o tiempos de release o cualquier cosa útil que tengamos
en nuestro anillo, independientemente del pulso en el que estemos.

## Las escalas y acordes son anillos

Algo útil de saber es que las listas regresadas por `scale` y `acorde`
también son anillos que te permiten las accedas con índices arbitrarios.

## Constructores de Anillos

Además de `ring` hay un número de funciones que construyen anillos por 
nosotros.

* `range` pide especificar un punto de inicio, final y tamaño del paso.
* `bools` permite usar `1`s y `0`s para representar booleanos.
* `knit` permite conectar una secuencia de valores repetidos.
* `spread` crea un anillo de booleanos con distribución euclideana.

Mira la documentación de cada uno para más información.
