/*
 * Routines to parse and print appinfo information
 */
#include "basil_alps.h"
#include <alps/apInfo.h>

/**
 * struct node_placement - sorted list of node placement entries
 */
struct node_placement {
	uint32_t	nid;		/* key for this entry */
	int		cmd_idx;	/* -1 means "no apid/command"	 */
	uint32_t	resid;		/* reservation ID (0 if not set) */
	uint64_t	apid;		/* 0 if cmd_idx == -1 		 */
	uint32_t	cores;		/* cores claimed by placement	 */
	int		res_width,	/* placement parameter		 */
			res_depth,	/* placement parameter		 */
			res_nppn,	/* placement parameter		 */
			res_memory;	/* placement parameter (MBs)	 */
	int		width,		/* placement parameter		 */
			depth,		/* placement parameter		 */
			nppn,		/* placement parameter		 */
			memory;		/* placement parameter (MBs)	 */

	struct node_placement *next;	/* sorted in ascending order of nids */
};

extern struct node_placement *np_add(struct node_placement **head, uint32_t nid);
extern struct node_placement *np_lookup(struct node_placement *head, uint32_t nid);
extern int  np_count(struct node_placement *head);
extern void np_free(struct node_placement *np);

/**
 * appinfo_get_node_placements  -  get node placement information
 * @ai_buf:   start of appinfo buffer
 * Return list of node placements or NULL on error.
 */
extern struct node_placement *appinfo_get_node_placements(const uint8_t *ai_buf);

/**
 * basil_get_appinfo_path  - determine configured appinfo path at runtime.
 * Return allocated result, abort on configuration error.
 */
extern char *basil_get_appinfo_path(void);

/**
 * basil_get_appinfo  -  return 'appinfo' as in-memory structure
 * Return buffer containing current appinfo (must be freed) or NULL.
 */
extern uint8_t *basil_get_appinfo(void);

/**
 * appinfo_by_resid  -  look up appinfo entry by reservation ID
 * @ai_buf: start of appinfo buffer
 * @resid:  reservation ID to search for
 * Returns pointer to appinfo entry, or NULL if not found.
 */
extern const appInfo_t *appinfo_by_resid(const uint8_t *ai_buf, uint32_t resid);

/**
 * appinfo_by_apid  -  look up appinfo entry by application ID
 * @ai_buf: start of appinfo buffer
 * @apid:   application ID to search for
 * Returns pointer to appinfo entry, or NULL if not found.
 */
extern const appInfo_t *appinfo_by_apid(const uint8_t *ai_buf, uint64_t apid);

/**
 * basil_get_apids_by_resv  -  return allocated APIDs for reservation ID
 * @ai_buf: start of appinfo buffer area
 * @resid:  reservation ID to look for (use 0 to get all Apids)
 * Return 0-terminated array of apids, NULL if no result and on error
 */
extern uint64_t *basil_get_apids_by_resv(const uint8_t *ai_buf, uint32_t resid);

/**
 * is_any_node_claimed  -  check if at least one node is being used
 * @start:   start of placement list array
 * @nplaces: number of places in @list
 * Returns true if at least one node has been claimed.
 * NB: the algorithm is not sufficient to distinguish node state
 *     between 'conf' and 'conf,claim' on CLE 2.x - use instead
 *     basil_rsvn_get_num_apps(rsvn).
 */
extern bool is_any_node_claimed(const uint8_t *buf_start, appInfo_t *ai_info);

/**
 * appinfo_nidlist  -  Extract nodelist from appinfo entry
 * @buf:     start of appinfo buffer area
 * @ai_info: current appinfo entry
 */
extern struct nodespec *appinfo_nidlist(const uint8_t *buf, appInfo_t *ai_info);

/**
 * num_placed_applications  -  count the number of placed APIDs
 * @ai_buf:  start of appinfo buffer area
 * @resv_id: resId > 0 to select, 0 to count all placed applications
 */
extern uint32_t num_placed_applications(const uint8_t *ai_buf, uint32_t resv_id);

/**
 * appinfo_arch  -  translate alps_archType_t into string
 * @arch: alps_archType_t value
 */
extern const char *appinfo_arch(uint8_t arch);
