//#define XERR
#include "tomo.ih"

// Tomo cost: 64   
// 
// #    bi-rad cat:    a       b       c       d             
// Tomo dose:          3       3       3       3  
// Tomo sensitivity:   0.87    0.84    0.73    0.65   
// 
// #                   agegroup
// Tomo specificity:   0 - 40:   0.961     40 - *: 0.965


//    Tomo:
//        costs:         64   
//
//        Dose:           
//          #            mean   spread    dist
//          bi-rad: a     3       1       Normal
//          bi-rad: b     3       1       Normal
//          bi-rad: c     3       1       Normal
//          bi-rad: d     3       1       Normal
//
//        Sensitivity:
//          #           proportion    spread      dist
//          bi-rad: a     .87          .05         Normal
//          bi-rad: b     .84          .05         Normal
//          bi-rad: c     .73          .05         Normal
//          bi-rad: d     .65          .05         Normal
//
//        Specificity:
//          #           range     proportion   spread      dist
//          ageGroup:   0 - 40:     .961       .0025       Normal
//          agegroup:  40 - * :     .965       .0025       Normal

Tomo::Tomo()
:
    ModBase("Tomo"),
    d_base{ "Modalities:", "Tomo:", "" }
{
    costBase(d_base);                // ModBase handles the costs spec.

    d_base.resize(4);

    doseBase(d_dose, d_base);        // using ModBase's members
    setSensitivity();

    specificityBase(d_specVect, d_base);
}



