/************************************************************************
 *
 * Copyright (C) 2009-2022 IRCAD France
 * Copyright (C) 2012-2019 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#pragma once

#include "modules/filter/image/config.hpp"

#include <data/Image.hpp>

#include <service/IFilter.hpp>

namespace sight::module::filter::image
{

/**
 * @brief Compute the substraction of two images.

 * @section XML XML Configuration
 *
 * @code{.xml}
   <service type="sight::module::filter::image::SImagesSubstract">
       <in key="image1" uid="..." />
       <in key="image2" uid="..." />
       <inout key="result" uid="..." />
   </service>
   @endcode
 * @subsection In In
 * - \b image1 [sight::data::Image]: first image.
 * - \b image2 [sight::data::Image]: second image.
 * @subsection InOut InOut
 * - \b result [sight::data::Image]: substract image.
 */

class MODULE_FILTER_IMAGE_CLASS_API SImagesSubstract final : public service::IFilter
{
public:

    SIGHT_DECLARE_SERVICE(SImagesSubstract, sight::service::IFilter);

    MODULE_FILTER_IMAGE_API SImagesSubstract()           = default;
    MODULE_FILTER_IMAGE_API ~SImagesSubstract() override = default;

protected:

    MODULE_FILTER_IMAGE_API void configuring() override;

    /// Overrides
    MODULE_FILTER_IMAGE_API void starting() override;

    /// Overrides
    MODULE_FILTER_IMAGE_API void stopping() override;

    /// Overrides
    MODULE_FILTER_IMAGE_API void updating() override;

private:

    sight::data::ptr<sight::data::Image, sight::data::Access::in> m_image1 {this, "image1"};
    sight::data::ptr<sight::data::Image, sight::data::Access::in> m_image2 {this, "image2"};
    sight::data::ptr<sight::data::Image, sight::data::Access::inout> m_result {this, "result"};
};

} // namespace sight::module::filter::image
