/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef WATCHMAKER_DEFINE_H
#define WATCHMAKER_DEFINE_H

namespace Watchmaker {

// Main Chars
#define DARRELL                 0
#define VICTORIA                1

// user define for .nl
#define TEXT1                   10000
#define TEXT2                   10001
#define TEXT3                   10002
#define TEXT4                   10003
#define TEXT5                                   10004
#define ANIM2                   10000

// Flag per Obj, ObjInv, Room
#define EXAMINEACT              1                   // Fa Azione in anim2 su esamina
#define ROOM                    2                   // Cambia Stanza - ma oggetto e' esaminabile
#define DOOR                    2                   // Cambia Stanza - ma oggetto e' esaminabile
#define CHARACTER               4                   // Parte dialogo
#define TAKE                    8                   // solo per obj - Lo prende
#define DAR                     0                   // solo per inv - se per darrell
#define VIC                     8                   // solo per inv - se per victoria
#define USE                     0                   // Se puo'  essere usato
#define USEWITH                 16                  // Fa Usa con
#define EXTRA                   32                  // Extra
#define EXTRA2                  64                  // Extra2
#define DONE                    128                 // Operato
#define ON                      256                 // Attivo (presente nella stanza)
#define WITHI                   512                 // se fa usacon automatico con invobj o con obj
#define HIDE                    1024                // Se l'oggetto e' nascosto (indipendentemente dal fatto che sia ON)
#define HIDEIN1ST               2048                // se invisibile in prima persona
#define HIDEIN3RD               4096                // se invisibile in terza persona
#define NOSWITCH                8192                // non torna in terza se sono in prima e ci clicco sopra
#define FORCERIGHT              16384               // se deve prendere sempre un click col destro
#define NOUPDATE                32768               // se non deve utare le mesh collegate

// Flags per animazioni
#define ANIM_ON                 1                   // Se attiva quando si entra nella stanza
#define ANIM_PORTAL_LINK        2                   // Se collega due portali
#define ANIM_ABS                4                   // Se non dipende da luce posizione
#define ANIM_BLOCK              8                   // Se deve tenere ultimo frame
#define ANIM_NO_FIX_POS         16                  // Se non deve fissare la posizione alla fine
#define ANIM_CHECK_BOUNDS       32                  // Se deve stare dentro i bounds
#define ANIM_TIME               64                  // Se e' un'animazione che da il tempo
#define ANIM_SKIP_LAST_FRAME    128                 // Non Playa ultimo frame
#define ANIM_NULL               256                 // Se serve soltanto come conta tempo
#define ANIM_PAUSED             512                 // Se e' in pausa
#define ANIM_STAND              1024                // Se e' un'animazione di stand-by quando uso l'altro personaggio
#define ANIM_DEFAULT            2048                // Se va caricata come default
#define ANIM_NO_START_BLEND     4096                // Se non va blendata all'inizio
#define ANIM_NO_END_BLEND       8192                // Se non va blendata alla fine
#define ANIM_DIARY              16384               // Se e' stata lanciata da un diario
#define ANIM_SKIP_1ST_FRAME     32768               // Non Playa il primo frame
#define ANIM_BLOCK_PLAYER       65536               // Blocca anche il player
#define ANIM_BKG                        131072                          // E' una animazione di background

// Flags per Sound - da implementare
#define SOUND_ON                1                   // Se il suono e' attivo
#define SOUND_LOOP              2                   // Se deve andare in loop
#define SOUND_BACK              4                   // Se e' un suono di background
#define SOUND_PSX               8                   // Se e' il suono del passo sinistro
#define SOUND_PDX               16                  // Se e' i,l suono del passo destro
#define SOUND_STAIRS            32                  // Se e' il suono di un passo sulle scale
#define SOUND_MUTE0             64                  // Se e' MUTE0
#define SOUND_MUTE1             128                 // Se e' MUTE1

// Flags per crediti
#define CF_NULL                                 0                              // nullo
#define CF_STATIC                               1                              // le scritte che seguono appaiono staticamente (di default scrollano)
#define CF_TITLE                                2                              // scrive la scritta nel mezzo (solo per scrolling)
#define CF_SPACE                                4                              // lascia x righe vuote prima di continuare a scrivere
#define CF_IMG                                  8                              // mette sulla sinistra l'immagine 64x64 e sulla destra la descrizione
#define CF_IMG2                                 16                             // mette sulla sinistra l'immagine 128x64 e sulla destra la descrizione
#define CF_END                                  32                             // e' la scritta finale, una volta che e' arrivata a meta' schermo si ferma e poi finiscono i crediti (solo per scrolling)

// Environment predefiniti per rooms
#define vGENERIC                0
#define vPADDEDCELL             1
#define vROOM                   2
#define vBATHROOM               3
#define vLIVINGROOM             4
#define vSTONEROOM              5
#define vAUDITORIUM             6
#define vCONCERTHALL            7
#define vCAVE                   8
#define vARENA                  9
#define vHANGAR                 10
#define vCARPETEDHALLWAY        11
#define vHALLWAY                12
#define vSTONECORRIDOR          13
#define vALLEY                  14
#define vFOREST                 15
#define vCITY                   16
#define vMOUNTAINS              17
#define vQUARRY                 18
#define vPLAIN                  19
#define vPARKINGLOT             20
#define vSEWERPIPE              21
#define vUNDERWATER             22
#define vDRUGGED                23
#define vDIZZY                  24
#define vPSYCHOTIC              25

// Flags per dialoghi
#define DIALOG_RTV              1                   // Se e' un RTV (non ha scelte)
#define DIALOG_RTV2             2                   // Se deve partire RTV2
#define DIALOG_RTV3             4                   // Se deve partire RTV3
#define DIALOG_PRE1             8                   // Se deve partire il predialog1
#define DIALOG_PRE2             16                  // Se deve partire il predialog2
#define DIALOG_PRE3             32                  // Se deve partire il predialog3
#define DIALOG_PRE4             64                  // Se deve partire il predialog4
#define DIALOG_PRE_RAND         128                 // Se deve partire un predialog a caso tra quelli attivi
#define DIALOG_END1             256                 // Se finire con l'enddialog1
#define DIALOG_END2             512                 // Se finire con l'enddialog1
#define DIALOG_END3             1024                // Se finire con l'enddialog1
#define DIALOG_END_RAND         2048                // Se finire con un enddialog a caso tra quelli attivi
#define DIALOG_DONE             4096                // Se il dialogo e' gia' stato fatto
#define DIALOG_ONCE             8192                // Se dialogo deve essere eseguito una sola volta

// Flags per le Rooms
#define ROOM_VISITED            1                   // Se sono gia' stato in questa stanza
#define ROOM_VISIBLE            2                   // Se e' visibile
#define ROOM_OLDVISIBLE         4                   // Se prima era visbile
#define ROOM_EXTRA              8                   // Se e' successa una cosa extra
#define ROOM_EXTRA2             16                  // Se e' successa una cosa extra2

// effetti speciali
#define EFFECT_FADIN            1                   // Effetto FadIn
#define EFFECT_FADOUT           2                   // Effetto FadOut
#define EFFECT_FADOUT_FADIN     3                   // Effetto FadOut-FadIn
#define EFFECT_WAIT             4                   // Effetto Aspetta
#define EFFECT_WAITDARK         5                   // Effetto Aspetta con schermo nero
#define EFFECT_ROOMINFO         6                   // Effetto RoomInfo
#define EFFECT_FADEIN_T1        7                   // Effetto FadIn T1
#define EFFECT_FADEOUT_T1       8                   // Effetto FadOut T1
#define EFFECT_FADEIN_T2        9                   // Effetto FadIn T2
#define EFFECT_FADEOUT_T2       10                  // Effetto FadOut T2
#define EFFECT_MOVEIN_T1        11                  // Effetto MOVEIn T1
#define EFFECT_MOVEOUT_T1       12                  // Effetto MOVEOut T1
#define EFFECT_MOVEIN_T2        13                  // Effetto MOVEIn T2
#define EFFECT_MOVEOUT_T2       14                  // Effetto MOVEOut T2
#define EFFECT_DISPLAY_NEWLOGIMG        15                  // Mostra una immagine quando il log viene aggiornato

// Per i log del PDA (menu e sottomenu)
#define PDA_UPDATE                              1
#define PDA_MENU                            2
#define PDA_ON                              4
#define PDA_MAIN                            8

/* -----------------17/03/98 10.42-------------------
 *                      AtFrame
 * --------------------------------------------------*/

#define ATF_DO                              1               // Esegue l'evento programmabile <event>
#define ATF_PUSH                            2               // Mette il valore <val> nello stack
#define ATF_POP                             3               // Cancella il valore attuale dallo stack
#define ATF_JUMP                            4               // Fa saltare animazioni NON in stack al frame <frame>
#define ATF_JUMP_ALL                        5               // Fa saltare tutte le animazioni al frame <frame>
#define ATF_LOOP_LEN                        6               // Definisce lunghezza del loop dal frame attuale
#define ATF_LOOP_END                        7               // Definisce fine del loop dal frame attuale
#define ATF_LOOP_MASK                       8               // Definisce animazioni su cui NON funziona il loop
#define ATF_TEXT                            9               // Dice la frase <sent>
#define ATF_POP_TEXT                        10              // Dice la frase prendendola dallo stack

#define ATF_CHANGE_ROOM                     13              // Posiziona omino in <roomname> e setta la posizione
#define ATF_CHANGE_ROOM_AN                  14              // Come ATF_SET_ROOM solo che fa partire anim in stack
#define ATF_SET_CAMERA                      15              // Forza la camera a diventare <cam>
#define ATF_SET_BND_LEVEL                   16              // Setta il livello <lev> di bounds
#define ATF_TO_1ST_SENT                     17              // Setta la frase da dire appena entra in prima
#define ATF_TO_1ST_ANIM                     18              // Setta animazione di entrata in prima persona
#define ATF_FROM_1ST_ANIM                   19              // Setta animazione di uscita dalla prima persona
#define ATF_CUROBJ                          20              // Setta il CurObj
#define ATF_CHANGE_PLAYER                   21              // Cambia personaggio con cui stai giocando
#define ATF_NO_INPUT                        22              // Setta on/off l'input da parte del giocatore
#define ATF_UPDATE_BBOX                     23              // Aggiorna Bounding box della mesh nel canale <mesh>
#define ATF_RESET_BLEND                     24              // Resetta blend per la mesh nel canale <mesh>
#define ATF_CAMERA_TARGET                   25              // Cambia oggetto su cui deve puntare la camera
#define ATF_UPDATE_MAX_TARGET               26              // Aggiorna il target con quello attuale
#define ATF_SUB_MUSIC                       27              // Cambia la sottomusica attuale
#define ATF_EXIT                            28              // Termina l'animazione istantaneamente
#define ATF_LINK                            29              // Definisce questo frame come possibile uscita dal loop

#define ATFO_OFF                            30              // Spegne l'oggetto <obj>
#define ATFO_ON                             31              // Attiva l'oggetto <obj>
#define ATFO_HIDE                           32              // hida oggetto <obj>
#define ATFO_UNHIDE                         33              // unhida oggetto <obj>
#define ATFOM_OFF                           34              // Spegne l'oggetto <obj> e tutte le mesh collegate
#define ATFOM_ON                            35              // Attiva l'oggetto <obj> e tutte le mesh collegate
#define ATFOM_HIDE                          36              // hida oggetto <obj> e tutte le mesh collegate
#define ATFOM_UNHIDE                        37              // unhida oggetto <obj> e tutte le mesh collegate
#define ATFD_OFF                            38              // Spegne il dialogo <dlg>
#define ATFD_ON                             39              // Attiva il dialogo <dlg>
#define ATFW_OFF                            40              // Spegne l'effetto sonoro <wav>
#define ATFW_ON                             41              // Attiva l'effetto sonoro <wav>
#define ATFI_OFF                            42              // Spegne l'icona <icon>
#define ATFI_ON                             43              // Attiva l'icona <icon>
#define ATFA_OFF                            44              // Spegne l'animazione <anim>
#define ATFA_ON                             45              // Attiva l'animazione <anim>
#define ATFA_OFF_POP                        46              // Spegne l'animazione <anim> in stack
#define ATFA_ON_POP                         47              // Attiva l'animazione <anim> in stack
#define ATFA_PAUSE                          48              // Pausa l'animazione <anim>
#define ATFA_CONTINUE                       49              // Continua l'animazione <anim>
#define ATFP_OFF                            50              // Spegne il portale nella subanim <portal>
#define ATFP_ON                             51              // Attiva il portale nella subanim <portal>
#define ATFM_OFF                            52              // Spegne la mesh nella subanim <mesh>
#define ATFM_ON                             53              // Attiva la mesh nella subanim <mesh>
#define ATFM_OFF_POP                        54              // Non fa rivelare <mesh> al mouse
#define ATFM_ON_POP                         55              // Fa rivelare <mesh> al mouse
#define ATFM_HIDE                           56              // Spegne la mesh del canale che viene poppata
#define ATFM_UNHIDE                         57              // Attiva la mesh del canale che viene poppata
#define ATFM_SET_AVFLAG                     58              // Setta la mesh sempre visibile
#define ATFM_CLR_AVFLAG                     59              // Torna a fare il normale test di visibilita'
#define ATFM_SETFRAME                       60              // setta il frame del filmato nella <mesh>
#define ATFM_INCFRAME                       61              // incrementa il frame del filmato nella <mesh>
#define ATFM_DECFRAME                       62              // decrementa il frame del filmato nella <mesh>
#define ATFM_START_MOVIE                    63              // attiva il filmato nella <mesh>
#define ATFM_STOP_MOVIE                     64              // disattiva il filmato nella <mesh>
#define ATFH_ON                             65              // attiva tutte le haloes nella stanza
#define ATFH_OFF                            66              // disattiva tutte le haloes nella stanza
#define ATFC_HIDE                           67              // Nasconde personaggio <ch>
#define ATFC_UNHIDE                         68              // Fa apparire personaggio <ch>
#define ATFC_SETTO                          69              // Teletrasporta personaggio in stack in <pos>
#define ATFC_GOTO                           70              // Fa camminare personaggio in stack in <pos>
#define ATFC_RUNTO                          71              // Fa correre personaggio in stack in <pos>
#define ATFC_BACKTO                         72              // Fa indietreggiare personaggio in stack in <pos>
#define ATFC_GOTO_AN                        73              // Fa camminare pers in stack in <pos> e parte anim
#define ATFC_RUNTO_AN                       74              // Fa correre pers in stack in <pos> e parte anim
#define ATFC_BACKTO_AN                      75              // Fa indietreggiare pers in stack in <pos> e parte anim
#define ATFC_FIX_POS                        76              // Fissa la posizione attuale del personaggio <ch>
#define ATFC_SET_ALT0                       77              // Setta il persoanggio <ch> come alternate default
#define ATFC_SET_ALT1                       78              // Setta il persoanggio <ch> come alternate 1
#define ATFC_SET_ALT2                       79              // Setta il persoanggio <ch> come alternate 2
#define ATFC_SET_ALT3                       80              // Setta il persoanggio <ch> come alternate 3
#define ATFPL_SETTO                         81              // Teletrasporta giocatore in <pos>
#define ATFPL_GOTO                          82              // Fa camminare giocatore in <pos>
#define ATFPL_RUNTO                         83              // Fa correre giocatore in stack in <pos>
#define ATFPL_BACKTO                        84              // Fa indietreggiare giocatore in stack in <pos>
#define ATFPL_GOTO_AN                       85              // Fa camminare giocatore in <pos> e parte anim in stack
#define ATFPL_RUNTO_AN                      86              // Fa correre giocatore in <pos> e parte anim in stack
#define ATFPL_BACKTO_AN                     87              // Fa indietreggiare giocatore in <pos> e parte anim
#define ATFDM_OFF                           88              // Spegne menu item <item>
#define ATFDM_ON                            89              // Attiva menu item <item>
#define ATFS_OFF                            90              // Spegne effetto sonoro <sound>
#define ATFS_ON                             91              // Attiva effetto sonoro <sound>
#define ATFS_PSX                            92              // Suona passo di sinistra
#define ATFS_PDX                            93              // Suona passo di destra

#define ATFO_TEX                            94              // Parte frase esamina dell'oggetto in stack
#define ATFO_TACT                           95              // Parte frase action dell'oggetto in stack
#define ATFO_TEXT                           96              // Parte frase text dell'oggetto in stack
#define ATFO_CEX                            97              // Cambia frase esamina con <sent> dell'oggetto in stack
#define ATFO_CACT                           98              // Cambia frase action con <sent> dell'oggetto in stack
#define ATFO_CANIM                          99              // Cambia animazione con <anim> dell'oggetto in stack
#define ATFO_CANIM2                         100             // Cambia animazione2 con <anim> dell'oggetto in stack
#define ATFO_CPOS                           101             // Cambia posizione con <pos> dell'oggetto in stack
#define ATFO_SET_FLAG                       102             // Setta il <flag> nell'oggetto in stack
#define ATFO_CLR_FLAG                       103             // Cancella il <flag> nell'oggetto in stack
#define ATFCO_TEX                           104             // Parte frase esamina dell'oggetto attuale
#define ATFCO_TACT                          105             // Parte frase action dell'oggetto attuale
#define ATFCO_TEXT                          106             // Parte frase text dell'oggetto attuale
#define ATFCO_CEX                           107             // Cambia frase esamina con <sent> dell'oggetto attuale
#define ATFCO_CACT                          108             // Cambia frase action con <sent> dell'oggetto attuale
#define ATFCO_CANIM                         109             // Cambia animazione con <anim> dell'oggetto attuale
#define ATFCO_CANIM2                        110             // Cambia animazione2 con <anim> dell'oggetto attuale
#define ATFCO_CPOS                          111             // Cambia posizione con <pos> dell'oggetto attuale
#define ATFCO_SET_FLAG                      112             // Setta il <flag> nell'oggetto attuale
#define ATFCO_CLR_FLAG                      113             // Cancella il <flag> nell'oggetto attuale
#define ATFI_TEX                            114             // Parte frase esamina dell'icona in stack
#define ATFI_TACT                           115             // Parte frase action dell'icona in stack
#define ATFI_TEXT                           116             // Parte frase text dell'icona in stack
#define ATFI_CEX                            117             // Cambia frase esamina con <sent> dell'icona in stack
#define ATFI_CACT                           118             // Cambia frase action con <sent> dell'icona in stack
#define ATFI_CANIM                          119             // Cambia animazione con <anim> dell'icona in stack
#define ATFI_CANIM2                         120             // Cambia animazione con <anim> dell'icona in stack
#define ATFI_CUWOBJ                         121             // Cambia uwobj con <obj> dell'icona in stack
#define ATFI_SET_FLAG                       122             // Setta il <flag> nell'icona in stack
#define ATFI_CLR_FLAG                       123             // Cancella il <flag> nell'icona in stack
#define ATFI_REPLACE                        124             // Rimpiazza l'icona in stack con <icon>
#define ATFSA_START                         125             // Attiva tutte le sottoanimazioni NON in <mask>
#define ATFSA_BLOCK                         126             // Blocca ultimo frame sottoanim <num>
#define ATF_PUSH_USED                       127             // Mette in stack l'oggetto usato nell'usa con
#define ATF_PUSH_WITH                       128             // Mette in stack l'oggetto destinazione nell'usa con
#define ATF_GG_MODE                         129             // Cambia il GolfMode
#define ATF_VISIBILITY                      130             // Forza riaggiornamento visibilita' della stanza

#define ATF_INC_TIME                        135             // Incrementa contatore interno tempo
#define ATF_DEC_TIME                        136             // Decrementa contatore interno tempo
#define ATF_SET_TIME                        137             // Setta contatore interno tempo
#define ATF_SET_STARTT                      138             // Setta all'ora attuale l'ora di partenza di un diario
#define ATF_SET_ENDT                        139             // Setta all'ora attuale l'ora di fine di un diario
#define ATF_START_T2D                       140             // Parte sezione T2D

#define ATFO_CANIMD                         141
#define ATFO_CANIMV                         142
#define ATFO_CANIM2D                        143
#define ATFO_CANIM2V                        144
#define ATFCO_CANIMD                        145
#define ATFCO_CANIMV                        146
#define ATFCO_CANIM2D                       147
#define ATFCO_CANIM2V                       148
#define ATFI_CANIMD                         149
#define ATFI_CANIMV                         150
#define ATFI_CANIM2D                        151
#define ATFI_CANIM2V                        152
#define ATFO_CANIMCP                        153
#define ATFO_CANIMOP                        154
#define ATFO_CANIM2CP                       155
#define ATFO_CANIM2OP                       156
#define ATFCO_CANIMCP                       157
#define ATFCO_CANIMOP                       158
#define ATFCO_CANIM2CP                      159
#define ATFCO_CANIM2OP                      160
#define ATFI_CANIMCP                        161
#define ATFI_CANIMOP                        162
#define ATFI_CANIM2CP                       163
#define ATFI_CANIM2OP                       164
#define ATFC_HIDE_BND                       165
#define ATFC_UNHIDE_BND                     166
#define ATFI_ON_DAR                         167
#define ATFI_ON_VIC                         168
#define ATFO_CEX_DLG                        169
#define ATFO_CACT_DLG                       170
#define ATFO_CEX_BOTH                       171
#define ATFO_CACT_BOTH                      172
#define ATFCO_CEX_BOTH                      173
#define ATFCO_CACT_BOTH                     174
#define ATFI_CEX_BOTH                       175
#define ATFI_CACT_BOTH                      176
#define ATFD_ON_DLG                         177
#define ATFS_PSX_STAIRS                     178
#define ATFS_PDX_STAIRS                     179
#define ATFO_SET_NOUPDATE                   180
#define ATFO_CLR_NOUPDATE                   181
#define ATFC_DIARY_ENABLE                   182
#define ATFC_DIARY_DISABLE                  183
#define ATFL_ON                             184
#define ATFC_ENABLE_SHADOWS                 185
#define ATFC_DISABLE_SHADOWS                186
#define ATFD_ON_WAITTEXT                    187
#define ATF_SET_NOSKIP                                          188
#define ATFO_TACTOP                                               189   // Parte frase action dell'OtherPlayer dell'oggetto in stack
#define ATFO_TEXOP                                                190   // Parte frase esamina dell'OtherPlayer dell'oggetto in stack
#define ATF_SET_BASAMENTO                                         191   // indica se il curplayer e' su oXT14BASAMENTO o meno
#define ATFC_ENABLE_VOLUMETRIC_SHADOWS                            192
#define ATFC_DISABLE_VOLUMETRIC_SHADOWS                           193
#define ATFS_SET_FLAG                                           194             // Setta il <flag> nel suono in stack
#define ATFS_CLR_FLAG                                           195             // Cancella il <flag> nel suono in stack
#define ATF_START_WIDESCREEN                                    196
#define ATF_END_WIDESCREEN                                      197
#define ATF_DONT_PLAY_STEPS                                     198
#define ATFO_CEXD                                               199              // Cambia frase esamina con <sent> dell'oggetto in stack (solo Darrell)
#define ATFO_CEXV                                               200              // Cambia frase esamina con <sent> dell'oggetto in stack (solo Victoria)

/* -----------------17/03/98 10.44-------------------
 *                      AtfDo
 * --------------------------------------------------*/
#define fFADIN                              1
#define fFADOUT                             2
#define fFADOUTWAIT2                        3
#define fFADOUTWAIT5                        4
#define fPOP_ROOM                           5
#define fPUSH_ROOM                          6
#define fPOP_ROOM_dR015                                        7
#define fSET_MOGLIE_GYM                     8
#define fSET_MOGLIE_SANGUE                  9
#define fSET_PLAYERSWITCH_ON                10
#define fSET_PLAYERSWITCH_OFF               11
#define fUSCITAPOZZO                        12
#define f22STOPWAVES                        13
#define f2OENTRALIFT                        14
#define f2OESCELIFT                         15
#define f23ENTRALIFT                        16
#define f23ESCELIFT                         17
#define f25CHECK                            18
#define f2QENTRALAB                         19
#define f2QESCELAB                          20
#define fFORCE_DEFAULT_ANIM                                     22
#define f34MERIDIANASX                                          23
#define f34MERIDIANADX                      24
#define f34CRISTALLOSX                      25
#define f34CRISTALLODX                      26
#define f34CHECK                            27
#define f35LIGHTS                           28
#define f36MSD                              29
#define f36MSS                              30
#define f36PSD                              31
#define f36PSS                              32
#define f36MID                              33
#define f36MIS                              34
#define f36PID                              35
#define f36PIS                              36
#define f3BCHECK                            37
#define f41WALK                             38
#define f44UPDATE                           39
#define f45STARTTIMER                       40
#define f45STOPTIMER                        41
#define f49CHECK                            42
#define f4ASETBND44                         43
#define fSTART_CACCIATORE                   44
#define fSTOP_CACCIATORE                    45
#define fPASSA_ICONE                                            48
#define f47SETPDALOGS                                           49
#define f41STARTTIMER                                           50
#define f41STOPTIMER                                            51
#define fDISABLESAVE                                            52
#define fENABLESAVE                                             53
#define fSAVEPARTICULAR                                         54
#define f42RESETCOMBINATION                                     55
#define fdR222CHECK                                             59
#define fCPSPEAK_PORTACHIUSA1                                   60
#define fCPSPEAK_PORTACHIUSA2                                   61
#define fSET_BLOCCO_PORTE_ESTERNO                               62
#define fCLR_BLOCCO_PORTE_ESTERNO                               63
#define f25CHECKFORNO                                           64
#define fCALLOTHERPLAYER_START                                  65
#define fCALLOTHERPLAYER_END                                    66
#define fLAUNCHGAMEOVERMUSIC                                    67
#define fLAUNCHCREDITSMUSIC                                     68
#define fSTART_TITOLI_CODA                                      69
#define fSTART_MAIN_MENU                                        70
#define fSTART_DISCESAPISCINA                                   71
#define fEND_DISCESAPISCINA                                     72
#define f48_STOPSOUNDS_ENDTRO                                   73

#define fGG_USER1                                                       80
#define fGG_USER2                                                       81

/* -----------------20/06/00 11.41-------------------
 *                  MeshModifier
 * --------------------------------------------------*/
#define MM_ADD_FLAGS                        1
#define MM_REMOVE_FLAGS                     2
#define MM_ADD_MAT_FLAGS                    4
#define MM_REMOVE_MAT_FLAGS                 8
#define MM_SET_MAT_FRAME                    16
#define MM_ANIM_BLOCK                       32
#define MM_SET_BND_LEVEL                    64
#define MM_SET_HALOES                       128
#define MM_SET_WAVES                        256
#define MM_SET_PARTICLES                    512

/* -----------------17/09/98 11.11-------------------
 *                  Item Commands
 * --------------------------------------------------*/
#define IC_NULL                             0               // Comando nullo
#define IC_SET_PLAYER                       1               // Stabilisce per chi sono i comandi seguenti
#define IC_ANIM                             2               // Parte anim
#define IC_SET_CAMERA                       3               // Cambia la camera con un cut
#define IC_MOVE_CAMERA_TO                   4               // Cambia la camera con un movimento
#define IC_SET_TARGET                       5               // Setta il target su un oggetto
#define IC_SET_CHAR                         6               // Posiziona un personaggio
#define IC_WALK_CHAR                        7               // Fa camminare un personaggio fino a
#define IC_RUN_CHAR                         8               // Fa correre un personaggio fino a
#define IC_BACK_CHAR                        9               // Fa indietreggiare un personaggio fino a
#define IC_HIDE_CHAR                        10              // Nasconde un personaggio
#define IC_UNHIDE_CHAR                      11              // Mostra un personaggio
#define IC_CHANGE_ROOM                      12              // Cambia la stanza
#define IC_EXPRESSION                       13              // Attiva un'espressione facciale
#define IC_CHANGE_PLAYER                    14              // Cambia il personaggio con cui giochi
#define IC_DEBUG                            15              // Scrive una scritta di debug
#define IC_ITEM                             16              // Attiva o disattiva un item di dialogo
#define IC_SET_FLAGS                        17              // Setta flags per il dialogo
#define IC_CLR_FLAGS                        18              // Desetta flags per il dialogo
#define IC_ATFRAME                          19              // Lancia ATFrame all'istante
#define IC_NEXT_DLG                         20              // Dialogo che deve partire alla fine
#define IC_SET_CHAR2                        21              // Non fa setcahcr se e' in alternate
#define IC_INTRO_TEXT1                      22              // Intro text1
#define IC_INTRO_TEXT2                      23              // Intro text2

#define IC_TIME_ANIM                        24              // Parte animazione che da' il tempo
#define IC_TIME_ANIM2                       25              // Parte animazione che da' il tempo
#define IC_TIME_WALK_CHAR                   26              // Parte camminata che da' il tempo
#define IC_TIME_RUN_CHAR                    27              // Parte corsa che da' il tempo
#define IC_TIME_BACK_CHAR                   28              // Parte camminata che da' il tempo
#define IC_TIME_WAIT_CAMERA                 29              // Aspetta che la camera abbia finito prima di continuare
#define IC_TIME_WAIT                        30              // Aspetta tempo prima di continuare
#define IC_TIME_FADOUT                      31              // Aspetta che abbia finito il fadout prima di continuare

/* -----------------27/06/00 14.49-------------------
 *              Espressioni Facciali
 * --------------------------------------------------*/
#define EXPR_DEFAULT                        0
#define EXPR_SORRIDENTE                     1
#define EXPR_SECCATO                        2
#define EXPR_SERIO                          3
#define EXPR_DISPERATO                      4
#define EXPR_STUPITO                        5
#define EXPR_IMPAURITO                      6
#define EXPR_TRISTE                         7
#define EXPR_IRONICO                        8

/* -----------------17/03/98 10.20-------------------
 *                      Rooms
 * --------------------------------------------------*/

#define rNULL                               0
#define r13                                 1
#define r15                                 2
#define r17                                 3
#define r19                                 4
#define r1B                                 5
#define r1C                                 6
#define r1D                                 7
#define r1F                                 8
#define r21                                 9
#define r22                                 10
#define r23                                 11
#define r24                                 12
#define r25                                 13
#define r26                                 14
#define r27                                 15
#define r28                                 16
#define r29                                 17
#define r2A                                 18
#define r2B                                 19
#define r2C                                 20
#define r2D                                 21
#define r2E                                 22
#define r2F                                 23
#define r2G                                 24
#define r2H                                 25
#define r2I                                 26
#define r2L                                 27
#define r2M                                 28
#define r2N                                 29
#define r2O                                 30
#define r2P                                 31
#define r2Q                                 32
#define r2R                                 33
#define r2S                                 34
#define r2T                                 35
#define r31                                 36
#define r32                                 37
#define r33                                 38
#define r34                                 39
#define r35                                 40
#define r36                                 41
#define r37                                 42
#define r38                                 43
#define r39                                 44
#define r3a                                 45
#define r3b                                 46
#define r3c                                 47
#define r41                                 48
#define r42                                 49
#define r43                                 50
#define r44                                 51
#define r45                                 52
#define r46                                 53
#define r47                                 54
#define r48                                 55
#define r49                                 56
#define r4a                                 57
#define rXT                                 58
#define r21_dR212                           59
#define r81                                 60
#define r82                                 61
#define r83                                 62
#define r84                                 63
#define r91                                                             64
#define r92                                                             65
#define r71                                                             66
#define r72                                                             67
#define r73                                                             68
#define r74                                                             69
#define r97                                                             71
#define r98                                                             72
#define r99                                                             73
/* -----------------17/03/98 10.20-------------------
 *                      Objs
 * --------------------------------------------------*/
#define oNULL                               0

#define ocDARRELL                           1
#define ocVICTORIA                          2
#define ocCUOCO                             3
#define ocDOMESTICA                         4
#define ocGIARDINIERE                       5
#define ocCUSTODE                           6
#define ocSERVETTA                          7
#define ocSUPERVISORE                       8
#define ocMOGLIESUPERVISORE                 9
#define ocMOGLIE_KIMONO                     10
#define ocCACCIATORE                        11
#define ocVECCHIO                           12
#define ocCHIRURGO                          13
#define ocTRADUTTORE                        14
#define ocOROLOGIAIO                        15
#define ocKRENN                             16
#define ocDUKES                             17
#define ocCORONA                            18
#define ocVALENCIA                          19
#define ocNOTAIO                            20
#define ocMOORE                             21
#define ocDARRELLALETTO                     22
#define ocCACCIATOREMALPRESO                23
#define ocMOOREBUCATO                       24

#define ocLASTCHAR                          24

#define ocCURPLAYER                         25

#define oCAMERAMAX                          26

#define oTOOLTIPS                           98
#define oNEXTPORTAL                         99

#define o21pXT                              201
#define o21p22                              202
#define o21PULSANTEASC                      203
#define o21p24                              204
#define o21As21BDX                          205
#define o21As21BSX                          206
#define o21Bs21A                            207
#define o21s26DX                            208
#define o21s26SX                            209
#define o21p23                              210
#define o21QUADROPORTONEDX                  211
#define o21QUADROPORTONESX                  212
#define o21QUADROCX                         213
#define o21QUADROSX                         214
#define o21DIVANOSCALE                      215
#define o21DIVANO                           216
#define o21DIVANOSOPPALCO                   217
#define o21TAVOLINOPORTONE                  218
#define o21TAVOLINOSCALE                    219
#define o21TAVOLINOSOPPALCO                 220
#define o21SEDIA1PORTONE                    221
#define o21SEDIA2PORTONE                    222
#define o21SEDIA3PORTONE                    223
#define o21SEDIA1SCALE                      224
#define o21SEDIA2SCALE                      225
#define o21SEDIA1SOPPALCO                   226
#define o21SEDIA2SOPPALCO                   227
#define o21PENDOLO                          228
#define o21PIANTA1                          229
#define o21PIANTA2                          230
#define o21PIANTA3                          231
#define o21PIANTA4                          232
#define o22PISCINA                          233
#define o22TRAMPOLINO                       234
#define o22SCALETTA                         235
#define o22SKIMMER1                         236
#define o22SKIMMER2                         237
#define o22LETTINO1                         238
#define o22LETTINO2                         239
#define o22LETTINO3                         240
#define o22LETTINO4                         241
#define o22POLTRONA                         242
#define o22LAMPADA                          243
#define o22TAVOLINO                         244
#define o22SEDIA1                           245
#define o22SEDIA2                           246
#define o22SEDIA3                           247
#define o22pXT                              248
#define o22PORTA33                          249
#define o22p33                              250
#define o22p21                              251
#define o22BRACCIALE                        252
#define o22LIBRO                            253
#define o22PISCINASCHIUMA                   254
#define o23ATASTO1                          255
#define o23ATASTO2                          256
#define o23ATASTO3                          257
#define o23ATASTOA                          258
#define o23BTASTO1                          259
#define o23BTASTO2                          260
#define o23BTASTO3                          261
#define o23BTASTOA                          262
#define o23CTASTO1                          263
#define o23CTASTO2                          264
#define o23CTASTO3                          265
#define o23CTASTOA                          266
#define o24PORTATRAMEZZOA                   267
#define o24p21                              268
#define o24MOBILETTOENTRATA                 269
#define o24BOTTE1                           270
#define o24BOTTE2                           271
#define o24QUADRO                           272
#define o24TAVOLO                           273
#define o24SEDIA1                           274
#define o24SEDIA2                           275
#define o24SEDIA3                           276
#define o24SEDIA4                           277
#define o24SEDIA5                           278
#define o24SEDIA6                           279
#define o24SEDIA7                           280
#define o24SEDIA8                           281
#define o24SEDIA9                           282
#define o24SEDIA10                          283
#define o24CERVO                            284
#define o24CINGHIALE                        285
#define o24LUPO                             286
#define o24FINESTRA1                        287
#define o24CAMINO                           288
#define o24OROLOGIO                         289
#define o24CARRELLO                         290
#define o24CASSAPANCA                       291
#define o24ZUPPIERA                         292
#define o24FINESTRA2                        293
#define o24p2M                              294
#define o24p25                              295
#define o24CREDENZACH                       296
#define o24CREDENZAAP                       297
#define o24TOVAGLIECREDENZA                 298
#define o24POSATECREDENZA                   299
#define o24VASSOIO                          300
#define o24TAZZINA                          301
#define o24VASETTTOVASSOIO                  302
#define o24BOCCIOLO                         303
#define o24BOCCIOLOSANGUE                   304
#define o24CHIAVETTAOROLOGIO                305
#define o24PORTATRAMEZZOB                   306
#define o25CAPPA                            307
#define o25FORNELLI                         308
#define o25PIASTRE                          309
#define o25FRIGGITRICE                      310
#define o25PIANODILAVORO                    311
#define o25UTENSILICUOCO                    312
#define o25LAVELLOCAPPA                     313
#define o25FORNOCH                          314
#define o25FORNOAP                          315
#define o25DISPLAYFORNO                     316
#define o25TASTOONFORNO                     317
#define o25TASTOOFFFORNO                    318
#define o25TASTOPIUFORNO                    319
#define o25TASTOMENOFORNO                   320
#define o25CONTROLLIFORNO                   321
#define o25FIALAAFORNO                      322
#define o25FIALABFORNO                      323
#define o25FIALABFORNOCALDA                 324
#define o25p24                              325
#define o25BIDONE1                          326
#define o25LAVANDINO1                       327
#define o25FINESTRALAVANDINO1               328
#define o25LAVANDINO2                       329
#define o25LAVASTOVIGLIE                    330
#define o25p2Q                              331
#define o25pXT                              332
#define o25APPENDIOGGETTI                   333
#define o25GANCIO                           334
#define o25CHIAVI                           335
#define o25MOBILETTO                        336
#define o25TAVOLO                           337
#define o25SEDIA2                           339
#define o25BOTTIGLIAVUOTA                   340
#define o25BICCHIERE                        341
#define o25NAVE                             342
#define o25FOTO                             344
#define o25FINESTRATAVOLO                   345
#define o25BIDONE2                          346
#define o25Ap25B                            347
#define o25Bp25A                            348
#define o25SCAFFALEMAGAZZINO                349
#define o25SACCHIMAGAZZINO                  350
#define o25SCOPAMAGAZZINO                   351
#define o25SECCHIOMAGAZZINO                 352
#define o25BIDONEMAGAZZINO                  353
#define o25SEDIAMAGAZZINO                   354
#define o25APORTACELLA                      355
#define o25PORTACELLA                       356
#define o25SCAFFALECELLA                    357
#define o25CONGELATORE1                     358
#define o25CONGELATORE2CH                   359
#define o25CONGELATORE2AP                   360
#define o25CONGELATORE3                     361
#define o25DISPLAYCONGELATORE               362
#define o25TASTOPIUCONGELATORE              363
#define o25TASTOMENOCONGELATORE             364
#define o25CONTROLLIFRIGO                   365
#define o25FIALAACONGELATORE                366
#define o25FIALABCONGELATORE                367
#define o25FIALAACONGELATOREFREDDA          368
#define o26s2Q                              369
#define o26PORTABALCONE                     370
#define o26TAVOLINO1BAR                     371
#define o26TAVOLINO2BAR                     372
#define o26SEDIA1                           373
#define o26SEDIA2                           374
#define o26SEDIA3                           375
#define o26SEDIA4                           376
#define o26BANCONE                          377
#define o26SPINEBIRRA                       378
#define o26SCAFFALE                         379
#define o26SHAKER                           380
#define o26ZUCCHERIERA                      381
#define o26TOVAGLIOLINI                     382
#define o26SGABELLO1                        383
#define o26SGABELLO2                        384
#define o26SGABELLO3                        385
#define o26SGABELLO4                        386
#define o26LAMPADABANCONE                   387
#define o26QUADRO1                          388
#define o26QUADRO2                          389
#define o26p23                              390
#define o26PULSANTEASC                      391
#define o26SEDIAASC                         392
#define o26TENDONE1                         393
#define o26TENDONE2                         394
#define o26DIVANO                           395
#define o26TAVOLINODIVANO                   396
#define o26SEDIA5                           397
#define o26SEDIA6                           398
#define o26s21                              399
#define o26STATUA1                          400
#define o26STATUA2                          401
#define o26POLTRONASCALA                    402
#define o26TAVOLINOSCALA                    403
#define o26SEDIA7                           404
#define o26SEDIA8                           405
#define o26POLTRONCINA                      406
#define o26FESTONE                          407
#define o27p2P                              408
#define o27SPECCHIO                         409
#define o27SBARRA                           410
#define o27STEPPER1                         411
#define o27STEPPER2                         412
#define o27CYCLETTE                         413
#define o27GAMBE                            414
#define o27PANCHETTA                        415
#define o27PETTORALI                        416
#define o27DORSALI                          417
#define o27RASTRELLIERA                     418
#define o27PANCA                            419
#define o27CONSOLESPENTA                    420
#define o27VANOCH                           421
#define o27VANOAP                           422
#define o27BATTERIE                         423
#define o27CONSOLEACCESA                    424
#define o28TAVOLO                           425
#define o28SEDIA1                           426
#define o28SEDIA2                           427
#define o28SEDIA3                           428
#define o28SEDIA4                           429
#define o28SEDIA5                           430
#define o28SEDIA6                           431
#define o28SEDIA7                           432
#define o28LAMPADA1                         433
#define o28LAMPADA2                         434
#define o28LAMPADA3                         435
#define o28LAMPADA4                         436
#define o28LAMPADA5                         437
#define o28LAMPADA6                         438
#define o28LAMPADA7                         439
#define o28p2Q                              440
#define o28SCHEDARIO                        441
#define o28CARTELLA1                        442
#define o28CARTELLA2                        443
#define o28TENDA1                           444
#define o28TENDA2                           445
#define o28MAPPAMONDO                       446
#define o28MONITOR                          447
#define o28PULSANTEMONITOR                  448
#define o28LIBRI1                           449
#define o28LIBRI2                           450
#define o28LIBRO                            451
#define o28REGISTRI1                        452
#define o28REGISTRI2                        453
#define o28REGISTRI3                        454
#define o28TARGA1                           455
#define o28TARGA2                           456
#define o28CAMPIONE1                        457
#define o28CAMPIONE2                        458
#define o28BONSAI                           459
#define o28WALKMAN                          460
#define o28POSTER1                          461
#define o28GRAFICO1                         462
#define o28GRAFICO2                         463
#define o28GRAFICO3                         464
#define o28POSTER2                          465
#define o28POSTER3                          466
#define o28ANTEDXCH                         467
#define o28ANTEDXAP                         468
#define o28ANTECXCH                         469
#define o28ANTECXAP                         470
#define o28ANTESXCH                         471
#define o28ANTESXAP                         472
#define o29p2Q                              473
#define o29PIANTAPORTA                      474
#define o29LIBRI                            475
#define o29REGISTRI                         476
#define o29TARGA1                           477
#define o29TARGA2                           478
#define o29TARGA3                           479
#define o29TARGA4                           480
#define o29COPPA                            481
#define o29PIANTALIBRERIA                   482
#define o29PORTA                            483
#define o29FINESTRA                         484
#define o29ATTACCAPANNI                     485
#define o29LAMPADA                          486
#define o29SCRIVANIA                        487
#define o29POLTRONA                         488
#define o29SEDIA1                           489
#define o29SEDIA2                           490
#define o29PORTACENERE                      491
#define o29CESTINO                          492
#define o29PORTAFOTOCONJUDE                 493
#define o29PORTAFOTOVUOTO                   494
#define o29PORTAFOTOROVESCIATO              495
#define o29COMPUTER                         496
#define o29SCANNER                          497
#define o29TELEFONO                         498
#define o29SIGARI                           499
#define o29LAMPADASCRIVANIA                 500
#define o29SCHEDARIO                        501
#define o29FOTO1                            502
#define o29FOTO2                            503
#define o29FOTO3                            504
#define o29FOTO4                            505
#define o29FOTO5                            506
#define o29FOTO6                            507
#define o29FOTO7                            508
#define o29FOTO8                            509
#define o29INGRANDIMENTO                    510
#define o29FOTOSCANNER                      511
#define o2ATAVOLINO                         512
#define o2Ap2Q                              513
#define o2ATASTIERINO                       514
#define o2ACASSACH                          515
#define o2ATASTOROSSO                       516
#define o2ABUSTASANGUE                      517
#define o2ACUORE                            518
#define o2ARENE                             519
#define o2ACERVELLO                         520
#define o2ASEDIA1                           521
#define o2ACASETTI1                         522
#define o2AOSCILLOSCOPIO                    523
#define o2AMICROSCOPIO1                     524
#define o2ACARTELLA                         525
#define o2ACENTRIFUGA1                      526
#define o2ATESTER1                          527
#define o2APROVETTA                         528
#define o2AFIALE                            529
#define o2ASCATOLE                          530
#define o2ACONTENITORE1                     531
#define o2ACONTENITORE2                     532
#define o2ACONTENITORE3                     533
#define o2ACONDIZIONATORE                   534
#define o2ASCHEDARIO                        535
#define o2ASEDIA2                           536
#define o2ACASSETTI2                        537
#define o2ATESTER2                          538
#define o2AMICROSCOPIO2                     539
#define o2ACONTENITORE4                     540
#define o2AACIDO                            541
#define o2ASCAFFALE                         542
#define o2ACASSETTI3                        543
#define o2ASEDIA3                           544
#define o2ALETTORE                          545
#define o2ACASSETTOAP                       546
#define o2ASIRINGA                          547
#define o2ASCANNER                          548
#define o2ACENTRIFUGA2                      549
#define o2ACOMPUTER                         550
#define o2ATASTIERACOMPUTER                 551
#define o2AVETRO                            552
#define o2APORTA                            553
#define o2BLAVANDINO                        554
#define o2Bp2O                              555
#define o2BPULSANTEASC                      556
#define o2BDIVANO                           557
#define o2BAp2BB                            558
#define o2BBp2BA                            559
#define o2BAp2BD                            560
#define o2BDp2BA                            561
#define o2BAp2BC                            562
#define o2BCp2BA                            563
#define o2BPANCHINA                         564
#define o2BBRACIERE                         565
#define o2BAPPENDIABITIM                    566
#define o2BARMADIETTOMCH                    567
#define o2BARMADIETTOMAP                    568
#define o2BAPPENDIABITIF                    569
#define o2BARMADIETTOFCH                    570
#define o2BARMADIETTOFAP                    571
#define o2BBORSA                            572
#define o2BSACCHETTO                        573
#define o2BDISPENSER                        574
#define o2Cp2R                              575
#define o2Cp2E                              576
#define o2Cp2F                              577
#define o2Cp2T                              578
#define o2Cp2S                              579
#define o2CQUADRO1                          580
#define o2CBUSTO                            581
#define o2Cp2O                              582
#define o2Cp23                              583
#define o2CCASSAPANCA                       584
#define o2CPIANTA1                          585
#define o2CQUADRO2                          586
#define o2CQUADRO3                          587
#define o2CQUADRO4                          588
#define o2CPULSANTEASC2O                    589
#define o2CPULSANTEASC23                    590
#define o2CPIANTA2                          591
#define o2Dp2P                              592
#define o2DSTEREO                           593
#define o2DTV                               594
#define o2DCASSA1                           595
#define o2DCASSA2                           596
#define o2DLIBRERIA                         597
#define o2DQUADRO1                          598
#define o2DVETRATA                          599
#define o2DTAVOLINO                         600
#define o2DSEDIA1                           601
#define o2DSEDIA2                           602
#define o2DDIVANO                           603
#define o2DQUADRO2                          604
#define o2DPORTACAMERA                      605
#define o2DCAMINO                           606
#define o2DPIANTA1                          607
#define o2DPIANTA2                          608
#define o2DVASSOIO                          609
#define o2DTAZZA                            610
#define o2DROSA                             611
#define o2DQUADRODIVANO                     612
#define o2DCASSAFORTECH                     613
#define o2DTASTIERINO                       614
#define o2D0                                615
#define o2D1                                616
#define o2D2                                617
#define o2D3                                618
#define o2D4                                619
#define o2D5                                620
#define o2D6                                621
#define o2D7                                622
#define o2D8                                623
#define o2D9                                624
#define o2DC                                625
#define o2DE                                626
#define o2DCASSAFORTEAP                     627
#define o2DSOLDI                            628
#define o2DTITOLI                           629
#define o2DTARGA                            630
#define o2DSESTERZO                         631
#define o2DANTA1                            632
#define o2DANTA2                            633
#define o2DANTA3                            634
#define o2DANTA4                            635
#define o2Ep2C                              636
#define o2EpBAGNO                           637
#define o2Ep15                              638
#define o2ELETTO                            639
#define o2ECOMODINO                         640
#define o2ELAMPADACOMODINO                  641
#define o2EMOBILEANTE                       642
#define o2ESCRITTOIO                        643
#define o2ELAMPADASCRITTOIO                 644
#define o2ESEDIA                            645
#define o2ECAMINO                           646
#define o2EQUADRO1                          647
#define o2EQUADRO2                          648
#define o2EQUADRO3                          649
#define o2EQUADRO4                          650
#define o2EMOBILECASSETTI                   651
#define o2Fp2C                              652
#define o2FpBAGNO                           653
#define o2Fp15                              654
#define o2FLETTO                            655
#define o2FCOMODINO                         656
#define o2FLAMPADACOMODINO                  657
#define o2FMOBILEANTE                       658
#define o2FSCRITTOIO                        659
#define o2FLAMPADASCRITTOIO                 660
#define o2FSEDIA1                           661
#define o2FSEDIA2                           662
#define o2FCAMINO                           663
#define o2FQUADRO1                          664
#define o2FQUADRO2                          665
#define o2FQUADRO3                          666
#define o2FQUADRO4                          667
#define o2FMOBILECASSETTI                   668
#define o2Gp2H                              669
#define o2GCALDAIA                          670
#define o2GESTINTORE1                       671
#define o2GTUBOCALDAIA                      672
#define o2GPOMPADX                          673
#define o2GPOMPASX                          674
#define o2GMANOMETRODX                      675
#define o2GMANOMETROSX                      676
#define o2GTUBOPOMPE                        677
#define o2GFILTRODXCH                       678
#define o2GFILTROSXCH                       679
#define o2GFILTRODXAP                       680
#define o2GFILTROSXAP                       681
#define o2GFILTRODXAPDETERSIVO              682
#define o2GFILTROSXAPDETERSIVO              683
#define o2GCONSOLE                          684
#define o2GON                               685
#define o2GOFF                              686
#define o2GBIDONE                           687
#define o2GTANICADX                         688
#define o2GTANICASX                         689
#define o2GSACCHI                           690
#define o2GESTINTORE2                       691
#define o2Hp2O                              692
#define o2HPULSANTEASC                      693
#define o2Hp2L                              694
#define o2Hp2G                              695
#define o2HPALLET                           696
#define o2HCASSA                            697
#define o2HPANNELLO                         698
#define o2HSCATOLONE1                       699
#define o2HSCATOLONE2                       700
#define o2HSCATOLAELETTRICA                 701
#define o2Hp2I                              702
#define o2Ip2H                              703
#define o2IBIDONE                           704
#define o2ISCOPA                            705
#define o2IMOBILE                           706
#define o2ILENZUOLA                         707
#define o2IASCIUGAMANI                      708
#define o2IFLACONE1                         709
#define o2IFLACONE2                         710
#define o2IFLACONE3                         711
#define o2ICESTA1                           712
#define o2IASSE                             713
#define o2IFERRO                            714
#define o2ITAVOLO                           715
#define o2IMACCHINACUCIRE                   716
#define o2ICAMICIA                          717
#define o2IMAGLIETTE                        718
#define o2ISEDIA1                           719
#define o2ISEDIA2                           720
#define o2ICESTA2                           721
#define o2ILAVATRICENUOVA                   722
#define o2ILAVATRICEVECCHIA                 723
#define o2IDISPENSER                        724
#define o2Lp2H                              725
#define o2LBOTTEPORTA                       726
#define o2LDAMIGIANA1                       727
#define o2LDAMIGIANA2                       728
#define o2LBOTTE1                           729
#define o2LBOTTE2                           730
#define o2LCASSETTA                         731
#define o2LCASSA                            732
#define o2LFIASCO                           733
#define o2LBOTTIGLIADX                      734
#define o2LBOTTIGLIASX                      735
#define o2LIMBUTI                           736
#define o2LFIASCOMENSOLA                    737
#define o2LCASSETTE                         738
#define o2LCASSABASSA                       739
#define o2LSGABELLO                         740
#define o2LSCAFFALE                         741
#define o2MSPECCHIO                         742
#define o2MLAVANDINOSPECCHIO                743
#define o2MDISPENSERDXLAV                   744
#define o2MDISPENSERSXLAV                   745
#define o2Mp24                              746
#define o2MPIANTA1                          747
#define o2MMOBILETTO1                       748
#define o2MMOBILETTO2                       749
#define o2MPIANTA2                          750
#define o2MAp2MD                            751
#define o2MDp2MA                            752
#define o2MAp2MC                            753
#define o2MCp2MA                            754
#define o2MLAVANDINOM                       755
#define o2MLAVANDINOF                       756
#define o2MBIDETM                           757
#define o2MBIDETF                           758
#define o2MWCM                              759
#define o2MWMF                              760
#define o2MLAVANDINODOCCE                   761
#define o2MDISPENDERLAVDOCCE                762
#define o2MMOBILE                           763
#define o2MANTECHMOBILE                     764
#define o2MANTEAPMOBILE                     765
#define o2MSAPONETTE                        766
#define o2MFLACONE1                         767
#define o2MFLACONE2                         768
#define o2MACIDO                            769
#define o2MPIANTA3                          770
#define o2MPIANTA4                          771
#define o2MPIANTA5                          772
#define o2MBp2MF                            773
#define o2MFp2MB                            774
#define o2MBp2ME                            775
#define o2MEp2MB                            776
#define o2MPANCHINA1M                       777
#define o2MPANCHINA2M                       778
#define o2MPANCHINA1F                       779
#define o2MPANCHINA2F                       780
#define o2MATTACCAPANNIM                    781
#define o2MATTACCAPANNIF                    782
#define o2MARMADIETTOM                      783
#define o2MARMADIETTOF                      784
#define o2MPORTA1M                          785
#define o2MPORTA2M                          786
#define o2MPORTA1F                          787
#define o2MPORTA2F                          788
#define o2Mp2O                              789
#define o2MPULSANTEASC                      790
#define o2MFLACONELAVANDINO                 791
#define o2OATASTOU                          792
#define o2OATASTO0                          793
#define o2OATASTO1                          794
#define o2OATASTO2                          795
#define o2OATASTO3                          796
#define o2OATASTOSTOP                       797
#define o2OATASTOALLARME                    798
#define o2OATASTOINTERFONO                  799
#define o2OBTASTOU                          800
#define o2OBTASTO0                          801
#define o2OBTASTO1                          802
#define o2OBTASTO2                          803
#define o2OBTASTO3                          804
#define o2OBTASTOSTOP                       805
#define o2OBTASTOALLARME                    806
#define o2OBTASTOINTERFONO                  807
#define o2OCTASTOU                          808
#define o2OCTASTO0                          809
#define o2OCTASTO1                          810
#define o2OCTASTO2                          811
#define o2OCTASTO3                          812
#define o2OCTASTOSTOP                       813
#define o2OCTASTOALLARME                    814
#define o2OCTASTOINTERFONO                  815
#define o2ODTASTOU                          816
#define o2ODTASTO0                          817
#define o2ODTASTO1                          818
#define o2ODTASTO2                          819
#define o2ODTASTO3                          820
#define o2ODTASTOSTOP                       821
#define o2ODTASTOALLARME                    822
#define o2ODTASTOINTERFONO                  823
#define o2OETASTOU                          824
#define o2OETASTO0                          825
#define o2OETASTO1                          826
#define o2OETASTO2                          827
#define o2OETASTO3                          828
#define o2OETASTOSTOP                       829
#define o2OETASTOALLARME                    830
#define o2OETASTOINTERFONO                  831
#define o2Pp2D                              832
#define o2PPIANTA1                          833
#define o2PPIANTA2                          834
#define o2PCAMINETTO                        835
#define o2PCANDELABRO1                      836
#define o2PCANDELABRO2                      837
#define o2POROLOGIO                         838
#define o2Pp2O                              839
#define o2PPULSANTEASC                      840
#define o2Pp27                              841
#define o2Qs26                              842
#define o2QQUADRO1                          843
#define o2QTAVOLINO                         844
#define o2QSEDIA1                           845
#define o2QSEDIA2                           846
#define o2QSEDIA3                           847
#define o2QPORTACENERE1                     848
#define o2QLAMPADATAVOLINO                  849
#define o2QPORTACENERETAVOLINO              850
#define o2QFINESTRA                         851
#define o2Qs25                              852
#define o2QQUADRO2                          853
#define o2QATTACCAPANNI                     854
#define o2QPIANTA1                          855
#define o2Qp28                              856
#define o2Qp29                              857
#define o2Qp2N                              858
#define o2QQUADRO3                          859
#define o2QPIANTA2                          860
#define o2QQUADRO4                          861
#define o2QPORTACENERE2                     862
#define o2Qp2A                              863
#define o2QTASTIERINO                       864
#define o2Q0                                865
#define o2Q1                                866
#define o2Q2                                867
#define o2Q3                                868
#define o2Q4                                869
#define o2Q5                                870
#define o2Q6                                871
#define o2Q7                                872
#define o2Q8                                873
#define o2Q9                                874
#define o2QC                                875
#define o2QE                                876
#define o2QLAMPADA                          877
#define o2QQUADRO5                          878
#define o2QQUADRO6                          879
#define o2QQUADRO7                          880
#define o2Rp2C                              881
#define o2RPORTA                            882
#define o2RFINESTRA1                        883
#define o2RFINESTRA2                        884
#define o2RLETTO                            885
#define o2RCOMODINOSX                       886
#define o2RCOMODINODX                       887
#define o2RARMADIOANTE                      888
#define o2RSEPARE                           889
#define o2RCAMINETTO                        890
#define o2RSCRITTOIO                        891
#define o2RLAMPADA                          892
#define o2RSEDIA                            893
#define o2RQUADRO1                          894
#define o2RQUADRO2                          895
#define o2RQUADRO3                          896
#define o2RARMADIOCASSETTI                  897
#define o2RCASSETTOSCRITTOIOAP              898
#define o2RBUSTE                            899
#define o2Sp2C                              900
#define o2SQUADRO1                          901
#define o2SPORTA                            902
#define o2STAVOLINO1                        903
#define o2SLETTO                            904
#define o2SCOMODINODX                       905
#define o2SCOMODINOSX                       906
#define o2SLAMPADADX                        907
#define o2SLAMPADASX                        908
#define o2SSEDIA1                           909
#define o2SARMADIOANTE                      910
#define o2SCASSAPANCA                       911
#define o2SCUSCINO1                         912
#define o2SCUSCINO2                         913
#define o2SPENDOLA                          914
#define o2SPOLTRONA1                        915
#define o2SPOLTRONA2                        916
#define o2SLAMPADA                          917
#define o2STAVOLINO2                        918
#define o2SPORTACENERE                      919
#define o2SCASSETTIERA                      920
#define o2SVASO                             921
#define o2SLIBRI                            922
#define o2SPIATTINO                         923
#define o2STENDADX                          924
#define o2STENDASX                          925
#define o2SQUADRO2                          926
#define o2SQUADRO3                          927
#define o2SQUADRO4                          928
#define o2SQUADRO5                          929
#define o2SARMADIOCASSETTI                  930
#define o2Tp2C                              931
#define o2TPORTA                            932
#define o2TTENDA                            933
#define o2TLETTO                            934
#define o2TCOMODINOSX                       935
#define o2TCOMODINODX                       936
#define o2TMOBILEANTE                       937
#define o2TCASSETTIERA                      938
#define o2TLAMPADA                          939
#define o2TSEDIA                            940
#define o2TQUADRO1                          941
#define o2TQUADRO2                          942
#define o2TQUADRO3                          943
#define o2TMOBILECASSETTI                   944
#define o31INGRANAGGI                       945
#define o31TUBO                             946
#define o31MACCHINAAP                       947
#define o31LEVA                             948
#define o31MACCHINAAPINGRANAGGGIO           949
#define o31ANELLO                           950
#define o31SEGATURA                         951
#define o31s32                              952
#define o31BOTOLACH                         953
#define o31BOTOLAAP                         954
#define o31DISCOSANO                        955
#define o31DISCOROTTO                       956
#define o31DISCONUOVO                       957
#define o31BAULECH                          958
#define o31LEVETTA1                         959
#define o31LEVETTA2                         960
#define o31LEVETTA3                         961
#define o31LEVETTA4                         962
#define o31LEVETTA5                         963
#define o31BAULEAP                          964
#define o31DISCOBAULE                       965
#define o31ROBABAULE                        966
#define o31DISCOROTTOPAVIMENTO              967
#define o31ALLOGGIAMENTO                    968
#define o31CRISTALLO                        969
#define o31CRISTALLOATTIVATO                970
#define o31MACCHINACH                       971
#define o32s31                              972
#define o32LASTRONE                         973
#define o32LASTRONEMOSSO                    974
#define o32LEVA                             975
#define o33p35                              976
#define o33p22                              977
#define o33s36                              978
#define o33OROLOGIO                         979
#define o33LANCETTAHSX                      980
#define o33LANCETTAMSX                      981
#define o33LANCETTAHDX                      982
#define o33LANCETTAMDX                      983
#define o33DIVANETTO                        984
#define o33MOBILETTO                        985
#define o33LAMPADA                          986
#define o33QUADROPASSAGGIO                  987
#define o33QUADRO1                          988
#define o33QUADROOROLOGIO                   989
#define o33QUADROLAMAPADA                   990
#define o33QUADROSCALA                      991
#define o34ALTARE                           992
#define o34SFERA                            993
#define o34QUADRANTESFERA                   994
#define o34LASTRADX                         995
#define o34LASTRASX                         996
#define o34CANDELABRODX                     997
#define o34CANDELABROSX                     998
#define o34CANDELABRODXD                    999
#define o34CANDELABROSXD                    1000
#define o34FACCIABIANCA                     1001
#define o34FACCIANERA                       1002
#define o34DIARIOCH                         1003
#define o34PERGAMENA                        1004
#define o34BORSONECH                        1005
#define o34BORSONEAP                        1006
#define o34SCATOLA                          1007
#define o34MUROPORTA                        1008
#define o34LEVA                             1009
#define o34SFERASU                          1010
#define o34CRISTALLO1                       1011
#define o34CRISTALLO2                       1012
#define o34CRISTALLO3                       1013
#define o34CRISTALLO4                       1014
#define o34CRISTALLO5                       1015
#define o34CRISTALLO6                       1016
#define o34DIARIOAP                         1017
#define o35CASSETTIERA                      1018
#define o35TAVOLO                           1019
#define o35SEDIATAVOLO                      1020
#define o35DIVANO                           1021
#define o35SEDIADIVANODX                    1022
#define o35SEDIADIVANOSX                    1023
#define o35TAVOLINO                         1024
#define o35VASETTOTAVOLINO                  1025
#define o35CREDENZA                         1026
#define o35CHIODO                           1027
#define o35QUADRO                           1028
#define o35SEDIASX                          1029
#define o35SEDIACX                          1030
#define o35SEDIADX                          1031
#define o35VASOSX                           1032
#define o35VASODX                           1033
#define o35TENDASX                          1034
#define o35TENDACX                          1035
#define o35TENDADX                          1036
#define o35INTERRUTTORE                     1037
#define o35p32                              1038
#define o35CREDENZASPOSTATA                 1039
#define o36p39                              1040
#define o36p37                              1041
#define o36p38                              1042
#define o36QUADRO1                          1043
#define o36QUADRO2                          1044
#define o36s32                              1045
#define o36TAVOLINO                         1046
#define o36SPECCHIO                         1047
#define o36BILANCIA                         1048
#define o36PIATTODX                         1049
#define o36PIATTOSX                         1050
#define o36SESTERZODX                       1051
#define o36SESTERZOSX                       1052
#define o36INCENSODX                        1053
#define o36INCENSOSX                        1054
#define o37p36                              1055
#define o37QUADROCAMINO                     1056
#define o37CAMINO                           1057
#define o37PIANOFORTE                       1058
#define o37SGABELLOPIANOFORTE               1059
#define o37LIBRERIA                         1060
#define o37CILINDRO                         1061
#define o37LIBRO                            1062
#define o37TENDA                            1063
#define o37SCRIVANIA                        1064
#define o37POLTRONA                         1065
#define o37SEDIASX                          1066
#define o37SEDIADX                          1067
#define o37FONOGRAFO                        1068
#define o37FONOGRAFOCILINDRO                1069
#define o37LAMPADA                          1070
#define o37QUADRO                           1071
#define o37QUADROANNA                       1072
#define o37BACHECA                          1073
#define o37QUADRODX                         1074
#define o37QUADROSX                         1075
#define o38p36                              1076
#define o38PANCA1                           1077
#define o38PANCA2                           1078
#define o38LIBRERIA                         1079
#define o38TENDASX                          1080
#define o38TENDADX                          1081
#define o38BACHECA                          1082
#define o38SESTANTI                         1083
#define o38MANOSCRITTO                      1084
#define o38CANNOCCHIALE                     1085
#define o38TELESCOPIO1                      1086
#define o38SCALA                            1087
#define o38FINESTRASX                       1088
#define o38FINESTRADX                       1089
#define o38TAVOLO                           1090
#define o38TELESCOPIO2                      1091
#define o38SGABELLO                         1092
#define o38SEDIASX                          1093
#define o38SEDIADX                          1094
#define o38QUADRO1                          1095
#define o38MAPPA1                           1096
#define o38MAPPA2                           1097
#define o38QUADRO2                          1098
#define o38QUADRO3                          1099
#define o38MACCHINA                         1100
#define o38MANOVELLA                        1101
#define o39SCAFFALE1                        1102
#define o39SCAFFALE2                        1103
#define o39p36                              1104
#define o39QUADRO1                          1105
#define o39PENDOLADX                        1106
#define o39PENDOLASX                        1107
#define o39BACHECADX                        1108
#define o39BACHECASX                        1109
#define o39TENDA1                           1110
#define o39TENDA2                           1111
#define o39TENDA3                           1112
#define o39PENDOLO1                         1113
#define o39PENDOLO2                         1114
#define o39TAVOLINO                         1115
#define o39CANDELABRO                       1116
#define o39TAVOLO                           1117
#define o39OROLOGIO                         1118
#define o39SCOMPARTOCH                      1119
#define o39SCOMPARTOAP                      1120
#define o39RETTANGOLO                       1121
#define o39TONDO                            1122
#define o39SEMICERCHIO                      1123
#define o39CRISTALLO                        1124
#define o39SFERA                            1125
#define o39COLLANA                          1126
#define o39ANGELO                           1127
#define o39CRISTALLOATTIVATO                1128
#define o3BLAPIDI                           1129
#define o3Bs3C                              1130
#define o3BFESSURA                          1131
#define o3BALTARE                           1132
#define o3BSCULTURABRACCIALI                1133
#define o3BSCULTURA                         1134
#define o3BCOPPABRACCIALI                   1135
#define o3BCOPPA                            1136
#define o3BSESTERZOBRACCIALI                1137
#define o3BSESTERZO                         1138
#define o3B1DOSEBRACCIALI                   1139
#define o3B1DOSE                            1140
#define o3B2DOSIBRACCIALI                   1141
#define o3B2DOSI                            1142
#define o3BNICCHIA                          1143
#define o3BLASTRA                           1144
#define o3CpXT                              1145
#define o3CALTARE                           1146
#define o3Cs3B                              1147
#define o3CSERRATURACH                      1148
#define o3CSERRATURAAP                      1149
#define o3CSCALA                            1150
#define o13p12                              1151
#define o13SCRITTOIO                        1152
#define o13LIBRERIA                         1153
#define o13MANGIME                          1154
#define o13SCALPELLO                        1155
#define o13STATUETTE                        1156
#define o13LAMPADA                          1157
#define o13CUSTODIA                         1158
#define o13FINESTRA                         1159
#define o13TENDA                            1160
#define o13PORTA                            1161
#define o13QUADRO1                          1162
#define o13QUADRO2                          1163
#define o13QUADRO3                          1164
#define o13MOBILE                           1165
#define o13LAMPADAMOBILE                    1166
#define o13COMODINO                         1167
#define o13VASO                             1168
#define o13TAVOLINO                         1169
#define o13POLTRONA                         1170
#define o13CREDENZA                         1171
#define o13DIVANETTO                        1172
#define o15COLONNINATORRE                   1173
#define o15COLONNINA                        1174
#define o15p2E                              1175
#define o15p2F                              1176
#define o15BASSORILIEVO1                    1177
#define o15BASSORILIEVO2                    1178
#define o15CREPAESTERNA                     1179
#define o15OROLOGIO                         1180
#define o15INTONACO                         1181
#define o15QUADRANTE                        1182
#define o15PASSAGGIO                        1183
#define o15BRECCIA                          1184
#define o17p16                              1185
#define o17AUTOSPORTIVA                     1186
#define o17FORD                             1187
#define o17FURGONE                          1188
#define o17PORTELLONE                       1189
#define o17PORTELLONECH                     1190
#define o17PORTELLONEAP                     1191
#define o17SACCO                            1192
#define o17SACCHI                           1193
#define o17COMPUTER                         1194
#define o17SARACINESCA                      1195
#define o17SERRATURA                        1196
#define o17ESTINTORE                        1197
#define o17CAVETTO                          1198
#define o19p18                              1199
#define o19TARGA                            1200
#define o19PANCHINA1                        1201
#define o19SCACCHIERA                       1202
#define o19BAMBOLA                          1203
#define o19T01                              1204
#define o19T02                              1205
#define o19T03                              1206
#define o19T04                              1207
#define o19T05                              1208
#define o19T06                              1209
#define o19T07                              1210
#define o19T08                              1211
#define o19T09                              1212
#define o19T10                              1213
#define o19T11                              1214
#define o19T12                              1215
#define o19T13                              1216
#define o19T14                              1217
#define o19T15                              1218
#define o19T16                              1219
#define o19T17                              1220
#define o19T18                              1221
#define o19T19                              1222
#define o19T20                              1223
#define o19T21                              1224
#define o19T22                              1225
#define o19T23                              1226
#define o19T24                              1227
#define o19T25                              1228
#define o19T26                              1229
#define o19T27                              1230
#define o19T28                              1231
#define o19T29                              1232
#define o19T30                              1233
#define o19T31                              1234
#define o19T32                              1235
#define o19T33                              1236
#define o19T34                              1237
#define o19T35                              1238
#define o19T36                              1239
#define o19T37                              1240
#define o19T38                              1241
#define o19T39                              1242
#define o19T40                              1243
#define o19T41                              1244
#define o19T42                              1245
#define o19T43                              1246
#define o19T44                              1247
#define o19T45                              1248
#define o19T46                              1249
#define o19T47                              1250
#define o19T48                              1251
#define o19T49                              1252
#define o19T50                              1253
#define o19T51                              1254
#define o19T52                              1255
#define o19T53                              1256
#define o19T54                              1257
#define o19T55                              1258
#define o19T56                              1259
#define o19T57                              1260
#define o19T58                              1261
#define o19T59                              1262
#define o19T60                              1263
#define o19T61                              1264
#define o19T62                              1265
#define o19T63                              1266
#define o19T64                              1267
#define o19CANDELIERE1                      1268
#define o19CANDELIERE2                      1269
#define o19PANCHINA2                        1270
#define o1Bp1A                              1271
#define o1Bp1C                              1272
#define o1BAIUOLA1                          1273
#define o1BAIUOLA2                          1274
#define o1BARMADIETTOCH                     1275
#define o1BARMADIETTOAP                     1276
#define o1BUTENSILI                         1277
#define o1BBUSTE                            1278
#define o1BFLACONI                          1279
#define o1BSCATOLONE                        1280
#define o1BCARTONE                          1281
#define o1Cp1B                              1282
#define o1CFONTANA                          1283
#define o1CSTATUA                           1284
#define o1CBOCCA                            1285
#define o1Cs41                              1286
#define o1CALBERO1                          1287
#define o1CALBERO2                          1288
#define o1CALBERO3                          1289
#define o1CALBERO4                          1290
#define o1DBRECCIA                          1291
#define o1DCREDENZACH                       1292
#define o1DCREDENZAAP                       1293
#define o1DVALIGETTACREDENZA                1294
#define o1DVALIGETTACH                      1295
#define o1DSWITCH1                          1296
#define o1DSWITCH2                          1297
#define o1DSWITCH3                          1298
#define o1DSWITCH4                          1299
#define o1DSWITCH5                          1300
#define o1DTASTO                            1301
#define o1DVALIGETTAAP                      1302
#define o1DAUDIOCASSETTA                    1303
#define o1DBANCONOTE                        1304
#define o1DBOTTIGLIE                        1305
#define o1DCESTA                            1306
#define o1DBARATTOLI                        1307
#define o1DTRONCHESE                        1308
#define o1DSEMENTI                          1309
#define o1DSACCHI                           1310
#define o1DVASI                             1311
#define o1DDAMIGIANA                        1312
#define o1DFALCIATRICE                      1313
#define o1DSCALA                            1314
#define o1DSEMENTITERRA                     1315
#define o1Fs1A                              1316
#define o1FACQUA                            1317
#define o1FSBARREDX                         1318
#define o1FSBARRESX                         1319
#define o1FVARCO                            1320
#define o1FDETRITI                          1321
#define o1FMACCHINARIO                      1322
#define o1FPULSANTE                         1323
#define o1FPULSANTEFUSO                     1324
#define o1FLEVAGIU                          1325
#define o1FLEVASU                           1326
#define o1FCRISTALLODX                      1327
#define o1FCRISTALLOSX                      1328
#define o1FPORTA                            1329
#define o1FTUBO                             1330
#define o1FINDICATORE1                      1332
#define o1FINDICATORE2                      1333
#define o1FINDICATORE3                      1334
#define o1FINDICATORE4                      1335
#define o1FINDICATORE5                      1336
#define oXT11p21                            1337
#define oXT11CANCELLO                       1338
#define oXT11ALBERO1                        1339
#define oXT11ALBERO2                        1340
#define oXT11ALBERO3                        1341
#define oXT11SIEPE                          1342
#define oXT12CASACUSTODE                    1343
#define oXT12p13                            1344
#define oXT12ALBERO                         1345
#define oXT14ALBERO                         1346
#define oXT14PIUMA                          1347
#define oXT14BASAMENTO                      1348
#define oXT14NIDO                           1349
#define oXT14OCCHIALI                       1350
#define oXT14PIANTA                         1351
#define oXT14VASO                           1352
#define oXT14SACCHETTO                      1353
#define oXT14p3C                            1354
#define oXT1ACOLOMBAVOLA                    1355
#define oXT16PORTA                          1356
#define oXT16p17                            1357
#define oXT16SARACINESCA                    1358
#define oXT16SIEPI                          1359
#define oXT16ALBERI                         1360
#define oXT18p19                            1361
#define oXT18ROSETO                         1362
#define oXT18INTONACO                       1363
#define oXT18MAUSOLEO                       1364
#define oXT18SCACCHIERA                     1365
#define oXT18p25                            1366
#define oXT18ALBERO                         1367
#define oXT1Ap1B                            1368
#define oXT1ABUCO1                          1369
#define oXT1ABUCO2                          1370
#define oXT1AVETRI                          1371
#define oXT1AVOLIERA                        1372
#define oXT1ASPORTELLO                      1373
#define oXT1ALUCCHETTO                      1374
#define oXT1AFINESTRA                       1375
#define oXT1Ap22                            1376
#define oXT1APOZZO                          1377
#define oXT1AANTECH                         1378
#define oXT1AANTEAP                         1379
#define oXT1AALBERO                         1380
#define oXT1ASASSO                          1381
#define oXT1ABIDONE                         1382
#define oXT1ABOTTIGLIA                      1383
#define oXT1ECASAGIARDINIERE                1384
#define oXT1EPORTA                          1385
#define oXT1ETARGHETTA                      1386
#define oXT1ELAVABO                         1387
#define oXT1ETESTA1                         1388
#define oXT1ETESTA2                         1389
#define oXT1EALBERO1                        1390
#define oXT1EALBERO2                        1391
#define oXT1EFINESTRA                       1392
#define o41SCALEPIETRA                      1393
#define o41PORTALABIRINTO                   1394
#define o41STRANOSIMBOLO                    1395
#define o41CADAVEREGIARDINIERE              1396
#define o41MUCCHIOSABBIA                    1397
#define o41OGGETTOARGENTEO                  1398
#define o41PAVLASTRICATO                    1399
#define o41PRIMOTASTOSU                     1400
#define o41SECONDOTASTOSU                   1401
#define o41TERZOTASTOSU                     1402
#define o41QUARTOTASTOSU                    1403
#define o41QUINTOTASTOSU                    1404
#define o41SESTOTASTOSU                     1405
#define o41PRIMOTASTOGIU                    1406
#define o41SECONDOTASTOGIU                  1407
#define o41TERZOTASTOGIU                    1408
#define o41QUARTOTASTOGIU                   1409
#define o41QUINTOTASTOGIU                   1410
#define o41SESTOTASTOGIU                    1411
#define o42MACCHINACHIUSA                   1412
#define o42LEVA                             1413
#define o42PIATTAFORMA                      1414
#define o42PORTALABIRINTO                   1415
#define o42STRANOSIMBOLO                    1416
#define o42TASTO01SU                        1417
#define o42TASTO02SU                        1418
#define o42TASTO03SU                        1419
#define o42TASTO04SU                        1420
#define o42TASTO05SU                        1421
#define o42TASTO06SU                        1422
#define o42TASTO07SU                        1423
#define o42TASTO08SU                        1424
#define o42TASTO09SU                        1425
#define o42TASTO10SU                        1426
#define o42TASTO11SU                        1427
#define o42TASTO12SU                        1428
#define o42TASTO01GIU                       1429
#define o42TASTO02GIU                       1430
#define o42TASTO03GIU                       1431
#define o42TASTO04GIU                       1432
#define o42TASTO05GIU                       1433
#define o42TASTO06GIU                       1434
#define o42TASTO07GIU                       1435
#define o42TASTO08GIU                       1436
#define o42TASTO09GIU                       1437
#define o42TASTO10GIU                       1438
#define o42TASTO11GIU                       1439
#define o42TASTO12GIU                       1440
#define o42s43                              1441
#define o42LEVAMURATA                       1442
#define o42TUBOPIATTAFORMA                  1443
#define o43s42                              1444
#define o43CANCELLO01                       1445
#define o43CANCELLO02                       1446
#define o43CANCELLO03                       1447
#define o43s45                              1448
#define o43CANCELLOALZATO01                 1449
#define o43CANCELLOALZATO02                 1450
#define o43CANCELLOALZATO03                 1451
#define o44OROLOGIO                         1452
#define o44AFFRESCO                         1453
#define o44LEVAORE                          1454
#define o44LEVAMINUTI                       1455
#define o44LEVAGRADI                        1456
#define o45INGRANAGGI                       1457
#define o45APERTURA                         1458
#define o45MACCHINARIO                      1459
#define o45SPORTELLO                        1460
#define o45ALLOGGIAMENTO                    1461
#define o45STELLAMETALLICA                  1462
#define o45SCOMPARTIMENTO                   1463
#define o45INDICATORE1                      1464
#define o45INDICATORE2                      1465
#define o45INDICATORE3                      1466
#define o45INDICATORE4                      1467
#define o45INDICATORE5                      1468
#define o45s43                              1469
#define o45SANGUE                           1470
#define o46PRIMODIAGRAMMA                   1471
#define o46SECONDODIAGRAMMA                 1472
#define o46PIANTACASTELLO                   1473
#define o46SCRITTOIO                        1474
#define o46BUSTAOROLOGIAIO                  1475
#define o46CARTELLINA1                      1476
#define o46CARTELLINA2                      1477
#define o46CARTELLINA3                      1478
#define o46CARTELLINA4                      1479
#define o46CARTELLINA5                      1480
#define o46CARTELLINA6                      1481
#define o46CARTELLINA7                      1482
#define o46CARTELLINAC                      1483
#define o46POLTRONA                         1484
#define o46CANDELABRO                       1485
#define o46CANDELA1                         1486
#define o46CANDELA2                         1487
#define o46CASSETTO                         1488
#define o46PERGAMENAINGIALLITA              1489
#define o46CALAMAIO                         1490
#define o46COMPASSO                         1491
#define o46SESTANTE                         1492
#define o46STELLAMETALLICA                  1493
#define o46BRACERE                          1494
#define o46CANDELABRACERE                   1495
#define o46CERABRACERE                      1496
#define o46CALCOBRACERE                     1497
#define o46SCAFFALE                         1498
#define o47CADAVERECORONA                   1499
#define o47TRAPPOLA                         1500
#define o47s41                              1501
#define o48RINGHIERA                        1502
#define o48PENDOLO                          1503
#define o48MANETTE                          1504
#define o48KRENNSVENUTO                     1506
#define o49BASSORILIEVO                     1507
#define o49DUKESMORTO                       1508
#define o49TESTALEONE                       1509
#define o49s4A                              1510
#define o49SANGUE                           1511
#define o49ALTARE                           1512
#define o49AMPOLLAAZZURRO                   1513
#define o49AMPOLLAVERDE                     1514
#define o49AMPOLLAGIALLO                    1515
#define o49AMPOLLAROSSO                     1516
#define o49PERGAMENA                        1517
#define o49STELLADX                         1518
#define o49STELLADXCIA                      1519
#define o49STELLASX                         1520
#define o49STELLASXCIA                      1521
#define o49INCAVODX                         1522
#define o49INCAVOSX                         1523
#define o49PORTACHIUSA                      1524
#define o4ALEVA                             1525
#define o4As49                              1526
#define oXT14OCCHIALI_NOTAKE                1527
#define oXT14NIDO_da_sopra_il_basamento     1528
#define o2CCARRELLO1                        1529
#define o2CCARRELLO2                        1530
#define o2PCARRELLO1                        1531
#define o37BACHECAAPERTA                    1532
#define o31INGRALEGNO               1533
#define o46CARTELLINA8              1534
#define o25SPUGNETTECUOCO                   1535
#define o25TEIERA                           1536
#define o2TBOTTIGLIACUOCO                   1537
#define o26PULIZIATENDA                     1538
#define o26PULIZIAFORCHETTA                 1539
#define o28FOGLIODOMESTICA                  1540
#define o2LOGGETTIDOMESTICA                 1541
#define o25OGGETTIDOMESTICA                 1542
#define o22OGGETTIDOMESTICA                 1543
#define o13OCCHIALIDIARIO                   1544
#define o2MOGGETTICUSTODE_TOSHOW            1545
#define o2MOGGETTICUSTODE_TOHIDE            1546
#define oXTSECCHIGIARDINIERE                1547
#define o48DARRELLSVENUTO           1548
#define o2QSTRACCIODIARIO                   1549
#define o26OGGETTISUPERVISORE               1550
#define o48ELEKTRO                          1551
#define oDIARIOPAG1A                        1552
#define oDIARIOPAG1B                        1553
#define oDIARIOPAG1C                        1554
#define oDIARIOPAG1D                        1555
#define oDIARIOPAG1E                        1556
#define oDIARIOPAG1F                        1557
#define oDIARIOPAG2A                        1558
#define oDIARIOPAG2B                        1559
#define oDIARIOPAG2C                        1560
#define oDIARIOPAG2D                        1561
#define oDIARIOPAG2E                        1562
#define oDIARIOPAG2F                        1563
#define oDIARIOPAG3A                        1564
#define oDIARIOPAG3B                        1565
#define oDIARIOPAG3C                        1566
#define oDIARIOPAG3D                        1567
#define oDIARIOPAG4A                        1568
#define oDIARIOPAG4B                        1569
#define oDIARIOPAG4C                        1570
#define oDIARIOPAG4D                        1571
#define oDIARIOPAG4E                        1572
#define oDIARIOPAG4F                        1573
#define oDIARIOPAG4G                        1574
#define oDIARIOPAG4H                        1575
#define oDIARIOPAG4I                        1576
#define oDIARIOPAG4J                        1577
#define oDIARIOPAG4K                        1578
#define oDIARIOPAG4L                        1579
#define o34DIARIOKRENNAPERTO                1580
#define o22LIBRORTV                         1581
#define oCOMPUTERDIAL               1582
#define oCOMPUTEREMAIL1             1583
#define oCOMPUTEREMAIL2             1584
#define oTONERHELP              1585
#define o2DOGGETTIRTV                       1586
#define o2DTAVOLINORTV                      1587
#define o48PISTOLAKRENN                     1588
#define o29ANTAWIN                          1589
#define o29ANTAWINROTTA                     1590
#define oXTTAXI                             1591
#define o49FUMO                             1592
#define o2CMEGABB_2R                        1593
#define o2CMEGABB_2S                        1594
#define o2PMEGABB_2D                        1595
#define oXTPISCINA                          1596
#define o2CTASTOVERDE                       1597
#define o2CTASTOROSSO                       1598
#define o2CTASTOBLINK                       1599
#define o2MTASTOVERDE                       1600
#define o2MTASTOROSSO                       1601
#define o2MTASTOBLINK                       1602
#define oXTPERSIANECHIUSE                   1603
#define oXTPERSIANEAPERTE                   1604
#define o98LETTER                           1605
#define o98PARCHMENT                        1606
#define o91DARRELLALETTO                    1607
#define o91TELEFONO                         1608
#define o91COPERTABASSA                     1609
#define o91COPERTAALTA                      1610
#define o97SFONDO                           1611
#define o97BORDI                            1612
#define o97COLORI                           1613
#define o97NETERT                           1614
#define o97LETTERE                          1615
#define o97LOGOWM                           1616
#define o73SFONDO                           1617
#define oADDTEXTOBJ                         1618
#define oEXTRALS                            1619

/* -----------------17/03/98 10.20-------------------
 *                      Anims
 * --------------------------------------------------*/
#define aNULL                               0
#define aSTAND                              1
#define aWALK_START                         2
#define aWALK_LOOP                          3
#define aWALK_END                           4
#define aBACK_START                         5
#define aBACK_LOOP                          6
#define aBACK_END                           7
#define aRUN_START                          8
#define aRUN_LOOP                           9
#define aRUN_END                            10
#define aROT_DX                             11
#define aROT_SX                             12

#define aGIRO                               16
#define aBOH                                17
#define aTO1PERSON                          18
#define aTO3PERSON                          19
#define aDUMMY                              20

#define aCAMBIO_DARRELL_91                                              21
#define aCAMBIO_VICTORIA_92                                             22
#define aCAMBIO_DARRELL_93                                              23
#define aCAMBIO_VICTORIA_94                                             24
#define aCAMBIO_DARRELL_95                                              25
#define aCAMBIO_VICTORIA_96                                             26
#define aCAMBIO_DARRELL_97                                              27
#define aCAMBIO_VICTORIA_98                                             28

#define aFOX                                                            29
#define aPENSA                                                          30
#define aDUMMY_dR391_A                                                  31
#define aDUMMY_dR391_B                                                  32
#define aDUMMY_dR391_C                                                  33

#define aIDLE_DARRELL_1                                                 34
#define aIDLE_DARRELL_2                                                 35
#define aIDLE_VICTORIA_1                                                36
#define aIDLE_VICTORIA_2                                                37

#define aCUO251                             51
#define aCUO252                             52
#define aCUO253                             53
#define aCUO254                             54
#define aCUO255                             55
#define aCUO256                             56
#define aCUO257                             57
#define aCUO258                             58
#define aCUO259                             59
#define aCUO25s                             60
#define aCUO2T1                             61
#define aCUS131                             62
#define aCUS132                             63
#define aCUS133                             64
#define aCUS134                             65
#define aCUS135                             66
#define aCUS136                             67
#define aCUS2G1                             71
#define aCUS2G2                             72
#define aCUS2M1                             74
#define aCUS2M2                             75
#define aCUS2M3                             76
#define aCUS2M4                             77
#define aDARRELL481                         78
#define aDOM221                             79
#define aDOM222                             80
#define aDOM223                             81
#define aDOM251                             82
#define aDOM252                             83
#define aDOM261                             85
#define aDOM262                             86
#define aDOM263                             87
#define aDOM264                             88
#define aDOM265                             89
#define aDOM26s                             90
#define aDOM281                             91
#define aDOM2L1                             93
#define aDOM2L2                             94
#define aGIA141                             95
#define aGIA142                             96
#define aGIA143                             97
#define aGIA1A1                             98
#define aGIA1A2                             99
#define aGIA1A3                             100
#define aGIA1A4                             101
#define aGIA1A5                             102
#define aGIA1A6                             103
#define aGIA181                             104
#define aGIA182                             105
#define aGIA183                             106
#define aGIA2G1                             107
#define aGIA2G2                             108
#define aMOS221                             110
#define aMOS222                             111
#define aMOS271                             112
#define aMOS272                             113
#define aMOS273                             114
#define aMOS274                             115
#define aMOS2P1                             116
#define aMOS2P2                             117
#define aSER2C1                             118
#define aSER2C2                             119
#define aSER2C3                             120
#define aSER2C4                             121
#define aSER2C5                             122
#define aSER2C6                             123
#define aSER2C7                             124
#define aSER2C8                             125
#define aSER2C9                             126
#define aSER2C10                            127
#define aSER2I1                             128
#define aSER2I2                             129
#define aSER2P1                             130
#define aSER2P2                             131
#define aSER2P3                             132
#define aSER2P4                             133
#define aSER2P5                             134
#define aSER2Q1                             135
#define aSER2Q2                             136
#define aSER2Q3                             137
#define aSUP261                             138
#define aSUP262                             139
#define aSUP263                             140
#define aSUP291                             141
#define aSUP292                             142
#define aSUP293                             143
#define aSUP294                             144
#define aSUP295                             145
#define aSUP296                             146
#define aSUP297                             147
#define aMOS27sa                            148
#define aMOS27sb                            149

// AZIONI (come da librone)
#define a211                                201
#define a212                                202
#define a213                                203
#define a214                                204
#define a215                                205
#define a216                                206
#define a217                                207
#define a218                                208
#define a219                                209
#define a2110                               210
#define a2111                               211
#define a2112                               212
#define a2113                               213
#define a221                                214
#define a222                                215
#define a223                                216
#define a224                                217
#define a225                                218
#define a226                                219
#define a227                                220
#define a2210                               221
#define a2211                               222
#define a241                                223
#define a242                                224
#define a243                                225
#define a244                                226
#define a245                                227
#define a246                                228
#define a247                                229
#define a248                                230
#define a249                                231
#define a2410                               232
#define a2411                               233
#define a251                                234
#define a252                                235
#define a253                                236
#define a254                                237
#define a255                                238
#define a256                                239
#define a257                                240
#define a258                                241
#define a259                                242
#define a2510                               243
#define a2511                               244
#define a2512                               245
#define a2513                               246
#define a2514                               247
#define a2515                               248
#define a2516                               249
#define a2517                               250
#define a2518                               251
#define a2519                               252
#define a2520                               253
#define a2521                               254
#define a2522                               255
#define a2523                               256
#define a2524                               257
#define a2525                               258
#define a2526                               259
#define a2527                               260
#define a2528                               261
#define a2531                               262
#define a2532                               263
#define a2533                               264
#define a2534                               265
#define a2535                               266
#define a2536                               267
#define a261                                268
#define a262                                269
#define a263                                270
#define a264                                271
#define a265                                272
#define a267                                273
#define a268                                274
#define a271                                275
#define a272                                276
#define a273                                277
#define a274                                278
#define a275                                279
#define a276                                280
#define a277                                281
#define a281                                282
#define a282                                283
#define a283                                284
#define a284                                285
#define a285                                286
#define a289                                287
#define a2811                               288
#define a2812                               289
#define a2813                               290
#define a2814                               291
#define a2815                               292
#define a2816                               293
#define a2817                               294
#define a291                                295
#define a292                                296
#define a293                                297
#define a295                                298
#define a297                                299
#define a298                                300
#define a299                                301
#define a2A1                                302
#define a2A2                                303
#define a2A3                                304
#define a2A4                                305
#define a2A5                                306
#define a2A6                                307
#define a2A7                                308
#define a2A8                                309
#define a2A9                                310
#define a2A10                               311
#define a2A11                               312
#define a2A12                               313
#define a2A13                               314
#define a2A14                               315
#define a2A15                               316
#define a2B1                                317
#define a2B2                                318
#define a2B3                                319
#define a2B4                                320
#define a2B5                                321
#define a2B6                                322
#define a2B7                                323
#define a2B8                                324
#define a2B9                                325
#define a2B10                               326
#define a2B11                               327
#define a2B12                               328
#define a2B13                               329
#define a2B14                               330
#define a2C1                                331
#define a2C2                                332
#define a2C3                                333
#define a2C4                                334
#define a2C5                                335
#define a2C6                                336
#define a2C7                                337
#define a2C9                                338
#define a2C10                               339
#define a2C11                               340
#define a2D1                                341
#define a2D2                                342
#define a2D3                                343
#define a2D4                                344
#define a2D5                                345
#define a2D6                                346
#define a2D7                                347
#define a2D11                               348
#define a2D12                               349
#define a2D13                               350
#define a2D14                               351
#define a2D15                               352
#define a2D16                               353
#define a2E1                                354
#define a2E2                                355
#define a2E3                                356
#define a2E4                                357
#define a2E5                                358
#define a2E6                                359
#define a2E7                                360
#define a2F1                                361
#define a2F2                                362
#define a2F3                                363
#define a2F4                                364
#define a2F5                                365
#define a2F6                                366
#define a2F7                                367
#define a2F8                                368
#define a2G1                                369
#define a2G2                                370
#define a2G3                                371
#define a2G4                                372
#define a2G5                                373
#define a2G6                                374
#define a2G7                                375
#define a2G8                                376
#define a2G9                                377
#define a2H1                                378
#define a2H2                                379
#define a2H3                                380
#define a2H4                                381
#define a2H5                                382
#define a2H6                                383
#define a2H7                                384
#define a2I1                                385
#define a2I2                                386
#define a2I3                                387
#define a2I4                                388
#define a2L1                                389
#define a2L2                                390
#define a2L3                                391
#define a2L4                                392
#define a2M1                                393
#define a2M3                                394
#define a2M4                                395
#define a2M5                                396
#define a2M6                                397
#define a2M7                                398
#define a2M8                                399
#define a2M9                                400
#define a2M10                               401
#define a2M11                               402
#define a2M12                               403
#define a2M13                               404
#define a2M14                               405
#define a2M15                               406
#define a2M16                               407
#define a2M17                               408
#define a2M18                               409
#define a2M19                               410
#define a2M20                               411
#define a2M21                               412
#define a2M22                               413
#define a2M23                               414
#define a2M24                               415
#define a2P1                                416
#define a2P2                                417
#define a2P3                                418
#define a2P4                                419
#define a2P5                                420
#define a2P6                                421
#define a2Q1                                422
#define a2Q2                                423
#define a2Q3                                424
#define a2Q4                                425
#define a2Q5                                426
#define a2Q6                                427
#define a2Q7                                428
#define a2Q11                               429
#define a2Q12                               430
#define a2Q13                               431
#define a2Q14                               432
#define a2R1                                433
#define a2R2                                434
#define a2R3                                435
#define a2R4                                436
#define a2R5                                437
#define a2R6                                438
#define a2R7                                439
#define a2R8                                440
#define a2R9                                441
#define a2S1                                442
#define a2S2                                443
#define a2S3                                444
#define a2S4                                445
#define a2S5                                446
#define a2S6                                447
#define a2S7                                448
#define a2T1                                449
#define a2T2                                450
#define a2T3                                451
#define a2T4                                452
#define a2T5                                453
#define a2T6                                454
#define a2T7                                455
#define a111                                456
#define a112                                457
#define a121                                458
#define a131                                459
#define a132                                460
#define a133                                461
#define a139                                462
#define a1310                               463
#define a1311                               464
#define a1312                               465
#define a141                                466
#define a142                                467
#define a143                                468
#define a144                                469
#define a145                                470
#define a146                                471
#define a147                                472
#define a148                                473
#define a151                                474
#define a153                                475
#define a154                                476
#define a155                                477
#define a156                                478
#define a157                                479
#define a158                                480
#define a159                                481
#define a1510                               482
#define a161                                483
#define a162                                484
#define a163                                485
#define a164                                486
#define a171                                487
#define a172                                488
#define a173                                489
#define a174                                490
#define a175                                491
#define a176                                492
#define a177                                493
#define a178                                494
#define a1710                               495
#define a1711                               496
#define a181                                497
#define a182                                498
#define a183                                499
#define a191                                500
#define a192                                501
#define a193                                502
#define a194                                503
#define a1A1                                504
#define a1A2                                505
#define a1A3                                506
#define a1A4                                507
#define a1A5                                508
#define a1A6                                509
#define a1A8                                510
#define a1A9                                511
#define a1A10                               512
#define a1A11                               513
#define a1A14                               514
#define a1A15                               515
#define a1A12                               516
#define a1B1                                517
#define a1B2                                518
#define a1B3                                519
#define a1B4                                520
#define a1B5                                521
#define a1B6                                522
#define a1C1                                523
#define a1C2                                524
#define a1D1                                525
#define a1D2                                526
#define a1D3                                527
#define a1D4                                528
#define a1D5                                529
#define a1D6                                530
#define a1D8                                531
#define a1D9                                532
#define a1D10                               533
#define a1D11                               534
#define a1D12                               535
#define a1E1                                536
#define a1E2                                537
#define a1E3                                538
#define a1E4                                539
#define a1F1                                540
#define a1F2                                541
#define a1F3                                542
#define a1F4                                543
#define a1F5                                544
#define a1F6                                545
#define a1F7                                546
#define a1F8                                547
#define a1F9                                548
#define a1F10                               549
#define a1F11                               550
#define a1F12                               551
#define a311                                552
#define a312                                553
#define a313                                554
#define a314                                555
#define a315                                556
#define a316                                557
#define a317                                558
#define a318                                559
#define a319                                560
#define a3110                               561
#define a3111                               562
#define a3112                               563
#define a3113                               564
#define a3114                               565
#define a3115                               566
#define a3116                               567
#define a3117                               568
#define a3119                               569
#define a3120                               570
#define a3121                               571
#define a321                                572
#define a322                                573
#define a323                                574
#define a326                                575
#define a327                                576
#define a324                                577
#define a325                                578
#define a331                                579
#define a336                                580
#define a337                                581
#define a338                                582
#define a339                                583
#define a3310                               584
#define a341                                585
#define a342                                586
#define a343                                587
#define a344                                588
#define a345                                589
#define a346                                590
#define a347_DARRELL                                                    591
#define a349                                                            593
#define a3410                               594
#define a3411                               595
#define a3412                               596
#define a3413                               597
#define a3414                               598
#define a3415                               599
#define a3416                               600
#define a3417                               601
#define a3418                               602
#define a3419                               603
#define a351                                604
#define a352                                605
#define a353                                606
#define a354                                607
#define a355                                608
#define a356                                609
#define a357                                610
#define a361                                611
#define a362                                612
#define a363                                613
#define a364                                614
#define a36MSDM                             615
#define a36MSSM                             616
#define a36MSDA                             617
#define a36MSSA                             618
#define a36PSDB                             619
#define a36PSSB                             620
#define a36PSDM                             621
#define a36PSSM                             622
#define a36MIDA                             623
#define a36MISA                             624
#define a36PIDB                             625
#define a36PISB                             626
#define a36PIDM                             627
#define a36PISM                             628
#define a36PBDB                             629
#define a36PBSB                             630
#define a36PBDM                             631
#define a36PBSM                             632
#define a3627                               633
#define a371                                634
#define a372                                635
#define a373                                636
#define a374                                637
#define a375                                638
#define a376                                639
#define a377                                640
#define a378                                641
#define a381                                642
#define a382                                643
#define a383                                644
#define a384                                645
#define a386                                646
#define a387                                647
#define a391                                648
#define a392                                649
#define a393                                650
#define a394                                651
#define a395                                652
#define a396                                653
#define a397                                654
#define a398                                655
#define a399                                656
#define a3910                               657
#define a3911                               658
#define a3912                               659
#define a3913                               660
#define a3B1                                661
#define a3B2                                662
#define a3B3                                663
#define a3B4                                664
#define a3B5                                665
#define a3B6                                666
#define a3B7                                667
#define a3B8                                668
#define a3B9                                669
#define a3B10                               670
#define a3B11                               671
#define a3B12                               672
#define a3B13                               673
#define a3B14                               674
#define a3B15                               675
#define a3B16                               676
#define a3B17                               677
#define a3B18                               678
#define a3B19                               679
#define a3B20                               680
#define a3B21                               681
#define a3B24                               682
#define a3B25                               683
#define a3B26                               684
#define a3C1                                685
#define a3C2                                686
#define a3C3                                687
#define a3C4                                688
#define a3C5                                689
#define a3C6                                690
#define a3C7                                691
#define a3C8                                692
#define a411                                693
#define a412                                694
#define a413                                695
#define a421                                696
#define a422                                697
#define a424                                698
#define a425                                699
#define a426                                700
#define a427                                701
#define a428                                702
#define a431                                703
#define a432                                704
#define a433                                705
#define a434                                706
#define a435                                707
#define a436                                708
#define a437                                709
#define a438                                710
#define a441                                711
#define a442                                712
#define a443                                713
#define a444                                714
#define a451                                715
#define a452                                716
#define a453                                717
#define a454                                718
#define a455                                719
#define a456                                720
#define a457                                721
#define a458                                722
#define a459                                723
#define a4510                               724
#define a461                                725
#define a462                                726
#define a463                                727
#define a464                                728
#define a465                                729
#define a466                                730
#define a467                                731
#define a468                                732
#define a469                                733
#define a4610                               734
#define a4611                               735
#define a4612                               736
#define a4613                               737
#define a4614                               738
#define a4615                               739
#define a4616                               740
#define a4617                               741
#define a4618                               742
#define a4619                               743
#define a4620                               744
#define a471                                745
#define a481                                746
#define a482                                747
#define a491                                748
#define a492                                749
#define a493a                               750
#define a493b                               751
#define a494a                               752
#define a494b                               753
#define a493ca                              754
#define a493cb                              755
#define a494ca                              756
#define a494cb                              757
#define a495                                758
#define a496                                759
#define a497                                760
#define a498                                761
#define a499                                762
#define a4910                               763
#define a4911                               764
#define a4912                               765
#define a4913                               766
#define a4914                               767
#define a4915                               768
#define a4916                               769
#define a4917                               770
#define a4918                               771
#define a4A1                                                            774
#define a4A2                                775
#define a4A3                                776
#define a4A4                                777
#define a1F13                               778

// per chris
#define aGOPHER_ACTION                      901
//ATTENZIONE! numeri incasinati!!
#define aDARRELL_PARLA                                          926
#define aVICTORIA_PARLA                     927
#define aCURPLAYER_PARLA                    928
#define aCURPLAYER_ASCOLTA                  929
#define aCURPLAYER_PENSA                    930
#define aCUOCO_PARLA                        931
#define aDOMESTICA_PARLA                    932
#define aGIARDINIERE_PARLA                  933
#define aCUSTODE_PARLA                      934
#define aSERVETTA_PARLA                     935
#define aSUPERVISORE_PARLA                  936
#define aMOGLIESUPERVISORE_PARLA            937
#define aDARRELL_ASCOLTA                    938
#define aVICTORIA_ASCOLTA                   939
#define aCUOCO_ASCOLTA                      940
#define aDOMESTICA_ASCOLTA                  941
#define aGIARDINIERE_ASCOLTA                942
#define aCUSTODE_ASCOLTA                    943
#define aSERVETTA_ASCOLTA                   944
#define aSUPERVISORE_ASCOLTA                945
#define aMOGLIESUPERVISORE_ASCOLTA          946
#define aCUSTODE_ALZA_TESTA                 947
#define aCUSTODE_ABBASSA_TESTA              948
#define aCAMBIA_FRASI                       949
#define aFINE_RTV                           950
#define aFINE_DEMO                          951
#define aPORTALE_32_34                      952
#define aPORTALE_34_32                      953
#define a48PENDOLO                          954
#define aCAC1a5a                            955
#define aCAC1a5b                            956
#define aCAC1c3                             957
#define aCAC2a1                             958
#define aCOL1a2a                            959
#define aCOL1a2b                            960
#define aCUO2t2a                            961
#define aCUO2t2b                            962
#define aCUS1a1d                            963
#define aCUS1a2                             964
#define aDAR1a1a                            965
#define aDAR1a1b                            966
#define aDAR1a1c                            967
#define aDAR1a3a                            968
#define aDAR1a4                             969
#define aDAR1c1a                            970
#define aDAR1c1c                            971
#define aDAR1c2a                            972
#define aDAR1c2b                            973
#define aDAR1c3                             974
#define aDAR1c3b                            975
#define aDAR1c3c                            976
#define aDAR221b                            977
#define aDAR421                             978
#define aDAR481                             979
#define aGIA1a1a                            980
#define aGIA1a1b                            981
#define aGIA1a1c                            982
#define aGIA1a1d                            983
#define aGIA1a3a                                                        984
#define aJUD222a                            985
#define aJUD222b                            986
#define aJUD2d1a                            987
#define aJUD2d1b                            988
#define aJUD2p1                             989
#define aKRE481a                            990
#define aKRE481b                            991
#define aPSG1c3a                            992
#define aPSG1c3b                            993
#define aSER1a1                             994
#define aSER1a2                             995
#define aSUP291a1                           996
#define aSUP291a2                           997
#define aSUP291a3                           998
#define aSUP291b                            999
#define aSUP291c                            1000
#define aSUP291d                            1001
#define aVIC1a3a                            1002
#define aVIC1a4                             1003
#define aVIC1a5                             1004
#define aVIC1e1                             1005
#define aVIC212b                            1006
#define aVIC221b                            1007
#define aVIC291a                            1008
#define aVIC291b1                           1009
#define aVIC291b2                           1010
#define aVIC291b3                           1011
#define aVIC291c                            1012
#define aVIC2a1                             1013
#define aVIC411a                            1014
#define aVIC411b                            1015
#define aVIC411c                            1016
#define aVIC491b                            1017
#define aVIV451                             1018
#define aVIV452a                            1019
#define aVIV452b                            1020
#define aVIV471a                            1021
#define aVIV471b                            1022
#define aVIV472c                            1023
#define aAND007a                            1024
#define aAND007c                            1025
#define aCUO009a                            1026
#define aCUO009b                            1027
#define aDAR009                             1028
#define aHEN002b                            1029
#define aVIC0010                            1030
#define aVIC0014                            1031
#define aVIC009                             1032
#define aSUP1a2a                            1033
#define aSUP1a2b                            1034
#define aR1f1                               1035
#define aDARRELL_DARE                       1036
#define aVICTORIA_DARE                      1037
#define aDARRELL_PRENDERE                   1038
#define aVICTORIA_PRENDERE                  1039
#define aDARRELL_ARRIVA_R41                 1040
#define aVIC1c1a                            1041
#define aDARRELL_ARRIVA_R1C                 1042
#define aCACPOR                             1043
#define aMOGLIE_KIMONO_PARLA                1044
#define aMOGLIE_KIMONO_ASCOLTA              1045
#define aCACCIATORE_PARLA                   1046
#define aCACCIATORE_ASCOLTA                 1047
#define aCACCIATORE_SCENDE                  1048
#define aCACCIATORE_ARRIVA_R41              1049
#define aSab411                             1050
#define aJUD2d1c                            1051
#define aMOGLIE_KIMONO_DARE                 1052
#define aVIC1c3b                            1053
#define aDAR1c3d                            1054
#define aDAR1c3d_nopoptext                  1055
#define aKRENN_PARLA                        1056
#define aKRENN_ASCOLTA                      1057
#define aVALENCIA_PARLA                     1058
#define aVALENCIA_ASCOLTA                   1059
#define aSUP_PARLA                          1060
#define aR1A5_ENDRTV                        1061
#define aVIC212a                            1062
#define aSUP1a2c                            1063
#define aCOL1a2c                            1064
#define aCOL1a2d                            1065
#define aSER1a2_SHOW_OBJS                   1066
#define aR1f1_START                         1067
#define aSERVETTA_PRENDERE                  1068
#define aSERVETTA_DARE                      1069
#define aCUSTODE_PENSA                      1070
#define aCUSTODESEDUTO_PARLA                1071
#define aCUSTODESEDUTO_ASCOLTA              1072
#define aCUSTODESEDUTO_PENSA                1073
#define aSUPERVISORESEDUTO_PARLA            1074
#define aSUPERVISORESEDUTO_ASCOLTA          1075
#define aMOGLIESEDUTA_PARLA                 1076
#define aMOGLIESEDUTA_ASCOLTA               1077
#define aCAM461                             1078
#define aCUSTODE_PRENDERE                   1079
#define aCUSTODE_DARE                       1080
#define aPorta421_LEFT                      1081
#define aPorta421_RIGHT                     1082
#define aDAR421a                            1083
#define aVIC421a                            1084
#define aDAR421b                            1085
#define aPorta421a_LEFT                     1086
#define aPorta421a_RIGHT                    1087
#define aDOM221a                            1088
#define aDOM221b                            1089
#define aDAR000b                            1091
#define aDAR000c                            1092
#define aDAR000d                            1093
#define aDAR000e                            1094
#define aR000_SVEGLIA                       1095
#define aCUSTODE_PORTA                      1096
#define aTAXI1                              1097
#define aTAXI2                              1098
#define aVIC000tb                           1099
#define aTAXI3                              1100
#define aSUPERVISORE_ALZA                   1101
#define aSUPERVISORE_PARLABAR               1102
#define aDAR2c1                             1103
#define aVIC2c1                             1104
#define aSUPERVISORE_PRENDERE               1105
#define aSUPERVISORE_DARE                   1106
#define aCUSTODE_OCCHIALI                   1107
#define aCUSTODE_OCCHIALISEDUTO             1108
#define aCUSTODE_OSSERVAPRENDE              1109
#define aCUSTODE_OSSPRENDESEDUTO            1110
#define aSERVETTA_OSSERVAPRENDE             1111
#define aDAR000f                            1112
#define aDAR000g                            1113
#define aDAR000h                            1114
#define aDAR000j                            1115
#define aVIC000b                            1117
#define aVIC000c                            1118
#define aVIC000d                            1119
#define aVIC000e                            1120
#define aPET000a1                           1121
#define aPET000a2                           1122
#define aPET000b                            1123
#define aPET000c                            1124
#define aPET000d                            1125
#define aPET000e                            1126
#define aPET000f                            1127
#define aDAR_DOOR_A92                       1128
#define a144_switch_camera                  1130
#define aSUPERVISORE_APRE_PORTA             1131
#define a145_con_occhiali                   1132
#define a148_start                          1133
#define a2Q4b                               1134
#define a1A7                                1135
#define aCUOCO_VERSA                        1136
#define aCUOCO_BEVE                         1137
#define aCUSTODE_SEDUTODARE                 1138
#define aCUSTODE_SEDUTOPRENDERE             1139
#define a3123                               1140
#define aDAR482a                            1141
#define aDAR482b                            1142
#define aDAR482c                            1143
#define aDAR482in                           1144
#define aCAC482a                            1145
#define aCAC482l                                                1146
#define aCAC482c                            1147
#define aCAC482d                            1148
#define aCAC482e                            1149
#define aCAC482f                            1150
#define aCAC482g                            1151
#define aCAC482h                            1152
#define aCAC482i                            1153
#define aCAC482j                            1154
#define aCAC482k                            1155
#define aVIC482a                            1156
#define aVIC482a1                           1157
#define aVIC482in                           1158
#define a3123_switch_to_a159                1159
#define a48PORTA                            1161
#define aDARRELL_BOTTIGLIA                              1163
#define aCUOCO_VERSAUNO                     1164
#define aVICTORIA_BOTTIGLIA                 1165
#define aDARRELL_SEGNO                      1166
#define aVICTORIA_SEGNO                     1167
#define aCUOCO_MOSTRAQUADRO                 1168
#define aDARRELL_PRENDECHIAVI               1169
#define aVICTORIA_PRENDECHIAVI              1170
#define aCUOCO_INTERRUPT1                   1171
#define aCUOCO_INTERRUPT2                   1172
#define aDOMESTICA_INTERRUPT1               1173
#define aDOMESTICA_INTERRUPT2               1174
#define aGIARDINIERE_INTERRUPT1             1175
#define aGIARDINIERE_INTERRUPT2             1176
#define aCUSTODE_INTERRUPT1                 1177
#define aCUSTODE_INTERRUPT2                 1178
#define aCUSTODE_INTERRUPT3                 1179
#define aCUSTODE_INTERRUPT4                 1180
#define aCUSTODE_INTERRUPT5                 1181
#define aMOGLIESUP_INTERRUPT1               1182
#define aMOGLIESUP_INTERRUPT2               1183
#define aSUPERVISORE_INTERRUPT1             1184
#define aSUPERVISORE_INTERRUPT2             1185
#define aSUPERVISORE_INTERRUPT3             1186
#define aSUPERVISORE_INTERRUPT4             1187
#define aKREI347a                           1188
#define aKREI347b                           1189
#define aPEN347                             1190
#define aCORI347a                           1191
#define aCORI347b                           1192
#define aCORI347c                           1193
#define aKREI347c                           1194
#define aKREI347d                           1195
#define aKREI347e                           1196
#define aDUKI347a                           1197
#define aDUKI347b                           1198
#define aDUKI347c                           1199
#define a1A9_rtv                            1200
//#define a1A9_dice_solo_frase              1201
#define a225_prima_volta                    1202
#define aDUKI347d                           1203
#define aDUKI347e                           1204
#define aDUKI347f                           1205
#define aDUKI347g                           1206
#define aVICI347a                           1207
#define aVICI347b                           1208
#define aGREI347a                           1209
#define aGREI347b                           1210
#define aGREI347c                           1211
#define a84cam                              1212
#define a2G9_parte_rtv                      1213
#define a323_tira                                               1214
#define a323_lascia                                             1215
#define aCUO255_nopentole                   1216
#define aDARI347a                           1217
#define aDARI347b                           1218
#define aFAKE_BOTTLE                        1219
#define aSUP295_loop                        1220
#define a2P7                                1222
#define a2P8                                1223
#define a41_lancia_dR411                    1224
#define aSUPERVISORE_GUARDAFOTO             1225
#define aGIA2G_PORTA                        1226
#define a229                                1227
#define a2211_ultimavolta                   1228
#define aVOCEFUORICAMPO                     1229
#define a289_noinctime                      1230
#define aVOCECORONA                         1231
#define aVOCEDUKES                          1232
#define a22CAMBIA2T                         1233
#define a22LANCIAR2T2                       1234
#define a2TCAMBIA22                         1235
#define a1E1_rtv                            1237
#define aKREN491a                                               1239
#define aKREN491b                           1240
#define a18GUARDA_SCACCHIERA                    1241
#define a1A11_primavolta                                        1242
#define a1D3_dopo                       1243
#define a1D4_fine                       1244
#define a1F10_cambia_indicatori                 1245
#define a347_VICTORIA                                           1246
#define aVIV347a                                                1247
#define aVIV347b                                                1248
#define aCOLOMBAMUORE                       1249
#define aALB1A5                                                 1251
#define a4617DARRELL                        1252
#define aGREI347d                                               1253
#define a4612A                                                  1254
#define a429                            1255
#define aDAR241a                                                1256
#define aDOM241                                                 1257
#define aDOM2D1                                                 1258
#define aJUD_dR241                                              1259
#define aFINE_dR241                                             1260
#define aDAR241b                                                1261
#define aDUKI347d_nofrase                                       1262
#define a426VIC                                                 1266
#define aVIC1c3c                                                1267
#define aCACCIATOREMALPRESO_PARLA                               1268
#define a2513_DOM                                               1269
#define a2512_DOM                                               1270
#define a111_DOM                                                1271
#define a1A4_DOM                                                1272
#define aLancia_dR015                                           1273
#define a2Q13_lancia_dR015                                      1274
#define a465B                                                   1275
#define a466B                                                   1276
#define a467B                                                   1277
#define a468B                                                   1278
#define a469B                                                   1279
#define a4610B                                                  1280
#define a4611B                                                  1281
#define a4612B                                                  1282
#define a4612AB                                                 1283
#define aDARRELL_SOLO_FRASE                 1284
#define aVICTORIA_SOLO_FRASE                    1285
#define a2C4_CUOCODORME                                         1286
#define aKRE481                                                 1288
#define aKRE482                                                 1289
#define aKRE483                                                 1290
#define aKRE484                                                 1291
#define aMOS2P1_restore                                         1292
#define aGIA_dr1a4_doorA                                        1293
#define aPEN73a                                                 1294
#define aKRE48indica                                            1295
#define aKRE48spara                                             1296
#define aLaunch_WMLetter                                        1297
#define aLaunch_Parchment                                       1298
#define aVIC48spavent                                           1299
#define aDAR721                                                 1300
#define aCACinvita                                              1301
#define aCACinvitab                                             1302
#define aVICarresa                                              1303
#define adR451_fine                                             1304
#define a1A13                           1305 //anim null per frase in RTV lucchetto
#define aVIC_FRASE_BRACCIALE                    1306 //anim null per frase da bracciale a servetta
#define aPorta421_RIGHT_nocamera                                1307
#define a48camera                                               1308
#define aDAR482ing_idle                                         1309
#define aVIC482ing_idle                                         1310
#define aMORTE_CHIRURGO                                         1311
#define aMORTE_MOORE                                            1312
#define aMORTE_TRADUTTORE                                       1313
#define aMORTE_VECCHIO                                          1314
#define aSUPERVISORE_ASCOLTABAR                 1315
#define aVIC000a                                                1316
#define aVIC_PORTA_ANDERSON                 1317
#define aSETTA_FINESTRA_XT_ACCESA                               1318
#define a251_DaAcceso                                           1319
#define aVIV471b1                                               1320
#define aWALKMAN_STOP                                           1321
#define aWALKMAN_PLAY                                           1322
#define aWALKMAN_FASTF                                          1323
#define a253_SportelloAperto                                    1324
#define aDOOR_A_CHIUSA1                                         1325
#define aDOOR_A_CHIUSA2                                         1326
#define a2C6_occupato                                           1327
#define a2M8_occupato                                           1328
#define aTAXI483a                                               1329
#define aDAR483_GIRATESTA                                       1330
#define aVIC483_GIRATESTA                                       1331
#define aDAR483_IDLE                                            1332
#define aVIC483_IDLE                                            1333
#define aCAMERA483                                              1334
#define aPORTALLINK_26a_26b                                     1335
#define aPORTALLINK_26b_26a                                     1336
#define aPORTALLINK_24a_24b                                     1337
#define aPORTALLINK_24b_24a                                     1338
#define aPORTALLINK_38b_38a                                     1339
#define aLOGOTREC_START                                         1340
#define aLOGOTREC                                               1341
#define aR000cam                                                1342
#define aDAR000a                                                1343
#define aCHIUDOCANCINTRO                                        1344
#define a393b                                                   1345
#define a39VORTICE                                              1346
#define a39VORTICE_CLEAN                                        1347
#define aCAMERA483inizio                                        1348
#define aCACMUOREFUMO                                           1349
#define aVIC482b                                                1350
#define aLOGOWM                                                 1351
#define a2G8_fake                                               1352
#define aMOORE_PARLA                                            1353

/* -----------------18/08/99 17.00-------------------
 *                      Icons
 * --------------------------------------------------*/
#define iNULL                                                     0
#define i00TELEFONO                                               1
#define i00TELEFONOVIC                                            2
#define i13SCALPELLO                                              3
#define i13INGRANAGGIO                                            4
#define i14PIUMA                                                  5
#define i14OCCHIALI                                               6
#define i19BAMBOLA                                                7
#define i19FOGLIO1                                                8
#define i19CRISTALLO                                              9
#define i1aLUCCHETTO                                              10
#define i1aSASSO                                                  11
#define i1aBOTTIGLIAVUOTA                                         12
#define i1cMEDAGLIONI3                                            13
#define i1cMEDAGLIONI2                                            14
#define i1cMEDAGLIONE                                             15
#define i1dAUDIOCASSETTA                                          16
#define i1dTRONCHESE                                              17
#define i22BRACCIALE                                              18
#define i22LIBROCHIUSODEPLIANT                                    19
#define i22DEPLIANT                                               20
#define i22LIBROAPERTODEPLIANT                                    21
#define i22LIBROAPERTO                                            22
#define i22LIBROCHIUSO                                            23
#define i24COLTELLO                                               24
#define i24CHIAVETTA                                              25
#define i25MAZZODUECHIAVI                                         26
#define i25FIALABOK                                               27
#define i25FIALAAOK                                               28
#define i25FIALEABPIENE                                           29
#define i25FIALEABUSATE                                           30
#define i25MEDAGLIONI4                                            31
#define i27PILE                                                   32
#define i28WALKMANVUOTO                                           33
#define i28WALKMANNASTRO                                          34
#define i28WALKMANPILE                                            35
#define i28WALKMANOK                                              36
#define i29FOTOJUDE1                                              37
#define i29CHIAVESUPERVISORE                                      38
#define i29FOTOPROGETTO                                           39
#define i29FOTOIMMORTALI                                          40
#define i29STAMPAINGRANAGGIO                                      41
#define i2aSANGUE                                                 42
#define i2aSIRINGAVUOTA                                           43
#define i2aSIRINGANITRICO                                         44
#define i2bSACCHETTOINCENSO                                       45
#define i2cBANCONOTA1                                             46
#define i2dSESTERZO                                               47
#define i2dCOLLANA                                                48
#define i2iDETERSIVO                                              49
#define i2lBOTTIGLIAVINO                                          50
#define i2mSIRINGASOLFORICO                                       51
#define i2mSIRINGAACIDI                                           52
#define i2rBUSTAVUOTAA                                            53
#define i2rBUSTAVUOTAB                                            54
#define i31ANELLOBRONZO                                           55
#define i31DISCONUOVO                                             56
#define i34PERGAMENA                                              57
#define i34DIARIO                                                 58
#define i34LASTRE                                                 59
#define i34STAMPO                                                 60
#define i34FIALAA                                                 61
#define i34FIALAB                                                 62
#define i34SFERA                                                  63
#define i35DISEGNO                                                64
#define i36BUSTA1DOSEA                                            65
#define i36BUSTA2DOSIA                                            66
#define i36BUSTA1DOSEB                                            67
#define i36BUSTA2DOSIB                                            68
#define i37CILINDRO                                               69
#define i39CRISTALLOATTIVATO                                      70
#define i3bLASTRA2VOLTI                                           71
#define i3bLASTRABIANCA                                           72
#define i3bLASTRANERA                                             73
#define i41OGGETTO                                                74
#define i46BUSTAOROLOGIAIO                                        75
#define i46CANDELA1                                               76
#define i46CANDELA2                                               77
#define i46PERGAMENA                                              78
#define i46STELLA1                                                79
#define i46STELLA2                                                80
#define i46FIALEABVUOTE                                           81
#define i48CHIAVIMANETTE                                          82
#define i49ACCENDINO                                              83
#define i2lBOTTIGLIAVINO_NOCUOCO                                  84

/* -----------------17/03/98 10.20-------------------
 *                      Actions
 * --------------------------------------------------*/
#define h11RACCOGLIECARTA                   1

/* -----------------17/03/98 10.21-------------------
 *                      Scripts
 * --------------------------------------------------*/
#define s16CARD                             1

/* -----------------17/03/98 10.21-------------------
 *                      Sounds
 * --------------------------------------------------*/
#define wNULL                               0
#define wPROVA                              1
#define wPASSODESTROCOTTO                   2
#define wPASSOSINISTROCOTTO                 3
#define wPASSODESTROTAPPETO                 4
#define wPASSOSINISTROTAPPETO               5
#define wPASSODESTROASFALTO                 6
#define wPASSOSINISTROASFALTO               7
#define wPASSODESTROPIETRA                  8
#define wPASSOSINISTROPIETRA                9
#define wPASSODESTROERBA                    10
#define wPASSOSINISTROERBA                  11
#define wPASSODESTROASFALTO2                12
#define wPASSOSINISTROASFALTO2              13
#define wPASSODESTROASFALTO3                14
#define wPASSOSINISTROASFALTO3              15
#define wPASSODESTROMARMO                   16
#define wPASSOSINISTROMARMO                 17
#define wPASSODESTROLEGNO                   18
#define wPASSOSINISTROLEGNO                 19
#define wPASSODESTROTAPPETO2                20
#define wPASSOSINISTROTAPPETO2              21
#define wPASSODESTROTAPPETO3                22
#define wPASSOSINISTROTAPPETO3              23
#define wPASSODESTROTAPPETO4                24
#define wPASSOSINISTROTAPPETO4              25
#define wPASSODESTROTAPPETO5                26
#define wPASSOSINISTROTAPPETO5              27
#define w132                                28
#define w133a                               29
#define w133b                               30
#define w139a                               31
#define w139b                               32
#define w1311a                              33
#define w1311b                              34
#define w1312a                              35
#define w1312b                              36
#define w213a                               37
#define w213b                               38
#define w2111                               39
#define w221a                               40
#define w221b                               41
#define w222a                               42
#define w222b                               43
#define w2210a                              44
#define w2210b                              45
#define w2211a                              46
#define w2211b                              47
#define w2211c                              48
#define w2211d                              49
#define w223a                               50
#define w223b                               51
#define w225a                               52
#define w225b                               53
#define w226a                               54
#define w226b                               55
#define w241a                               56
#define w241b                               57
#define w242a                               58
#define w242b                               59
#define w243a                               60
#define w243b                               61
#define w243c                               62
#define w243d                               63
#define w244                                64
#define w245                                65
#define w246                                66
#define w247                                67
#define w248                                68
#define w249a                               69
#define w249b                               70
#define w2411                               71
#define w251                                72
#define w252                                73
#define w25puls                             74
#define w25fialf                            75
#define w2512a                              76
#define w2512b                              77
#define w2512c                              78
#define w2512d                              79
#define w2513a                              80
#define w2513b                              81
#define w2515                               82
#define w2518a                              83
#define w2518b                              84
#define w2519a                              85
#define w2519b                              86
#define w2520                               87
#define w2521                               88
#define w2522                               89
#define w25fialc                            90
#define w2531a                              91
#define w2531b                              92
#define w2532a                              93
#define w2532b                              94
#define w2533a                              95
#define w2533b                              96
#define w2534a                              97
#define w2534b                              98
#define w2535a                              99
#define w2535b                              100
#define w2536a                              101
#define w2536b                              102
#define w2536d                              103
#define w2536c                              104
#define w111a                               105
#define w111b                               106
#define w143                                107
#define w156A                               108
#define w156B                               109
#define w156C                               110
#define w157A                               111
#define w158A                               112
#define w158B                               113
#define w161A                               114
#define w161B                               115
#define w172                                116
#define w173                                117
#define w174                                118
#define w176                                119
#define w177                                120
#define w112                                121
#define w162A                               122
#define w162B                               123
#define w162C                               124
#define w164                                125
#define w175                                126
#define w178                                127
#define w1710A                              128
#define w1710B                              129
#define w181A                               130
#define w181B                               131
#define w182A                               132
#define w182B                               133
#define w193A                               134
#define w193B                               135
#define w195                                136
#define w1A5A                               137
#define w1A5B                               138
#define w1A6                                139
#define w1A9                                140
#define w1A10                               141
#define w1A11A                              142
#define w1A11B                              143
#define w1A15                               144
#define w1B3                                145
#define w1B4A                               146
#define w1B4B                               147
#define w1B6                                148
#define w1C2A                               149
#define w1C2B                               150
#define w1D1A                               151
#define w1D1B                               152
#define w1D3                                153
#define w1D4A                               154
#define w1D4B                               155
#define w1D5                                156
#define w1D6A                               157
#define w1D6B                               158
#define w1D8                                159
#define w1D10                               160
#define w1D12                               161
#define w1E1                                162
#define w1F7                                163
#define w1F9                                164
#define w262A                               165
#define w262B                               166
#define w264A                               167
#define w264B                               168
#define w268                                169
#define w272                                170
#define w273                                171
#define w274                                172
#define w275                                173
#define w276                                174
#define w277                                175
#define w282                                176
#define w283                                177
#define w284A                               178
#define w284B                               179
#define w2811A                              180
#define w2811B                              181
#define wBCUCINA                            182
#define w2812                               183
#define w2813                               184
#define w2814                               185
#define w2815                               186
#define w2816                               187
#define w2817                               188
#define w292                                189
#define w293A                               190
#define w293B                               191
#define w295                                192
#define w297                                193
#define w298A                               194
#define w298B                               195
#define w298C                               196
#define w298D                               197
#define w298E                               198
#define w298F                               199
#define w299                                200
#define w2A1A                               201
#define w2A1B                               202
#define w2A1C                               203
#define w2A1D                               204
#define w2A1E                               205
#define w2A2A                               206
#define w2A2B                               207
#define w2A2C                               208
#define w2A4A                               209
#define w2A4B                               210
#define w2A5A                               211
#define w2A5B                               212
#define w2A6A                               213
#define w2A6B                               214
#define w2A6C                               215
#define w2A6D                               216
#define w2A7A                               217
#define w2A7B                               218
#define w2A8A                               219
#define w2A8B                               220
#define w2A9                                221
#define w2A11                               222
#define w2A12A                              223
#define w2A12B                              224
#define w2B1A                               225
#define w2B1B                               226
#define w2B6                                227
#define w2B9                                228
#define w2B10A                              229
#define w2B10B                              230
#define w2B11                               231
#define w2B12                               232
#define w2B14                               233
#define w2C6A                               234
#define w2C6B                               235
#define w2C7A                               236
#define w2C7B                               237
#define w2C9                                238
#define w2C10                               239
#define w2C11A                              240
#define w2C11B                              241
#define w2D3A                               242
#define w2D3B                               243
#define w2D4A                               244
#define w2D4B                               245
#define w2D5A                               246
#define w2D5B                               247
#define w2D6                                248
#define w2D11A                              249
#define w2D11B                              250
#define w2D12                               251
#define w2D13                               252
#define w2D14A                              253
#define w2D14B                              254
#define w2D15A                              255
#define w2D15B                              256
#define w2D16A                              257
#define w2D16B                              258
#define w2E2A                               259
#define w2E2B                               260
#define w2E4A                               261
#define w2E4B                               262
#define w2E5A                               263
#define w2E5B                               264
#define w2E6A                               265
#define w2E6B                               266
#define w2E7A                               267
#define w2E7B                               268
#define w2F2A                               269
#define w2F2B                               270
#define w2F4A                               271
#define w2F4B                               272
#define w2F5A                               273
#define w2F5B                               274
#define w2F6A                               275
#define w2F6B                               276
#define w2F7A                               277
#define w2F7B                               278
#define w2F8A                               279
#define w2F8B                               280
#define w2G2A                               281
#define w2G2B                               282
#define w2G2C                               283
#define w2G2D                               284
#define w2G3A                               285
#define w2G3B                               286
#define w2G3C                               287
#define w2G3D                               288
#define w2G4                                289
#define w2G5                                290
#define w2G6                                291
#define w2G7                                292
#define w2G8                                293
#define w2G9                                294
#define w2H1A                               295
#define w2H1B                               296
#define w2H5A                               297
#define w2H5B                               298
#define w2H6A                               299
#define w2H6B                               300
#define w2H7                                301
#define w2I2                                302
#define w2I3A                               303
#define w2I3B                               304
#define w2I3C                               305
#define w2I3D                               306
#define w2I4A                               307
#define w2I4B                               308
#define w2L2                                309
#define w2L3                                310
#define w2L4A                               311
#define w2L4B                               312
#define w2M1                                313
#define w2M4A                               314
#define w2M4B                               315
#define w2M5A                               316
#define w2M5B                               317
#define w2M6                                318
#define w2M7                                319
#define w2M8A                               320
#define w2M8B                               321
#define w2M15A                              322
#define w2M15B                              323
#define w2M16A                              324
#define w2M16B                              325
#define w2M17A                              326
#define w2M17B                              327
#define w2P1A                               328
#define w2P1B                               329
#define w2P1C                               330
#define w2P1D                               331
#define w2P2A                               332
#define w2P2B                               333
#define w2P3A                               334
#define w2P3B                               335
#define w2P5A                               336
#define w2P5B                               337
#define w2P5C                               338
#define w2P5D                               339
#define w2P6                                340
#define w2R2A                               341
#define w2R2B                               342
#define w2R3                                343
#define w2R4A                               344
#define w2R4B                               345
#define w2R5A                               346
#define w2R5B                               347
#define w2R6A                               348
#define w2R6B                               349
#define w2R7A                               350
#define w2R7B                               351
#define w2R8                                352
#define w2R9                                353
#define w2S2A                               354
#define w2S2B                               355
#define w2S3A                               356
#define w2S3B                               357
#define w2S4A                               358
#define w2S4B                               359
#define w2S5A                               360
#define w2S5B                               361
#define w2S6A                               362
#define w2S6B                               363
#define w2S7A                               364
#define w2S7B                               365
#define w2Q5A                               366
#define w2Q5B                               367
#define w2Q7A                               368
#define w2Q7B                               369
#define w2Q7C                               370
#define w2Q7D                               371
#define w2Q7E                               372
#define w2Q11A                              373
#define w2Q11B                              374
#define w2Q14                               375
#define wCUO254A                            376
#define wCUO254B                            377
#define wCUO254C                            378
#define wCUO254D                            379
#define wCUO254E                            380
#define wCUO252A                            381
#define wCUO252B                            382
#define wCUO251A                            383
#define wCUO251B                            384
#define wCUO251C                            385
#define wCUO251D                            386
#define wCUO251E                            387
#define wCUO253A                            388
#define wCUO253B                            389
#define wCUO253C                            390
#define wCUO255                             391
#define w2517a                              392
#define w2517b                              393
#define w271a                               394
#define w271b                               395
#define w281a                               396
#define w281b                               397
#define w291a                               398
#define w291b                               399
#define w2B3a                               400
#define w2B3b                               401
#define w2B5a                               402
#define w2B5b                               403
#define w2B8a                               404
#define w2B8b                               405
#define w2E1a                               406
#define w2E1b                               407
#define w2F1a                               408
#define w2F1b                               409
#define w2H2a                               410
#define w2H2b                               411
#define w2H3a                               412
#define w2H3b                               413
#define w2I1a                               414
#define w2I1b                               415
#define w2M12a                              416
#define w2M12b                              417
#define w2M14a                              418
#define w2M14b                              419
#define w2M19a                              420
#define w2M19b                              421
#define w2M21a                              422
#define w2M21b                              423
#define w2R1a                               424
#define w2R1b                               425
#define w2S1a                               426
#define w2S1b                               427
#define w2T1a                               428
#define w2T1b                               429
#define w211a                               430
#define w211b                               431
#define w2514a                              432
#define w2514b                              433
#define w212a                               434
#define w212b                               435
#define w214a                               436
#define w214b                               437
#define w2516a                              438
#define w2516b                              439
#define w2B2a                               440
#define w2B2b                               441
#define w2B4a                               442
#define w2B4b                               443
#define w2B7a                               444
#define w2B7b                               445
#define w2C1a                               446
#define w2C1b                               447
#define w2C2a                               448
#define w2C2b                               449
#define w2C3a                               450
#define w2C3b                               451
#define w2C4a                               452
#define w2C4b                               453
#define w2C5a                               454
#define w2C5b                               455
#define w2D1a                               456
#define w2D1b                               457
#define w2E3a                               458
#define w2E3b                               459
#define w2F3A                               460
#define w2F3B                               461
#define w2G1a                               462
#define w2G1b                               463
#define w2H4a                               464
#define w2H4b                               465
#define w2L1a                               466
#define w2L1b                               467
#define w2M3a                               468
#define w2M3b                               469
#define w2M11a                              470
#define w2M11b                              471
#define w2M13a                              472
#define w2M13b                              473
#define w2M18a                              474
#define w2M18b                              475
#define w2M20a                              476
#define w2M20b                              477
#define w2P4a                               478
#define w2P4b                               479
#define w2Q3a                               480
#define w2Q3b                               481
#define w2Q4a                               482
#define w2Q4b                               483
#define w121a                               484
#define w121b                               485
#define w163a                               486
#define w163b                               487
#define w183a                               488
#define w183b                               489
#define w1A1a                               490
#define w1A1b                               491
#define w1C1a                               492
#define w1C1b                               493
#define w131a                               494
#define w131b                               495
#define w153a                               496
#define w153b                               497
#define w154a                               498
#define w154b                               499
#define w171a                               500
#define w171b                               501
#define w1B1a                               502
#define w1B1b                               503
#define w1B2a                               504
#define w1B2b                               505
#define w144A                               506
#define w144B                               507
#define w145                                508
#define w1D10A                              509
#define w1D10B                              510
#define w1D10C                              511
#define w1F1A                               512
#define w1F1B                               513
#define w1F5A                               514
#define w1F5B                               515
#define w1F5C                               516
#define w411                                517
#define w413A                               518
#define w413B                               519
#define w421A                               520
#define w421B                               521
#define w421C                               522
#define w425                                523
#define w428A                               524
#define w428B                               525
#define w442A                               526
#define w443A                               527
#define w444A                               528
#define w454A                               529
#define w454B                               530
#define w4510                               531
#define w461                                532
#define w462                                533
#define w465A                               534
#define w465B                               535
#define w465C                               536
#define w4613                               537
#define w4614A                              538
#define w4614B                              539
#define w4614C                              540
#define w4616                               541
#define w4618A                              542
#define w4618B                              543
#define w4619                               544
#define w4620                               545
#define w481                                546
#define w482A                               547
#define w482B                               548
#define w492A                               549
#define w492B                               550
#define w493A                               551
#define w493BA                              552
#define w493BB                              553
#define w494BA                              554
#define w494BB                              555
#define w495A                               556
#define w495B                               557
#define w496A                               558
#define w496B                               559
#define w497A                               560
#define w497B                               561
#define w498A                               562
#define w498B                               563
#define w499A                               564
#define w499B                               565
#define w4910A                              566
#define w4910B                              567
#define w4910C                              568
#define w4915                               569
#define w4916                               570
#define w4A1A                               571
#define w4A1B                               572
#define w4A2A                               573
#define w4A2B                               574
#define w494A                               575
#define w442B                               576
#define w443B                               577
#define w444B                               578
#define w4612                               579
#define w453                                580
#define w311A                               581
#define w311B                               582
#define w312                                583
#define w313                                584
#define w315                                585
#define w316                                586
#define w317                                587
#define w318                                588
#define w319                                589
#define w3112                               590
#define w3113                               591
#define w3114                               592
#define w3115                               593
#define w3116                               594
#define w3117                               595
#define w3119                               596
#define w3120                               597
#define w323A                               598
#define w323B                               599
#define w337A                               600
#define w337B                               601
#define w342A                               602
#define w342B                               603
#define w344                                604
#define w345                                605
#define w349A                               606
#define w349B                               607
#define w349C                               608
#define w3415                               609
#define w3416                               610
#define w343A                               611
#define w343B                               612
#define w331A                               613
#define w331B                               614
#define w339A                               615
#define w339B                               616
#define w351A                               617
#define w351B                               618
#define w361A                               619
#define w361B                               620
#define w362A                               621
#define w362B                               622
#define w363A                               623
#define w363B                               624
#define w352A                               625
#define w352B                               626
#define w352C                               627
#define w352D                               628
#define w353A                               629
#define w353B                               630
#define w353C                               631
#define w353D                               632
#define w355                                633
#define w356                                634
#define w371A                               635
#define w371B                               636
#define w375                                637
#define w376                                638
#define w377                                639
#define w378                                640
#define w394                                641
#define w395                                642
#define w396                                643
#define w397                                644
#define w398                                645
#define w399                                646
#define w3910                               647
#define w3911                               648
#define w3912                               649
#define w3913                               650
#define w3B21                               651
#define w3B24A                              652
#define w3B24B                              653
#define w3B25A                              654
#define w3B25B                              655
#define w3C4A                               656
#define w3C4B                               657
#define w3C5A                               658
#define w3C5B                               659
#define w374A                               660
#define w374B                               661
#define w347A                               662
#define w347B                               663
#define w354A                               664
#define w354B                               665
#define w3417                               666
#define w384A                               667
#define w384B                               668
#define w384C                               669
#define w384D                               670
#define w392                                671
#define wB451                               672
#define w197                                673
#define w228                                674
#define w2D8                                675
#define w2D9                                676
#define w2D9B                               677
#define w2D10                               678
#define w2Q8                                679
#define w2Q9                                680
#define w2Q9B                               681
#define w2Q10                               682
#define w422                                683
#define w424                                684
#define w1D7                                685
#define w3118                               686
#define w3B22                               687
#define wCIAERRORE                          688
#define wCIAPULSANTE                        689
#define wPDAPULSANTE                        690
#define wPDAALERT                           691
#define wPDAOFF                             692
#define wSCANPULSANTE                       693
#define w2T2A                               694
#define w2T2B                               695
#define w2T3A                               696
#define w2T3B                               697
#define w2T4A                               698
#define w2T4B                               699
#define w2T5A                               700
#define w2T5B                               701
#define w2T6A                               702
#define w2T6B                               703
#define w2T7A                               704
#define w2T7B                               705
#define w4618C                              706
#define w3C2A                               707
#define w3C2B                               708
#define w2D7A                               709
#define w2D7B                               710
#define w148A                               711
#define w148B                               712
#define w148C                               713
#define w325                                714
#define w3414A                              715
#define w3414B                              716
#define w3419                               717
#define w36MIDA                             718
#define w36MISA                             719
#define w36MSDA                             720
#define w36PBDBA                            721
#define w36PBSBA                            722
#define w36PSDB                             723
#define w3B2                                724
#define w3B3                                725
#define w3B4                                726
#define w3B5                                727
#define w3B8                                728
#define w3B9A                               729
#define w3B10A                              730
#define w3B19                               731
#define w3B20                               732
#define w36PBDBB                            733
#define w36PBSBB                            734
#define w3B9B                               735
#define w3B10B                              736
#define w3B9C                               737
#define w3B10C                              738
#define wCUO256A                            739
#define wCUO256B                            740
#define wCUO256C                            741
#define wCUO256D                            742
#define wCUO256E                            743
#define wCUO258A                            744
#define wCUO258B                            745
#define wCUO2T1A                            746
#define wCUO2T1B                            747
#define wCUO2T1C                            748
#define wCUS131A                            749
#define wCUS131B                            750
#define wCUS131C                            751
#define wCUS131D                            752
#define wCUS131E                            753
#define wCUS133                             754
#define wCUS134                             755
#define wCUS2G2                             756
#define wCUS2M1A                            757
#define wCUS2M1B                            758
#define wCUS2M1C                            759
#define wCUS2M1D                            760
#define wCUS2M1E                            761
#define wCUS2M2A                            762
#define wCUS2M2B                            763
#define wCUS2M2C                            764
#define wCUS2M3A                            765
#define wCUS2M3B                            766
#define wCUS2M3C                            767
#define wCUS2M3D                            768
#define wCUS2M3E                            769
#define wCUS2M3F                            770
#define wCUS2M3G                            771
#define wDOM221A                            772
#define wDOM221B                            773
#define wDOM221C                            774
#define wDOM221D                            775
#define wDOM221E                            776
#define wDOM221F                            777
#define wDOM261A                            778
#define wDOM261B                            779
#define wDOM263A                            780
#define wDOM263B                            781
#define wDOM263C                            782
#define wDOM265                             783
#define wDOM281A                            784
#define wDOM281B                            785
#define wGIA141                             786
#define wGIA142                             787
#define wGIA181A                            788
#define wGIA181B                            789
#define wGIA181C                            790
#define wGIA183A                            791
#define wGIA183B                            792
#define wGIA183C                            793
#define wGIA183D                            794
#define wGIA1A1A                            795
#define wGIA1A1B                            796
#define wGIA1A1C                            797
#define wGIA1A2A                            798
#define wGIA1A2B                            799
#define wGIA1A2C                            800
#define wGIA1A2D                            801
#define wGIA1A4A                            802
#define wGIA1A4B                            803
#define wGIA1A4C                            804
#define wGIA1A5A                            805
#define wGIA1A5B                            806
#define wGIA1A5C                            807
#define wGIA1A5D                            808
#define wGIA2G1A                            809
#define wGIA2G1B                            810
#define wGIA2G1C                            811
#define wGIA2G1D                            812
#define wGIA2G1E                            813
#define wGIA2G1F                            814
#define wMOS273A                            815
#define wMOS273B                            816
#define wMOS273C                            817
#define wMOS274A                            818
#define wMOS274B                            819
#define wMOS2P1                             820
#define wMOS2P2                             821
#define wSER2C1A                            822
#define wSER2C1B                            823
#define wSER2C2A                            824
#define wSER2C2B                            825
#define wSER2C2C                            826
#define wSER2C3A                            827
#define wSER2C3B                            828
#define wSER2C3C                            829
#define wSER2C3D                            830
#define wSER2C4A                            831
#define wSER2C4B                            832
#define wSER2C5A                            833
#define wSER2C5B                            834
#define wSER2C6A                            835
#define wSER2C6B                            836
#define wSER2C7A                            837
#define wSER2C7B                            838
#define wSER2C7C                            839
#define wSER2C8A                            840
#define wSER2C8B                            841
#define wSER2C8C                            842
#define wSER2C8D                            843
#define wSER2C9A                            844
#define wSER2C9B                            845
#define wSER2C10A                           846
#define wSER2C10B                           847
#define wSER2I1A                            848
#define wSER2I1B                            849
#define wSER2I2                             850
#define wSER2P1A                            851
#define wSER2P1B                            852
#define wSER2P2A                            853
#define wSER2P2B                            854
#define wSER2P2C                            855
#define wSER2P3A                            856
#define wSER2P3B                            857
#define wSER2P3C                            858
#define wSER2P3D                            859
#define wSER2P4A                            860
#define wSER2P4B                            861
#define wSER2P5A                            862
#define wSER2P5B                            863
#define wSER2Q1A                            864
#define wSER2Q1B                            865
#define wSER2Q1C                            866
#define wSER2Q3A                            867
#define wSER2Q3B                            868
#define wSER2Q3C                            869
#define wSER2Q3D                            870
#define wSUP261A                            871
#define wSUP261B                            872
#define wSUP261C                            873
#define wSUP262A                            874
#define wSUP262B                            875
#define wSUP291A                            876
#define wSUP291B                            877
#define wSUP291C                            878
#define wSUP295A                            879
#define wSUP295B                            880
#define wSUP295C                            881
#define wSUP296A                            882
#define wSUP296B                            883
#define wSUP297                             884
#define wPASSODESTROPIETRA2                 885
#define wPASSOSINISTROPIETRA2               886
#define wDAR1A1B                            887
#define wDAR1A1CA                           888
#define wDAR1A1CB                           889
#define wDAR1A1CC                           890
#define wCOL1A2AA                           891
#define wCOL1A2AB                           892
#define wCOL1A2AC                           893
#define wCOL1A2AD                           894
#define wSUP1A2AA                           895
#define wSUP1A2AB                           896
#define wDAR1A3AA                           897
#define wDAR1A3AB                           898
#define wVIC1A3AA                           899
#define wVIC1A3AB                           900
#define wCUO2T2AA                           901
#define wCUO2T2AB                           902
#define wPSG1C3A                            903
#define wVIV451A                            904
#define wVIV451B                            905
#define wVIV452AA                           906
#define wVIV452AB                           907
#define wCAC1A5A                            908
#define wCAC1A5B                            909
#define wVIC212A                            910
#define wVIC291A                            911
#define wSUP291CA                           912
#define wSUP291CB                           913
#define wSUP291CC                           914
#define wSUP291CD                           915
#define wSUP291CE                           916
#define wVIC291C                            917
#define wVIV471AA                           918
#define wVIV471AB                           919
#define wJUD222B                            920
#define wVIV471B                            921
#define wDAR421A                            922
#define wDAR481A                            923
#define wDAR481B                            924
#define wDAR482IN                           925
#define wVIC482IN                           926
#define wCAC482C                            927
#define wKREI347A                           928
#define wKREI347BA                          929
#define wKREI347BB                          930
#define wCORI347A                           931
#define wKREI347EA                          932
#define wKREI347EB                          933
#define wKREI347EC                          934
#define wDUKI347DA                          935
#define wDUKI347DB                          936
#define wDUKI347DC                          937
#define wDUKI347DD                          938
#define wDUKI347DE                          939
#define wDUKI347DF                          940
#define wGREI347AA                          941
#define wGREI347AB                          942
#define wDUKI347FA                          943
#define wDUKI347FB                          944
#define wGREI347BA                          945
#define wGREI347BB                          946
#define wAND007C                            947
#define wCUO009AA                           948
#define wCUO009AB                           949
#define wCUO009AC                           950
#define wCUO009BA                           951
#define wCUO009BB                           952
#define wDAR009                             953
#define wGIA1A3A                            954
#define wGIA1A3B                            955
#define wGIA1A3C                            956
#define wKRE481A                            957
#define wDAR000BA                           958
#define wDAR000BB                           959
#define wDAR000BC                           960
#define wDAR000BD                           961
#define wDAR000E                            962
#define wDAR000J                            963
#define wCARLOOP                            964
#define wCARLOOP2                           965
#define wCARSTART                           966
#define wCARSTOP                            967
#define wDAR000TAA                          968
#define wDAR000TAB                          969
#define wDAR000TAC                          970
#define wVIV47A                             971
#define wPET000E                            972
#define wR1F1A                              973
#define wR1F1B                              974
#define wR1F1C                              975
#define wR1F1D                              976
#define wR1F1E                              977
#define wSABBIAA                            978
#define wSABBIAB                            979
#define wSABBIAC                            980
#define wSABBIAD                            981
#define wVIC1A5                             982
#define wRAGGIOSTART                        983
#define wCAC2A1                             984
#define wVIC221B                            985
#define wDOM221AA                           986
#define wDOM221AB                           987
#define wDAR2C1A                            988
#define wDAR2C1B                            989
#define wDOM221BA                           990
#define wDOM221BB                           991
#define wDAR_DOOR_A92A                      992
#define wDAR_DOOR_A92B                      993
#define wGREI347CA                          994
#define wGREI347CB                          995
#define wVICI347B                           996
#define wDARI347A                           997
#define wVIC491B                            998
#define wV_3G1A                             999
#define wC_3G1A                             1000
#define wC_3G1B                             1001
#define wC_3G1C                             1002
#define wO_3G1A                             1003
#define wO_3G1B                             1004
#define wPASSODESTROTAPPETO6                1005
#define wPASSOSINISTROTAPPETO6              1006
#define wPASSODESTROTAPPETO7                1007
#define wPASSOSINISTROTAPPETO7              1008
#define wPASSODESTROTAPPETO8                1009
#define wPASSOSINISTROTAPPETO8              1010
#define wPASSODESTROFERRO                   1011
#define wPASSOSINISTROFERRO                 1012
#define wELICOTTERO                         1013
#define wSVEGLIA                            1014
#define wFONTANA                            1015
#define wLAVATRICE                          1016
#define wSUP291AB                           1017
#define wSER1A1                             1018
#define wSER1A2                             1019
#define w336                                1020
#define wNASTROFFWDDAR                      1021
#define wNASTROFFWDVIC                      1022
#define wNASTROSTARTDAR                     1023
#define wNASTROSTARTVIC                     1024
#define w425B                               1025
#define w444C                               1026
#define w157B                               1027
#define w157C                               1028
#define w157D                               1029
#define w157E                               1030
#define wDOM262                             1031
#define w147A                               1032
#define w147B                               1033
#define w2B13                               1034
#define w194A                               1035
#define w194B                               1036
#define w194C                               1037
#define w293C                               1038
#define w2A3                                1039
#define w2A14                               1040
#define w1A7                                1041
#define w259                                1042
#define w3111                               1043
#define wCAMINETTO                          1044
#define wPOMPA                              1045
#define wRINGHIERAA                         1046
#define wRINGHIERAB                         1047
#define wCOLONA                             1048
#define wCOLONB                             1049
#define wCOLONC                             1050
#define wCUO257A                            1051
#define wCUO257B                            1052
#define wCUO257C                            1053
#define w391A                               1054
#define w391B                               1055
#define wPFERRODX                           1056
#define wPFERROSX                           1057
#define w1D11A                              1058
#define w1D11B                              1059
#define w372                                1060
#define wPASSODESTROCOTTO2                  1061
#define wPASSOSINISTROCOTTO2                1062
#define wPENDOLO                            1063
#define wMARMOFAKE1                         1064
#define wTAPPETOFAKEDX1                     1065
#define wTAPPETOFAKESX1                     1066
#define wTAPPETOFAKE2                       1067
#define wMARMOFAKEDX2                       1068
#define wMARMOFAKESX2                       1069
#define wMARMOFAKE3                         1070
#define wSPAROLENTO                         1071
#define wTIC                                1072
#define wTAC                                1073
#define wDOM2D1                             1074
#define wDOM241                             1075
#define wLEYLINES                           1076
#define wCLICK                              1077
#define wMODEM                              1078
#define w231074                             1079
#define wCAC482B                            1080
#define wCAC482KA                           1081
#define wCAC482KB                           1082
#define wCAC482KC                           1083
#define wCAC482KD                           1084
#define wCAC482KE                           1085
#define wCAC482KF                           1086
#define wMANETTEA                           1087
#define wMANETTEB                           1088
#define wPORTA421                           1089
#define wPORTA421A                          1090
#define wCUOREBRUCIA                        1091
#define wGREIPORTA                          1092
#define wDUKIFIN                            1093
#define wSCALATAA                           1094
#define wSCALATAB                           1095
#define wSCALATAC                           1096
#define wPORTACHIUSA                        1097
#define wMODEMFULL                          1098
#define wVIC2C1A                            1099
#define wVIC2C1B                            1100
#define wDAR2C1                             1101
#define w48PORTA                            1102
#define wCAC482CTEL                         1103

/* -----------------17/03/98 10.21-------------------
 *                      Menu
 * --------------------------------------------------*/
#define mNULL                               0
#define mPREDIALOG1                         1
#define mPREDIALOG2                         2
#define mPREDIALOG3                         3
#define mPREDIALOG4                         4
#define mENDDIALOG1                         5
#define mENDDIALOG2                         6
#define mENDDIALOG3                         7
#define mQUIT                               9
#define mMAIN                               10
#define mRTV                                11
#define mRTV2                               12
#define mRTV3                               13
#define mCUOCO                              20
#define mCUOCO1                             21
#define mCUOCO2                             22
#define mDOMESTICA                          30
#define mDOMESTICA1                         31
#define mDOMESTICA2                         32
#define mGIARDINIERE                        40
#define mGIARDINIERE1                       41
#define mGIARDINIERE2                       42
#define mGIARDINIERE3                       43
#define mCUSTODE                            50
#define mCUSTODE1                           51
#define mCUSTODE2                           52
#define mSERVETTA                           60
#define mSERVETTA1                          61
#define mSERVETTA2                          62
#define mSUPERVISORE                        70
#define mSUPERVISORE1                       71
#define mSUPERVISORE2                       72
#define mSUPERVISORE3                       73
#define mSUPERVISORE4                       74
#define mMOGLIESUPERVISORE                  80
#define mMOGLIESUPERVISORE1                 81
#define mMOGLIESUPERVISORE2                 82
#define mMOGLIESUPERVISORE3                 83
#define mMOGLIESUPERVISORE4                 84
#define mMOGLIESUPERVISORE5                 85
#define mCOSEFATTI                          90
#define mCOSEFATTI1                         91
#define mCOSEFATTI2                         92
#define mCOSEFATTI3                         93
#define mCOSEFATTI4                         94
#define mCOSEFATTI5                         95
#define mCOSEFATTI6                         96
#define mCOSEFATTI7                         97
#define mCOSEFATTI8                         98
#define mCOSEFATTI9                         99

/* -----------------17/03/98 10.21-------------------
 *                      Diary
 * --------------------------------------------------*/
#define eNULL                               0
#define eCUOCO1                                                         2
#define eCUOCO2                                                         3
#define eCUOCO3                                                         4
#define eCUOCO4                                                         5
#define eCUOCO5                                                         6
#define eDOMESTICA1                                                     7
#define eDOMESTICA2                                                     8
#define eDOMESTICA3                                                     9
#define eDOMESTICA4                                                     10
#define eDOMESTICA5                                                     11
#define eDOMESTICA6                                                     12
#define eGIARDINIERE1                                                   13
#define eGIARDINIERE2                                                   14
#define eGIARDINIERE3                                                   15
#define eCUSTODE0                                                       16
#define eCUSTODE1                                                       17
#define eCUSTODE2_prima                                                 18
#define eCUSTODE2_dopo                                                  19
#define eCUSTODE3                                                       20
#define eCUSTODE4_prima                                                 21
#define eCUSTODE4_dopo                                                  22
#define eCUSTODE5                                                       23
#define eCUSTODE6                                                       24
#define eSERVETTA1                                                      25
#define eSERVETTA2                                                      26
#define eSERVETTA3                                                      27
#define eSERVETTA4                                                      28
#define eSERVETTA5                                                      29
#define eSERVETTA6                                                      30
#define eSUPERVISORE0                                                   31
#define eSUPERVISORE1                                                   32
#define eSUPERVISORE2                                                   33
#define eSUPERVISORE3                                                   34
#define eSUPERVISORE4                                                   35
#define eMOGLIESUPERVISORE1                                             36
#define eMOGLIESUPERVISORE2                                             37
#define eKRENN1                                                         38

/* -----------------17/03/98 10.21---------------------
 *                      Dialogs
 * --------------------------------------------------*/
#define dNULL                               0

// in questi rtv si vede il mouse
#define dCUOCO                              1
#define dCUSTODE                            2
#define dDOMESTICA                          3
#define dGIARDINIERE                        4
#define dMOGLIESUPERVISORE                  5
#define dSERVETTA                           6
#define dSUPERVISORE                        7

// in questi rtv il mouse viene nascosto
#define dCUOCO_INTERRUPT1                   8
#define dCUOCO_INTERRUPT2                   9
#define dCUSTODE_INTERRUPT1                 10
#define dCUSTODE_INTERRUPT2                 11
#define dCUSTODE_INTERRUPT3                 12
#define dCUSTODE_INTERRUPT4                 13
#define dCUSTODE_INTERRUPT5                 14
#define dDOMESTICA_INTERRUPT1               15
#define dDOMESTICA_INTERRUPT2               16
#define dGIARDINIERE_INTERRUPT1             17
#define dGIARDINIERE_INTERRUPT2             18
#define dMOGLIESUP_INTERRUPT1               19
#define dMOGLIESUP_INTERRUPT2               20
#define dR000                               21
#define dR001                               22
#define dR0010                              23
#define dR0014_left                         24
#define dR0014_right                        25
#define dR002                               26
#define dR003                               27
#define dR004                               28
#define dR005                               29
#define dR006                               30
#define dR007                               31
#define dR008                               32
#define dR009                               33
#define dR015                               34
#define dR111                               35
#define dR1A2                               36
#define dR1A3                               37
#define dR1A5                               38
#define dR1C1                               39
#define dR1C1_fine                          40
#define dR1C2                               41
#define dR1C3                               42
#define dR1E1                               43
#define dR1F1                               44
#define dR1a1                               45
#define dR1a1_fine_DARRELL                  46
#define dR1a1_fine_VICTORIA                 47
#define dR1a3                               48
#define dR1a4                               49
#define dR211                               50
#define dR211_dlg                           51
#define dR212                               52
#define dR221                               53
#define dR222                               54
#define dR241                               55
#define dR291                               56
#define dR2A1                               57
#define dR2C1                               58
#define dR2D1                               59
#define dR2P0                               60
#define dR2P1                               61
#define dR2T1                               62
#define dR2T2                               63
#define dR321_DAR                           64
#define dR321_VIC                           65
#define dR347_DARRELL_PART1                 66
#define dR347_DARRELL_PART2                 67
#define dR347_VICTORIA_PART1                68
#define dR347_VICTORIA_PART2                69
#define dR371                               70
#define dR391                               71
#define dR411                               72
#define dR421_DAR                           73
#define dR421_VIC                           74
#define dR421_fine                          75
#define dR42_porta                          76
#define dR451                               77
#define dR452                               78
#define dR461                               79
#define dR471                               80
#define dR481                               81
#define dR482                               82
#define dR483                               83
#define dR483_finale                        84
#define dR48KRENNSPARA                      85
#define dR48_chiavi                         86
#define dR491                               87
#define dRCALLOTHERPLAYER                   88
#define dRCARTELLINA1                       89
#define dRCARTELLINA2                       90
#define dRCARTELLINA3                       91
#define dRCARTELLINA4                       92
#define dRCARTELLINA5                       93
#define dRCARTELLINA6                       94
#define dRCARTELLINA7                       95
#define dRCARTELLINA8                       96
#define dRCARTELLINAC                       97
#define dRGAMEOVER                          98
#define dRLOGHI                             99
#define dROLDPARCHMENT                      100
#define dRUN_R1a1_CENTER                    101
#define dRUN_R1a1_RIGHT                     102
#define dRWALKMAN                           103
#define dRWATCHMAKERSLETTER                 104
#define dSUPERVISORE_INTERRUPT1             105
#define dSUPERVISORE_INTERRUPT2             106
#define dSUPERVISORE_INTERRUPT3             107
#define dSUPERVISORE_INTERRUPT4             108
#define dR391_end                           109
#define dPROVA                              110

/* -----------------23/06/00 16.38---------109------------
*                    Music
* ----------------------------------------------------*/
#define nNULL                               0
#define nPROVA                              1
#define nPROVA2                             2
#define nBACK1                              3
#define nBACK2                              4
#define nBACK3                              5
#define nBACK4                              6
#define nCRIPTA                             7
#define nCHIESA                             8
#define nCACCIATORE                         9
#define nOROLOGIAIO                         10
#define nINSEGUIMENTO                       11
#define nFRIGO                              12
#define nTRAPPOLA                           13
#define nLABIRINTO                          14
#define nBACK21                            15
#define nBACK22                            16
#define nBACK41                            17
#define nLABIRINTO1                        18
#define nINTRO                             19


/* -----------------15/01/99 16.41-------------------
 *                      T2D
 * --------------------------------------------------*/
#define tNULL                           0
#define tSCANNER                            1
#define tCOMPUTER                           2
#define tPDA                            3
#define tDIARIO                         4
#define tLETTERA                            5
#define tOPTIONS                            6
#define tMAINMENU                           7
#define tGAMEOVER                           8
#define tPROVA                          9

/* -----------------26/04/00 17.01-------------------
 *                  PDA Logs
 * --------------------------------------------------*/
#define lNULL                                                           0
#define lPDA1_TITLE0                            1
#define lPDA1_TITLE1                                                    2
#define lPDA1_MENU1_ITEM1                                               3
#define lPDA1_MENU1_ITEM2                                               4
#define lPDA1_MENU1_ITEM3                                               5
#define lPDA1_MENU1_ITEM4                                               6
#define lPDA1_MENU1_ITEM5                                               7
#define lPDA1_MENU1_ITEM6                                               8
#define lPDA1_MENU1_ITEM7                                               9
#define lPDA1_MENU1_ITEM8                                               10
#define lPDA2_TITLE2                                                    11
#define lPDA2_TITLE3_CUO                                                12
#define lPDA2_MENU3_CUO_ITEM1                                           13
#define lPDA2_MENU3_CUO_ITEM2                                           14
#define lPDA2_MENU3_CUO_ITEM3                                           15
#define lPDA2_TITLE4_DOM                                                16
#define lPDA2_MENU4_DOM_ITEM1                                           17
#define lPDA2_MENU4_DOM_ITEM2                                           18
#define lPDA2_TITLE5_RAUL                                               19
#define lPDA2_MENU5_RAUL_ITEM1                                          20
#define lPDA2_MENU5_RAUL_ITEM2                                          21
#define lPDA2_MENU5_RAUL_ITEM3                                          22
#define lPDA2_MENU5_RAUL_ITEM4                                          23
#define lPDA2_MENU5_RAUL_ITEM5                                          24
#define lPDA2_TITLE6_CUS                                                25
#define lPDA2_MENU6_CUS_ITEM1                                           26
#define lPDA2_MENU6_CUS_ITEM2                                           27
#define lPDA2_MENU6_CUS_ITEM3                                           28
#define lPDA2_MENU6_CUS_ITEM4                                           29
#define lPDA2_TITLE7_SER                                                30
#define lPDA2_MENU7_SER_ITEM1                                           31
#define lPDA2_MENU7_SER_ITEM2                                           32
#define lPDA2_MENU7_SER_ITEM3                                           33
#define lPDA2_TITLE8_SUP                                                34
#define lPDA2_MENU8_SUP_ITEM1                                           35
#define lPDA2_MENU8_SUP_ITEM2                                           36
#define lPDA2_MENU8_SUP_ITEM3                                           37
#define lPDA2_MENU8_SUP_ITEM4                                           38
#define lPDA2_MENU8_SUP_ITEM5                                           39
#define lPDA2_MENU8_SUP_ITEM6                                           40
#define lPDA2_TITLE9_MOGL                                               41
#define lPDA2_MENU9_MOGL_ITEM1                                          42
#define lPDA2_MENU9_MOGL_ITEM2                                          43
#define lPDA3_TITLE10                                                   44
#define lPDA3_TITLE11_CORONA                                            45
#define lPDA3_MENU11_CORONA_ITEM1                                       46
#define lPDA3_MENU11_CORONA_ITEM2                                       47
#define lPDA3_MENU11_CORONA_ITEM3                                       48
#define lPDA3_TITLE12_DUKES                                             49
#define lPDA3_MENU12_DUKES_ITEM1                                        50
#define lPDA3_MENU12_DUKES_ITEM2                                        51
#define lPDA3_TITLE13_KRENN                                             52
#define lPDA3_MENU13_KRENN_ITEM1                                        53
#define lPDA3_MENU13_KRENN_ITEM2                                        54
#define lPDA3_TITLE14_VALENCIA                                          55
#define lPDA3_MENU14_VALENCIA_ITEM1                                     56
#define lPDA3_MENU14_VALENCIA_ITEM2                                     57
#define lPDA3_TITLE15_CONCLUSIONS                                       58
#define lPDA3_MENU15_CONCLUSIONS_ITEM1                                  59
#define lPDA3_MENU15_CONCLUSIONS_ITEM2                                  60
#define lPDA3_MENU15_CONCLUSIONS_ITEM3                                  61
#define lPDA3_MENU15_CONCLUSIONS_ITEM4                                  62
#define lPDA4_TITLE16                                                   63
#define lPDA4_TITLE17                                                   64
#define lPDA4_MENU17_ITEM1                                              65
#define lPDA4_TITLE18                                                   66
#define lPDA4_MENU18_ITEM1                                              67
#define lPDA4_TITLE19                                                   68
#define lPDA4_MENU19_ITEM1                                              69
#define lPDA4_TITLE20                                                   70
#define lPDA4_MENU20_ITEM1                                              71
#define lPDA4_TITLE21                                                   72
#define lPDA4_MENU21_ITEM1                                              73
#define lPDA5_TITLE22                                                   74
#define lPDA5_TITLE23                                                   75
#define lPDA5_MENU23_ITEM1                                              76
#define lPDA5_MENU23_ITEM2                                              77
#define lPDA5_TITLE24                                                   78
#define lPDA5_MENU24_ITEM1                                              79
#define lPDA5_TITLE25                                                   80
#define lPDA5_MENU25_ITEM1                                              81
#define lPDA5_TITLE26                                                   82
#define lPDA5_MENU26_ITEM1                                              83
#define lPDA5_MENU26_ITEM2                                              84
#define lPDA5_MENU26_ITEM3                                              85
#define lPDA5_TITLE27                                                   86
#define lPDA5_MENU27_ITEM1                                              87
#define lPDA6_TITLE28                                                   88
#define lPDA6_TITLE29                                                   89
#define lPDA6_MENU29_ITEM1                                              90
#define lPDA6_MENU29_ITEM2                                              91
#define lPDA6_TITLE30                                                   92
#define lPDA6_MENU30_ITEM1                                              93
#define lPDA6_TITLE31                                                   94
#define lPDA6_MENU31_ITEM1                                              95
#define lPDA6_MENU31_ITEM2                                              96
#define lPDA6_TITLE32                                                   97
#define lPDA6_MENU32_ITEM1                                              98
#define lPDA6_MENU32_ITEM2                                              99
//aggiunte
#define lPDA5_MENU25_ITEM2                                              100

/* -----------------17/03/98 10.21-------------------
 *                      END.
 * --------------------------------------------------*/

} // End of namespace Watchmaker

#endif // WATCHMAKER_DEFINE_H
