# Release Notes v0.11.1 : BDD and ZBDD Optimizations

This release implements apparent, natural BDD-ZBDD optimizations
that lead to simplicity or don't introduce much complexity.


## Major Changes

- Stricter application of the set order cut-off for ZBDD

    * Increased ZBDD/MOCUS performance sensitivity to the cut-off
    * Cut-off awareness of ZBDD cut-set extraction
      (~2x improvement of the extraction speed)

- Intrusive reference counting for BDD and ZBDD vertices.
  (around 20% speed and memory improvements)

- Intrusive hash table for BDD and ZBDD unique tables.
  (10-30% speed and memory improvements)

- BDD and ZBDD node management without garbage collectors.
  (10-30% speed improvement)


## Minor Changes

- Faster and more efficient reporting of analysis results with XML streams.
  (200,000 cut sets per second with minimal memory overhead)

- Cross-validation of qualitative analysis algorithms with the Fuzz tester.


## Removed Features

- Experimental support for
  nested Boolean formulae and nested parentheses in the shorthand format.


## Bug Fixes

- Missing check for negative literal approximations
  in application of minimal cut set order cut-offs (ZBDD/MOCUS). (#128)

- Incorrect check for cloning constraints
  in common argument decomposition processing.
  The decomposition code fails to correctly determine
  if the no-clone operation has a side effect outside of the sub-graph. (#128)

- Undefined behavior (int overflow)
  in probability calculations of CCF MGL and Alpha Models
  with many members (> 12)
  and high factor levels (>= (# members / 2)).

- Missing proper error messages
  for int overflow or other numerical problems
  in XML input files.

- InvalidArgument error is reported as unexpected
  when it communicates expected errors
  in user configurations and settings.

- Memory leak in validating input files with RelaxNG schema.

- The population standard deviation from Boost accumulators
  isn't adjusted to the sample standard deviation.


## Since v0.11.0

163 commits resulted in 167 files changed, 7034 insertions(+), 39890 deletions(-)

- Core : 61 files changed, 3963 insertions(+), 3230 deletions(-)
- Scripts : 8 files changed, 1894 insertions(+), 2074 deletions(-)
- GUI : no change
- Tests : 68 files changed, 496 insertions(+), 33698 deletions(-)
- Documentation : 15 files changed, 360 insertions(+), 714 deletions(-)
