from __future__ import print_function
from _mock import _Mock




find_executable = _Mock()



class IntelCCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  cc_args = 'fPIC'
  cc_exe = 'icc'
  compiler_type = 'intel'
  dylib_lib_extension = '.dylib'
  dylib_lib_format = 'lib%s%s'
  obj_extension = '.o'
  shared_lib_extension = '.so'
  shared_lib_format = 'lib%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelEM64TCCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  cc_args = '-fPIC'
  cc_exe = 'icc -m64 -fPIC'
  compiler_type = 'intelem'
  dylib_lib_extension = '.dylib'
  dylib_lib_format = 'lib%s%s'
  obj_extension = '.o'
  shared_lib_extension = '.so'
  shared_lib_format = 'lib%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelItaniumCCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  cc_args = 'fPIC'
  compiler_type = 'intele'
  dylib_lib_extension = '.dylib'
  dylib_lib_format = 'lib%s%s'
  obj_extension = '.o'
  shared_lib_extension = '.so'
  shared_lib_format = 'lib%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class UnixCCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compiler_type = 'unix'
  dylib_lib_extension = '.dylib'
  dylib_lib_format = 'lib%s%s'
  obj_extension = '.o'
  shared_lib_extension = '.so'
  shared_lib_format = 'lib%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

