/*
 * Decompiled with CFR 0.152.
 */
package org.openstack.sahara.edp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Arrays;

public class MainWrapper {
    public static void main(String[] args) throws Throwable {
        Throwable exception;
        SecurityManager originalSecurityManager;
        block5: {
            String actionConf = System.getProperty("oozie.action.conf.xml");
            if (actionConf != null) {
                Class<?> configClass = Class.forName("org.apache.hadoop.conf.Configuration");
                Method method = configClass.getMethod("addDefaultResource", String.class);
                method.invoke(null, "action.xml");
            }
            originalSecurityManager = System.getSecurityManager();
            WrapperSecurityManager newSecurityManager = new WrapperSecurityManager(originalSecurityManager);
            System.setSecurityManager(newSecurityManager);
            Class<?> mainClass = Class.forName(args[0]);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
            exception = null;
            try {
                mainMethod.invoke(null, new Object[]{newArgs});
            }
            catch (InvocationTargetException e) {
                if (newSecurityManager.getExitInvoked()) break block5;
                exception = e.getTargetException();
            }
        }
        System.setSecurityManager(originalSecurityManager);
        if (exception != null) {
            throw exception;
        }
        if (newSecurityManager.getExitInvoked()) {
            System.exit(newSecurityManager.getExitCode());
        }
    }

    static class WrapperSecurityManager
    extends SecurityManager {
        private static boolean exitInvoked = false;
        private static int firstExitCode;
        private SecurityManager securityManager;

        public WrapperSecurityManager(SecurityManager securityManager) {
            this.securityManager = securityManager;
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
            if (this.securityManager != null) {
                this.securityManager.checkPermission(perm, context);
            }
        }

        @Override
        public void checkPermission(Permission perm) {
            if (this.securityManager != null) {
                this.securityManager.checkPermission(perm);
            }
        }

        @Override
        public void checkExit(int status) throws SecurityException {
            if (!exitInvoked) {
                exitInvoked = true;
                firstExitCode = status;
            }
            throw new SecurityException("Intercepted System.exit(" + status + ")");
        }

        public static boolean getExitInvoked() {
            return exitInvoked;
        }

        public static int getExitCode() {
            return firstExitCode;
        }
    }
}

