/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file NetTools.hxx
    \author Romain BONDUE
    \date 08/05/2006
    \warning This file should only be included from NetTools.h */
inline nsNet::CInterface::~CInterface () throw() {}


inline unsigned long nsNet::CInterface::GetRXBytes () const throw()
{
    return m_RXBytes;

} // GetRXBytes()


inline unsigned long nsNet::CInterface::GetRXPackets () const throw()
{
    return m_RXPackets;

} // GetRXPackets()


inline unsigned long nsNet::CInterface::GetRXErrors () const throw()
{
    return m_RXErrors;

} // GetRXErrors()


inline unsigned long nsNet::CInterface::GetRXDropped () const throw()
{
    return m_RXDropped;

} // GetRXDropped()


inline unsigned long nsNet::CInterface::GetRXFifo () const throw()
{
    return m_RXFifo;

} // GetRXFifo()


inline unsigned long nsNet::CInterface::GetRXFrame () const throw()
{
    return m_RXFrame;

} // GetRXFrame()


inline unsigned long nsNet::CInterface::GetRXCompressed () const throw()
{
    return m_RXCompressed;

} // GetRXCompressed()


inline unsigned long nsNet::CInterface::GetMulticast () const throw()
{
    return m_Multicast;

} // GetMulticast()


inline unsigned long nsNet::CInterface::GetTXBytes () const throw()
{
    return m_TXBytes;

} // GetTXBytes()


inline unsigned long nsNet::CInterface::GetTXPackets () const throw()
{
    return m_TXPackets;

} // GetTXPackets()


inline unsigned long nsNet::CInterface::GetTXErrors () const throw()
{
    return m_TXErrors;

} // GetTXErrors()


inline unsigned long nsNet::CInterface::GetTXDropped () const throw()
{
    return m_TXDropped;

} // GetTXDropped()


inline unsigned long nsNet::CInterface::GetTXFifo () const throw()
{
    return m_TXFifo;

} // GetTXFifo()


inline unsigned long nsNet::CInterface::GetCollisions () const throw()
{
    return m_Collisions;

} // GetCollisions()



inline unsigned long nsNet::CInterface::GetCarrier () const throw()
{
    return m_Carrier;

} // GetCarrier()


inline unsigned long nsNet::CInterface::GetTXCompressed () const throw()
{
    return m_TXCompressed;

} // GetTXCompressed()


inline nsNet::CIPAddress::CIPAddress (uint32_t Addr) throw()
    : m_Addr (Addr) {}


inline void nsNet::CIPAddress::Set (uint32_t Addr) throw() {m_Addr = Addr;}


inline uint32_t nsNet::CIPAddress::Get () const throw() {return m_Addr;}


inline uint8_t nsNet::CIPAddress::Get (unsigned Pos) const throw()
{
    return reinterpret_cast<const uint8_t*> (&m_Addr) [Pos];

} // Get()


inline void nsNet::CIPAddress::Set (uint8_t Value, unsigned Pos) throw()
{
    reinterpret_cast<uint8_t*> (&m_Addr) [Pos] = Value;

} // Set()


inline const std::string& nsNet::CInterface::GetName () const throw()
{
    return m_IfName;

} // GetName()


inline void nsNet::CInterface::SetName (const std::string& IfName) throw()
{
    m_IfName = IfName;
    ClearStats();

} // SetName()
