// Copyright 2017 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// compile-pass
mod my_mod {
    #[derive(Clone, Copy, Eq, PartialEq, PartialOrd, Ord, Hash)]
    pub struct Name<'a> {
        source: &'a str,
    }

    pub const JSON: Name = Name { source: "JSON" };
}

pub fn crash() -> bool {
  match (my_mod::JSON, None) {
    (_, Some(my_mod::JSON)) => true,
    (my_mod::JSON, None) => true,
    _ => false,
  }
}

fn main() {}
