A visibility qualifier was used where one is not permitted. Visibility
qualifiers are not permitted on enum variants, trait items, impl blocks, and
extern blocks, as they already share the visibility of the parent item.

Erroneous code examples:

```compile_fail,E0449
struct Bar;

trait Foo {
    fn foo();
}

enum Baz {
    pub Qux, // error: visibility qualifiers are not permitted here
}

pub impl Bar {} // error: visibility qualifiers are not permitted here

pub impl Foo for Bar { // error: visibility qualifiers are not permitted here
    pub fn foo() {} // error: visibility qualifiers are not permitted here
}
```

To fix this error, simply remove the visibility qualifier. Example:

```
struct Bar;

trait Foo {
    fn foo();
}

enum Baz {
    // Enum variants share the visibility of the enum they are in, so
    // `pub` is not allowed here
    Qux,
}

// Directly implemented methods share the visibility of the type itself,
// so `pub` is not allowed here
impl Bar {}

// Trait methods share the visibility of the trait, so `pub` is not
// allowed in either case
impl Foo for Bar {
    fn foo() {}
}
```
