A `#[coverage]` attribute was applied to something which does not show up
in code coverage, or is too granular to be excluded from the coverage report.

For now, this attribute can only be applied to function, method, and closure
definitions. In the future, it may be added to statements, blocks, and
expressions, and for the time being, using this attribute in those places
will just emit an `unused_attributes` lint instead of this error.

Example of erroneous code:

```compile_fail,E0788
#[coverage(off)]
struct Foo;

#[coverage(on)]
const FOO: Foo = Foo;
```

`#[coverage(off)]` tells the compiler to not generate coverage instrumentation
for a piece of code when the `-C instrument-coverage` flag is passed. Things
like structs and consts are not coverable code, and thus cannot do anything
with this attribute.

If you wish to apply this attribute to all methods in an impl or module,
manually annotate each method; it is not possible to annotate the entire impl
with a `#[coverage]` attribute.
