use malachite_base::num::basic::floats::PrimitiveFloat;
use malachite_base::num::basic::traits::NegativeInfinity;
use malachite_base::num::exhaustive::exhaustive_primitive_floats;
use malachite_base::test_util::num::exhaustive::exhaustive_primitive_floats_helper_helper;

fn exhaustive_primitive_floats_helper<T: PrimitiveFloat>(out: &[T]) {
    exhaustive_primitive_floats_helper_helper(exhaustive_primitive_floats::<T>(), out);
}

#[test]
fn test_exhaustive_primitive_floats() {
    exhaustive_primitive_floats_helper::<f32>(&[
        f32::NAN,
        f32::INFINITY,
        f32::NEGATIVE_INFINITY,
        0.0,
        -0.0,
        1.0,
        -1.0,
        2.0,
        -2.0,
        1.5,
        -1.5,
        0.5,
        -0.5,
        1.25,
        -1.25,
        3.0,
        -3.0,
        1.75,
        -1.75,
        4.0,
        -4.0,
        1.125,
        -1.125,
        2.5,
        -2.5,
        1.375,
        -1.375,
        0.75,
        -0.75,
        1.625,
        -1.625,
        3.5,
        -3.5,
        1.875,
        -1.875,
        0.25,
        -0.25,
        1.0625,
        -1.0625,
        2.25,
        -2.25,
        1.1875,
        -1.1875,
        0.625,
        -0.625,
        1.3125,
        -1.3125,
        2.75,
        -2.75,
        1.4375,
    ]);
    exhaustive_primitive_floats_helper::<f64>(&[
        f64::NAN,
        f64::INFINITY,
        f64::NEGATIVE_INFINITY,
        0.0,
        -0.0,
        1.0,
        -1.0,
        2.0,
        -2.0,
        1.5,
        -1.5,
        0.5,
        -0.5,
        1.25,
        -1.25,
        3.0,
        -3.0,
        1.75,
        -1.75,
        4.0,
        -4.0,
        1.125,
        -1.125,
        2.5,
        -2.5,
        1.375,
        -1.375,
        0.75,
        -0.75,
        1.625,
        -1.625,
        3.5,
        -3.5,
        1.875,
        -1.875,
        0.25,
        -0.25,
        1.0625,
        -1.0625,
        2.25,
        -2.25,
        1.1875,
        -1.1875,
        0.625,
        -0.625,
        1.3125,
        -1.3125,
        2.75,
        -2.75,
        1.4375,
    ]);
}
