#!/usr/bin/env ruby

# This file is a sample based on GoogleSearchClient.rb, which can be
# generated by WSDL file and wsdl2ruby.rb.
#
# $ wsdl2ruby.rb --type client --force \
#   --wsdl http://api.google.com/GoogleSearch.wsdl
#
# See wsdlDriver.rb to use WSDL file directly (slow).
require 'GoogleSearchDriver.rb'

endpoint_url = ARGV.shift
obj = GoogleSearchPort.new(endpoint_url)

# Uncomment the below line to see SOAP wiredumps.
# obj.wiredump_dev = STDERR

# SYNOPSIS
#   doGoogleSearch(key, q, start, maxResults, filter, restrict, safeSearch, lr, ie, oe)
#
# ARGS
#   key		 - {http://www.w3.org/2001/XMLSchema}string
#   q		 - {http://www.w3.org/2001/XMLSchema}string
#   start		 - {http://www.w3.org/2001/XMLSchema}int
#   maxResults		 - {http://www.w3.org/2001/XMLSchema}int
#   filter		 - {http://www.w3.org/2001/XMLSchema}boolean
#   restrict		 - {http://www.w3.org/2001/XMLSchema}string
#   safeSearch		 - {http://www.w3.org/2001/XMLSchema}boolean
#   lr		 - {http://www.w3.org/2001/XMLSchema}string
#   ie		 - {http://www.w3.org/2001/XMLSchema}string
#   oe		 - {http://www.w3.org/2001/XMLSchema}string
#
# RETURNS
#   return		GoogleSearchResult - {urn:GoogleSearch}GoogleSearchResult
#
# RAISES
#    N/A
#
key = q = start = maxResults = filter = restrict = safeSearch = lr = ie = oe = nil
key = File.open(File.expand_path("~/.google_key")) { |f| f.read }.chomp
q = "Ruby"
start = 0
maxResults = 10
filter = false
restrict = ""
safeSearch = false
lr = ""
ie = "utf-8"
oe = "utf-8"
result = obj.doGoogleSearch(key, q, start, maxResults, filter, restrict, safeSearch, lr, ie, oe)

result.resultElements.each do |ele|
  puts "== #{ele.title}: #{ele.URL}"
  puts ele.snippet
  puts
end
