/*
*  Rubrica
*  file: 
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>

#ifndef _RUBRICA_MODELS_H
#define _RUBRICA_MODELS_H

#include "types.h"


GtkTreeModel* rubrica_model_new (RubricaModelType type); 

void rubrica_model_init_tree    (GtkTreeView* view, RubricaModelType type);
void rubrica_model_add_columns  (GtkTreeView* view, RubricaColumnsType type);
void rubrica_model_toggle_group (GtkCellRendererToggle *cell, gchar *path, 
				 gpointer data);

void rubrica_model_clean_groups_view     (GtkTreeView* view);
void rubrica_model_populate_groups_view  (GtkTreeView* view, RGroupBox* box);
void rubrica_model_update_groups_view    (GtkTreeView* view, RGroupBox* box);
void rubrica_model_redisplay_groups_view (GtkTreeView* view, RGroupBox* box);

GtkTreeModel* rubrica_model_combo_new (void);
void rubrica_model_add_combo_columns     (GtkComboBox *combo_box);
void rubrica_model_populate_combo        (GtkComboBox *combo_box, 
					  RubricaCombo* array);
#endif
