/*
 *  file: main.c
 *  
 *  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include "libral.h"

#include "app.h"
#include "types.h"
#include "utils.h"
#include "callbacks.h"
#include "preferences.h"
#include "themes.h"

void rubrica_init(void);

gchar* rubfile   = NULL;
gchar* csvfile   = NULL;
gchar* vcardfile = NULL;


GOptionEntry options[] = {
  {"rub", 'r', 0, G_OPTION_ARG_FILENAME, &rubfile, 
   "Open a rubrica's file", NULL},
  {"csv", 'c', 0, G_OPTION_ARG_FILENAME, &csvfile, 
   "Open a csv file", NULL}, 
  {"vcard", 'v', 0, G_OPTION_ARG_FILENAME, &vcardfile, 
   "Open a vcard file", NULL}, 
  {NULL}
};

GOptionContext* ctx;


void 
rubrica_open_addressbooks(RubricaApp* app, gchar *argv[])
{
  if (rubfile)
    rubrica_app_load_file(app, rubfile, "rub");
      
  if (csvfile)
    rubrica_app_load_file(app, csvfile, "csv");

  if (vcardfile)
    rubrica_app_load_file(app, vcardfile, "vcard");   

  ++argv;
  for (; *argv; argv++)
    rubrica_app_load_file(app, *argv, NULL);
}


void rubrica_init(void)
{
  bindtextdomain (GETTEXT_PACKAGE, RUBRICA_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  g_set_application_name (_("Rubrica"));
  gtk_window_set_default_icon_name ("rubrica");

  rubrica_themes_add_directory(RUBRICA_ICONS_DIR"/16x16/apps");
  rubrica_themes_add_directory(RUBRICA_ICONS_DIR"/22x22/apps");
  rubrica_themes_add_directory(RUBRICA_ICONS_DIR"/24x24/apps");
  rubrica_themes_add_directory(RUBRICA_ICONS_DIR"/48x48/apps");
  rubrica_themes_add_directory(RUBRICA_ICONS_DIR"/scalable/apps");
}



int 
main (int argc, char *argv[])
{ 
  GOptionContext* context;
  RubricaApp* app = NULL;
  GError *error = NULL;

  context = g_option_context_new ("Rubrica");
  g_option_context_add_main_entries (context, options, GETTEXT_PACKAGE);
  g_option_context_parse (context, &argc, &argv, &error);
  g_option_context_free(context);

  g_thread_init(NULL);
  gtk_init(&argc, &argv);

  g_print("\n\nRubrica ***");
  g_print("\nRubrica *** version: %s", RUBRICA_VERSION); 
  g_print("\nRubrica *** code name: %s, %s",
	  RUBRICA_CODE_NAME, 
	  RUBRICA_INFO_CODE_NAME);
  g_print("\nRubrica ***\n");
  g_print("\nRubrica ***");
  g_print("\nRubrica *** This is a release candidate version (%s)", 
	  RUBRICA_VERSION); 
  g_print("\nRubrica *** Please notify me for all bugs that you'll find"); 
  g_print("\nRubrica *** last stable release of 1.0.x series is 1.0.18, "
	  "you can get it at");
  g_print("\nRubrica *** http://rubrica.berlios.de");
  g_print("\nRubrica *** For suggestions, patches, localizations,"
	  " bugs, other...");
  g_print("\nRubrica *** please write me: nicolafragale@gmail.com");
  g_print("\n\nRubrica *** rubrica needs localization, please help me");
  g_print("\nRubrica ***");
  g_print("\n\n"); 

  r_lib_init();
  rubrica_init();

  app = rubrica_app_new();

  rubrica_open_addressbooks(app, argv);

  rubrica_app_run(app);
  gtk_main();

  g_print("\n");
  return 0;
}
