/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve;

import java.io.IOException;
import java.io.InputStream;
import org.rosuda.REngine.Rserve.protocol.RPacket;
import org.rosuda.REngine.Rserve.protocol.RTalk;

public class RFileInputStream
extends InputStream {
    RTalk rt;
    boolean closed;
    boolean eof;

    RFileInputStream(RTalk rTalk, String string) throws IOException {
        this.rt = rTalk;
        RPacket rPacket = this.rt.request(16, string);
        if (rPacket == null || !rPacket.isOk()) {
            throw new IOException((String)(rPacket == null ? "Connection to Rserve failed" : "Request return code: " + rPacket.getStat()));
        }
        this.closed = false;
        this.eof = false;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) < 1) {
            return -1;
        }
        return byArray[0];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("File is not open");
        }
        if (this.eof) {
            return -1;
        }
        RPacket rPacket = this.rt.request(19, n2);
        if (rPacket == null || !rPacket.isOk()) {
            throw new IOException((String)(rPacket == null ? "Connection to Rserve failed" : "Request return code: " + rPacket.getStat()));
        }
        byte[] byArray2 = rPacket.getCont();
        if (byArray2 == null) {
            this.eof = true;
            return -1;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[n + i] = byArray2[i];
        }
        return byArray2.length;
    }

    @Override
    public void close() throws IOException {
        RPacket rPacket = this.rt.request(18, (byte[])null);
        if (rPacket == null || !rPacket.isOk()) {
            throw new IOException((String)(rPacket == null ? "Connection to Rserve failed" : "Request return code: " + rPacket.getStat()));
        }
        this.closed = true;
    }
}

