/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2007: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 26/Sep/2007                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <rsbac/types.h>
#include <rsbac/getname.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  char name[80];
  int value;

  locale_init();
  
  if (argc == 2)
    {
      value = strtol(argv[1],0,10);
      if((value < 0) || (value > A_none))
        printf("%i\n", A_none);
      else
        printf("%s\n", get_attribute_name(name,value));
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s value\n"), argv[0]);
      printf(gettext("value = attribute number\n\n"));
      exit(1);
    }
    
  exit(0);
}
