# Change Log for rocRAND

Full documentation for rocRAND is available at [https://rocrand.readthedocs.io/en/latest/](https://rocrand.readthedocs.io/en/latest/)
## (Unreleased) rocRAND-2.10.17 for ROCm 5.5.0
### Added
- MT19937 pseudo random number generator based on M. Matsumoto and T. Nishimura, 1998, Mersenne Twister: A 623-dimensionally equidistributed uniform pseudorandom number generator.
- New benchmark for the device API using Google Benchmark, `benchmark_rocrand_device_api`, replacing `benchmark_rocrand_kernel`. `benchmark_rocrand_kernel` is deprecated and will be removed in a future version. Likewise, `benchmark_curand_host_api` is added to replace `benchmark_curand_generate` and `benchmark_curand_device_api` is added to replace `benchmark_curand_kernel`.
- experimental HIP-CPU feature
- ThreeFry pseudorandom number generator based on Salmon et al., 2011, "Parallel random numbers: as easy as 1, 2, 3".
### Changed
- Python 2.7 is no longer officially supported.

## rocRAND-2.10.16 for ROCm 5.4.0
### Added
- MRG31K3P pseudorandom number generator based on L'Ecuyer and Touzin, 2000, "Fast combined multiple recursive generators with multipliers of the form a = ±2q ±2r".
- LFSR113 pseudorandom number generator based on L'Ecuyer, 1999, "Tables of maximally equidistributed combined LFSR generators".
- SCRAMBLED_SOBOL32 and SCRAMBLED_SOBOL64 quasirandom number generators. The Scrambled Sobol sequences are generated by scrambling the output of a Sobol sequence.
### Changed
- The `mrg_<distribution>_distribution` structures, which provided numbers based on MRG32K3A, are now replaced by `mrg_engine_<distribution>_distribution`, where `<distribution>` is `log_normal`, `normal`, `poisson`, or `uniform`. These structures provide numbers for MRG31K3P (with template type `rocrand_state_mrg31k3p`) and MRG32K3A (with template type `rocrand_state_mrg32k3a`).
### Fixed
- Sobol64 now returns 64 bits random numbers, instead of 32 bits random numbers. As a result, the performance of this generator has regressed.
- Fixed a bug that prevented compiling code in C++ mode (with a host compiler) when it included the rocRAND headers on Windows.

## rocRAND-2.10.15 for ROCm 5.3.0
### Added
- New benchmark for the host api using googlebenchmark replacing `benchmark_rocrand_generate`,
  `benchmark_rocrand_generate` is deprecated and will be removed in a future version.
### Changed
- Increased number of warmup iterations for rocrand_benchmark_generate from 5 to 15 to eliminate corner cases that would generate artificially high benchmark scores.

## (Released) rocRAND-2.10.14 for ROCm 5.2.0
### Added
- Backward compatibility for deprecated `#include <rocrand.h>` using wrapper header files.
- Packages for test and benchmark executables on all supported OSes using CPack.

## rocRAND-2.10.13 for ROCm 5.1.0
### Added
- Generating a random sequence different sizes now produces the same sequence without gaps
  indepent of how many values are generated per call.
  - Only in the case of XORWOW, MRG32K3A, PHILOX4X32_10, SOBOL32 and SOBOL64
  - This only holds true if the size in each call is a divisor of the distributions
    `output_width` due to performance
  - Similarly the output pointer has to be aligned to `output_width * sizeof(output_type)`
### Changed
- [hipRAND](https://github.com/ROCmSoftwarePlatform/hipRAND.git) split into a separate package
- Header file installation location changed to match other libraries.
  - When using the `rocrand.h` header file, users should now use `#include <rocrand/rocrand.h>`, rather than `#include <rocrand.h>`
- rocRAND still includes hipRAND using a submodule
  - The rocRAND package also sets the provides field with hipRAND, so projects which require hipRAND can begin to specify it.
### Fixed
- Fix offset behaviour for XORWOW, MRG32K3A and PHILOX4X32_10 generator, setting offset now
  correctly generates the same sequence starting from the offset.
  - Only uniform int and float will work as these can be generated with a single call to the generator
### Known issues
- kernel_xorwow unit test is failing for certain GPU architectures.

## rocRAND-2.10.12 for ROCm 5.0.0
### Changed
- No updates or changes for ROCm 5.0.0.

## rocRAND-2.10.12 for ROCm 4.5.0
### Addded
- Initial HIP on Windows support. See README for instructions on how to build and install.
### Changed
- Packaging split into a runtime package called rocrand and a development package called rocrand-devel. The development package depends on runtime. The runtime package suggests the development package for all supported OSes except CentOS 7 to aid in the transition. The suggests feature in packaging is introduced as a deprecated feature and will be removed in a future rocm release.
### Fixed
- Fix for mrg_uniform_distribution_double generating incorrect range of values
- Fix for order of state calls for log_normal, normal, and uniform
### Known issues
- kernel_xorwow test is failing for certain GPU architectures.

## [rocRAND-2.10.11 for ROCm 4.4.0]
### Added
- Sobol64 support added.
- Benchmark time measurement improvement
- Address Sanitizer build option added.
### Fixed
- nvcc backend fix
- Fix ranges of MRG32k3a device functions.

## [rocRAND-2.10.10 for ROCm 4.3.0]
### Added
- gfx90a support added.
- gfx1030 support added
- gfx803 supported re-enabled
### Fixed
- Memory leaks in Poisson tests has been fixed.
- Memory leaks when generator has been created but setting seed/offset/dimensions throws an exception has been fixed.

## [rocRAND-2.10.9 for ROCm 4.2.0]
### Fixed
- rocRAND benchmark performance drop for xorwow has been fixed for older ROCm builds.

## [rocRAND-2.10.8 for ROCm 4.1.0]
### Added
- Ability to force install dependencies with new -d flag in install script
### Changed
- rocRAND package name has been updated to support newer versions of ROCm.
### Fixed
- rocRAND benchmark performance drop has been fixed.
- Debug builds via the install script have been fixed.

## [rocRAND-2.10.7 for ROCm 4.0.0]
### Added
- No new features

## [rocRAND-2.10.6 for ROCm 3.10]
### Added
- No new features

## [rocRAND-2.10.5 for ROCm 3.9.0]
### Added
- No new features

## [rocRAND-2.10.4 for ROCm 3.8.0]
### Added
- No new features

## [rocRAND-2.10.3 for ROCm 3.7.0]
### Fixed
- Fixed package naming to reflect OS name and architecture.

## [rocRAND-2.10.2 for ROCm 3.6.0]
### Added
- No new features

## [rocRAND-2.10.1 for ROCm 3.5.0]
### Added
- Static library build options added in beta (subject to change in build method and naming in future releases)
### Changed
- Switched to hip-clang as default compiler
### Deprecated
- HCC build deprecated
