// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"0xacab.org/leap/bitmask-core/models"
)

// GetAPI5BridgeLocationReader is a Reader for the GetAPI5BridgeLocation structure.
type GetAPI5BridgeLocationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAPI5BridgeLocationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetApi5BridgeLocationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetApi5BridgeLocationBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetApi5BridgeLocationNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetApi5BridgeLocationInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /api/5/bridge/{location}] GetAPI5BridgeLocation", response, response.Code())
	}
}

// NewGetApi5BridgeLocationOK creates a GetApi5BridgeLocationOK with default headers values
func NewGetApi5BridgeLocationOK() *GetApi5BridgeLocationOK {
	return &GetApi5BridgeLocationOK{}
}

/*
GetApi5BridgeLocationOK describes a response with status code 200, with default header values.

OK
*/
type GetApi5BridgeLocationOK struct {
	Payload []*models.ModelsBridge
}

// IsSuccess returns true when this get api5 bridge location o k response has a 2xx status code
func (o *GetApi5BridgeLocationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get api5 bridge location o k response has a 3xx status code
func (o *GetApi5BridgeLocationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get api5 bridge location o k response has a 4xx status code
func (o *GetApi5BridgeLocationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get api5 bridge location o k response has a 5xx status code
func (o *GetApi5BridgeLocationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get api5 bridge location o k response a status code equal to that given
func (o *GetApi5BridgeLocationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get api5 bridge location o k response
func (o *GetApi5BridgeLocationOK) Code() int {
	return 200
}

func (o *GetApi5BridgeLocationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/bridge/{location}][%d] getApi5BridgeLocationOK %s", 200, payload)
}

func (o *GetApi5BridgeLocationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/bridge/{location}][%d] getApi5BridgeLocationOK %s", 200, payload)
}

func (o *GetApi5BridgeLocationOK) GetPayload() []*models.ModelsBridge {
	return o.Payload
}

func (o *GetApi5BridgeLocationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetApi5BridgeLocationBadRequest creates a GetApi5BridgeLocationBadRequest with default headers values
func NewGetApi5BridgeLocationBadRequest() *GetApi5BridgeLocationBadRequest {
	return &GetApi5BridgeLocationBadRequest{}
}

/*
GetApi5BridgeLocationBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetApi5BridgeLocationBadRequest struct {
	Payload interface{}
}

// IsSuccess returns true when this get api5 bridge location bad request response has a 2xx status code
func (o *GetApi5BridgeLocationBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get api5 bridge location bad request response has a 3xx status code
func (o *GetApi5BridgeLocationBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get api5 bridge location bad request response has a 4xx status code
func (o *GetApi5BridgeLocationBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get api5 bridge location bad request response has a 5xx status code
func (o *GetApi5BridgeLocationBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get api5 bridge location bad request response a status code equal to that given
func (o *GetApi5BridgeLocationBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get api5 bridge location bad request response
func (o *GetApi5BridgeLocationBadRequest) Code() int {
	return 400
}

func (o *GetApi5BridgeLocationBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/bridge/{location}][%d] getApi5BridgeLocationBadRequest %s", 400, payload)
}

func (o *GetApi5BridgeLocationBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/bridge/{location}][%d] getApi5BridgeLocationBadRequest %s", 400, payload)
}

func (o *GetApi5BridgeLocationBadRequest) GetPayload() interface{} {
	return o.Payload
}

func (o *GetApi5BridgeLocationBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetApi5BridgeLocationNotFound creates a GetApi5BridgeLocationNotFound with default headers values
func NewGetApi5BridgeLocationNotFound() *GetApi5BridgeLocationNotFound {
	return &GetApi5BridgeLocationNotFound{}
}

/*
GetApi5BridgeLocationNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetApi5BridgeLocationNotFound struct {
	Payload interface{}
}

// IsSuccess returns true when this get api5 bridge location not found response has a 2xx status code
func (o *GetApi5BridgeLocationNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get api5 bridge location not found response has a 3xx status code
func (o *GetApi5BridgeLocationNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get api5 bridge location not found response has a 4xx status code
func (o *GetApi5BridgeLocationNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get api5 bridge location not found response has a 5xx status code
func (o *GetApi5BridgeLocationNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get api5 bridge location not found response a status code equal to that given
func (o *GetApi5BridgeLocationNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get api5 bridge location not found response
func (o *GetApi5BridgeLocationNotFound) Code() int {
	return 404
}

func (o *GetApi5BridgeLocationNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/bridge/{location}][%d] getApi5BridgeLocationNotFound %s", 404, payload)
}

func (o *GetApi5BridgeLocationNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/bridge/{location}][%d] getApi5BridgeLocationNotFound %s", 404, payload)
}

func (o *GetApi5BridgeLocationNotFound) GetPayload() interface{} {
	return o.Payload
}

func (o *GetApi5BridgeLocationNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetApi5BridgeLocationInternalServerError creates a GetApi5BridgeLocationInternalServerError with default headers values
func NewGetApi5BridgeLocationInternalServerError() *GetApi5BridgeLocationInternalServerError {
	return &GetApi5BridgeLocationInternalServerError{}
}

/*
GetApi5BridgeLocationInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetApi5BridgeLocationInternalServerError struct {
	Payload interface{}
}

// IsSuccess returns true when this get api5 bridge location internal server error response has a 2xx status code
func (o *GetApi5BridgeLocationInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get api5 bridge location internal server error response has a 3xx status code
func (o *GetApi5BridgeLocationInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get api5 bridge location internal server error response has a 4xx status code
func (o *GetApi5BridgeLocationInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get api5 bridge location internal server error response has a 5xx status code
func (o *GetApi5BridgeLocationInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get api5 bridge location internal server error response a status code equal to that given
func (o *GetApi5BridgeLocationInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get api5 bridge location internal server error response
func (o *GetApi5BridgeLocationInternalServerError) Code() int {
	return 500
}

func (o *GetApi5BridgeLocationInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/bridge/{location}][%d] getApi5BridgeLocationInternalServerError %s", 500, payload)
}

func (o *GetApi5BridgeLocationInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/bridge/{location}][%d] getApi5BridgeLocationInternalServerError %s", 500, payload)
}

func (o *GetApi5BridgeLocationInternalServerError) GetPayload() interface{} {
	return o.Payload
}

func (o *GetApi5BridgeLocationInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
