/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef RIPOFFMODEL_H
#define RIPOFFMODEL_H
#include "lib/RipOff.h"

enum
{
	COL_TRACK_NUMBER=0,
	COL_TRACK_NAME,
	COL_ARTIST_NAME,
	COL_TRACK_LENGTH_STRING,
	COL_EXTRACT,
	COL_FRAME_OFFSET,
	COL_TRACK_LENGTH_INT,
	NUM_COLS
};

void change_row(	gint track_number, 
			const gchar *artist_string, 
			const gchar *track_string,
			GtkTreeModel *model); 

/* Handler for "toggled" events of the model */
void cell_toggled(	GtkCellRendererToggle *cell, 
			gchar *path_string, 
			gpointer data);

/* Handler for "edited" events of model */
void cell_edited(	GtkCellRendererText *cell, 
		 	gchar *path_string, 
			gchar *new_text, 
			gpointer data);

/* Creates a view and model of the CD by using the device pointed to by
 * device path */
GtkWidget *create_view_and_model(gchar *device_path);

/* select_all signal function, called when select all is chosen in menu */
void select_all(GtkWidget *widget, gpointer data);

/* deselect_all signal function, called when deselect all is chosen in menu */
void deselect_all(GtkWidget *widget, gpointer data);

/* has the model fill itself to represent a newly inserted CD */
void ripoff_refill_model(gchar *device_path, GtkTreeStore *treestore);

#endif
