/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript.qa.drivers;

import com.netscape.javascript.qa.drivers.RefDrv;
import com.netscape.javascript.qa.drivers.TestCase;
import com.netscape.javascript.qa.drivers.TestDriver;
import com.netscape.javascript.qa.drivers.TestEnvironment;
import com.netscape.javascript.qa.drivers.TestFile;
import com.netscape.javascript.qa.drivers.TestLog;
import com.netscape.javascript.qa.drivers.TestSuite;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

public class MacRefEnv
implements TestEnvironment {
    TestFile file;
    TestSuite suite;
    RefDrv driver;
    String directoryName;
    TestLog testargs;
    File results;
    Process task;
    public static final String[] tags;
    public static final String sizeTag = "<#TEST CASES SIZE>";
    public static final String startTag = "<#TEST CASE";
    public static final String endTag = ">";

    static {
        String[] stringArray = new String[]{"PASSED", "NAME", "EXPECTED", "ACTUAL", "DESCRIPTION", "REASON", "BUGNUMBER"};
        tags = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            MacRefEnv.tags[n] = "<#TEST CASE " + stringArray[n] + endTag;
            ++n;
        }
    }

    public MacRefEnv(TestFile testFile, TestSuite testSuite, RefDrv refDrv) {
        this.file = testFile;
        this.suite = testSuite;
        this.driver = refDrv;
    }

    public void close() {
    }

    public Object createContext() {
        try {
            File file = new File("flagfile.flg");
            if (file.exists()) {
                file.delete();
            }
            this.task = Runtime.getRuntime().exec(this.driver.EXECUTABLE);
            int n = 0;
            while (!file.exists() && n++ <= 60) {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException in RunJS : " + iOException);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException in RunJS : " + interruptedException);
        }
        return null;
    }

    public boolean createTestargsFile() {
        String string = "testargs.txt";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        this.testargs = new TestLog("testargs.txt", "");
        return true;
    }

    public boolean deleteResultsFile() {
        String string = "results.txt";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        return true;
    }

    public Object executeTestFile() {
        return null;
    }

    public boolean getDirectoryName() {
        this.directoryName = ":";
        return true;
    }

    public String getMacFileString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '/') {
                stringBuffer.append(":");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parseResult() {
        this.results = new File("results.txt");
        if (!this.results.exists()) {
            return false;
        }
        try {
            String string;
            FileReader fileReader = new FileReader(this.results);
            LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
            do {
                string = lineNumberReader.readLine();
                TestDriver.p(string);
                if (string != null) continue;
                TestDriver.p("\tERROR: No lines to read");
                return false;
            } while (!string.equals(sizeTag));
            string = lineNumberReader.readLine();
            if (string == null) {
                return false;
            }
            this.file.totalCases = Integer.valueOf(string);
            string = lineNumberReader.readLine();
            if (string == null) {
                TestDriver.p("\tERROR: No lines after <#TEST CASES SIZE>");
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= this.file.totalCases) {
                    try {
                        lineNumberReader.close();
                        fileReader.close();
                        return true;
                    }
                    catch (IOException iOException) {
                        System.out.println("IOException in RunJS : " + iOException);
                        return false;
                    }
                }
                String[] stringArray = new String[tags.length];
                try {
                    int n2 = 0;
                    block9: while (n2 < tags.length) {
                        stringArray[n2] = null;
                        if (!string.startsWith(tags[n2])) {
                            TestDriver.p("line didn't start with " + tags[n2] + ":" + string);
                            return false;
                        }
                        while (true) {
                            if ((string = lineNumberReader.readLine()) == null || string.startsWith(startTag)) {
                                if (stringArray[n2] == null) {
                                    stringArray[n2] = "";
                                }
                                ++n2;
                                continue block9;
                            }
                            stringArray[n2] = stringArray[n2] == null ? string : String.valueOf(stringArray[n2]) + "\n" + string;
                        }
                    }
                    if (string == null && n < this.file.totalCases - 1) {
                        TestDriver.p("line == null and " + n + "<" + (this.file.totalCases - 1));
                        return false;
                    }
                }
                catch (IOException iOException) {
                    TestDriver.p("Exception reading process output: " + iOException);
                    this.file.exception = iOException.toString();
                    return false;
                }
                TestCase testCase = new TestCase(stringArray[0], stringArray[1], stringArray[4], stringArray[2], stringArray[3], stringArray[5]);
                this.file.bugnumber = stringArray[6];
                this.file.caseVector.addElement(testCase);
                if (testCase.passed.equals("false")) {
                    if (this.file.name.endsWith("-n.js")) {
                        this.file.passed = true;
                    } else {
                        this.file.passed = false;
                        this.suite.passed = false;
                    }
                }
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("\tERROR: No integer after <#TEST CASES SIZE>");
            return false;
        }
        catch (IOException iOException) {
            System.out.println("Exception reading process output:" + iOException.toString());
            this.file.exception = iOException.toString();
            return false;
        }
    }

    public synchronized void runTest() {
        try {
            if (this.setupMacFiles()) {
                this.file.startTime = TestDriver.getCurrentTime();
                this.createContext();
                this.file.endTime = TestDriver.getCurrentTime();
            }
            if (!this.parseResult()) {
                if (this.file.name.endsWith("-n.js")) {
                    this.file.passed = true;
                } else {
                    this.suite.passed = false;
                    this.file.passed = false;
                }
            }
        }
        catch (Exception exception) {
            this.suite.passed = false;
            this.file.passed = false;
            this.file.exception = "Unknown process exception.";
        }
    }

    public boolean setupMacFiles() {
        boolean bl = this.getDirectoryName();
        this.deleteResultsFile();
        boolean bl2 = this.createTestargsFile();
        boolean bl3 = this.writeTestargsFile();
        return bl && bl2 && bl3;
    }

    public boolean writeTestargsFile() {
        String string = this.getMacFileString(":" + this.driver.HELPER_STRING);
        String string2 = this.getMacFileString(":" + this.file.filePath);
        this.testargs.writeLine("-f");
        this.testargs.writeLine(string);
        this.testargs.writeLine("-f");
        this.testargs.writeLine(string2);
        this.testargs.closeLog();
        return true;
    }
}

