///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/pstream.h"
#include "rheolef/compiler.h"
using namespace rheolef;
using namespace std;
//
// usage: ipstream_tst
//     enter filename on standard input
//     copy file on standard output
//
int main(int argc, char**argv)
{
    string filename;
    cin >> filename;
    string command = string("cat ") + filename;
    ipstream toto(command.c_str());

    cerr << "ipstream good = " << toto.good() << endl;
    cerr << "ipstream eof  = " << toto.eof() << endl;
    cerr << "ipstream fail = " << toto.fail() << endl;
    cerr << "ipstream bad  = " << toto.bad() << endl;

    while (toto) {
        int c = toto.get();
        if (c != EOF) cout.put(char(c));
    }
    toto.close();
    return 0;
}
