// file automatically generated by "../../../rheolef/nfem/pbasis/basis_symbolic_cxx.cc"
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P2.h"
namespace rheolef {
using namespace std;
template<class T>
class basis_P2_p {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P2_e {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P2_t {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P2_q {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P2_T {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P2_P {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P2_H {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
void
basis_P2_p<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] = 1.0;
}
template<class T>
void
basis_P2_p<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(1);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_p<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
}
template<class T>
void
basis_P2_p<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(1);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_p<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>();
}
template<class T>
void
basis_P2_p<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(1);
  hat_node (x.begin());
}
template<class T>
void
basis_P2_e<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] =  -3.0*hat_x[0]+2.0*(hat_x[0]*hat_x[0])+1.0;
  values[1] =  2.0*(hat_x[0]*hat_x[0])-hat_x[0];
  values[2] =  -4.0*(hat_x[0]*hat_x[0])+4.0*hat_x[0];
}
template<class T>
void
basis_P2_e<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(3);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_e<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] =  4.0*hat_x[0]-3.0;
  values[1][0] =  4.0*hat_x[0]-1.0;
  values[2][0] =  -8.0*hat_x[0]+4.0;
}
template<class T>
void
basis_P2_e<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(3);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_e<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(0.0);
  x[1] = point_basic<T>(1.0);
  x[2] = point_basic<T>((1.0/2.0));
}
template<class T>
void
basis_P2_e<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(3);
  hat_node (x.begin());
}
template<class T>
void
basis_P2_t<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] =  hat_x[1]*( 4.0*hat_x[0]-3.0)+2.0*(hat_x[0]*hat_x[0])+2.0*(hat_x[1]*hat_x[1])+-3.0*hat_x[0]+1.0;
  values[1] =  2.0*(hat_x[0]*hat_x[0])-hat_x[0];
  values[2] =  2.0*(hat_x[1]*hat_x[1])-hat_x[1];
  values[3] =  -4.0*(hat_x[0]*hat_x[0])+4.0*hat_x[0]+-4.0*hat_x[1]*hat_x[0];
  values[4] = 4.0*hat_x[0]*hat_x[1];
  values[5] =  -4.0*(hat_x[1]*hat_x[1])+-4.0*hat_x[1]*( hat_x[0]-1.0);
}
template<class T>
void
basis_P2_t<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(6);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_t<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] =  4.0*hat_x[0]+4.0*hat_x[1]-3.0;
  values[0][1] =  4.0*hat_x[0]+4.0*hat_x[1]-3.0;
  values[1][0] =  4.0*hat_x[0]-1.0;
  values[1][1] = 0.0;
  values[2][0] = 0.0;
  values[2][1] =  4.0*hat_x[1]-1.0;
  values[3][0] =  -8.0*hat_x[0]+-4.0*hat_x[1]+4.0;
  values[3][1] = -4.0*hat_x[0];
  values[4][0] = 4.0*hat_x[1];
  values[4][1] = 4.0*hat_x[0];
  values[5][0] = -4.0*hat_x[1];
  values[5][1] =  -4.0*hat_x[0]+-8.0*hat_x[1]+4.0;
}
template<class T>
void
basis_P2_t<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(6);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_t<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(0.0, 0.0);
  x[1] = point_basic<T>(1.0, 0.0);
  x[2] = point_basic<T>(0.0, 1.0);
  x[3] = point_basic<T>((1.0/2.0), 0.0);
  x[4] = point_basic<T>((1.0/2.0), (1.0/2.0));
  x[5] = point_basic<T>(0.0, (1.0/2.0));
}
template<class T>
void
basis_P2_t<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(6);
  hat_node (x.begin());
}
template<class T>
void
basis_P2_q<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] =  ( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])/4.0-( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]/4.0;
  values[1] =  (hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/4.0-hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/4.0;
  values[2] =  ( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0+( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]/4.0;
  values[3] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/4.0-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0;
  values[4] =  hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/2.0-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/2.0;
  values[5] = -( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/2.0+hat_x[0]/2.0+(hat_x[0]*hat_x[0])/2.0;
  values[6] = -(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/2.0-hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/2.0;
  values[7] = -(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/2.0+(hat_x[0]*hat_x[0])/2.0-hat_x[0]/2.0;
  values[8] = -(hat_x[0]*hat_x[0])+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+1.0;
}
template<class T>
void
basis_P2_q<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(9);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_q<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] = -hat_x[1]*( 2.0*hat_x[0]-1.0)/4.0+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/4.0;
  values[0][1] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/2.0+hat_x[0]/4.0-(hat_x[0]*hat_x[0])/4.0;
  values[1][0] =  (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)/4.0-hat_x[1]*( 2.0*hat_x[0]+1.0)/4.0;
  values[1][1] = -(hat_x[0]*hat_x[0])/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/2.0-hat_x[0]/4.0;
  values[2][0] =  ( 2.0*hat_x[0]+1.0)*hat_x[1]/4.0+( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])/4.0;
  values[2][1] =  hat_x[0]/4.0+hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/2.0+(hat_x[0]*hat_x[0])/4.0;
  values[3][0] =  ( 2.0*hat_x[0]-1.0)*hat_x[1]/4.0+( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])/4.0;
  values[3][1] = -hat_x[0]/4.0+(hat_x[0]*hat_x[0])/4.0-( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/2.0;
  values[4][0] = -(hat_x[1]*hat_x[1])*hat_x[0]+hat_x[1]*hat_x[0];
  values[4][1] = -( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+(hat_x[0]*hat_x[0])/2.0-(1.0/2.0);
  values[5][0] =  hat_x[0]-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)/2.0+(1.0/2.0);
  values[5][1] = -hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0]);
  values[6][0] = -hat_x[0]*(hat_x[1]*hat_x[1])-hat_x[0]*hat_x[1];
  values[6][1] = -hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-(hat_x[0]*hat_x[0])/2.0+(1.0/2.0);
  values[7][0] = -( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])/2.0+hat_x[0]-(1.0/2.0);
  values[7][1] = ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1];
  values[8][0] =  2.0*(hat_x[1]*hat_x[1])*hat_x[0]+-2.0*hat_x[0];
  values[8][1] = 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1];
}
template<class T>
void
basis_P2_q<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(9);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_q<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(-1.0, -1.0);
  x[1] = point_basic<T>(1.0, -1.0);
  x[2] = point_basic<T>(1.0, 1.0);
  x[3] = point_basic<T>(-1.0, 1.0);
  x[4] = point_basic<T>(0.0, -1.0);
  x[5] = point_basic<T>(1.0, 0.0);
  x[6] = point_basic<T>(0.0, 1.0);
  x[7] = point_basic<T>(-1.0, 0.0);
  x[8] = point_basic<T>(0.0, 0.0);
}
template<class T>
void
basis_P2_q<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(9);
  hat_node (x.begin());
}
template<class T>
void
basis_P2_T<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] =  -3.0*hat_x[0]+( 4.0*hat_x[0]-3.0)*hat_x[1]+2.0*(hat_x[2]*hat_x[2])+( 4.0*hat_x[0]+4.0*hat_x[1]-3.0)*hat_x[2]+2.0*(hat_x[0]*hat_x[0])+2.0*(hat_x[1]*hat_x[1])+1.0;
  values[1] = -hat_x[0]+2.0*(hat_x[0]*hat_x[0]);
  values[2] =  2.0*(hat_x[1]*hat_x[1])-hat_x[1];
  values[3] = -hat_x[2]+2.0*(hat_x[2]*hat_x[2]);
  values[4] =  -4.0*(hat_x[0]*hat_x[0])+-4.0*hat_x[2]*hat_x[0]+-4.0*hat_x[1]*hat_x[0]+4.0*hat_x[0];
  values[5] = 4.0*hat_x[1]*hat_x[0];
  values[6] =  -4.0*hat_x[1]*hat_x[2]+-4.0*hat_x[1]*( hat_x[0]-1.0)+-4.0*(hat_x[1]*hat_x[1]);
  values[7] =  -4.0*hat_x[2]*( hat_x[1]+hat_x[0]-1.0)+-4.0*(hat_x[2]*hat_x[2]);
  values[8] = 4.0*hat_x[2]*hat_x[0];
  values[9] = 4.0*hat_x[2]*hat_x[1];
}
template<class T>
void
basis_P2_T<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(10);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_T<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] =  4.0*hat_x[2]+4.0*hat_x[0]+4.0*hat_x[1]-3.0;
  values[0][1] =  4.0*hat_x[2]+4.0*hat_x[0]+4.0*hat_x[1]-3.0;
  values[0][2] =  4.0*hat_x[0]+4.0*hat_x[1]+4.0*hat_x[2]-3.0;
  values[1][0] =  4.0*hat_x[0]-1.0;
  values[1][1] = 0.0;
  values[1][2] = 0.0;
  values[2][0] = 0.0;
  values[2][1] =  4.0*hat_x[1]-1.0;
  values[2][2] = 0.0;
  values[3][0] = 0.0;
  values[3][1] = 0.0;
  values[3][2] =  4.0*hat_x[2]-1.0;
  values[4][0] =  -4.0*hat_x[2]+-8.0*hat_x[0]+-4.0*hat_x[1]+4.0;
  values[4][1] = -4.0*hat_x[0];
  values[4][2] = -4.0*hat_x[0];
  values[5][0] = 4.0*hat_x[1];
  values[5][1] = 4.0*hat_x[0];
  values[5][2] = 0.0;
  values[6][0] = -4.0*hat_x[1];
  values[6][1] =  -4.0*hat_x[0]+-8.0*hat_x[1]+-4.0*hat_x[2]+4.0;
  values[6][2] = -4.0*hat_x[1];
  values[7][0] = -4.0*hat_x[2];
  values[7][1] = -4.0*hat_x[2];
  values[7][2] =  -4.0*hat_x[1]+-8.0*hat_x[2]+-4.0*hat_x[0]+4.0;
  values[8][0] = 4.0*hat_x[2];
  values[8][1] = 0.0;
  values[8][2] = 4.0*hat_x[0];
  values[9][0] = 0.0;
  values[9][1] = 4.0*hat_x[2];
  values[9][2] = 4.0*hat_x[1];
}
template<class T>
void
basis_P2_T<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(10);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_T<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(0.0, 0.0, 0.0);
  x[1] = point_basic<T>(1.0, 0.0, 0.0);
  x[2] = point_basic<T>(0.0, 1.0, 0.0);
  x[3] = point_basic<T>(0.0, 0.0, 1.0);
  x[4] = point_basic<T>((1.0/2.0), 0.0, 0.0);
  x[5] = point_basic<T>((1.0/2.0), (1.0/2.0), 0.0);
  x[6] = point_basic<T>(0.0, (1.0/2.0), 0.0);
  x[7] = point_basic<T>(0.0, 0.0, (1.0/2.0));
  x[8] = point_basic<T>((1.0/2.0), 0.0, (1.0/2.0));
  x[9] = point_basic<T>(0.0, (1.0/2.0), (1.0/2.0));
}
template<class T>
void
basis_P2_T<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(10);
  hat_node (x.begin());
}
template<class T>
void
basis_P2_P<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] = -( 3.0*hat_x[0]+-2.0*(hat_x[1]*hat_x[1])-( 4.0*hat_x[0]-3.0)*hat_x[1]+-2.0*(hat_x[0]*hat_x[0])-1.0)*(hat_x[2]*hat_x[2])/2.0+( 3.0*hat_x[0]+-2.0*(hat_x[1]*hat_x[1])-( 4.0*hat_x[0]-3.0)*hat_x[1]+-2.0*(hat_x[0]*hat_x[0])-1.0)*hat_x[2]/2.0;
  values[1] =  hat_x[2]*( hat_x[0]+-2.0*(hat_x[0]*hat_x[0]))/2.0-(hat_x[2]*hat_x[2])*( hat_x[0]+-2.0*(hat_x[0]*hat_x[0]))/2.0;
  values[2] = -(hat_x[2]*hat_x[2])*( hat_x[1]+-2.0*(hat_x[1]*hat_x[1]))/2.0+hat_x[2]*( hat_x[1]+-2.0*(hat_x[1]*hat_x[1]))/2.0;
  values[3] =  ( 2.0*(hat_x[0]*hat_x[0])+2.0*(hat_x[1]*hat_x[1])+hat_x[1]*( 4.0*hat_x[0]-3.0)+-3.0*hat_x[0]+1.0)*hat_x[2]/2.0+( 2.0*(hat_x[0]*hat_x[0])+2.0*(hat_x[1]*hat_x[1])+hat_x[1]*( 4.0*hat_x[0]-3.0)+-3.0*hat_x[0]+1.0)*(hat_x[2]*hat_x[2])/2.0;
  values[4] =  (hat_x[2]*hat_x[2])*( 2.0*(hat_x[0]*hat_x[0])-hat_x[0])/2.0+hat_x[2]*( 2.0*(hat_x[0]*hat_x[0])-hat_x[0])/2.0;
  values[5] = -(hat_x[2]*hat_x[2])*( hat_x[1]+-2.0*(hat_x[1]*hat_x[1]))/2.0-hat_x[2]*( hat_x[1]+-2.0*(hat_x[1]*hat_x[1]))/2.0;
  values[6] =  -2.0*hat_x[2]*( hat_x[0]-(hat_x[0]*hat_x[0])-hat_x[0]*hat_x[1])+2.0*(hat_x[2]*hat_x[2])*( hat_x[0]-(hat_x[0]*hat_x[0])-hat_x[0]*hat_x[1]);
  values[7] =  -2.0*hat_x[2]*hat_x[0]*hat_x[1]+2.0*(hat_x[2]*hat_x[2])*hat_x[0]*hat_x[1];
  values[8] =  -2.0*( (hat_x[1]*hat_x[1])+( hat_x[0]-1.0)*hat_x[1])*(hat_x[2]*hat_x[2])+2.0*( (hat_x[1]*hat_x[1])+( hat_x[0]-1.0)*hat_x[1])*hat_x[2];
  values[9] =  2.0*(hat_x[0]*hat_x[0])+hat_x[1]*( 4.0*hat_x[0]-3.0)+2.0*(hat_x[1]*hat_x[1])-(hat_x[2]*hat_x[2])*( 2.0*(hat_x[0]*hat_x[0])+hat_x[1]*( 4.0*hat_x[0]-3.0)+2.0*(hat_x[1]*hat_x[1])+-3.0*hat_x[0]+1.0)+-3.0*hat_x[0]+1.0;
  values[10] = -(hat_x[2]*hat_x[2])*( 2.0*(hat_x[0]*hat_x[0])-hat_x[0])+2.0*(hat_x[0]*hat_x[0])-hat_x[0];
  values[11] = -hat_x[1]+2.0*(hat_x[1]*hat_x[1])+( hat_x[1]+-2.0*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2]);
  values[12] =  2.0*( hat_x[0]-hat_x[0]*hat_x[1]-(hat_x[0]*hat_x[0]))*hat_x[2]+2.0*( hat_x[0]-hat_x[0]*hat_x[1]-(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2]);
  values[13] =  2.0*hat_x[0]*hat_x[1]*hat_x[2]+2.0*hat_x[0]*hat_x[1]*(hat_x[2]*hat_x[2]);
  values[14] =  -2.0*( (hat_x[1]*hat_x[1])+( hat_x[0]-1.0)*hat_x[1])*(hat_x[2]*hat_x[2])+-2.0*( (hat_x[1]*hat_x[1])+( hat_x[0]-1.0)*hat_x[1])*hat_x[2];
  values[15] =  4.0*hat_x[0]+-4.0*hat_x[0]*hat_x[1]+-4.0*(hat_x[2]*hat_x[2])*( hat_x[0]-hat_x[0]*hat_x[1]-(hat_x[0]*hat_x[0]))+-4.0*(hat_x[0]*hat_x[0]);
  values[16] =  4.0*hat_x[1]*hat_x[0]+-4.0*hat_x[1]*(hat_x[2]*hat_x[2])*hat_x[0];
  values[17] =  -4.0*hat_x[1]*( hat_x[0]-1.0)+-4.0*(hat_x[1]*hat_x[1])+4.0*(hat_x[2]*hat_x[2])*( hat_x[1]*( hat_x[0]-1.0)+(hat_x[1]*hat_x[1]));
}
template<class T>
void
basis_P2_P<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(18);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_P<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] =  ( 4.0*hat_x[1]+4.0*hat_x[0]-3.0)*(hat_x[2]*hat_x[2])/2.0-( 4.0*hat_x[1]+4.0*hat_x[0]-3.0)*hat_x[2]/2.0;
  values[0][1] = -hat_x[2]*( 4.0*hat_x[1]+4.0*hat_x[0]-3.0)/2.0+(hat_x[2]*hat_x[2])*( 4.0*hat_x[1]+4.0*hat_x[0]-3.0)/2.0;
  values[0][2] = -(hat_x[1]*hat_x[1])-( 4.0*hat_x[0]-3.0)*hat_x[1]/2.0+( 2.0*(hat_x[1]*hat_x[1])+( 4.0*hat_x[0]-3.0)*hat_x[1]+-3.0*hat_x[0]+2.0*(hat_x[0]*hat_x[0])+1.0)*hat_x[2]+(3.0/2.0)*hat_x[0]-(hat_x[0]*hat_x[0])-(1.0/2.0);
  values[1][0] =  (hat_x[2]*hat_x[2])*( 4.0*hat_x[0]-1.0)/2.0-hat_x[2]*( 4.0*hat_x[0]-1.0)/2.0;
  values[1][1] = 0.0;
  values[1][2] = -(hat_x[0]*hat_x[0])+hat_x[0]/2.0+hat_x[2]*( 2.0*(hat_x[0]*hat_x[0])-hat_x[0]);
  values[2][0] = 0.0;
  values[2][1] =  (hat_x[2]*hat_x[2])*( 4.0*hat_x[1]-1.0)/2.0-hat_x[2]*( 4.0*hat_x[1]-1.0)/2.0;
  values[2][2] =  hat_x[1]/2.0-( hat_x[1]+-2.0*(hat_x[1]*hat_x[1]))*hat_x[2]-(hat_x[1]*hat_x[1]);
  values[3][0] =  hat_x[2]*( 4.0*hat_x[0]+4.0*hat_x[1]-3.0)/2.0+(hat_x[2]*hat_x[2])*( 4.0*hat_x[0]+4.0*hat_x[1]-3.0)/2.0;
  values[3][1] =  ( 4.0*hat_x[0]+4.0*hat_x[1]-3.0)*(hat_x[2]*hat_x[2])/2.0+( 4.0*hat_x[0]+4.0*hat_x[1]-3.0)*hat_x[2]/2.0;
  values[3][2] =  -(3.0/2.0)*hat_x[0]+( 4.0*hat_x[0]-3.0)*hat_x[1]/2.0+(hat_x[1]*hat_x[1])-( 3.0*hat_x[0]-( 4.0*hat_x[0]-3.0)*hat_x[1]+-2.0*(hat_x[1]*hat_x[1])+-2.0*(hat_x[0]*hat_x[0])-1.0)*hat_x[2]+(hat_x[0]*hat_x[0])+(1.0/2.0);
  values[4][0] =  ( 4.0*hat_x[0]-1.0)*hat_x[2]/2.0+( 4.0*hat_x[0]-1.0)*(hat_x[2]*hat_x[2])/2.0;
  values[4][1] = 0.0;
  values[4][2] =  (hat_x[0]*hat_x[0])+( 2.0*(hat_x[0]*hat_x[0])-hat_x[0])*hat_x[2]-hat_x[0]/2.0;
  values[5][0] = 0.0;
  values[5][1] =  ( 4.0*hat_x[1]-1.0)*(hat_x[2]*hat_x[2])/2.0+( 4.0*hat_x[1]-1.0)*hat_x[2]/2.0;
  values[5][2] =  (hat_x[1]*hat_x[1])+( 2.0*(hat_x[1]*hat_x[1])-hat_x[1])*hat_x[2]-hat_x[1]/2.0;
  values[6][0] =  -2.0*( 2.0*hat_x[0]+hat_x[1]-1.0)*(hat_x[2]*hat_x[2])+2.0*( 2.0*hat_x[0]+hat_x[1]-1.0)*hat_x[2];
  values[6][1] =  2.0*hat_x[2]*hat_x[0]+-2.0*(hat_x[2]*hat_x[2])*hat_x[0];
  values[6][2] =  2.0*(hat_x[0]*hat_x[0])+-2.0*hat_x[0]+-4.0*( (hat_x[0]*hat_x[0])-hat_x[0]+hat_x[0]*hat_x[1])*hat_x[2]+2.0*hat_x[0]*hat_x[1];
  values[7][0] =  -2.0*hat_x[1]*hat_x[2]+2.0*hat_x[1]*(hat_x[2]*hat_x[2]);
  values[7][1] =  2.0*hat_x[0]*(hat_x[2]*hat_x[2])+-2.0*hat_x[0]*hat_x[2];
  values[7][2] =  -2.0*hat_x[0]*hat_x[1]+4.0*hat_x[0]*hat_x[1]*hat_x[2];
  values[8][0] =  2.0*hat_x[1]*hat_x[2]+-2.0*hat_x[1]*(hat_x[2]*hat_x[2]);
  values[8][1] =  -2.0*(hat_x[2]*hat_x[2])*( 2.0*hat_x[1]+hat_x[0]-1.0)+2.0*hat_x[2]*( 2.0*hat_x[1]+hat_x[0]-1.0);
  values[8][2] =  2.0*hat_x[1]*( hat_x[0]-1.0)+2.0*(hat_x[1]*hat_x[1])+-4.0*( hat_x[1]*( hat_x[0]-1.0)+(hat_x[1]*hat_x[1]))*hat_x[2];
  values[9][0] =  4.0*hat_x[1]-(hat_x[2]*hat_x[2])*( 4.0*hat_x[1]+4.0*hat_x[0]-3.0)+4.0*hat_x[0]-3.0;
  values[9][1] =  4.0*hat_x[1]-(hat_x[2]*hat_x[2])*( 4.0*hat_x[1]+4.0*hat_x[0]-3.0)+4.0*hat_x[0]-3.0;
  values[9][2] = -2.0*hat_x[2]*( 2.0*(hat_x[1]*hat_x[1])+2.0*(hat_x[0]*hat_x[0])+-3.0*hat_x[0]+( 4.0*hat_x[0]-3.0)*hat_x[1]+1.0);
  values[10][0] = -(hat_x[2]*hat_x[2])*( 4.0*hat_x[0]-1.0)+4.0*hat_x[0]-1.0;
  values[10][1] = 0.0;
  values[10][2] = -2.0*hat_x[2]*( 2.0*(hat_x[0]*hat_x[0])-hat_x[0]);
  values[11][0] = 0.0;
  values[11][1] = -( 4.0*hat_x[1]-1.0)*(hat_x[2]*hat_x[2])+4.0*hat_x[1]-1.0;
  values[11][2] = 2.0*( hat_x[1]+-2.0*(hat_x[1]*hat_x[1]))*hat_x[2];
  values[12][0] =  -2.0*( 2.0*hat_x[0]+hat_x[1]-1.0)*(hat_x[2]*hat_x[2])+-2.0*( 2.0*hat_x[0]+hat_x[1]-1.0)*hat_x[2];
  values[12][1] =  -2.0*hat_x[0]*hat_x[2]+-2.0*hat_x[0]*(hat_x[2]*hat_x[2]);
  values[12][2] =  -2.0*hat_x[0]*hat_x[1]+2.0*hat_x[0]+-4.0*hat_x[2]*( hat_x[0]*hat_x[1]-hat_x[0]+(hat_x[0]*hat_x[0]))+-2.0*(hat_x[0]*hat_x[0]);
  values[13][0] =  2.0*hat_x[1]*hat_x[2]+2.0*hat_x[1]*(hat_x[2]*hat_x[2]);
  values[13][1] =  2.0*hat_x[2]*hat_x[0]+2.0*(hat_x[2]*hat_x[2])*hat_x[0];
  values[13][2] =  2.0*hat_x[1]*hat_x[0]+4.0*hat_x[1]*hat_x[2]*hat_x[0];
  values[14][0] =  -2.0*hat_x[1]*hat_x[2]+-2.0*hat_x[1]*(hat_x[2]*hat_x[2]);
  values[14][1] =  -2.0*(hat_x[2]*hat_x[2])*( hat_x[0]+2.0*hat_x[1]-1.0)+-2.0*hat_x[2]*( hat_x[0]+2.0*hat_x[1]-1.0);
  values[14][2] =  -4.0*hat_x[2]*( (hat_x[1]*hat_x[1])+( hat_x[0]-1.0)*hat_x[1])+-2.0*(hat_x[1]*hat_x[1])+-2.0*( hat_x[0]-1.0)*hat_x[1];
  values[15][0] =  4.0*(hat_x[2]*hat_x[2])*( 2.0*hat_x[0]+hat_x[1]-1.0)+-8.0*hat_x[0]+-4.0*hat_x[1]+4.0;
  values[15][1] =  -4.0*hat_x[0]+4.0*(hat_x[2]*hat_x[2])*hat_x[0];
  values[15][2] = 8.0*( (hat_x[0]*hat_x[0])+hat_x[0]*hat_x[1]-hat_x[0])*hat_x[2];
  values[16][0] =  -4.0*hat_x[1]*(hat_x[2]*hat_x[2])+4.0*hat_x[1];
  values[16][1] =  4.0*hat_x[0]+-4.0*hat_x[0]*(hat_x[2]*hat_x[2]);
  values[16][2] = -8.0*hat_x[0]*hat_x[1]*hat_x[2];
  values[17][0] =  4.0*hat_x[1]*(hat_x[2]*hat_x[2])+-4.0*hat_x[1];
  values[17][1] =  -4.0*hat_x[0]+-8.0*hat_x[1]+4.0*( hat_x[0]+2.0*hat_x[1]-1.0)*(hat_x[2]*hat_x[2])+4.0;
  values[17][2] = 8.0*( hat_x[1]*( hat_x[0]-1.0)+(hat_x[1]*hat_x[1]))*hat_x[2];
}
template<class T>
void
basis_P2_P<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(18);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_P<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(0.0, 0.0, -1.0);
  x[1] = point_basic<T>(1.0, 0.0, -1.0);
  x[2] = point_basic<T>(0.0, 1.0, -1.0);
  x[3] = point_basic<T>(0.0, 0.0, 1.0);
  x[4] = point_basic<T>(1.0, 0.0, 1.0);
  x[5] = point_basic<T>(0.0, 1.0, 1.0);
  x[6] = point_basic<T>((1.0/2.0), 0.0, -1.0);
  x[7] = point_basic<T>((1.0/2.0), (1.0/2.0), -1.0);
  x[8] = point_basic<T>(0.0, (1.0/2.0), -1.0);
  x[9] = point_basic<T>(0.0, 0.0, 0.0);
  x[10] = point_basic<T>(1.0, 0.0, 0.0);
  x[11] = point_basic<T>(0.0, 1.0, 0.0);
  x[12] = point_basic<T>((1.0/2.0), 0.0, 1.0);
  x[13] = point_basic<T>((1.0/2.0), (1.0/2.0), 1.0);
  x[14] = point_basic<T>(0.0, (1.0/2.0), 1.0);
  x[15] = point_basic<T>((1.0/2.0), 0.0, 0.0);
  x[16] = point_basic<T>((1.0/2.0), (1.0/2.0), 0.0);
  x[17] = point_basic<T>(0.0, (1.0/2.0), 0.0);
}
template<class T>
void
basis_P2_P<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(18);
  hat_node (x.begin());
}
template<class T>
void
basis_P2_H<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] = -( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*hat_x[2]/8.0+( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/8.0;
  values[1] =  ( hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0]))*hat_x[2]/8.0-( hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0]))*(hat_x[2]*hat_x[2])/8.0;
  values[2] =  (hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0]))/8.0-hat_x[2]*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0]))/8.0;
  values[3] = -hat_x[2]*( ( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]+( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1]))/8.0+(hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]+( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1]))/8.0;
  values[4] =  ( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))*hat_x[2]/8.0+( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))*(hat_x[2]*hat_x[2])/8.0;
  values[5] =  hat_x[2]*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])-hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0]))/8.0+(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])-hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0]))/8.0;
  values[6] =  (hat_x[2]*hat_x[2])*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])+( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1])/8.0+hat_x[2]*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])+( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1])/8.0;
  values[7] = -hat_x[2]*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/8.0-(hat_x[2]*hat_x[2])*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/8.0;
  values[8] =  hat_x[2]*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])/4.0-(hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])/4.0;
  values[9] = -hat_x[2]*( (hat_x[0]*hat_x[0])-( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])+hat_x[0])/4.0+(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])+hat_x[0])/4.0;
  values[10] = -( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*(hat_x[2]*hat_x[2])/4.0+( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2]/4.0;
  values[11] = -( hat_x[0]-(hat_x[0]*hat_x[0])-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/4.0+( hat_x[0]-(hat_x[0]*hat_x[0])-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*hat_x[2]/4.0;
  values[12] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/4.0+(hat_x[2]*hat_x[2])*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1])/4.0;
  values[13] =  (hat_x[2]*hat_x[2])*( hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0])))/4.0-hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/4.0+(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/4.0;
  values[14] =  (hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/4.0-(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))+hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0])))/4.0+hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/4.0;
  values[15] =  hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/4.0+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/4.0-( hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0]))*(hat_x[2]*hat_x[2])/4.0;
  values[16] = -(hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])/4.0-hat_x[2]*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])/4.0;
  values[17] = -( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[0]*hat_x[0])-hat_x[0])*hat_x[2]/4.0-( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[2]*hat_x[2])/4.0;
  values[18] = -( hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2]/4.0-( hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0))*(hat_x[2]*hat_x[2])/4.0;
  values[19] =  ( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[2]/4.0+( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/4.0;
  values[20] =  (hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0)/2.0-hat_x[2]*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0)/2.0;
  values[21] =  ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/2.0-hat_x[0]/2.0-(hat_x[2]*hat_x[2])*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]+(hat_x[0]*hat_x[0]))/2.0+(hat_x[0]*hat_x[0])/2.0;
  values[22] = -(hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1]))/2.0+( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/2.0-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0;
  values[23] = -hat_x[2]*( (hat_x[0]*hat_x[0])-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-1.0)/2.0-(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-1.0)/2.0;
  values[24] =  hat_x[0]/2.0+(hat_x[0]*hat_x[0])/2.0-( hat_x[0]+(hat_x[0]*hat_x[0])-( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/2.0-( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/2.0;
  values[25] =  ( ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/2.0-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/2.0-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0;
  values[26] = -( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0)*(hat_x[2]*hat_x[2])+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0;
}
template<class T>
void
basis_P2_H<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(27);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_H<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] =  ( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])-( 2.0*hat_x[0]-1.0)*hat_x[1])*(hat_x[2]*hat_x[2])/8.0-( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])-( 2.0*hat_x[0]-1.0)*hat_x[1])*hat_x[2]/8.0;
  values[0][1] = -( hat_x[0]+-2.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-(hat_x[0]*hat_x[0]))*hat_x[2]/8.0+( hat_x[0]+-2.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/8.0;
  values[0][2] =  hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/8.0-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/8.0-( hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0]))*hat_x[2]/4.0;
  values[1][0] =  (hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)-hat_x[1]*( 2.0*hat_x[0]+1.0))/8.0-hat_x[2]*( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)-hat_x[1]*( 2.0*hat_x[0]+1.0))/8.0;
  values[1][1] = -(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])+-2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])/8.0+hat_x[2]*( (hat_x[0]*hat_x[0])+-2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])/8.0;
  values[1][2] = -( hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0]))*hat_x[2]/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/8.0-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])/8.0;
  values[2][0] =  (hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])+( 2.0*hat_x[0]+1.0)*hat_x[1])/8.0-hat_x[2]*( ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])+( 2.0*hat_x[0]+1.0)*hat_x[1])/8.0;
  values[2][1] = -( 2.0*( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[2]/8.0+( 2.0*( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/8.0;
  values[2][2] = -( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]/8.0-( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/8.0+hat_x[2]*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/4.0;
  values[3][0] = -( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+hat_x[1]*( 2.0*hat_x[0]-1.0))*hat_x[2]/8.0+( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+hat_x[1]*( 2.0*hat_x[0]-1.0))*(hat_x[2]*hat_x[2])/8.0;
  values[3][1] = -( (hat_x[0]*hat_x[0])-hat_x[0]+2.0*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])*hat_x[2]/8.0+( (hat_x[0]*hat_x[0])-hat_x[0]+2.0*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])*(hat_x[2]*hat_x[2])/8.0;
  values[3][2] =  ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/8.0-( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*hat_x[2]/4.0+( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/8.0;
  values[4][0] = -( ( 2.0*hat_x[0]-1.0)*hat_x[1]-( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1]))*hat_x[2]/8.0-( ( 2.0*hat_x[0]-1.0)*hat_x[1]-( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/8.0;
  values[4][1] =  ( hat_x[0]+-2.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/8.0+( hat_x[0]+-2.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-(hat_x[0]*hat_x[0]))*hat_x[2]/8.0;
  values[4][2] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/8.0-( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1])*hat_x[2]/4.0+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/8.0;
  values[5][0] =  hat_x[2]*( ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])-( 2.0*hat_x[0]+1.0)*hat_x[1])/8.0+(hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])-( 2.0*hat_x[0]+1.0)*hat_x[1])/8.0;
  values[5][1] = -( (hat_x[0]*hat_x[0])+-2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])*hat_x[2]/8.0-( (hat_x[0]*hat_x[0])+-2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])/8.0;
  values[5][2] = -hat_x[2]*( hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0]))/4.0-hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/8.0+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])/8.0;
  values[6][0] =  ( hat_x[1]*( 2.0*hat_x[0]+1.0)+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0))*hat_x[2]/8.0+( hat_x[1]*( 2.0*hat_x[0]+1.0)+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0))*(hat_x[2]*hat_x[2])/8.0;
  values[6][1] =  ( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])/8.0+( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])*hat_x[2]/8.0;
  values[6][2] =  ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])/8.0+( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/8.0+hat_x[2]*( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])/4.0;
  values[7][0] =  (hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])+( 2.0*hat_x[0]-1.0)*hat_x[1])/8.0+hat_x[2]*( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])+( 2.0*hat_x[0]-1.0)*hat_x[1])/8.0;
  values[7][1] =  (hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])+2.0*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]-hat_x[0])/8.0+hat_x[2]*( (hat_x[0]*hat_x[0])+2.0*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]-hat_x[0])/8.0;
  values[7][2] =  ( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]/8.0+hat_x[2]*( ( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]+( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1]))/4.0+( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])/8.0;
  values[8][0] = -( hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]))*hat_x[2]/2.0+( hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/2.0;
  values[8][1] = -( (hat_x[0]*hat_x[0])+-2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-1.0)*hat_x[2]/4.0+( (hat_x[0]*hat_x[0])+-2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-1.0)*(hat_x[2]*hat_x[2])/4.0;
  values[8][2] =  ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/4.0-( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])*hat_x[2]/2.0-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/4.0;
  values[9][0] = -( 2.0*hat_x[0]-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+1.0)*hat_x[2]/4.0+( 2.0*hat_x[0]-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+1.0)*(hat_x[2]*hat_x[2])/4.0;
  values[9][1] =  hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[2]/2.0-hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/2.0;
  values[9][2] = -(hat_x[0]*hat_x[0])/4.0+hat_x[2]*( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])/2.0+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])/4.0-hat_x[0]/4.0;
  values[10][0] = -(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*hat_x[0]+hat_x[1]*hat_x[0])/2.0+hat_x[2]*( (hat_x[1]*hat_x[1])*hat_x[0]+hat_x[1]*hat_x[0])/2.0;
  values[10][1] = -(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-1.0)/4.0+hat_x[2]*( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-1.0)/4.0;
  values[10][2] =  (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/4.0-( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2]/2.0+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/4.0;
  values[11][0] =  hat_x[2]*( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])+-2.0*hat_x[0]+1.0)/4.0-(hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])+-2.0*hat_x[0]+1.0)/4.0;
  values[11][1] = -hat_x[2]*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/2.0+(hat_x[2]*hat_x[2])*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/2.0;
  values[11][2] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0+hat_x[0]/4.0-(hat_x[0]*hat_x[0])/4.0+hat_x[2]*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]+(hat_x[0]*hat_x[0]))/2.0;
  values[12][0] =  (hat_x[2]*hat_x[2])*( hat_x[1]*( 2.0*hat_x[0]-1.0)-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0))/4.0-hat_x[1]*( 2.0*hat_x[0]-1.0)/4.0+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/4.0;
  values[12][1] = -(hat_x[0]*hat_x[0])/4.0+hat_x[0]/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/2.0+(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-hat_x[0]+-2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))/4.0;
  values[12][2] = -(1.0/2.0)*( ( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])*hat_x[2];
  values[13][0] =  (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)/4.0-( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)-hat_x[1]*( 2.0*hat_x[0]+1.0))*(hat_x[2]*hat_x[2])/4.0-hat_x[1]*( 2.0*hat_x[0]+1.0)/4.0;
  values[13][1] =  ( hat_x[0]+-2.0*hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))+(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/4.0-hat_x[0]/4.0+hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/2.0-(hat_x[0]*hat_x[0])/4.0;
  values[13][2] = (1.0/2.0)*hat_x[2]*( hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0])));
  values[14][0] =  hat_x[1]*( 2.0*hat_x[0]+1.0)/4.0+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)/4.0-( hat_x[1]*( 2.0*hat_x[0]+1.0)+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0))*(hat_x[2]*hat_x[2])/4.0;
  values[14][1] =  (hat_x[0]*hat_x[0])/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/2.0+hat_x[0]/4.0-( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])/4.0;
  values[14][2] = -(1.0/2.0)*( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])*hat_x[2];
  values[15][0] = -( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+hat_x[1]*( 2.0*hat_x[0]-1.0))*(hat_x[2]*hat_x[2])/4.0+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/4.0+hat_x[1]*( 2.0*hat_x[0]-1.0)/4.0;
  values[15][1] =  hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/2.0+(hat_x[0]*hat_x[0])/4.0-( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])+(hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[2]*hat_x[2])/4.0-hat_x[0]/4.0;
  values[15][2] = (1.0/2.0)*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1])*hat_x[2];
  values[16][0] =  ( hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/2.0+( hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]))*hat_x[2]/2.0;
  values[16][1] = -(hat_x[2]*hat_x[2])*( 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-(hat_x[0]*hat_x[0])+1.0)/4.0-hat_x[2]*( 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-(hat_x[0]*hat_x[0])+1.0)/4.0;
  values[16][2] = -( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/4.0-( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])*hat_x[2]/2.0+( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/4.0;
  values[17][0] =  ( 2.0*hat_x[0]-( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])+1.0)*hat_x[2]/4.0+( 2.0*hat_x[0]-( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])+1.0)*(hat_x[2]*hat_x[2])/4.0;
  values[17][1] = -( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]*(hat_x[2]*hat_x[2])/2.0-( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]*hat_x[2]/2.0;
  values[17][2] =  hat_x[0]/4.0-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/4.0+( hat_x[0]-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))+(hat_x[0]*hat_x[0]))*hat_x[2]/2.0+(hat_x[0]*hat_x[0])/4.0;
  values[18][0] = -( hat_x[0]*(hat_x[1]*hat_x[1])+hat_x[0]*hat_x[1])*hat_x[2]/2.0-( hat_x[0]*(hat_x[1]*hat_x[1])+hat_x[0]*hat_x[1])*(hat_x[2]*hat_x[2])/2.0;
  values[18][1] = -( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-1.0)*hat_x[2]/4.0-( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-1.0)*(hat_x[2]*hat_x[2])/4.0;
  values[18][2] = -(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/4.0-hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/4.0-( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2]/2.0;
  values[19][0] = -( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+-2.0*hat_x[0]+1.0)*(hat_x[2]*hat_x[2])/4.0-( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+-2.0*hat_x[0]+1.0)*hat_x[2]/4.0;
  values[19][1] = -hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[2]*hat_x[2])/2.0-hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[2]/2.0;
  values[19][2] =  ( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[0])*hat_x[2]/2.0+(hat_x[0]*hat_x[0])/4.0-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/4.0-hat_x[0]/4.0;
  values[20][0] =  (hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*hat_x[0]-hat_x[0])-hat_x[2]*( (hat_x[1]*hat_x[1])*hat_x[0]-hat_x[0]);
  values[20][1] =  ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[2]*hat_x[2])*hat_x[1]-( (hat_x[0]*hat_x[0])-1.0)*hat_x[2]*hat_x[1];
  values[20][2] = -(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/2.0+(hat_x[0]*hat_x[0])/2.0+hat_x[2]*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-(hat_x[0]*hat_x[0])+1.0)-(1.0/2.0);
  values[21][0] = -(hat_x[2]*hat_x[2])*( 2.0*hat_x[0]-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)-1.0)/2.0+hat_x[0]-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/2.0-(1.0/2.0);
  values[21][1] = -( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]+(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1];
  values[21][2] = -( (hat_x[0]*hat_x[0])-hat_x[0]-( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1]))*hat_x[2];
  values[22][0] = -(hat_x[2]*hat_x[2])*( hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]))+hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]);
  values[22][1] =  ( 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-(hat_x[0]*hat_x[0])+1.0)*(hat_x[2]*hat_x[2])/2.0-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+(hat_x[0]*hat_x[0])/2.0-(1.0/2.0);
  values[22][2] = -( ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1]))*hat_x[2];
  values[23][0] = -( hat_x[0]-hat_x[0]*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])-( hat_x[0]-hat_x[0]*(hat_x[1]*hat_x[1]))*hat_x[2];
  values[23][1] =  hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)*(hat_x[2]*hat_x[2])+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)*hat_x[2];
  values[23][2] = -(hat_x[0]*hat_x[0])/2.0-( (hat_x[0]*hat_x[0])-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-1.0)*hat_x[2]+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0+(1.0/2.0);
  values[24][0] =  (hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+-2.0*hat_x[0]-1.0)/2.0-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)/2.0+hat_x[0]+(1.0/2.0);
  values[24][1] = -hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[1]*(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])+hat_x[0]);
  values[24][2] = hat_x[2]*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[0]*hat_x[0])-hat_x[0]);
  values[25][0] = -hat_x[0]*hat_x[1]+(hat_x[2]*hat_x[2])*( hat_x[0]*hat_x[1]+hat_x[0]*(hat_x[1]*hat_x[1]))-hat_x[0]*(hat_x[1]*hat_x[1]);
  values[25][1] = -( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+(hat_x[2]*hat_x[2])*( 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+(hat_x[0]*hat_x[0])-1.0)/2.0-(hat_x[0]*hat_x[0])/2.0+(1.0/2.0);
  values[25][2] = hat_x[2]*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]);
  values[26][0] =  2.0*hat_x[0]*(hat_x[1]*hat_x[1])+-2.0*hat_x[0]+-2.0*(hat_x[2]*hat_x[2])*( hat_x[0]*(hat_x[1]*hat_x[1])-hat_x[0]);
  values[26][1] =  -2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)*(hat_x[2]*hat_x[2])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0);
  values[26][2] = -2.0*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-(hat_x[0]*hat_x[0])+1.0)*hat_x[2];
}
template<class T>
void
basis_P2_H<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(27);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P2_H<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(-1.0, -1.0, -1.0);
  x[1] = point_basic<T>(1.0, -1.0, -1.0);
  x[2] = point_basic<T>(1.0, 1.0, -1.0);
  x[3] = point_basic<T>(-1.0, 1.0, -1.0);
  x[4] = point_basic<T>(-1.0, -1.0, 1.0);
  x[5] = point_basic<T>(1.0, -1.0, 1.0);
  x[6] = point_basic<T>(1.0, 1.0, 1.0);
  x[7] = point_basic<T>(-1.0, 1.0, 1.0);
  x[8] = point_basic<T>(0.0, -1.0, -1.0);
  x[9] = point_basic<T>(1.0, 0.0, -1.0);
  x[10] = point_basic<T>(0.0, 1.0, -1.0);
  x[11] = point_basic<T>(-1.0, 0.0, -1.0);
  x[12] = point_basic<T>(-1.0, -1.0, 0.0);
  x[13] = point_basic<T>(1.0, -1.0, 0.0);
  x[14] = point_basic<T>(1.0, 1.0, 0.0);
  x[15] = point_basic<T>(-1.0, 1.0, 0.0);
  x[16] = point_basic<T>(0.0, -1.0, 1.0);
  x[17] = point_basic<T>(1.0, 0.0, 1.0);
  x[18] = point_basic<T>(0.0, 1.0, 1.0);
  x[19] = point_basic<T>(-1.0, 0.0, 1.0);
  x[20] = point_basic<T>(0.0, 0.0, -1.0);
  x[21] = point_basic<T>(-1.0, 0.0, 0.0);
  x[22] = point_basic<T>(0.0, -1.0, 0.0);
  x[23] = point_basic<T>(0.0, 0.0, 1.0);
  x[24] = point_basic<T>(1.0, 0.0, 0.0);
  x[25] = point_basic<T>(0.0, 1.0, 0.0);
  x[26] = point_basic<T>(0.0, 0.0, 0.0);
}
template<class T>
void
basis_P2_H<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(27);
  hat_node (x.begin());
}
template<class T>
basis_P2<T>::~basis_P2()
{
}
template<class T>
typename basis_P2<T>::size_type
basis_P2<T>::degree () const
{
    return 2;
}
template<class T>
typename basis_P2<T>::size_type
basis_P2<T>::size (
    reference_element hat_K) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
        return 1;
      }
      case reference_element::e: {
        return 3;
      }
      case reference_element::t: {
        return 6;
      }
      case reference_element::q: {
        return 9;
      }
      case reference_element::T: {
        return 10;
      }
      case reference_element::P: {
        return 18;
      }
      case reference_element::H: {
        return 27;
      }
      default : {
        error_macro ("size: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
template<class T>
void
basis_P2<T>::eval(
    reference_element     hat_K,
    const point_basic<T>& hat_x,
    vector<T>&        values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
        return basis_P2_p<T>::eval (hat_x, values);
      }
      case reference_element::e: {
        return basis_P2_e<T>::eval (hat_x, values);
      }
      case reference_element::t: {
        return basis_P2_t<T>::eval (hat_x, values);
      }
      case reference_element::q: {
        return basis_P2_q<T>::eval (hat_x, values);
      }
      case reference_element::T: {
        return basis_P2_T<T>::eval (hat_x, values);
      }
      case reference_element::P: {
        return basis_P2_P<T>::eval (hat_x, values);
      }
      case reference_element::H: {
        return basis_P2_H<T>::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P2<T>::eval(
    reference_element     hat_K,
    const point_basic<T>& hat_x,
    typename vector<T>::iterator        values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
        return basis_P2_p<T>::eval (hat_x, values);
      }
      case reference_element::e: {
        return basis_P2_e<T>::eval (hat_x, values);
      }
      case reference_element::t: {
        return basis_P2_t<T>::eval (hat_x, values);
      }
      case reference_element::q: {
        return basis_P2_q<T>::eval (hat_x, values);
      }
      case reference_element::T: {
        return basis_P2_T<T>::eval (hat_x, values);
      }
      case reference_element::P: {
        return basis_P2_P<T>::eval (hat_x, values);
      }
      case reference_element::H: {
        return basis_P2_H<T>::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P2<T>::grad_eval(
    reference_element        hat_K,
    const point_basic<T>&    hat_x,
    vector<point_basic<T> >&            values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_P2_p<T>::grad_eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_P2_e<T>::grad_eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_P2_t<T>::grad_eval (hat_x, values);
      }
      case reference_element::q: {
      return basis_P2_q<T>::grad_eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_P2_T<T>::grad_eval (hat_x, values);
      }
      case reference_element::P: {
      return basis_P2_P<T>::grad_eval (hat_x, values);
      }
      case reference_element::H: {
      return basis_P2_H<T>::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P2<T>::grad_eval(
    reference_element        hat_K,
    const point_basic<T>&    hat_x,
    typename vector<point_basic<T> >::iterator            values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_P2_p<T>::grad_eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_P2_e<T>::grad_eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_P2_t<T>::grad_eval (hat_x, values);
      }
      case reference_element::q: {
      return basis_P2_q<T>::grad_eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_P2_T<T>::grad_eval (hat_x, values);
      }
      case reference_element::P: {
      return basis_P2_P<T>::grad_eval (hat_x, values);
      }
      case reference_element::H: {
      return basis_P2_H<T>::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P2<T>::hat_node(
    reference_element hat_K,
    vector<point_basic<T> >&     hat_node) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
        return basis_P2_p<T>::hat_node (hat_node);
      }
      case reference_element::e: {
        return basis_P2_e<T>::hat_node (hat_node);
      }
      case reference_element::t: {
        return basis_P2_t<T>::hat_node (hat_node);
      }
      case reference_element::q: {
        return basis_P2_q<T>::hat_node (hat_node);
      }
      case reference_element::T: {
        return basis_P2_T<T>::hat_node (hat_node);
      }
      case reference_element::P: {
        return basis_P2_P<T>::hat_node (hat_node);
      }
      case reference_element::H: {
        return basis_P2_H<T>::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P2<T>::hat_node(
    reference_element hat_K,
    typename vector<point_basic<T> >::iterator     hat_node) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
        return basis_P2_p<T>::hat_node (hat_node);
      }
      case reference_element::e: {
        return basis_P2_e<T>::hat_node (hat_node);
      }
      case reference_element::t: {
        return basis_P2_t<T>::hat_node (hat_node);
      }
      case reference_element::q: {
        return basis_P2_q<T>::hat_node (hat_node);
      }
      case reference_element::T: {
        return basis_P2_T<T>::hat_node (hat_node);
      }
      case reference_element::P: {
        return basis_P2_P<T>::hat_node (hat_node);
      }
      case reference_element::H: {
        return basis_P2_H<T>::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
// instantiation in library:
template class basis_P2<Float>;
} // namespace rheolef
