///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// i/o in bamg (.nn)format

#include "rheolef/field.h"
using namespace rheolef;
using namespace std;

istream&
field::get_bamg_mbb (istream& in)
{
    size_type dim, n_field, sz, dim1;
    in >> dim >> n_field >> sz >> dim1;

    check_macro (dim == 2, "unexpected bamg field dimension `" << dim << "'");
    check_macro (dim1 == 2, "unexpected bamg field second dimension `" << dim1 << "'");
    check_macro (n_field == 1, "unsupported " << n_field << "-multi-field in bamg input");
    check_macro (size() == sz, "incompatible input size " << sz << " and field size "<< size());
    check_macro (get_approx() == "P1", "bamg field input: P1 approximation expected, `"
        << get_approx() << "' supplied field found");

    for (size_type dof = 0; dof < size(); dof++) {
        in >> at(dof);
    }
    return in;
}
istream&
field::get_bamg_metric (istream& in)
{
    size_type n_field, sz;
    in >> sz >> n_field ;

    check_macro (n_field == 1, "unsupported tensorial metric in bamg input");
    check_macro (size() == sz, "incompatible input size " << sz << " and field size "<< size());
    check_macro (get_approx() == "P1", "bamg metric input: P1 approximation expected, `"
        << get_approx() << "' supplied field found");

    for (size_type dof = 0; dof < size(); dof++) {
        in >> at(dof);
    }
    return in;
}
ostream&
field::put_bamg_mbb (ostream& out) const
{
    check_macro (get_approx() == "P1", "bamg mbb output: P1 approximation expected, `"
        << get_approx() << "' found");
    out << "2 1 " << size() << " 2" << endl;
    for (size_type dof = 0; dof < size(); dof++) {
        out << at(dof) << endl;
    }
    out << endl;
    return out;
}
ostream&
field::put_bamg_metric (ostream& out) const
{
    check_macro (get_approx() == "P1", "bamg metric output: P1 approximation expected, `"
        << get_approx() << "' found");
    if (n_component()==1) {
        return put_bamg_mbb (out);
    }
    check_macro(get_valued()=="tensor","Tensorial metric field expected");
    out << get_space().size_component(0) << " 3" << endl;
    size_type first_00=get_space().start(fem_helper::tensor_index("tensor",coordinate_system(),0,0));
    size_type first_01=get_space().start(fem_helper::tensor_index("tensor",coordinate_system(),0,1));
    size_type first_11=get_space().start(fem_helper::tensor_index("tensor",coordinate_system(),1,1));
    for (size_type dof = 0; dof < get_space().size_component(0); dof++) {
       out << at(first_00+dof) << " " 
	   << at(first_01+dof) << " " 
	   << at(first_11+dof) << endl;
   }
   out << endl;
   return out;
}
