#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "taylor_exact.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  Float err_linf_expected = (argc > 1) ? atof(argv[1]) : 1e+38;
  bool dump = (argc > 2);
  field uh, ph; din >> uh >> ph;
  space Xh = uh.get_space(),
        Qh = ph.get_space();
  geo omega = Xh.get_geo();
  size_t k = Xh.degree();
  size_t d = omega.dimension();
  quadrature_option_type qopt;
  qopt.set_family(quadrature_option_type::gauss);
  qopt.set_order(2*k+1);
  Float meas_omega = integrate (omega);
  Float moy_ph = integrate (omega, ph, qopt);
  ph = ph - moy_ph/meas_omega; // ph with zero average value
  string high_approx = "P"+itos(k+1)+"d";
  space Xh1 (omega, high_approx, "vector"),
        Qh1 (omega, high_approx);
  field euh = interpolate (Xh1, uh-u_exact());
  field eph = interpolate (Qh1, ph-p_exact());
  Float err_u_l2 = sqrt(integrate (omega, norm2(uh-u_exact()), qopt));
  Float err_u_linf = euh.max_abs();
  Float err_u_h1 = sqrt(integrate (omega, norm2(grad_h(euh)), qopt)
                    + integrate (omega.sides(), (1/h_local())*norm2(jump(euh)), qopt));
  Float err_p_l2 = sqrt(integrate (omega, sqr(ph-p_exact()), qopt));
  Float err_p_linf = eph.max_abs();
  derr << "err_u_l2   = " << err_u_l2 << endl
       << "err_u_linf = " << err_u_linf << endl
       << "err_u_h1   = " << err_u_h1 << endl
       << "err_p_l2   = " << err_p_l2 << endl
       << "err_p_linf = " << err_p_linf << endl;
  if (dump) {
    dout << catchmark("uh")  << uh 
         << catchmark("u")   << interpolate (Xh, u_exact())
         << catchmark("eu") << euh 
         << catchmark("ph")  << ph 
         << catchmark("p")   << interpolate (Qh, p_exact())
         << catchmark("ep") << eph;
  }
  return (max(err_u_linf,err_p_linf) <= err_linf_expected) ? 0 : 1;
}
