///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P1qd_numbering.h"
#include "Pkd_set_ios_permutations.h"
namespace rheolef {
using namespace std;

template <class T, class M>
std::string
numbering_P1qd<T,M>::name() const
{
  return "P1qd";
}
template <class T, class M>
typename numbering_P1qd<T,M>::size_type
numbering_P1qd<T,M>::degree () const
{
  return 1;
}
template <class T, class M>
void
numbering_P1qd<T,M>::set_degree (size_type degree) const
{
    check_macro (degree == 0, "cannot change `"<<name()<<"' degree to " << degree);
}
template <class T, class M>
bool
numbering_P1qd<T,M>::is_continuous () const
{
  return false;
}
template <class T, class M>
bool
numbering_P1qd<T,M>::has_compact_support_inside_element () const
{
  return true;
}
template <class T, class M>
typename numbering_P1qd<T,M>::size_type
numbering_P1qd<T,M>::ndof (
        const geo_size& gs, 
        size_type       map_dim) const
{
  return (map_dim+1)*gs.ownership_by_dimension [map_dim].size();
}
template <class T, class M>
typename numbering_P1qd<T,M>::size_type
numbering_P1qd<T,M>::dis_ndof (
        const geo_size& gs, 
        size_type       map_dim) const
{
  return (map_dim+1)*gs.ownership_by_dimension [map_dim].dis_size();
}
template <class T, class M>
void
numbering_P1qd<T,M>::dis_idof (
        const geo_size&       gs, 
	const geo_element&    K, 
	std::vector<size_type>&    dis_idof) const
{
  check_macro (K.variant() == reference_element::q || K.variant() == reference_element::H,
	"invalid element type `" << K.name() << "' for P1qd approximation (HINT: q or H element type expected)");
  size_type nloc = K.dimension() + 1;
  dis_idof.resize (nloc);
  for (size_type i = 0; i < nloc; ++i) {
    dis_idof [i] = nloc*K.dis_ie() + i;
  }
}
template <class T, class M>
void
numbering_P1qd<T,M>::set_ios_permutations (
    const geo_basic<T,M>& omega,
    array<size_type,M>&   idof2ios_dis_idof,
    array<size_type,M>&   ios_idof2dis_idof) const
{
  boost::array<size_type,reference_element::max_variant>  loc_ndof_by_variant;
  std::fill_n(loc_ndof_by_variant.begin(),loc_ndof_by_variant.size(),0);
  loc_ndof_by_variant [reference_element::q] = 3;
  loc_ndof_by_variant [reference_element::H] = 4;
  Pkd_set_ios_permutations (omega, degree(), idof2ios_dis_idof, ios_idof2dis_idof, loc_ndof_by_variant);
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------

template class numbering_P1qd<Float,sequential>;

#ifdef _RHEOLEF_HAVE_MPI
template class numbering_P1qd<Float,distributed>;
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
