int p_laplacian_fixed_point (Float p, field fh, field& uh, Float& r, size_t& n) {
    Float tol = r;
    Float r0 = 0;
    size_t max_iter =  n;
    const geo& omega_h = uh.get_geo();
    const space& Vh = uh.get_space();
    string grad_approx = (Vh.get_approx() == "P2") ? "P1d" : "P0";
    space Th (omega_h, grad_approx, "vector");
    form m (Vh, Vh, "mass");
    form inv_mt (Th, Th, "inv_mass");
    form grad (Vh, Th, "grad");
    cerr << "# Fixed-point algorithm on p-laplancian: p = " << p << endl
         << "# n r v" << endl;
    n = 0;
    do {
      field grad_uh = inv_mt*(grad*uh); 
      field wh = pow(sqr(grad_uh[0]) + sqr(grad_uh[1]), p/2.-1);
      form a (Vh, Vh, "grad_grad", wh);
      field rh = a*uh - m*fh;
      r = rh.u.max_abs();
      if (n == 0) r0 = r;
      Float v = (n == 0) ? 0 : log10(r0/r)/n;
      cerr << n << " " << r << " " << v << endl;
      if (r <= tol || n++ >= max_iter) break;
      ssk<Float> fact_a = ldlt(a.uu);
      uh.u = fact_a.solve (m.uu*fh.u + m.ub*fh.b - a.ub*uh.b);
    } while (true);
    return r <= tol;
}
