#include "rheolef.h"
#include "rheolef/damped-newton.h"
using namespace rheolef;
using namespace std;
#include "p-laplacian.h"
int main(int argc, char**argv) {
  geo omega_h (argv[1]);
  string approx = (argc > 2) ?      argv[2]  : "P1";
  Float  p      = (argc > 3) ? atof(argv[3]) : 2.5;
  cerr << "# P-Laplacian problem by Newton:" << endl
       << "# geo = " << omega_h.name() << endl
       << "# approx = " << approx << endl
       << "# p = " << p << endl;
  p_laplacian F (p, omega_h, approx);
  field uh = F.initial();
  Float tol = numeric_limits<Float>::epsilon();
  size_t max_iter = 500;
  int status = damped_newton (F, uh, tol, max_iter, &cerr);
  cout << setprecision(numeric_limits<Float>::digits10)
       << catchmark("p") << p << endl
       << catchmark("u") << uh;
  return status;
}
