# ifndef _SKIT_ARRAY_H
# define _SKIT_ARRAY_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// Array = vector + numeric features
//
// TODO: use valarray<T> instead
//
// author: Pierre.Saramito@imag.fr
//
// date: 14 january 1997
//
# include "rheolef/skitbase.h"
# include "rheolef/Vector.h"
# include "rheolef/num-algorithm.h"

namespace rheolef { 
/*Class:
NAME: @code{Array} - numeric vector
END: */

template<class T>
class Array : public Vector<T> 
{
public:
// typedefs:

	typedef T                                        element_type; 
	typedef typename Vector<T>::size_type            size_type;
	typedef typename std::vector<T>::difference_type difference_type;

// allocators/deallocators:

	explicit inline Array (unsigned int n = 0, const T& init_value = std::numeric_limits<T>::max());
	inline ~Array();

// modifiers:
	void reset() {  std::fill(Vector<T>::begin(), Vector<T>::end(), T()); }

// accessors:

	// do not forget that this accessor is slow
	const T& operator () (unsigned int i) const { return Vector<T>::at(i); }
	T& operator () (unsigned int i) { return Vector<T>::at(i); }

	bool all_elements_are_int_or_inf_or_nan () const
	{ return all_are_int_or_inf_or_nan (Vector<T>::begin(), Vector<T>::end(), T()); }  

	bool any_element_is_inf_or_nan () const
	{ return any_is_inf_or_nan (Vector<T>::begin(), Vector<T>::end(), T()); }

	bool any_element_is_negative () const
	{ return any_is_negative (Vector<T>::begin(), Vector<T>::end(), T()); }

	T max() const     { return select_max (Vector<T>::begin(), Vector<T>::end(), -std::numeric_limits<T>::max()); }
	T min() const     { return select_min (Vector<T>::begin(), Vector<T>::end(),  std::numeric_limits<T>::max()); }
	T max_abs() const { return select_max_abs (Vector<T>::begin(), Vector<T>::end(), T(0)); }
	T min_abs() const { return select_min_abs (Vector<T>::begin(), Vector<T>::end(), T(0)); }
};
// ==========================[ inlined's ] =====================================

# define array_name(T) 	((sizeof(T)==sizeof(double)) ? "Array<double>" : \
                         (sizeof(T)==sizeof(long double)) ? "Array<long double>" : \
                         (sizeof(T)==sizeof(unsigned int)) ? "Array<unsigned int>" : \
                         "Array<float>") \

extern int count_cumul;
extern int count_current;
extern int count_max_current;

template<class T>
inline 
Array<T>::Array (unsigned int n, const T& init_value)
: Vector<T>(n, init_value) 
{
}
template<class T>
inline 
Array<T>::~Array(void)
{ 
}
}// namespace rheolef
# endif /* _SKIT_ARRAY_H */
